/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class GotoFromResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ListMap<String, SimulinkBlock> gotoBlocksByTag = new ListMap();
    private final ListMap<String, SimulinkBlock> fromBlocksByTag = new ListMap();
    private final SetMap<String, SimulinkBlock> tagToScopeParents = new SetMap();
    private final Set<String> alreadyLoggedTags = new HashSet<String>();

    public GotoFromResolver(SimulinkBlock rootBlock) {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst(rootBlock, false, false)) {
            String gotoTag;
            if (block.isOfType("Goto")) {
                GotoFromResolver.insertGotoOrFromBlock(block, this.gotoBlocksByTag);
                continue;
            }
            if (SimulinkUtils.isFromBlock(block)) {
                GotoFromResolver.insertGotoOrFromBlock(block, this.fromBlocksByTag);
                continue;
            }
            if (!block.isOfType("GotoTagVisibility") || (gotoTag = GotoFromResolver.extractGotoTag(block)) == null) continue;
            this.tagToScopeParents.add((Object)gotoTag, (Object)block.getParent());
        }
    }

    private static void insertGotoOrFromBlock(SimulinkBlock block, ListMap<String, SimulinkBlock> blocksByTag) {
        String gotoTag = GotoFromResolver.extractGotoTag(block);
        if (gotoTag != null) {
            blocksByTag.add((Object)gotoTag, (Object)block);
        }
    }

    public static String extractGotoTag(SimulinkBlock block) {
        String tag = block.getParameter("GotoTag");
        if (tag == null) {
            LOGGER.warn("Missing GotoTag in " + block.getId());
        }
        return tag;
    }

    public static ETagVisibility extractTagVisibility(SimulinkBlock block) {
        String visibility = block.getParameter("TagVisibility");
        if (visibility == null) {
            LOGGER.warn("Missing TagVisibility in " + block.getId());
            return ETagVisibility.LOCAL;
        }
        ETagVisibility value = (ETagVisibility)EnumUtils.valueOf(ETagVisibility.class, (String)visibility.toUpperCase());
        if (value == null) {
            LOGGER.warn("Unknown TagVisibility " + visibility + " in " + block.getId());
            return ETagVisibility.LOCAL;
        }
        return value;
    }

    public List<SimulinkBlock> getConnectedFromBlocks(SimulinkBlock gotoBlock) {
        CCSMAssert.isTrue((boolean)gotoBlock.isOfType("Goto"), (String)"May only be used for goto blocks!");
        String tag = GotoFromResolver.extractGotoTag(gotoBlock);
        if (tag == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.filter((Collection)this.fromBlocksByTag.getCollectionOrEmpty((Object)tag), fromBlock -> this.getConnectedGotoBlocks((SimulinkBlock)fromBlock).contains(gotoBlock));
    }

    public List<SimulinkBlock> getConnectedGotoBlocks(SimulinkBlock fromBlock) {
        CCSMAssert.isTrue((boolean)SimulinkUtils.isFromBlock(fromBlock), (String)"May only be used for from blocks!");
        String tag = GotoFromResolver.extractGotoTag(fromBlock);
        if (tag == null) {
            return Collections.emptyList();
        }
        List candidates = (List)this.gotoBlocksByTag.getCollectionOrEmpty((Object)tag);
        if (candidates.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        List<SimulinkBlock> local = GotoFromResolver.extractMatchingLocalGotos(candidates, fromBlock);
        if (!local.isEmpty()) {
            return local;
        }
        List<SimulinkBlock> scoped = this.extractMatchingScopedGotos(candidates, fromBlock, tag);
        if (!scoped.isEmpty()) {
            return scoped;
        }
        List<SimulinkBlock> global = GotoFromResolver.extractGlobalGotos(candidates);
        if (!global.isEmpty()) {
            return global;
        }
        if (this.alreadyLoggedTags.add(tag)) {
            LOGGER.warn("Could not find matching Goto with correct visibility for From block with tag " + tag);
        }
        return candidates;
    }

    private static List<SimulinkBlock> extractMatchingLocalGotos(List<SimulinkBlock> candidates, SimulinkBlock fromBlock) {
        return CollectionUtils.filter(candidates, gotoBlock -> gotoBlock.getParent() == fromBlock.getParent() && GotoFromResolver.extractTagVisibility(gotoBlock) == ETagVisibility.LOCAL);
    }

    private List<SimulinkBlock> extractMatchingScopedGotos(List<SimulinkBlock> candidates, SimulinkBlock fromBlock, String tag) {
        Set scopeParents = (Set)this.tagToScopeParents.getCollectionOrEmpty((Object)tag);
        SimulinkBlock fromScopeParent = GotoFromResolver.getScopeParent(fromBlock, scopeParents);
        return CollectionUtils.filter(candidates, gotoBlock -> GotoFromResolver.extractTagVisibility(gotoBlock) == ETagVisibility.SCOPED && GotoFromResolver.getScopeParent(gotoBlock, scopeParents) == fromScopeParent);
    }

    private static SimulinkBlock getScopeParent(SimulinkBlock block, Set<SimulinkBlock> scopeParents) {
        while (block.getParent() != null && !scopeParents.contains(block)) {
            block = block.getParent();
        }
        return block;
    }

    private static List<SimulinkBlock> extractGlobalGotos(List<SimulinkBlock> candidates) {
        return CollectionUtils.filter(candidates, gotoBlock -> GotoFromResolver.extractTagVisibility(gotoBlock) == ETagVisibility.GLOBAL);
    }

    public static enum ETagVisibility {
        LOCAL,
        SCOPED,
        GLOBAL;

    }
}

