/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.build.IBuildRequest;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IQueuedBuildQueryResult;
import com.microsoft.tfs.core.clients.build.IQueuedBuildSpec;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.flags.QueueOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import ms.tfs.build.buildservice._04._BuildQueueQueryResult;
import ms.tfs.build.buildservice._04._BuildQueueServiceSoap;
import ms.tfs.build.buildservice._04._BuildQueueSpec;
import ms.tfs.build.buildservice._04._BuildRequest;
import ms.tfs.build.buildservice._04._QueryOptions;
import ms.tfs.build.buildservice._04._QueueOptions;
import ms.tfs.build.buildservice._04._QueuedBuildUpdateOptions;

public class BuildQueueWebService4 {
    private final _BuildQueueServiceSoap webService;
    private final IBuildServer buildServer;

    public BuildQueueWebService4(TFSTeamProjectCollection tfs) {
        this.webService = (_BuildQueueServiceSoap)tfs.getWebService(_BuildQueueServiceSoap.class);
        this.buildServer = tfs.getBuildServer();
    }

    public BuildQueueQueryResult queryBuildsById(int[] ids, String[] informationTypes, QueryOptions queryOptions) {
        _QueryOptions _options = queryOptions.getWebServiceObject();
        _BuildQueueQueryResult _result = this.webService.queryBuildsById(ids, informationTypes, _options);
        return new BuildQueueQueryResult(this.buildServer, _result);
    }

    public BuildQueueQueryResult updateBuilds(QueuedBuildUpdateOptions[] updateOptions) {
        _QueuedBuildUpdateOptions[] _options = (_QueuedBuildUpdateOptions[])WrapperUtils.unwrap(_QueuedBuildUpdateOptions.class, updateOptions);
        _BuildQueueQueryResult _result = this.webService.updateBuilds(_options);
        return new BuildQueueQueryResult(this.buildServer, _result);
    }

    public IQueuedBuildQueryResult[] queryBuilds(IQueuedBuildSpec[] buildQueueSpecs) {
        _BuildQueueSpec[] _specs = (_BuildQueueSpec[])WrapperUtils.unwrap(_BuildQueueSpec.class, buildQueueSpecs);
        _BuildQueueQueryResult[] _results = this.webService.queryBuilds(_specs);
        return BuildTypeConvertor.toBuildQueueQueryResults(this.buildServer, _results);
    }

    public IQueuedBuildQueryResult queueBuilds(IBuildRequest[] buildRequests, QueueOptions queryOptions) {
        _QueueOptions _options = queryOptions.getWebServiceObject();
        _BuildRequest[] _requests = (_BuildRequest[])WrapperUtils.unwrap(_BuildRequest.class, buildRequests);
        _BuildQueueQueryResult result = this.webService.queueBuilds(_requests, _options);
        return new BuildQueueQueryResult(this.buildServer, result);
    }

    public void cancelBuilds(int[] ids) {
        this.webService.cancelBuilds(ids);
    }

    public IQueuedBuildQueryResult startBuildsNow(int[] ids) {
        _BuildQueueQueryResult _result = this.webService.startBuildsNow(ids);
        return new BuildQueueQueryResult(this.buildServer, _result);
    }
}

