/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.ws.runtime.xml.XMLConvert;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.Calendar;
import java.util.Map;

public class CommonInformationHelper {
    public static int GetInt(Map<String, String> map, String fieldName) {
        return CommonInformationHelper.getInt(map, fieldName, 0);
    }

    public static int getInt(Map<String, String> map, String fieldName, int invalidValue) {
        String value = map.get(fieldName);
        if (value == null) {
            return invalidValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return invalidValue;
        }
    }

    public static String getString(Map<String, String> map, String fieldName) {
        String result = map.get(fieldName);
        if (result != null) {
            return result;
        }
        return "";
    }

    public static Calendar getDateTime(Map<String, String> map, String fieldName) {
        String value = map.get(fieldName);
        if (value == null) {
            return DotNETDate.MIN_CALENDAR;
        }
        return CommonInformationHelper.toCalendar(value);
    }

    public static Calendar toCalendar(String value) {
        return XMLConvert.toCalendar(value, true);
    }
}

