/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.commonstructure;

import com.microsoft.tfs.core.clients.commonstructure.CSSStructureType;
import com.microsoft.tfs.core.util.Hierarchical;
import com.microsoft.tfs.core.util.Labelable;
import java.util.ArrayList;
import java.util.List;

public class CSSNode
implements Hierarchical,
Labelable {
    public static final char PATH_SEPERATOR = '\\';
    private CSSNode parent;
    private final List children = new ArrayList();
    private int level = 0;
    private String uri;
    private String name;
    private String parentUri;
    private String path;
    private String projectUri;
    private final CSSStructureType structureType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSNode(CSSStructureType structureType, String uri) {
        this.structureType = structureType;
        CSSNode cSSNode = this;
        synchronized (cSSNode) {
            this.uri = uri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSNode(CSSStructureType structureType, String uri, String name, String parentUri, String path, String projectUri) {
        this(structureType, uri);
        CSSNode cSSNode = this;
        synchronized (cSSNode) {
            this.name = name;
            this.parentUri = parentUri;
            this.path = path;
            this.projectUri = projectUri;
        }
    }

    @Override
    public synchronized Object[] getChildren() {
        return this.children.toArray(new CSSNode[this.children.size()]);
    }

    public synchronized boolean removeChildNode(CSSNode node) {
        return this.children.remove(node);
    }

    public synchronized int indexOfChild(CSSNode node) {
        return this.children.indexOf(node);
    }

    public synchronized CSSNode removeChildAt(int index) {
        return (CSSNode)this.children.remove(index);
    }

    public synchronized void addChildAt(int index, CSSNode child) {
        this.children.add(index, child);
    }

    public synchronized CSSNode getChildAt(int index) {
        return (CSSNode)this.children.get(index);
    }

    public synchronized int getChildrenSize() {
        return this.children.size();
    }

    @Override
    public synchronized Object getParent() {
        return this.parent;
    }

    public synchronized CSSNode getParentNode() {
        return this.parent;
    }

    @Override
    public synchronized boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public synchronized boolean addChild(CSSNode childNode) {
        childNode.setParent(this);
        childNode.setParentURI(this.getURI());
        if (this.getPath() != null) {
            childNode.setPath(this.getPath() + '\\' + childNode.getName());
        }
        return this.children.add(childNode);
    }

    private synchronized void setParent(CSSNode parent) {
        this.parent = parent;
    }

    @Override
    public synchronized String getLabel() {
        return this.getName();
    }

    public synchronized int getLevel() {
        return this.level;
    }

    public synchronized void setLevel(int level) {
        this.level = level;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized String getParentURI() {
        return this.parentUri;
    }

    public synchronized void setParentURI(String parentUri) {
        this.parentUri = parentUri;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized void setPath(String path) {
        this.path = path;
    }

    public synchronized String getProjectURI() {
        return this.projectUri;
    }

    public synchronized void setProjectURI(String projectUri) {
        this.projectUri = projectUri;
    }

    public synchronized String getURI() {
        return this.uri;
    }

    public synchronized void setURI(String uri) {
        this.uri = uri;
    }

    public synchronized CSSStructureType getStructureType() {
        return this.structureType;
    }

    public synchronized String toString() {
        return this.getName();
    }

    public static CSSNode resolveNode(CSSNode parentNode, String initialPath) {
        if (parentNode.getPath().equals(initialPath)) {
            return parentNode;
        }
        CSSNode node = parentNode;
        if (initialPath.startsWith(parentNode.getPath()) && parentNode.hasChildren()) {
            CSSNode[] children = (CSSNode[])parentNode.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (initialPath.equals(children[i].getPath())) {
                    return children[i];
                }
                if (!initialPath.startsWith(children[i].getPath() + '\\')) continue;
                node = CSSNode.resolveNode(children[i], initialPath);
                break;
            }
        }
        return node;
    }
}

