/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.AbstractDownloadWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadSpec;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.io.File;

public class TempDownloadWorker
extends AbstractDownloadWorker {
    private final String downloadURL;
    private final File localFile;
    private final ItemType itemType;

    public TempDownloadWorker(EventSource eventSource, TaskMonitor cancelMonitor, VersionControlClient client, String downloadURL, File localFile, ItemType itemType) {
        super(eventSource, cancelMonitor, client);
        Check.notNull(localFile, "localFile");
        Check.notNull(itemType, "itemType");
        this.downloadURL = downloadURL;
        this.localFile = localFile;
        this.itemType = itemType;
    }

    @Override
    public WorkerStatus call() throws Exception {
        try {
            if (this.getCancelMonitor().isCanceled()) {
                return new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
            }
            if (this.itemType == ItemType.FOLDER) {
                this.localFile.mkdirs();
                return new WorkerStatus(this, WorkerStatus.FinalState.NORMAL);
            }
            File parentDirectory = this.localFile.getParentFile();
            if (!parentDirectory.exists()) {
                parentDirectory.mkdirs();
            }
            try {
                this.getClient().downloadFile(new DownloadSpec(this.downloadURL), this.localFile, true);
            }
            catch (CanceledException e) {
                if (this.localFile.exists()) {
                    this.localFile.delete();
                }
                return new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
            }
        }
        catch (Throwable t) {
            if (this.localFile.exists()) {
                this.localFile.delete();
            }
            return new WorkerStatus(this, WorkerStatus.FinalState.ERROR);
        }
        return new WorkerStatus(this, WorkerStatus.FinalState.NORMAL);
    }
}

