/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.CheckinEngine;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.ScannerModifiedFilesEvent;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.EnumeratedLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalDataAccessLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalItemEnumerable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalItemEnumerator;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalItemExclusionEvaluator;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.KeyValuePair;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalWorkspaceScanner {
    private static final Log log = LogFactory.getLog(LocalWorkspaceScanner.class);
    private static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    private static final int c_defaultCandidateAddsLimit = 50000;
    private static final int c_defaultEnumeratedItemsLimit = 500000;
    private static final int s_candidateAddsLimit = 50000;
    private static final int s_enumeratedItemsLimit = 500000;
    private final LocalWorkspaceProperties wp;
    private final WorkspaceVersionTable lv;
    private final LocalPendingChangesTable pc;
    private final Set<String> skippedItems = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final List<WorkspaceLocalItem> markForRemoval = new ArrayList<WorkspaceLocalItem>();
    private final List<WorkspaceLocalItem> reappearedOnDisk = new ArrayList<WorkspaceLocalItem>();
    private final List<KeyValuePair<String, Long>> toUndo = new ArrayList<KeyValuePair<String, Long>>();
    private final Set<String> candidateChanges = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> changedByScan = new TreeSet<String>(LocalPath.TOP_DOWN_COMPARATOR);

    public LocalWorkspaceScanner(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc, Iterable<String> skippedItems) {
        this.wp = wp;
        this.lv = lv;
        this.pc = pc;
        for (String skippedItem : skippedItems) {
            this.skippedItems.add(skippedItem);
        }
    }

    public void fullScan() throws CoreCancelException {
        long start = System.currentTimeMillis();
        int firstPassItems = 0;
        for (WorkspaceLocalItem lvEntry : this.lv.queryByLocalItem(null, RecursionType.FULL, null)) {
            lvEntry.setScanned(false);
        }
        TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
        WorkingFolder[] workingFolders = this.wp.getWorkingFolders();
        int candidateAddsCount = 0;
        int enumeratedItemsCount = 0;
        block1: for (LocalItemEnumerator localItemEnum : LocalItemEnumerable.getEnumeratorsForWorkingFolders(workingFolders)) {
            LocalItemExclusionEvaluator ignoreFileStack = new LocalItemExclusionEvaluator(this.wp, localItemEnum.getStartPath());
            while (localItemEnum.hasNext()) {
                if (taskMonitor.isCanceled()) {
                    throw new CoreCancelException();
                }
                EnumeratedLocalItem fromDisk = localItemEnum.next();
                if (candidateAddsCount >= s_candidateAddsLimit || enumeratedItemsCount >= s_enumeratedItemsLimit) break block1;
                ++enumeratedItemsCount;
                WorkspaceLocalItem lvEntry = this.lv.getByLocalItem(fromDisk.getFullPath());
                if (null != lvEntry) {
                    lvEntry.setScanned(true);
                    ++firstPassItems;
                    this.diffItem(fromDisk, lvEntry);
                    continue;
                }
                if (fromDisk.isDirectory() && !fromDisk.isSymbolicLink() || ignoreFileStack.isExcluded(fromDisk.getFullPath())) continue;
                WorkingFolder closestMapping = (WorkingFolder)localItemEnum.getTag();
                fromDisk.setServerItem(closestMapping.translateLocalItemToServerItem(fromDisk.getFullPath()));
                if (!ServerPath.isServerPath(fromDisk.getServerItem()) || !this.addCandidateAdd(fromDisk)) continue;
                ++candidateAddsCount;
            }
        }
        if (firstPassItems != this.lv.getLocalItemsCount()) {
            for (WorkspaceLocalItem lvEntry : this.lv.queryByLocalItem(null, RecursionType.FULL, null)) {
                if (lvEntry.isScanned()) continue;
                File localFile = new File(lvEntry.getLocalItem());
                FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(localFile);
                if (!attrs.exists()) {
                    this.markForRemoval.add(lvEntry);
                    continue;
                }
                EnumeratedLocalItem fromDisk = new EnumeratedLocalItem(localFile, attrs);
                this.diffItem(fromDisk, lvEntry);
            }
        }
        this.scanPartTwo();
        TreeSet<String> candidatesToRemove = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (LocalPendingChange candidateChange : this.pc.queryCandidatesByTargetServerItem("$/", RecursionType.FULL, null)) {
            if (this.candidateChanges.contains(candidateChange.getTargetServerItem())) continue;
            candidatesToRemove.add(candidateChange.getTargetServerItem());
        }
        for (String candidateToRemove : candidatesToRemove) {
            this.pc.removeCandidateByTargetServerItem(candidateToRemove);
        }
        if (candidatesToRemove.size() > 0) {
            LocalWorkspaceTransaction.getCurrent().setRaisePendingChangeCandidatesChanged(true);
        }
        this.fireChangedByScanEvent();
        log.debug((Object)MessageFormat.format("Full scan took {0} ms ({1} enum items, {2} fp items, {3} adds, {4} removes)", System.currentTimeMillis() - start, enumeratedItemsCount, firstPassItems, candidateAddsCount, candidatesToRemove.size()));
    }

    public void partialScan(Iterable<String> changedPaths) throws CoreCancelException {
        ArrayList<String> itemsToScan = new ArrayList<String>();
        boolean fallBackToFullScan = false;
        for (String changedPath : changedPaths) {
            try {
                itemsToScan.add(LocalPath.canonicalize(changedPath));
            }
            catch (Throwable t) {
                fallBackToFullScan = true;
                break;
            }
        }
        if (fallBackToFullScan) {
            this.fullScan();
            return;
        }
        ArrayList<String> itemsToScanNotOnDisk = new ArrayList<String>();
        Iterable<String> workspaceRoots = WorkingFolder.getWorkspaceRoots(this.wp.getWorkingFolders());
        for (String localItem : itemsToScan) {
            LocalItemExclusionEvaluator ignoreFileStack;
            WorkspaceLocalItem lvEntry = this.lv.getByLocalItem(localItem);
            File localFile = new File(localItem);
            FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(localFile);
            if (!attrs.exists()) {
                if (null != lvEntry) {
                    this.markForRemoval.add(lvEntry);
                }
                if (null != lvEntry && lvEntry.isCommitted()) continue;
                itemsToScanNotOnDisk.add(localItem);
                continue;
            }
            EnumeratedLocalItem fromDisk = new EnumeratedLocalItem(localFile, attrs);
            if (null != lvEntry) {
                this.diffItem(fromDisk, lvEntry);
                continue;
            }
            if (fromDisk.isDirectory()) continue;
            String workspaceRoot = null;
            for (String potentialRoot : workspaceRoots) {
                if (!LocalPath.isChild(potentialRoot, fromDisk.getFullPath())) continue;
                workspaceRoot = potentialRoot;
                break;
            }
            if (null == workspaceRoot || (ignoreFileStack = new LocalItemExclusionEvaluator(this.wp, workspaceRoot)).isExcluded(fromDisk.getFullPath())) continue;
            fromDisk.setServerItem(WorkingFolder.getServerItemForLocalItem(fromDisk.getFullPath(), this.wp.getWorkingFolders()));
            if (null == fromDisk.getServerItem() || !ServerPath.isServerPath(fromDisk.getServerItem())) continue;
            this.addCandidateAdd(fromDisk);
        }
        this.scanPartTwo();
        TreeSet<String> candidatesToRemove = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String itemToScan : itemsToScan) {
            LocalPendingChange candidateChange;
            String targetServerItem = WorkingFolder.getServerItemForLocalItem(itemToScan, this.wp.getWorkingFolders());
            if (null == targetServerItem || null == (candidateChange = this.pc.getCandidateByTargetServerItem(targetServerItem)) || this.candidateChanges.contains(candidateChange.getTargetServerItem())) continue;
            candidatesToRemove.add(candidateChange.getTargetServerItem());
        }
        if (itemsToScanNotOnDisk.size() > 0) {
            block6: for (LocalPendingChange candidateChange : this.pc.queryCandidatesByTargetServerItem("$/", RecursionType.FULL, null)) {
                String localItem;
                if (!candidateChange.isAdd() || this.candidateChanges.contains(candidateChange.getTargetServerItem()) || null == (localItem = WorkingFolder.getLocalItemForServerItem(candidateChange.getTargetServerItem(), this.wp.getWorkingFolders(), true))) continue;
                for (String parent : itemsToScanNotOnDisk) {
                    if (!LocalPath.isChild(parent, localItem)) continue;
                    candidatesToRemove.add(candidateChange.getTargetServerItem());
                    continue block6;
                }
            }
        }
        for (String candidateToRemove : candidatesToRemove) {
            this.pc.removeCandidateByTargetServerItem(candidateToRemove);
        }
        if (candidatesToRemove.size() > 0) {
            LocalWorkspaceTransaction.getCurrent().setRaisePendingChangeCandidatesChanged(true);
        }
        this.fireChangedByScanEvent();
    }

    private void scanPartTwo() {
        for (WorkspaceLocalItem workspaceLocalItem : this.markForRemoval) {
            LocalPendingChange pcEntry;
            if (this.skippedItems.contains(workspaceLocalItem.getLocalItem()) || null != (pcEntry = this.pc.getByLocalVersion(workspaceLocalItem)) && pcEntry.isAdd()) continue;
            if (!workspaceLocalItem.isMissingOnDisk()) {
                this.lv.removeByServerItem(workspaceLocalItem.getServerItem(), workspaceLocalItem.isCommitted(), false);
                workspaceLocalItem.setMissingOnDisk(true);
                this.lv.add(workspaceLocalItem);
            }
            String targetServerItem = this.pc.getTargetServerItemForLocalVersion(workspaceLocalItem);
            if (workspaceLocalItem.isCommitted() && null == pcEntry && null != this.pc.getByTargetServerItem(targetServerItem)) continue;
            LocalPendingChange newChange = new LocalPendingChange(workspaceLocalItem, targetServerItem, ChangeType.DELETE);
            newChange.setCandidate(true);
            this.addCandidateChange(newChange);
        }
        for (WorkspaceLocalItem workspaceLocalItem : this.reappearedOnDisk) {
            if (this.skippedItems.contains(workspaceLocalItem.getLocalItem())) continue;
            this.lv.removeByServerItem(workspaceLocalItem.getServerItem(), workspaceLocalItem.isCommitted(), false);
            workspaceLocalItem.setMissingOnDisk(false);
            this.lv.add(workspaceLocalItem);
        }
        for (KeyValuePair keyValuePair : this.toUndo) {
            LocalPendingChange pcEntry;
            String localItem = (String)keyValuePair.getKey();
            long onDiskModifiedTime = (Long)keyValuePair.getValue();
            if (this.skippedItems.contains(localItem)) continue;
            WorkspaceLocalItem lvEntry = this.lv.getByLocalItem(localItem);
            if (lvEntry.getLastModifiedTime() != onDiskModifiedTime) {
                lvEntry.setLastModifiedTime(onDiskModifiedTime);
                this.lv.setDirty(true);
            }
            if (null == (pcEntry = this.pc.getByLocalVersion(lvEntry)) || !pcEntry.isEdit() || pcEntry.isAdd() || pcEntry.isEncoding() && pcEntry.getEncoding() != lvEntry.getEncoding()) continue;
            AtomicReference<Failure[]> outFailures = new AtomicReference<Failure[]>();
            AtomicBoolean outOnlineOperationRequired = new AtomicBoolean();
            ArrayList<LocalPendingChange> pcEntries = new ArrayList<LocalPendingChange>(1);
            pcEntries.add(pcEntry);
            GetOperation[] getOps = LocalDataAccessLayer.undoPendingChanges(LocalWorkspaceTransaction.getCurrent().getWorkspace(), this.wp, this.lv, this.pc, pcEntries, ChangeType.EDIT, outFailures, outOnlineOperationRequired);
            Check.isTrue(!outOnlineOperationRequired.get() && 1 == getOps.length, "!outOnlineOperationRequired.get() && (1 == getOps.length)");
            LocalWorkspaceTransaction.getCurrent().setRaisePendingChangesChanged(true);
        }
    }

    private void diffItem(EnumeratedLocalItem fromDisk, WorkspaceLocalItem lvEntry) {
        if (fromDisk.isDirectory()) {
            if (!lvEntry.isDirectory()) {
                this.markForRemoval.add(lvEntry);
            } else if (lvEntry.isMissingOnDisk()) {
                this.reappearedOnDisk.add(lvEntry);
            }
        } else if (lvEntry.isDirectory()) {
            this.markForRemoval.add(lvEntry);
        } else {
            LocalPendingChange pcEntry;
            if (lvEntry.isMissingOnDisk()) {
                this.reappearedOnDisk.add(lvEntry);
            }
            boolean pendEdit = false;
            boolean symlink = false;
            if (lvEntry.isSymbolicLink() || fromDisk.isSymbolicLink()) {
                symlink = true;
            }
            if (-1L == lvEntry.getLength() || 0 == lvEntry.getHashValue().length) {
                pendEdit = false;
            } else if (lvEntry.getLength() != fromDisk.getFileSize() && !symlink) {
                pendEdit = true;
            } else {
                long onDiskModifiedTime = fromDisk.getLastWriteTime();
                if (symlink || lvEntry.getLastModifiedTime() != onDiskModifiedTime) {
                    pendEdit = true;
                    byte[] onDiskHash = new byte[]{};
                    try {
                        onDiskHash = CheckinEngine.computeMD5Hash(lvEntry.getLocalItem(), null);
                    }
                    catch (CoreCancelException e) {
                        // empty catch block
                    }
                    if (onDiskHash.length > 0 && Arrays.equals(onDiskHash, lvEntry.getHashValue())) {
                        pendEdit = false;
                        this.toUndo.add(new KeyValuePair<String, Long>(lvEntry.getLocalItem(), onDiskModifiedTime));
                    }
                }
            }
            if (!(!pendEdit || this.skippedItems.contains(lvEntry.getLocalItem()) || null != (pcEntry = this.pc.getByLocalVersion(lvEntry)) && pcEntry.isEdit())) {
                ChangeRequest changeRequest = new ChangeRequest(new ItemSpec(lvEntry.getLocalItem(), RecursionType.NONE), LatestVersionSpec.INSTANCE, RequestType.EDIT, ItemType.FILE, -2, LockLevel.UNCHANGED, 0, null, false);
                AtomicReference<Failure[]> outDummy = new AtomicReference<Failure[]>();
                ChangeRequest[] changeRequests = new ChangeRequest[]{changeRequest};
                LocalDataAccessLayer.pendEdit(LocalWorkspaceTransaction.getCurrent().getWorkspace(), this.wp, this.lv, this.pc, changeRequests, true, outDummy, null);
                LocalWorkspaceTransaction.getCurrent().setRaisePendingChangesChanged(true);
            }
            if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX) && LocalWorkspaceTransaction.getCurrent().getWorkspace().getClient().getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                ChangeRequest[] changeRequests;
                AtomicReference<Failure[]> outDummy;
                AtomicBoolean outOnlineOperationRequired;
                ChangeRequest changeRequest;
                PropertyValue pendProperty = null;
                if (PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_DISABLE_SYMBOLIC_LINK_PROP") == null) {
                    boolean isSymlink = PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(lvEntry.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.SymbolicLink"));
                    if (isSymlink != fromDisk.isSymbolicLink()) {
                        PropertyValue propertyValue = pendProperty = fromDisk.isSymbolicLink() ? PropertyConstants.IS_SYMLINK : PropertyConstants.NOT_SYMLINK;
                    }
                    if (pendProperty != null && !this.skippedItems.contains(lvEntry.getLocalItem())) {
                        changeRequest = new ChangeRequest(new ItemSpec(lvEntry.getLocalItem(), RecursionType.NONE), LatestVersionSpec.INSTANCE, RequestType.PROPERTY, ItemType.FILE, -2, LockLevel.UNCHANGED, 0, null, false);
                        changeRequest.setProperties(new PropertyValue[]{pendProperty});
                        outOnlineOperationRequired = new AtomicBoolean();
                        outDummy = new AtomicReference<Failure[]>();
                        changeRequests = new ChangeRequest[]{changeRequest};
                        LocalDataAccessLayer.pendPropertyChange(LocalWorkspaceTransaction.getCurrent().getWorkspace(), this.wp, this.lv, this.pc, changeRequests, true, outDummy, outOnlineOperationRequired, new String[]{"Microsoft.TeamFoundation.VersionControl.SymbolicLink"});
                        LocalWorkspaceTransaction.getCurrent().setRaisePendingChangesChanged(true);
                    }
                }
                if (pendProperty == null && PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_DISABLE_DETECT_EXECUTABLE_PROP") == null) {
                    boolean lvExecutable = PropertyConstants.EXECUTABLE_ENABLED_VALUE.equals(PropertyUtils.selectMatching(lvEntry.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.Executable"));
                    if (lvExecutable != fromDisk.isExecutable()) {
                        PropertyValue propertyValue = pendProperty = fromDisk.isExecutable() ? PropertyConstants.EXECUTABLE_ENABLED_VALUE : PropertyConstants.EXECUTABLE_DISABLED_VALUE;
                    }
                    if (pendProperty != null && !this.skippedItems.contains(lvEntry.getLocalItem())) {
                        changeRequest = new ChangeRequest(new ItemSpec(lvEntry.getLocalItem(), RecursionType.NONE), LatestVersionSpec.INSTANCE, RequestType.PROPERTY, ItemType.FILE, -2, LockLevel.UNCHANGED, 0, null, false);
                        changeRequest.setProperties(new PropertyValue[]{pendProperty});
                        outOnlineOperationRequired = new AtomicBoolean();
                        outDummy = new AtomicReference();
                        changeRequests = new ChangeRequest[]{changeRequest};
                        LocalDataAccessLayer.pendPropertyChange(LocalWorkspaceTransaction.getCurrent().getWorkspace(), this.wp, this.lv, this.pc, changeRequests, true, outDummy, outOnlineOperationRequired, new String[]{"Microsoft.TeamFoundation.VersionControl.Executable"});
                        LocalWorkspaceTransaction.getCurrent().setRaisePendingChangesChanged(true);
                    }
                }
            }
        }
    }

    private boolean addCandidateAdd(EnumeratedLocalItem item) {
        if (item.isDirectory() && !item.isSymbolicLink()) {
            return false;
        }
        if (item.getServerItem().lastIndexOf(47) <= 1) {
            return false;
        }
        LocalPendingChange pc = new LocalPendingChange(item.getServerItem(), null, 0, ItemType.FILE, -2, ZERO_LENGTH_BYTE_ARRAY, 0, ChangeType.ADD_EDIT_ENCODING);
        if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            if (item.isSymbolicLink()) {
                pc.setChangeType(pc.getChangeType().combine(ChangeType.PROPERTY));
                pc.setPropertyValues(new PropertyValue[]{PropertyConstants.IS_SYMLINK});
            } else if (item.isExecutable() && PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_DISABLE_DETECT_EXECUTABLE_PROP") == null) {
                pc.setChangeType(pc.getChangeType().combine(ChangeType.PROPERTY));
                pc.setPropertyValues(new PropertyValue[]{PropertyConstants.EXECUTABLE_ENABLED_VALUE});
            }
        }
        pc.setCandidate(true);
        this.addCandidateChange(pc);
        return true;
    }

    private void addCandidateChange(LocalPendingChange candidate) {
        LocalPendingChange existingCandidate = this.pc.getCandidateByTargetServerItem(candidate.getTargetServerItem());
        if (null == existingCandidate || !existingCandidate.getChangeType().equals(candidate.getChangeType()) || existingCandidate.isCommitted() != candidate.isCommitted() || existingCandidate.getCommittedServerItem() != null && !existingCandidate.getCommittedServerItem().equals(candidate.getCommittedServerItem())) {
            if (null != existingCandidate) {
                this.pc.removeCandidateByTargetServerItem(existingCandidate.getTargetServerItem());
            }
            this.pc.addCandidate(candidate);
            LocalWorkspaceTransaction.getCurrent().setRaisePendingChangeCandidatesChanged(true);
        }
        this.candidateChanges.add(candidate.getTargetServerItem());
    }

    private void fireChangedByScanEvent() {
        if (this.changedByScan.size() > 0) {
            Workspace workspace = LocalWorkspaceTransaction.getCurrent().getWorkspace();
            workspace.getClient().getEventEngine().fireScannerModifiedFile(new ScannerModifiedFilesEvent(EventSource.newFromHere(), workspace, this.changedByScan));
        }
    }
}

