/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.LocalPendingChangeFlags;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.TimeZone;
import ms.tfs.versioncontrol.clientservices._03._LocalPendingChange;

public final class LocalPendingChange
extends WebServiceObjectWrapper {
    public static final int LOCAL_PENDING_CHANGE_ID = -123;
    private static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    private static final ChangeType BRANCH_AND_TARGET_RENAME = ChangeType.BRANCH.combine(ChangeType.TARGET_RENAME);
    private byte flags;
    public static final Comparator<LocalPendingChange> SERVER_ITEM_COMPARATOR = new Comparator<LocalPendingChange>(){

        @Override
        public int compare(LocalPendingChange change1, LocalPendingChange change2) {
            return ServerPath.compareTopDown(change1.getTargetServerItem(), change2.getTargetServerItem());
        }
    };

    public LocalPendingChange() {
        this(new _LocalPendingChange());
    }

    public LocalPendingChange(_LocalPendingChange change) {
        super(change);
    }

    public LocalPendingChange(WorkspaceLocalItem lvEntry, String targetServerItem, ChangeType change) {
        this();
        this.setTargetServerItem(targetServerItem);
        this.setCommittedServerItem(lvEntry.getServerItem());
        this.setVersion(lvEntry.getVersion());
        this.setItemType(lvEntry.isDirectory() ? ItemType.FOLDER : ItemType.FILE);
        this.setEncoding(lvEntry.getEncoding());
        this.setHashValue(lvEntry.isDirectory() ? ZERO_LENGTH_BYTE_ARRAY : lvEntry.getHashValue());
        this.setItemID(lvEntry.getItemID());
        this.setCreationDate(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.setChangeType(change);
        this.setPropertyValues(lvEntry.getPropertyValues());
    }

    public LocalPendingChange(String targetServerItem, String committedServerItem, int version, ItemType itemType, int encoding, byte[] hashValue, int itemId, ChangeType change) {
        this();
        this.setTargetServerItem(targetServerItem);
        this.setCommittedServerItem(committedServerItem);
        this.setVersion(version);
        this.setItemType(itemType);
        this.setEncoding(itemType == ItemType.FOLDER ? -3 : encoding);
        this.setHashValue(itemType == ItemType.FOLDER ? ZERO_LENGTH_BYTE_ARRAY : hashValue);
        this.setItemID(itemId);
        this.setCreationDate(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.setChangeType(change);
    }

    public LocalPendingChange clone() {
        LocalPendingChange clone = new LocalPendingChange(LocalPendingChange.cloneWebServiceObject(this.getWebServiceObject()));
        clone.flags = this.flags;
        return clone;
    }

    private static _LocalPendingChange cloneWebServiceObject(_LocalPendingChange change) {
        Check.notNull(change, "change");
        return new _LocalPendingChange(change.getTsi(), change.getCsi(), change.getBfi(), change.getV(), change.getBfv(), change.getC(), change.getIt(), change.getE(), change.getL(), change.getIid(), change.getCd() != null ? (Calendar)change.getCd().clone() : null, change.getHv() != null ? (byte[])change.getHv().clone() : null, change.getDi(), change.getFl());
    }

    public _LocalPendingChange getWebServiceObject() {
        return (_LocalPendingChange)this.webServiceObject;
    }

    public synchronized ItemType getItemType() {
        return ItemType.fromByteValue(this.getWebServiceObject().getIt());
    }

    public synchronized void setItemType(ItemType value) {
        this.getWebServiceObject().setIt(value.getValue());
    }

    public synchronized String getBranchFromItem() {
        return this.getWebServiceObject().getBfi();
    }

    public synchronized void setBranchFromItem(String value) {
        this.getWebServiceObject().setBfi(value);
    }

    public synchronized int getBranchFromVersion() {
        return this.getWebServiceObject().getBfv();
    }

    public synchronized void setBranchFromVersion(int value) {
        this.getWebServiceObject().setBfv(value);
    }

    public synchronized Calendar getCreationDate() {
        return this.getWebServiceObject().getCd();
    }

    public synchronized void setCreationDate(Calendar value) {
        this.getWebServiceObject().setCd(value);
    }

    public synchronized String getCommittedServerItem() {
        return this.getWebServiceObject().getCsi();
    }

    public synchronized void setCommittedServerItem(String value) {
        this.getWebServiceObject().setCsi(value);
    }

    public synchronized int getDeletionID() {
        return this.getWebServiceObject().getDi();
    }

    public synchronized void setDeletionID(int value) {
        this.getWebServiceObject().setDi(value);
    }

    public synchronized int getEncoding() {
        return this.getWebServiceObject().getE();
    }

    public synchronized void setEncoding(int value) {
        this.getWebServiceObject().setE(value);
    }

    public synchronized byte[] getHashValue() {
        return this.getWebServiceObject().getHv() != null ? (byte[])this.getWebServiceObject().getHv().clone() : null;
    }

    public synchronized void setHashValue(byte[] value) {
        this.getWebServiceObject().setHv(value != null ? (byte[])value.clone() : null);
    }

    public synchronized int getItemID() {
        return this.getWebServiceObject().getIid();
    }

    public synchronized void setItemID(int value) {
        this.getWebServiceObject().setIid(value);
    }

    public synchronized byte getLockStatus() {
        return this.getWebServiceObject().getL();
    }

    public synchronized void setLockStatus(byte value) {
        this.getWebServiceObject().setL(value);
    }

    public synchronized String getTargetServerItem() {
        return this.getWebServiceObject().getTsi();
    }

    public synchronized void setTargetServerItem(String value) {
        this.getWebServiceObject().setTsi(value);
    }

    public synchronized String getServerItem() {
        String serverItem = this.getCommittedServerItem();
        if (serverItem == null) {
            serverItem = this.getTargetServerItem();
        }
        return serverItem;
    }

    public synchronized int getVersion() {
        return this.getWebServiceObject().getV();
    }

    public synchronized void setVersion(int value) {
        this.getWebServiceObject().setV(value);
    }

    public synchronized LocalPendingChangeFlags getFlags() {
        return new LocalPendingChangeFlags(this.flags);
    }

    public synchronized void setFlags(LocalPendingChangeFlags value) {
        this.flags = (byte)value.toIntFlags();
    }

    public synchronized ChangeType getChangeType() {
        ChangeType changeType = ChangeType.fromIntFlags(this.getWebServiceObject().getC() << 1);
        if (changeType.containsAll(BRANCH_AND_TARGET_RENAME)) {
            changeType = changeType.remove(BRANCH_AND_TARGET_RENAME).combine(ChangeType.RENAME);
        }
        return changeType;
    }

    public synchronized void setChangeType(ChangeType value) {
        int flags = value.remove(ChangeType.RENAME).toIntFlags() >> 1;
        if (value.contains(ChangeType.RENAME)) {
            flags |= BRANCH_AND_TARGET_RENAME.toIntFlags() >> 1;
        }
        this.getWebServiceObject().setC(flags);
    }

    public boolean isCommitted() {
        return this.getVersion() != 0;
    }

    public boolean isAdd() {
        return this.getChangeType().contains(ChangeType.ADD);
    }

    public boolean isEdit() {
        return this.getChangeType().contains(ChangeType.EDIT);
    }

    public boolean isProperty() {
        return this.getChangeType().contains(ChangeType.PROPERTY);
    }

    public boolean isRename() {
        return this.getChangeType().contains(ChangeType.RENAME);
    }

    public boolean isEncoding() {
        return this.getChangeType().contains(ChangeType.ENCODING);
    }

    public boolean isDelete() {
        return this.getChangeType().contains(ChangeType.DELETE);
    }

    public boolean isUndelete() {
        return this.getChangeType().contains(ChangeType.UNDELETE);
    }

    public boolean isBranch() {
        return this.getChangeType().contains(ChangeType.BRANCH);
    }

    public boolean isMerge() {
        return this.getChangeType().contains(ChangeType.MERGE);
    }

    public boolean isRollback() {
        return this.getChangeType().contains(ChangeType.ROLLBACK);
    }

    public boolean isLock() {
        return this.getChangeType().contains(ChangeType.LOCK);
    }

    public boolean isRecursiveChange() {
        return this.getChangeType().containsAny(ChangeType.RENAME_OR_DELETE) && ItemType.FOLDER == this.getItemType();
    }

    public boolean hasMergeConflict() {
        return this.getFlags().contains(LocalPendingChangeFlags.HAS_MERGE_CONFLICT);
    }

    public synchronized void setMergeConflict(boolean value) {
        if (value) {
            this.setFlags(this.getFlags().combine(LocalPendingChangeFlags.HAS_MERGE_CONFLICT));
        } else {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.HAS_MERGE_CONFLICT));
        }
    }

    public boolean isCandidate() {
        return this.getFlags().contains(LocalPendingChangeFlags.IS_CANDIDATE);
    }

    public synchronized void setCandidate(boolean value) {
        if (value) {
            this.setFlags(this.getFlags().combine(LocalPendingChangeFlags.IS_CANDIDATE));
        } else {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.IS_CANDIDATE));
        }
    }

    public PropertyValue[] getPropertyValues() {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        if (this.getFlags().contains(LocalPendingChangeFlags.SYMLINK)) {
            values.add(PropertyConstants.IS_SYMLINK);
        } else if (this.getFlags().contains(LocalPendingChangeFlags.NOT_SYMLINK)) {
            values.add(PropertyConstants.NOT_SYMLINK);
        } else if (this.getFlags().contains(LocalPendingChangeFlags.EXECUTABLE)) {
            values.add(PropertyConstants.EXECUTABLE_ENABLED_VALUE);
        } else if (this.getFlags().contains(LocalPendingChangeFlags.NOT_EXECUTABLE)) {
            values.add(PropertyConstants.EXECUTABLE_DISABLED_VALUE);
        }
        return values.size() > 0 ? values.toArray(new PropertyValue[values.size()]) : null;
    }

    public void setPropertyValues(PropertyValue[] values) {
        boolean setExecutable = false;
        boolean setNotExecutable = false;
        PropertyValue x = PropertyUtils.selectMatching(values, "Microsoft.TeamFoundation.VersionControl.Executable");
        if (x != null) {
            if (PropertyConstants.EXECUTABLE_ENABLED_VALUE.equals(x)) {
                setExecutable = true;
            } else {
                setNotExecutable = true;
            }
        }
        if (setExecutable) {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.NOT_EXECUTABLE).combine(LocalPendingChangeFlags.EXECUTABLE));
        } else if (setNotExecutable) {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.EXECUTABLE).combine(LocalPendingChangeFlags.NOT_EXECUTABLE));
        } else {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.EXECUTABLE).remove(LocalPendingChangeFlags.NOT_EXECUTABLE));
        }
        boolean setSymlink = false;
        boolean setNotSymlink = false;
        PropertyValue v = PropertyUtils.selectMatching(values, "Microsoft.TeamFoundation.VersionControl.SymbolicLink");
        if (v != null) {
            if (PropertyConstants.IS_SYMLINK.equals(v)) {
                setSymlink = true;
            } else {
                setNotSymlink = true;
            }
        }
        if (setSymlink) {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.NOT_SYMLINK).combine(LocalPendingChangeFlags.SYMLINK));
        } else if (setNotSymlink) {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.SYMLINK).combine(LocalPendingChangeFlags.NOT_SYMLINK));
        } else {
            this.setFlags(this.getFlags().remove(LocalPendingChangeFlags.SYMLINK).remove(LocalPendingChangeFlags.NOT_SYMLINK));
        }
    }

    public PendingChange toPendingChange(VersionControlClient sourceControl, String targetLocalItem) {
        int version;
        String item;
        byte[] hashValue = this.getHashValue();
        if (null == this.getHashValue() || 16 != this.getHashValue().length) {
            hashValue = ZERO_LENGTH_BYTE_ARRAY;
        }
        if ((item = this.getBranchFromItem()) == null) {
            item = this.getCommittedServerItem();
        }
        if ((version = this.getBranchFromVersion()) <= 0) {
            version = this.getVersion();
        }
        Calendar creationDate = this.getCreationDate();
        creationDate.setTimeZone(TimeZone.getDefault());
        return new PendingChange(this.getTargetServerItem(), item, version, 0, this.getDeletionID(), LockLevel.fromByteValue(this.getLockStatus()), targetLocalItem, this.getItemType(), this.getItemID(), creationDate, this.getVersion(), this.getChangeType(), hashValue, hashValue, this.getEncoding(), -123, this.getPropertyValues(), this.isCandidate());
    }

    public static LocalPendingChange fromPendingChange(PendingChange pc) {
        LocalPendingChange localPc = new LocalPendingChange();
        localPc.setTargetServerItem(pc.getServerItem());
        localPc.setCommittedServerItem(pc.getSourceServerItem());
        if (null == localPc.getCommittedServerItem() && !pc.isAdd() && !pc.isBranch()) {
            localPc.setCommittedServerItem(pc.getServerItem());
        }
        if (pc.isBranch()) {
            localPc.setBranchFromItem(pc.getSourceServerItem());
            localPc.setBranchFromVersion(pc.getSourceVersionFrom());
        }
        localPc.setVersion(pc.getVersion());
        localPc.setChangeType(pc.getChangeType());
        localPc.setItemType(pc.getItemType());
        localPc.setEncoding(pc.getEncoding());
        if (pc.getLockLevel() == LockLevel.CHECKOUT) {
            localPc.setLockStatus(LockLevel.CHECKIN.getValue());
        } else {
            localPc.setLockStatus(pc.getLockLevel().getValue());
        }
        localPc.setItemID(pc.isAdd() || pc.isBranch() ? 0 : pc.getItemID());
        Calendar creationDate = pc.getCreationDate();
        creationDate.setTimeZone(TimeZone.getTimeZone("UTC"));
        localPc.setCreationDate(creationDate);
        localPc.setDeletionID(pc.getDeletionID());
        if (ItemType.FILE == pc.getItemType()) {
            localPc.setHashValue(pc.getHashValue());
            if (null == localPc.getHashValue() || localPc.getHashValue().length != 16) {
                localPc.setHashValue(ZERO_LENGTH_BYTE_ARRAY);
            }
        }
        localPc.setMergeConflict(pc.getConflictType() == ConflictType.MERGE);
        localPc.setPropertyValues(pc.getPropertyValues());
        return localPc;
    }

    @Override
    public String toString() {
        return MessageFormat.format("LocalPendingChange [getServerItem()={11}, getItemType()={0}, getBranchFromItem()={1}, getBranchFromVersion()={2}, getCreationDate()={3}, getCommittedServerItem()={4}, getDeletionID()={5}, getEncoding()={6}, getHashValue()={7}, getItemID()={8}, getLockStatus()={9}, getTargetServerItem()={10}, getVersion()={12}, getFlags()={13}, getChangeType()={14}, isCommitted()={15}, getPropertyValues()={16}]", this.getItemType(), this.getBranchFromItem(), this.getBranchFromVersion(), this.getCreationDate() != null ? Long.valueOf(this.getCreationDate().getTimeInMillis()) : null, this.getCommittedServerItem(), this.getDeletionID(), this.getEncoding(), Arrays.toString(this.getHashValue()), this.getItemID(), this.getLockStatus(), this.getTargetServerItem(), this.getServerItem(), this.getVersion(), this.getFlags(), this.getChangeType(), this.isCommitted(), Arrays.toString(this.getPropertyValues()));
    }
}

