/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.artifact.ArtifactIDFactory;
import com.microsoft.tfs.core.checkinpolicies.PolicyContext;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluationCancelledException;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluator;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluatorState;
import com.microsoft.tfs.core.checkinpolicies.PolicyFailure;
import com.microsoft.tfs.core.clients.security.AccessControlEntry;
import com.microsoft.tfs.core.clients.security.AccessControlEntryDetails;
import com.microsoft.tfs.core.clients.security.AccessControlListDetails;
import com.microsoft.tfs.core.clients.versioncontrol.AutoResolveOptions;
import com.microsoft.tfs.core.clients.versioncontrol.BranchHistory;
import com.microsoft.tfs.core.clients.versioncontrol.BranchHistoryTreeItem;
import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.CheckinFlags;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetStatus;
import com.microsoft.tfs.core.clients.versioncontrol.ItemProperties;
import com.microsoft.tfs.core.clients.versioncontrol.MergeFlags;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.PropertiesMergeSummary;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.ReconcilePendingChangesStatus;
import com.microsoft.tfs.core.clients.versioncontrol.ResolveErrorOptions;
import com.microsoft.tfs.core.clients.versioncontrol.RollbackOptions;
import com.microsoft.tfs.core.clients.versioncontrol.SupportedFeatures;
import com.microsoft.tfs.core.clients.versioncontrol.UnshelveResult;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissionProfile;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionFactory;
import com.microsoft.tfs.core.clients.versioncontrol.engines.MergeEngine;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.CheckinEngine;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.GetEngine;
import com.microsoft.tfs.core.clients.versioncontrol.events.CheckinEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetOperationCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetOperationStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.MergeOperationCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.MergeOperationStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.MergingEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendOperationCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendOperationStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ResolveConflictCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ResolveConflictStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ResolveConflictsCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ResolveConflictsStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.RollbackOperationCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.RollbackOperationStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ShelveEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.UndoOperationCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.UndoOperationStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.UnshelveShelvesetCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.UnshelveShelvesetStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ActionDeniedBySubscriberException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.AutoMergeDisallowedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ChangeRequestValidationException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.CheckinException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.GatedCheckinException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemNotMappedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.MappingConflictException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ShelveException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.UnshelveException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.WorkspaceDeletedException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.WritableConflictOnSourcePathListener;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalDataAccessLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.OfflineCacheData;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalItemExclusionEvaluator;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.WorkspaceWatcher;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.internal.FileSystemWalker;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldDefinition;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictOptions;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.FileType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelChildOption;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Mapping;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.MergeCandidate;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PathTranslation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChangeComparator;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChangeComparatorType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PolicyOverrideInfo;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.SeverityType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Shelveset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLabel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkItemCheckinInfo;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkspaceItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.CheckinNotificationInfo;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.CheckinNotificationWorkItemInfo;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.SavedCheckin;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkItemCheckedInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptorComparer;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.clients.workitem.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnableToSaveException;
import com.microsoft.tfs.core.clients.workitem.link.ExternalLink;
import com.microsoft.tfs.core.clients.workitem.link.LinkFactory;
import com.microsoft.tfs.core.clients.workitem.link.RegisteredLinkType;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.externaltools.ExternalToolset;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.pendingcheckin.CheckinConflict;
import com.microsoft.tfs.core.pendingcheckin.CheckinConflictContainer;
import com.microsoft.tfs.core.pendingcheckin.CheckinEvaluationOptions;
import com.microsoft.tfs.core.pendingcheckin.CheckinEvaluationResult;
import com.microsoft.tfs.core.pendingcheckin.CheckinNoteFailure;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckin;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinNotes;
import com.microsoft.tfs.core.pendingcheckin.StandardPendingCheckin;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.FileEncodingDetector;
import com.microsoft.tfs.core.util.ServerURIComparator;
import com.microsoft.tfs.core.util.UserNameUtil;
import com.microsoft.tfs.core.util.notifications.Notification;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.jni.helpers.LocalHost;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import com.microsoft.tfs.util.NewlineUtils;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.process.ProcessFinishedHandler;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import ms.tfs.versioncontrol.clientservices._03._BranchRelative;
import ms.tfs.versioncontrol.clientservices._03._WorkingFolder;
import ms.tfs.versioncontrol.clientservices._03._Workspace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Workspace
extends WebServiceObjectWrapper
implements Comparable<Workspace> {
    private static final String TFIGNORE_HEADER_RESOURCE = "com/microsoft/tfs/core/tfignoreheader.txt";
    private static final String BUILD_CHECKIN_SUBSCRIBER = "Microsoft.TeamFoundation.Build.Server.BuildCheckinNotificationSubscriber";
    private static final Log log = LogFactory.getLog(Workspace.class);
    private final VersionControlClient client;
    private final OfflineCacheData offlineCache = new OfflineCacheData();
    private volatile WorkspacePermissionProfile permissionsProfile = null;
    private volatile WorkspaceWatcher workspaceWatcher;
    private volatile boolean deleted;
    private volatile boolean uncachedPropertiesStale;
    private volatile boolean workingFoldersStale;

    public Workspace(_Workspace workspace, VersionControlClient client) {
        super(workspace);
        this.client = client;
        String displayName = workspace.getOwnerdisp();
        if (displayName == null || displayName.length() == 0) {
            workspace.setOwnerdisp(workspace.getOwner());
        }
    }

    private Workspace(Workspace workspace) {
        super(workspace.getWebServiceObject());
        this.client = workspace.client;
        this.deleted = workspace.deleted;
        this.permissionsProfile = workspace.permissionsProfile == null ? null : new WorkspacePermissionProfile(workspace.permissionsProfile.getName(), workspace.permissionsProfile.getAccessControlEntries());
        this.uncachedPropertiesStale = workspace.uncachedPropertiesStale;
        this.workingFoldersStale = workspace.workingFoldersStale;
    }

    public Workspace(VersionControlClient client, String name, String owner, String comment, WorkingFolder[] workingFolders, String computer, WorkspaceLocation location) {
        this(client, name, owner, null, null, comment, workingFolders, computer, location, WorkspacePermissions.NONE_OR_NOT_SUPPORTED);
    }

    public Workspace(VersionControlClient client, String name, String owner, String ownerDisplayName, String[] ownerAliases, String comment, WorkingFolder[] workingFolders, String computer, WorkspaceLocation location, WorkspacePermissions effectivePermissions) {
        this(client, name, owner, ownerDisplayName, ownerAliases, comment, null, workingFolders, computer, location, effectivePermissions, null, WorkspaceOptions.NONE);
    }

    public Workspace(VersionControlClient client, String name, String owner, String ownerDisplayName, String[] ownerAliases, String comment, String securityToken, WorkingFolder[] workingFolders, String computer, WorkspaceLocation location, WorkspacePermissions effectivePermissions, WorkspacePermissionProfile permissionProfile, WorkspaceOptions options) {
        super(new _Workspace(computer, WorkspaceLocation.LOCAL.equals(location), name, owner, ownerDisplayName, owner, effectivePermissions.toIntFlags(), securityToken, null, null, comment, workingFolders != null ? (_WorkingFolder[])WrapperUtils.unwrap(_WorkingFolder.class, workingFolders) : new _WorkingFolder[]{}, ownerAliases, Calendar.getInstance(), options.toIntFlags()));
        Check.notNull(client, "client");
        Check.notNullOrEmpty(name, "name");
        Check.notNullOrEmpty(owner, "owner");
        Check.notNullOrEmpty(computer, "computer");
        Check.notNull(location, "location");
        this.client = client;
        this.permissionsProfile = permissionProfile;
    }

    public WorkspaceWatcher getWorkspaceWatcher() {
        if (this.workspaceWatcher == null) {
            this.workspaceWatcher = new WorkspaceWatcher(this);
        }
        return this.workspaceWatcher;
    }

    public OfflineCacheData getOfflineCacheData() {
        return this.offlineCache;
    }

    public String getLocalMetadataDirectory() {
        Check.isTrue(this.getLocation() == WorkspaceLocation.LOCAL, "getLocation() == WorkspaceLocation.LOCAL");
        File dir = Workstation.getOfflineMetadataFileRoot(this.getClient().getConnection().getPersistenceStoreProvider());
        return this.getWorkspaceDirectory(dir.getAbsolutePath());
    }

    public String getWorkspaceDirectory(String basePath) {
        String serverBase = LocalPath.combine(basePath, this.client.getServerGUID().getGUIDString());
        String workspaceBase = LocalPath.combine(serverBase, FileHelpers.removeInvalidNTFSFileNameCharacters(this.getSecurityToken()));
        return workspaceBase;
    }

    public _Workspace getWebServiceObject() {
        return (_Workspace)this.webServiceObject;
    }

    public String getServerName() {
        return this.client.getConnection().getName();
    }

    public URI getServerURI() {
        return this.client.getConnection().getBaseURI();
    }

    public GUID getServerGUID() {
        return this.client.getServerGUID();
    }

    public VersionControlClient getClient() {
        return this.client;
    }

    public void invalidate() {
        this.uncachedPropertiesStale = true;
        this.workingFoldersStale = true;
        this.permissionsProfile = null;
    }

    public void invalidateMappings() {
        this.workingFoldersStale = true;
    }

    public ExtendedItem[] getExtendedItems(String itemPath, DeletedState deletedState, ItemType itemType) {
        return this.getExtendedItems(new ItemSpec[]{new ItemSpec(itemPath, RecursionType.NONE)}, deletedState, itemType)[0];
    }

    public ExtendedItem[][] getExtendedItems(ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType) {
        return this.getExtendedItems(itemSpecs, deletedState, itemType, GetItemsOptions.NONE);
    }

    public ExtendedItem[][] getExtendedItems(ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType, GetItemsOptions options) {
        return this.getExtendedItems(itemSpecs, deletedState, itemType, options, null);
    }

    public ExtendedItem[][] getExtendedItems(ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType, GetItemsOptions options, String[] itemPropertyFilters) {
        return this.client.getExtendedItems(this.getName(), this.getOwnerName(), itemSpecs, deletedState, itemType, options, itemPropertyFilters);
    }

    public WorkspaceItemSet[] getItems(ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType, boolean generateDownloadUrls, GetItemsOptions getItemsOptions) {
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        return this.client.getWebServiceLayer().queryWorkspaceItems(this.getName(), this.getOwnerName(), itemSpecs, deletedState, itemType, generateDownloadUrls, getItemsOptions.toIntFlags());
    }

    public void addConflict(ConflictType conflictType, int itemID, int versionServer, int pendingChangeID, String sourceLocalItem, String targetLocalItem, OperationStatus conflictReason) {
        this.client.getWebServiceLayer().addConflict(this.getName(), this.getOwnerName(), conflictType, itemID, versionServer, pendingChangeID, sourceLocalItem, targetLocalItem, conflictReason, this.client.mergeWithDefaultItemPropertyFilters(null));
    }

    public CheckinEvaluationResult evaluateCheckIn(CheckinEvaluationOptions options, PendingChange[] allChanges, PendingChange[] changesToCheckin, String comment, CheckinNote checkinNotes, WorkItemCheckinInfo[] workItemChanges, PolicyEvaluator policyEvaluator, PolicyContext policyContext) throws PolicyEvaluationCancelledException {
        Check.notNull(options, "options");
        Check.notNullOrEmpty(allChanges, "allChanges");
        Check.notNullOrEmpty(changesToCheckin, "changesToCheckin");
        Check.notNull(checkinNotes, "checkinNote");
        Check.notNull(workItemChanges, "workItemChanges");
        Check.notNull(policyEvaluator, "policyEvaluator");
        Check.notNull(policyContext, "policyContext");
        return this.evaluateCheckIn(options, new StandardPendingCheckin(this, allChanges, changesToCheckin, comment, checkinNotes, workItemChanges, policyEvaluator), policyContext);
    }

    public CheckinEvaluationResult evaluateCheckIn(CheckinEvaluationOptions options, PendingCheckin pendingCheckin, PolicyContext policyContext) throws PolicyEvaluationCancelledException {
        Check.notNull(options, "options");
        Check.notNull(policyContext, "policyContext");
        TaskMonitor tm = TaskMonitorService.getTaskMonitor();
        if (tm.isCanceled()) {
            throw new CanceledException();
        }
        CheckinNoteFailure[] noteFailures = new CheckinNoteFailure[]{};
        if (options.containsAny(CheckinEvaluationOptions.NOTES)) {
            log.debug((Object)"Evaluating checkin notes");
            PendingCheckinNotes notes = pendingCheckin.getCheckinNotes();
            noteFailures = notes.evaluate();
            log.debug((Object)"Checking for notes that don't match field definitions");
            ArrayList<CheckinNoteFailure> unknownNotes = new ArrayList<CheckinNoteFailure>();
            if (notes.getCheckinNotes() != null && notes.getCheckinNotes().getValues() != null) {
                for (int i = 0; i < notes.getCheckinNotes().getValues().length; ++i) {
                    CheckinNoteFieldValue value = notes.getCheckinNotes().getValues()[i];
                    boolean noteNameDefinied = false;
                    for (int j = 0; j < notes.getFieldDefinitions().length; ++j) {
                        CheckinNoteFieldDefinition definition = notes.getFieldDefinitions()[j];
                        if (!value.getName().equalsIgnoreCase(definition.getName())) continue;
                        noteNameDefinied = true;
                        break;
                    }
                    if (noteNameDefinied) continue;
                    CheckinNoteFieldDefinition fakeDefinition = new CheckinNoteFieldDefinition(value.getName(), false, 0);
                    unknownNotes.add(new CheckinNoteFailure(fakeDefinition, MessageFormat.format(Messages.getString("Workspace.TheFieldDoesNotExistsFormat"), value.getName())));
                }
            }
            if (unknownNotes.size() > 0) {
                unknownNotes.addAll(Arrays.asList(noteFailures));
                noteFailures = unknownNotes.toArray(new CheckinNoteFailure[unknownNotes.size()]);
            }
        }
        if (tm.isCanceled()) {
            throw new CanceledException();
        }
        PolicyFailure[] policyFailures = new PolicyFailure[]{};
        PolicyEvaluatorState evaluatorState = null;
        Exception policyException = null;
        if (options.containsAny(CheckinEvaluationOptions.POLICIES)) {
            log.debug((Object)"Evaluating check-in policies");
            try {
                policyFailures = pendingCheckin.getCheckinPolicies().evaluate(policyContext);
            }
            catch (PolicyEvaluationCancelledException e) {
                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
                throw e;
            }
            catch (Exception e) {
                policyException = e;
            }
            evaluatorState = pendingCheckin.getCheckinPolicies().getPolicyEvaluatorState();
            log.debug((Object)MessageFormat.format("Final state of evaluator was: {0}", evaluatorState.toString()));
            log.debug((Object)MessageFormat.format("Policy exception was: {0}", policyException != null ? policyException.getMessage() : "<null>"));
            log.debug((Object)MessageFormat.format("Failures count: {0}", policyFailures != null ? Integer.toString(policyFailures.length) : "<null>"));
        }
        if (tm.isCanceled()) {
            throw new CanceledException();
        }
        CheckinConflict[] conflicts = new CheckinConflict[]{};
        if (options.containsAny(CheckinEvaluationOptions.CONFLICTS)) {
            Failure[] failures = this.checkPendingChanges(PendingChange.toServerItems(pendingCheckin.getPendingChanges().getCheckedPendingChanges()));
            conflicts = this.convertFailuresToConflicts(failures).getConflicts();
        }
        if (tm.isCanceled()) {
            throw new CanceledException();
        }
        return new CheckinEvaluationResult(conflicts, noteFailures, policyFailures, evaluatorState, policyException);
    }

    public int checkIn(PendingChange[] changes, String comment) throws CheckinException {
        return this.checkIn(changes, comment, null, null, null);
    }

    public int checkIn(PendingChange[] changes, String comment, CheckinNote checkinNote, WorkItemCheckinInfo[] associatedWorkItems, PolicyOverrideInfo policyOverrideInfo) throws CheckinException {
        return this.checkIn(changes, null, null, comment, checkinNote, associatedWorkItems, null);
    }

    public int checkIn(PendingChange[] changes, String author, String authorDisplayName, String comment, CheckinNote checkinNote, WorkItemCheckinInfo[] associatedWorkItems, PolicyOverrideInfo policyOverrideInfo) throws CheckinException {
        return this.checkIn(changes, author, authorDisplayName, comment, checkinNote, associatedWorkItems, policyOverrideInfo, CheckinFlags.NONE);
    }

    public int checkIn(PendingChange[] changes, String author, String authorDisplayName, String comment, CheckinNote checkinNote, WorkItemCheckinInfo[] associatedWorkItems, PolicyOverrideInfo policyOverrideInfo, CheckinFlags flags) throws CheckinException {
        return this.checkIn(changes, null, null, author, authorDisplayName, comment, checkinNote, associatedWorkItems, policyOverrideInfo, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkIn(PendingChange[] changes, String committer, String committerDisplayName, String author, String authorDisplayName, String comment, CheckinNote checkinNote, WorkItemCheckinInfo[] associatedWorkItems, PolicyOverrideInfo policyOverrideInfo, CheckinFlags flags) throws CheckinException {
        Check.isTrue(changes == null || changes.length > 0, "changes must be null for server-side change selection or non-empty");
        Check.notNull(flags, "flags");
        if (associatedWorkItems == null) {
            associatedWorkItems = new WorkItemCheckinInfo[]{};
        }
        TaskMonitor monitor = TaskMonitorService.getTaskMonitor();
        monitor.begin("", 100);
        String[] serverItems = null;
        if (changes != null) {
            changes = (PendingChange[])changes.clone();
            Arrays.sort(changes, new PendingChangeComparator(PendingChangeComparatorType.SERVER_ITEM));
            serverItems = PendingChange.toServerItems(changes);
        }
        boolean success = false;
        try {
            CheckinResult result;
            Changeset changeset;
            block49: {
                FileSystemAttributes attributes;
                TaskMonitorService.pushTaskMonitor(monitor.newSubTaskMonitor(75));
                try {
                    if (changes != null) {
                        CheckinEngine ci = new CheckinEngine(this.client, this);
                        long start = System.currentTimeMillis();
                        ci.uploadChanges(changes, false, this.getLocation() == WorkspaceLocation.LOCAL);
                        log.debug((Object)MessageFormat.format("total time for upload of {0} was {1} ms", changes.length, System.currentTimeMillis() - start));
                    } else {
                        log.debug((Object)"null changes (server side change selection), skipped upload");
                    }
                }
                finally {
                    TaskMonitorService.popTaskMonitor(true);
                }
                if (author == null) {
                    author = ".";
                }
                if (authorDisplayName == null) {
                    authorDisplayName = UserNameUtil.getCurrentUserName();
                    String domainName = UserNameUtil.getCurrentUserDomain();
                    if (!StringUtil.isNullOrEmpty(domainName)) {
                        authorDisplayName = UserNameUtil.format(authorDisplayName, domainName);
                    }
                }
                changeset = new Changeset(null, comment, checkinNote, policyOverrideInfo, committer, committerDisplayName, null, -1, author, authorDisplayName, null);
                if (monitor.isCanceled()) {
                    throw new CoreCancelException();
                }
                monitor.setCurrentWorkDescription(Messages.getString("Workspace.CheckinInNewChangeset"));
                AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
                AtomicReference<Failure[]> conflicts = new AtomicReference<Failure[]>();
                boolean noAutoResolve = flags.contains(CheckinFlags.NO_AUTO_RESOLVE);
                try {
                    result = this.getClient().getWebServiceLayer().checkIn(this.getName(), this.getOwnerName(), serverItems, changeset, this.makeCheckinNotificationInfo(associatedWorkItems), flags, null, conflicts, failures, false, 0, this.client.mergeWithDefaultItemPropertyFilters(null));
                }
                catch (ActionDeniedBySubscriberException e) {
                    if (e.getSubscriberType().equals(BUILD_CHECKIN_SUBSCRIBER) && e.getStatusCode() == 1) {
                        throw new GatedCheckinException(e);
                    }
                    throw e;
                }
                monitor.worked(10);
                changeset.setChangesetID(result.getChangeset());
                this.reportCheckinConflictsAndThrow(result, conflicts.get(), failures.get(), noAutoResolve);
                TaskMonitor setFileTimeMonitor = monitor.newSubTaskMonitor(5);
                try {
                    GetOperation[] updates;
                    if (this.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN) && (updates = result.getLocalVersionUpdates()) != null && updates.length > 0) {
                        setFileTimeMonitor.begin(Messages.getString("Workspace.SettingFileTime"), updates.length);
                        for (WebServiceObjectWrapper webServiceObjectWrapper : updates) {
                            if (ItemType.FILE != ((GetOperation)webServiceObjectWrapper).getItemType() || null == ((GetOperation)webServiceObjectWrapper).getTargetLocalItem() || !new File(((GetOperation)webServiceObjectWrapper).getTargetLocalItem()).exists()) continue;
                            setFileTimeMonitor.setCurrentWorkDescription(((GetOperation)webServiceObjectWrapper).getTargetLocalItem());
                            try {
                                attributes = FileSystemUtils.getInstance().getAttributes(((GetOperation)webServiceObjectWrapper).getTargetLocalItem());
                                boolean restoreReadOnly = false;
                                if (attributes.isReadOnly()) {
                                    attributes.setReadOnly(false);
                                    FileSystemUtils.getInstance().setAttributes(((GetOperation)webServiceObjectWrapper).getTargetLocalItem(), attributes);
                                    restoreReadOnly = true;
                                }
                                new File(((GetOperation)webServiceObjectWrapper).getTargetLocalItem()).setLastModified(result.getCreationDate().getTimeInMillis());
                                if (!restoreReadOnly) continue;
                                attributes.setReadOnly(true);
                                FileSystemUtils.getInstance().setAttributes(((GetOperation)webServiceObjectWrapper).getTargetLocalItem(), attributes);
                            }
                            catch (Exception e) {
                                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
                            }
                        }
                    }
                }
                finally {
                    setFileTimeMonitor.done();
                }
                TaskMonitor makeReadOnlyMonitor = monitor.newSubTaskMonitor(5);
                try {
                    if (changes == null || this.getLocation() != WorkspaceLocation.SERVER) break block49;
                    makeReadOnlyMonitor.begin(Messages.getString("Workspace.SettingReadOnly"), changes.length);
                    for (WebServiceObjectWrapper webServiceObjectWrapper : changes) {
                        if (((PendingChange)webServiceObjectWrapper).getChangeType().contains(ChangeType.EDIT) && ((PendingChange)webServiceObjectWrapper).getLocalItem() != null && new File(((PendingChange)webServiceObjectWrapper).getLocalItem()).exists()) {
                            makeReadOnlyMonitor.setCurrentWorkDescription(((PendingChange)webServiceObjectWrapper).getLocalItem());
                            try {
                                attributes = FileSystemUtils.getInstance().getAttributes(((PendingChange)webServiceObjectWrapper).getLocalItem());
                                if (!attributes.isSymbolicLink() && !attributes.isDirectory()) {
                                    attributes.setReadOnly(true);
                                    FileSystemUtils.getInstance().setAttributes(((PendingChange)webServiceObjectWrapper).getLocalItem(), attributes);
                                }
                            }
                            catch (Exception e) {
                                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
                            }
                        } else {
                            makeReadOnlyMonitor.setCurrentWorkDescription("");
                        }
                        makeReadOnlyMonitor.worked(1);
                    }
                }
                finally {
                    makeReadOnlyMonitor.done();
                }
            }
            monitor.setCurrentWorkDescription(Messages.getString("Workspace.NotifyingListeners"));
            PendingChange[] committedChangesArray = new PendingChange[]{};
            PendingChange[] undoneChangesArray = new PendingChange[]{};
            if (changes != null && changes.length > 0) {
                TreeSet<String> undoneServerItems = new TreeSet<String>(ServerPath.TOP_DOWN_COMPARATOR);
                for (String undoneServerItem : result.getUndoneServerItems()) {
                    undoneServerItems.add(undoneServerItem);
                }
                ArrayList<PendingChange> arrayList = new ArrayList<PendingChange>(undoneServerItems.size());
                ArrayList<PendingChange> committedPendingChanges = new ArrayList<PendingChange>();
                for (PendingChange change : changes) {
                    if (undoneServerItems.contains(change.getServerItem())) {
                        arrayList.add(change);
                        continue;
                    }
                    committedPendingChanges.add(change);
                }
                committedChangesArray = committedPendingChanges.toArray(new PendingChange[committedPendingChanges.size()]);
                undoneChangesArray = arrayList.toArray(new PendingChange[arrayList.size()]);
            }
            this.client.getEventEngine().fireCheckin(new CheckinEvent(EventSource.newFromHere(), this, result.getChangeset(), committedChangesArray, undoneChangesArray));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED);
            monitor.worked(1);
            int cset = changeset.getChangesetID();
            TaskMonitorService.pushTaskMonitor(monitor.newSubTaskMonitor(4));
            try {
                if (cset != 0) {
                    this.updateWorkItems(associatedWorkItems, cset, comment);
                }
            }
            finally {
                TaskMonitorService.popTaskMonitor(true);
            }
            this.setLastSavedCheckin(this.buildEmptyLastSavedCheckin());
            success = true;
            int n = cset;
            return n;
        }
        catch (CanceledException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new CoreCancelException(Messages.getString("Workspace.CheckinCancelled"))));
            int n = 0;
            return n;
        }
        catch (CoreCancelException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new CanceledException(Messages.getString("Workspace.CheckinCancelled"))));
            int n = 0;
            return n;
        }
        finally {
            if (!success) {
                this.updateLastSavedCheckin(comment, checkinNote, associatedWorkItems, policyOverrideInfo);
            }
            monitor.done();
        }
    }

    public Failure[] checkPendingChanges(String[] serverItems) {
        Check.notNull(serverItems, "serverItems");
        return this.client.getWebServiceLayer().checkPendingChanges(this.getName(), this.getOwnerName(), serverItems);
    }

    private CheckinConflictContainer convertFailuresToConflicts(Failure[] failures) {
        Check.notNull(failures, "failures");
        CheckinConflict[] ret = new CheckinConflict[failures.length];
        boolean anyResolvable = true;
        for (int i = 0; i < failures.length; ++i) {
            boolean thisOneResolvable = true;
            Failure failure = failures[i];
            if (!(failure.getCode().equals("LocalItemOutOfDateException") || failure.getCode().equals("MergeConflictExistsException") || failure.getCode().equals("ItemExistsException") || failure.getCode().equals("ItemDeletedException") || failure.getCode().equals("LatestVersionDeletedException"))) {
                thisOneResolvable = false;
                anyResolvable = false;
            }
            ret[i] = new CheckinConflict(failure.getServerItem(), failure.getCode(), failure.getMessage(), thisOneResolvable);
        }
        return new CheckinConflictContainer(ret, anyResolvable);
    }

    private void reportCheckinConflictsAndThrow(CheckinResult checkinResult, Failure[] conflicts, Failure[] failures, boolean noAutoResolve) {
        CheckinConflict[] checkinConflicts;
        boolean throwErrorOnFailedCheckin = false;
        if (failures != null && failures.length > 0) {
            for (Failure failure : failures) {
                if (SeverityType.ERROR.equals(failure.getSeverity())) {
                    throwErrorOnFailedCheckin = true;
                }
                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, failure));
            }
        }
        boolean isAnyResolvable = false;
        if (conflicts != null && conflicts.length > 0) {
            throwErrorOnFailedCheckin = true;
            CheckinConflictContainer checkinConflictContainer = this.convertFailuresToConflicts(conflicts);
            checkinConflicts = checkinConflictContainer.getConflicts();
            isAnyResolvable = checkinConflictContainer.isAnyResolvable();
            boolean allConflictsResolved = false;
            if (isAnyResolvable && !noAutoResolve) {
                ArrayList<String> conflictingPaths = new ArrayList<String>();
                for (CheckinConflict conflict : checkinConflicts) {
                    if (!conflict.isResolvable()) continue;
                    conflictingPaths.add(conflict.getServerItem());
                }
                Conflict[] actualConflicts = this.queryConflicts(conflictingPaths.toArray(new String[conflictingPaths.size()]), false);
                Conflict[] remainingActualConflicts = this.client.autoResolveValidConflicts(this, actualConflicts, AutoResolveOptions.ALL_SILENT);
                allConflictsResolved = remainingActualConflicts.length == 0;
                TreeSet<String> hashedRemainingConflicts = new TreeSet<String>(ServerPath.TOP_DOWN_COMPARATOR);
                for (Conflict conflict : remainingActualConflicts) {
                    if (conflict.getYourServerItemSource() != null) {
                        hashedRemainingConflicts.add(conflict.getYourServerItemSource());
                    }
                    if (conflict.getYourServerItem() == null) continue;
                    hashedRemainingConflicts.add(conflict.getYourServerItem());
                }
                ArrayList<CheckinConflict> remainingCheckinConflicts = new ArrayList<CheckinConflict>();
                for (CheckinConflict checkinConflict : checkinConflicts) {
                    if (!hashedRemainingConflicts.contains(checkinConflict.getServerItem())) continue;
                    remainingCheckinConflicts.add(checkinConflict);
                }
                checkinConflicts = remainingCheckinConflicts.toArray(new CheckinConflict[remainingCheckinConflicts.size()]);
            }
            for (CheckinConflict conflict : checkinConflicts) {
                this.client.getEventEngine().fireConflict(new ConflictEvent(EventSource.newFromHere(), conflict.getServerItem(), this, conflict.getMessage(), conflict.isResolvable()));
            }
            if (isAnyResolvable) {
                String errorMessage = allConflictsResolved ? Messages.getString("Workspace.AutoResolvedAllReCheckin") : Messages.getString("Workspace.ResolveAndReCheckin");
                throw new CheckinException(checkinConflicts, isAnyResolvable, allConflictsResolved, errorMessage);
            }
        } else {
            checkinConflicts = new CheckinConflict[]{};
        }
        if (checkinResult.getChangeset() == 0 && throwErrorOnFailedCheckin) {
            throw new CheckinException(checkinConflicts, isAnyResolvable, false, Messages.getString("Workspace.NoFilesCheckedIn"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWorkItems(WorkItemCheckinInfo[] workItemInfos, int changeSet, String comment) {
        if (workItemInfos == null) {
            return;
        }
        WorkItemClient wic = (WorkItemClient)this.getClient().getConnection().getClient(WorkItemClient.class);
        TaskMonitor monitor = TaskMonitorService.getTaskMonitor();
        monitor.begin("", workItemInfos.length);
        comment = StringUtil.formatCommentForOneLine(comment);
        try {
            for (int i = 0; i < workItemInfos.length; ++i) {
                WorkItem workItem = workItemInfos[i].getWorkItem();
                boolean resolve = CheckinWorkItemAction.RESOLVE == workItemInfos[i].getAction();
                monitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("Workspace.UpdatingWorkItemFormat"), Integer.toString(workItem.getFields().getID())));
                workItem.syncToLatest();
                workItem.open();
                String history = MessageFormat.format(Messages.getString("Workspace.AssociatedWithChangesetFormat"), Integer.toString(changeSet));
                RegisteredLinkType changesetLinkType = wic.getRegisteredLinkTypes().get("Fixed in Changeset");
                if (changesetLinkType != null) {
                    ArtifactID artifactId = ArtifactIDFactory.newChangesetArtifactID(changeSet);
                    ExternalLink link = LinkFactory.newExternalLink(changesetLinkType, artifactId, comment, false);
                    workItem.getLinks().add(link);
                }
                if (resolve) {
                    String nextState = workItem.getNextState("Microsoft.VSTS.Actions.Checkin");
                    if (nextState != null) {
                        workItem.getFields().getField("System.State").setValue(nextState);
                    }
                    history = MessageFormat.format(Messages.getString("Workspace.ResolvedWithChangesetFormat"), Integer.toString(changeSet));
                }
                workItem.getFields().getField("System.History").setValue(history);
                try {
                    workItem.save();
                }
                catch (UnableToSaveException e) {
                    log.warn((Object)"Unable to save work item", (Throwable)e);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private CheckinNotificationInfo makeCheckinNotificationInfo(WorkItemCheckinInfo[] workItemInfos) {
        Check.notNull(workItemInfos, "workItemInfos");
        CheckinNotificationWorkItemInfo[] notificationInfos = new CheckinNotificationWorkItemInfo[workItemInfos.length];
        for (int i = 0; i < workItemInfos.length; ++i) {
            notificationInfos[i] = workItemInfos[i].getNotification();
        }
        return new CheckinNotificationInfo(notificationInfos);
    }

    public WorkingFolder getWorkingFolderFromPaths(String serverPath, String localPath) {
        RecursionType recursionType = RecursionType.FULL;
        if ("*".equals(ServerPath.getFileName(serverPath))) {
            serverPath = ServerPath.getParent(serverPath);
            recursionType = RecursionType.ONE_LEVEL;
        }
        return new WorkingFolder(serverPath, LocalPath.canonicalize(localPath), WorkingFolderType.MAP, recursionType);
    }

    public void map(String serverPath, String localPath) {
        this.createWorkingFolder(this.getWorkingFolderFromPaths(serverPath, localPath));
    }

    public void addOrChangeMapping(String serverPath, String localPath) {
        this.createWorkingFolder(this.getWorkingFolderFromPaths(serverPath, localPath), true);
    }

    public void createWorkingFolder(WorkingFolder wf) {
        Check.notNull(wf, "wf");
        this.createWorkingFolder(wf, false);
    }

    public void createWorkingFolder(WorkingFolder newWorkingFolder, boolean overwriteExisting) {
        Check.notNull(newWorkingFolder, "newWorkingFolder");
        this.createWorkingFolders(new WorkingFolder[]{newWorkingFolder}, overwriteExisting);
    }

    public void createWorkingFolders(WorkingFolder[] newWorkingFolders) {
        this.createWorkingFolders(newWorkingFolders, false);
    }

    public void createWorkingFolders(WorkingFolder[] newWorkingFolders, boolean overwriteExisting) {
        Check.notNullOrEmpty(newWorkingFolders, "newWorkingFolders");
        WorkingFolder[] foldersArray = this.getFolders();
        ArrayList<WorkingFolder> folders = new ArrayList<WorkingFolder>();
        if (foldersArray != null) {
            folders.addAll(Arrays.asList(foldersArray));
        }
        for (WorkingFolder newWorkingFolder : newWorkingFolders) {
            Iterator i = folders.iterator();
            while (i.hasNext()) {
                String possibleChild;
                String parentPath;
                WorkingFolder existingWorkingFolder = (WorkingFolder)i.next();
                int numRemoved = 0;
                if (ServerPath.equals(existingWorkingFolder.getServerItem(), newWorkingFolder.getServerItem())) {
                    if (overwriteExisting && numRemoved == 0) {
                        i.remove();
                        ++numRemoved;
                        continue;
                    }
                    throw new VersionControlException(MessageFormat.format(Messages.getString("Workspace.NewMappingConflictsWithServerPathOfOtherMappingFormat"), newWorkingFolder.getServerItem(), newWorkingFolder.getLocalItem(), existingWorkingFolder.getServerItem(), existingWorkingFolder.getLocalItem()));
                }
                if (!StringUtil.isNullOrEmpty(existingWorkingFolder.getLocalItem()) && LocalPath.equals(existingWorkingFolder.getLocalItem(), newWorkingFolder.getLocalItem())) {
                    if (overwriteExisting && numRemoved == 0) {
                        i.remove();
                        ++numRemoved;
                        continue;
                    }
                    throw new VersionControlException(MessageFormat.format(Messages.getString("Workspace.NewMappingConflictsWithLocalPathOfOtherMappingFormat"), newWorkingFolder.getServerItem(), newWorkingFolder.getLocalItem(), existingWorkingFolder.getServerItem(), existingWorkingFolder.getLocalItem()));
                }
                if (newWorkingFolder.getType() != WorkingFolderType.CLOAK || existingWorkingFolder.getType() != WorkingFolderType.CLOAK || !ServerPath.isChild(parentPath = newWorkingFolder.getServerItem(), possibleChild = existingWorkingFolder.getServerItem())) continue;
                i.remove();
            }
            folders.add(newWorkingFolder);
        }
        this.update(null, null, folders.toArray(new WorkingFolder[folders.size()]));
        this.client.getEventEngine().fireWorkspaceUpdated(new WorkspaceUpdatedEvent(EventSource.newFromHere(), this, this.getName(), this.getLocation(), WorkspaceEvent.WorkspaceEventSource.INTERNAL));
    }

    public void deleteWorkingFolder(WorkingFolder wf) throws ServerPathFormatException, IOException {
        Check.notNull(wf, "wf");
        this.deleteWorkingFolders(new WorkingFolder[]{wf});
    }

    public void deleteWorkingFolders(WorkingFolder[] workingFolders) throws ServerPathFormatException, IOException {
        Check.notNullOrEmpty(workingFolders, "workingFolders");
        WorkingFolder[] foldersArray = this.getFolders();
        ArrayList<WorkingFolder> folders = new ArrayList<WorkingFolder>();
        if (foldersArray != null) {
            folders.addAll(Arrays.asList(foldersArray));
        }
        for (WorkingFolder wf : workingFolders) {
            Iterator i = folders.iterator();
            while (i.hasNext()) {
                WorkingFolder w = (WorkingFolder)i.next();
                if (ServerPath.equals(w.getServerItem(), wf.getServerItem())) {
                    i.remove();
                    continue;
                }
                if (w.getLocalItem() == null || w.getLocalItem().length() <= 0 || !LocalPath.equals(w.getLocalItem(), wf.getLocalItem())) continue;
                i.remove();
            }
            i = folders.iterator();
            while (i.hasNext()) {
                WorkingFolder cloaked = (WorkingFolder)i.next();
                if (cloaked.getType() != WorkingFolderType.CLOAK) continue;
                boolean foundParent = false;
                for (WorkingFolder possibleParent : folders) {
                    if (possibleParent.getType() == WorkingFolderType.CLOAK || !ServerPath.isChild(possibleParent.getServerItem(), cloaked.getServerItem())) continue;
                    foundParent = true;
                    break;
                }
                if (foundParent) continue;
                i.remove();
            }
        }
        this.update(null, null, folders.toArray(new WorkingFolder[folders.size()]));
        this.client.getEventEngine().fireWorkspaceUpdated(new WorkspaceUpdatedEvent(EventSource.newFromHere(), this, this.getName(), this.getLocation(), WorkspaceEvent.WorkspaceEventSource.INTERNAL));
    }

    public Changeset[] queryHistory(String serverOrLocalPath, VersionSpec version, int deletionID, RecursionType recursion, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includeFileDetails, boolean slotMode, boolean includeDownloadInfo, boolean sortAscending) throws ServerPathFormatException {
        return this.client.queryHistory(serverOrLocalPath, version, deletionID, recursion, user, versionFrom, versionTo, maxCount, includeFileDetails, slotMode, includeDownloadInfo, sortAscending);
    }

    public Iterator<Changeset> queryHistoryIterator(String serverOrLocalPath, VersionSpec version, int deletionID, RecursionType recursion, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includeFileDetails, boolean slotMode, boolean includeDownloadInfo, boolean sortAscending) throws ServerPathFormatException {
        return this.client.queryHistoryIterator(serverOrLocalPath, version, deletionID, recursion, user, versionFrom, versionTo, maxCount, includeFileDetails, slotMode, includeDownloadInfo, sortAscending);
    }

    public int createBranch(String sourceServerPath, String targetServerPath, VersionSpec version) {
        return this.client.createBranch(sourceServerPath, targetServerPath, version);
    }

    public LabelResult[] createLabel(VersionControlLabel label, LabelItemSpec[] items, LabelChildOption options) {
        return this.client.createLabel(label, items, options);
    }

    public LabelResult[] unlabelItem(String label, String scope, ItemSpec[] items, VersionSpec version) {
        return this.client.unlabelItem(label, scope, items, version);
    }

    public VersionControlLabel[] queryLabels(String label, String scope, String owner, boolean includeItemDetails, String filterItem, VersionSpec filterItemVersion) {
        return this.client.queryLabels(label, scope, owner, includeItemDetails, filterItem, filterItemVersion);
    }

    public String getComment() {
        return this.getWebServiceObject().getComment();
    }

    public String getComputer() {
        return this.getWebServiceObject().getComputer();
    }

    public WorkspaceOptions getOptions() {
        return WorkspaceOptions.fromFlags(this.getWebServiceObject().getOptions());
    }

    public IdentityDescriptor getOwnerDescriptor() {
        this.refreshIfNeeded();
        if (this.getWebServiceObject().getOwnerid() == null) {
            return null;
        }
        return new IdentityDescriptor(this.getWebServiceObject().getOwnertype(), this.getWebServiceObject().getOwnerid());
    }

    public String getSecurityToken() {
        return this.getWebServiceObject().getSecuritytoken();
    }

    public GetStatus get(GetOptions options) {
        Check.notNull(options, "options");
        return this.get(LatestVersionSpec.INSTANCE, options);
    }

    public GetStatus get(VersionSpec version, GetOptions options) {
        Check.notNull(version, "version");
        Check.notNull(options, "options");
        return this.get(new GetRequest(null, version), options);
    }

    public GetStatus get(GetRequest request, GetOptions options) {
        Check.notNull(request, "request");
        Check.notNull(options, "options");
        return this.get(new GetRequest[]{request}, options);
    }

    public GetStatus get(GetRequest[] requests, GetOptions options) {
        return this.get(requests, options, null, false, new AtomicReference<Conflict[]>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetStatus get(GetRequest[] requests, GetOptions options, String[] itemPropertyFilters, boolean alwaysQueryConflicts, AtomicReference<Conflict[]> conflicts) {
        Check.notNull(requests, "requests");
        Check.notNull(options, "options");
        Check.notNull(conflicts, "conflicts");
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        this.client.getEventEngine().fireOperationStarted(new GetOperationStartedEvent(EventSource.newFromHere(), this, requests));
        TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
        taskMonitor.begin("", 100);
        taskMonitor.setCurrentWorkDescription(Messages.getString("Workspace.ContactingServertoGetListOfItemsToUpdate"));
        boolean getAll = options.contains(GetOptions.GET_ALL);
        int maxResults = getAll ? 0 : 250000;
        GetStatus getStatus = new GetStatus();
        try {
            boolean attemptAutoResolve;
            String[] sourceWritableConflicts;
            WritableConflictOnSourcePathListener conflictListener = new WritableConflictOnSourcePathListener();
            try {
                int resultCount;
                this.client.getEventEngine().addGetListener(conflictListener);
                GetStatus latestStatus = null;
                GetEngine getEngine = new GetEngine(this.client);
                do {
                    log.debug((Object)"Call server for GetOperations.");
                    GetOperation[][] results = this.client.getWebServiceLayer().get(this.getName(), this.getOwnerName(), requests, maxResults, options, null, itemPropertyFilters, false);
                    taskMonitor.worked(5);
                    resultCount = 0;
                    for (GetOperation[] result : results) {
                        resultCount += result.length;
                    }
                    log.debug((Object)"Process GetOperations");
                    TaskMonitorService.pushTaskMonitor(taskMonitor.newSubTaskMonitor(95));
                    try {
                        latestStatus = getEngine.processGetOperations(this, ProcessType.GET, RequestType.NONE, results, options, false, true, ChangePendedFlags.UNKNOWN);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error processing GET operations", (Throwable)e);
                        if (e instanceof VersionControlException) {
                            throw (VersionControlException)e;
                        }
                        throw new VersionControlException(e);
                    }
                    finally {
                        TaskMonitorService.popTaskMonitor(true);
                    }
                    log.debug((Object)"Latest GetOperations status:");
                    log.debug((Object)("    NumOperations        = " + latestStatus.getNumOperations()));
                    log.debug((Object)("    NumUpdated           = " + latestStatus.getNumUpdated()));
                    log.debug((Object)("    NumWarnings          = " + latestStatus.getNumWarnings()));
                    log.debug((Object)("    NumFailures          = " + latestStatus.getNumFailures()));
                    log.debug((Object)("    NumConflicts         = " + latestStatus.getNumConflicts()));
                    log.debug((Object)("    NumResolvedConflicts = " + latestStatus.getNumResolvedConflicts()));
                    getStatus.combine(latestStatus);
                } while (resultCount == 250000 && latestStatus.getNumUpdated() >= 1);
                sourceWritableConflicts = conflictListener.getMovedPaths();
            }
            finally {
                this.client.getEventEngine().removeGetListener(conflictListener);
            }
            boolean bl = attemptAutoResolve = !options.contains(GetOptions.NO_AUTO_RESOLVE);
            if (getStatus.getNumConflicts() > 0 || getStatus.haveResolvableWarnings() && (alwaysQueryConflicts || attemptAutoResolve)) {
                log.debug((Object)"Querying conflicts.");
                taskMonitor.setCurrentWorkDescription(Messages.getString("Workspace.QueryingConflicts"));
                AtomicBoolean recursive = new AtomicBoolean();
                String[] conflictScope = this.calculateConflictScope(requests, sourceWritableConflicts, recursive);
                Conflict[] unresolvedConflicts = this.queryConflicts(conflictScope, recursive.get());
                if (attemptAutoResolve) {
                    log.debug((Object)"Resolving conflicts.");
                    taskMonitor.setCurrentWorkDescription(Messages.getString("Workspace.ResolvingConflicts"));
                    unresolvedConflicts = this.client.autoResolveValidConflicts(this, unresolvedConflicts, AutoResolveOptions.ALL_SILENT);
                    getStatus.setNumConflicts(unresolvedConflicts.length);
                }
                log.debug((Object)("Unresolved conflicts: " + unresolvedConflicts.length));
                conflicts.set(unresolvedConflicts);
            }
        }
        finally {
            taskMonitor.setCurrentWorkDescription(Messages.getString("Workspace.FinishingGetOperation"));
            this.client.getEventEngine().fireOperationCompleted(new GetOperationCompletedEvent(EventSource.newFromHere(), this, requests, getStatus));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_GET_COMPLETED);
            taskMonitor.done();
        }
        return getStatus;
    }

    private String[] calculateConflictScope(GetRequest[] getRequests, String[] writableConflictPaths, AtomicBoolean recursive) {
        recursive.set(false);
        ArrayList<Object> result = new ArrayList<Object>();
        for (GetRequest getRequest : getRequests) {
            if (getRequest.getItemSpec() == null) {
                return null;
            }
            if (RecursionType.FULL.equals(getRequest.getItemSpec().getRecursionType())) {
                recursive.set(true);
            }
            String path = getRequest.getItemSpec().getItem();
            if (RecursionType.ONE_LEVEL.equals(getRequest.getItemSpec().getRecursionType()) && path.indexOf(42) == -1) {
                if (ServerPath.isServerPath(path)) {
                    result.add(ServerPath.combine(path, "*"));
                } else {
                    result.add(LocalPath.combine(path, "*"));
                }
            }
            result.add(path);
        }
        if (writableConflictPaths != null) {
            for (String sourcePath : writableConflictPaths) {
                boolean includePath = true;
                for (GetRequest getRequest : getRequests) {
                    String getRequestPath = getRequest.getItemSpec().getItem();
                    if (getRequestPath == null || getRequestPath.length() <= 0 || ServerPath.isServerPath(getRequestPath) || !LocalPath.isChild(getRequestPath, sourcePath)) continue;
                    includePath = false;
                    break;
                }
                if (!includePath) continue;
                result.add(sourcePath);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public GetStatus rollback(ItemSpec[] itemSpecs, VersionSpec itemVersionSpec, VersionSpec versionFrom, VersionSpec versionTo, LockLevel lockLevel, RollbackOptions options) {
        return this.rollback(itemSpecs, itemVersionSpec, versionFrom, versionTo, lockLevel, options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetStatus rollback(ItemSpec[] itemSpecs, VersionSpec itemVersionSpec, VersionSpec versionFrom, VersionSpec versionTo, LockLevel lockLevel, RollbackOptions options, String[] itemPropertyFilters) {
        Check.notNull(versionFrom, "versionFrom");
        Check.notNull(versionTo, "versionTo");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(options, "options");
        this.client.getEventEngine().fireOperationStarted(new RollbackOperationStartedEvent(EventSource.newFromHere(), this, itemSpecs, options));
        GetStatus status = null;
        try {
            itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
            AtomicReference<Failure[]> failuresHolder = new AtomicReference<Failure[]>();
            AtomicReference<Conflict[]> conflictsHolder = new AtomicReference<Conflict[]>();
            AtomicReference<ChangePendedFlags> changePendedFlagsHolder = new AtomicReference<ChangePendedFlags>();
            GetOperation[] operations = this.getClient().getWebServiceLayer().rollback(this.getName(), this.getOwnerName(), itemSpecs, itemVersionSpec, versionFrom, versionTo, options, lockLevel, conflictsHolder, failuresHolder, null, itemPropertyFilters, changePendedFlagsHolder);
            Failure[] failures = failuresHolder.get();
            Conflict[] conflicts = conflictsHolder.get();
            int nonResolvedConflicts = 0;
            int resolvedConflicts = 0;
            ChangePendedFlags changePendedFlags = changePendedFlagsHolder.get();
            HashMap<Integer, Conflict> itemIDConflictMap = new HashMap<Integer, Conflict>();
            ArrayList<String> conflictPaths = new ArrayList<String>();
            for (Conflict conflict : conflicts) {
                if (conflict.isResolved()) {
                    itemIDConflictMap.put(new Integer(conflict.getYourItemID()), conflict);
                    continue;
                }
                conflictPaths.add(conflict.getServerPath());
            }
            for (WebServiceObjectWrapper webServiceObjectWrapper : operations) {
                Conflict conflict = (Conflict)itemIDConflictMap.get(new Integer(((GetOperation)webServiceObjectWrapper).getItemID()));
                if (conflict == null) continue;
                ((GetOperation)webServiceObjectWrapper).setMergeDetails(conflict);
            }
            if (this.isLocal()) {
                if (!options.contains(RollbackOptions.NO_AUTO_RESOLVE)) {
                    if (this.getClient().getServiceLevel().getValue() < WebServiceLevel.TFS_2012_1.getValue()) {
                        conflicts = this.queryConflicts(conflictPaths.toArray(new String[conflictPaths.size()]), false);
                    }
                    Conflict[] remainingConflicts = this.getClient().autoResolveValidConflicts(this, conflicts, AutoResolveOptions.ALL_SILENT);
                    resolvedConflicts = conflicts.length - remainingConflicts.length;
                    conflicts = remainingConflicts;
                }
                for (WebServiceObjectWrapper webServiceObjectWrapper : conflicts) {
                    if (((Conflict)webServiceObjectWrapper).getResolution() != Resolution.NONE) continue;
                    this.getClient().getEventEngine().fireMerging(new MergingEvent(EventSource.newFromHere(), (Conflict)webServiceObjectWrapper, this, false, null, OperationStatus.CONFLICT, ChangeType.NONE, true, new PropertyValue[0]));
                    ++nonResolvedConflicts;
                }
                GetEngine getEngine = new GetEngine(this.getClient());
                status = getEngine.processGetOperations(this, ProcessType.ROLLBACK, operations, GetOptions.NONE, changePendedFlags);
                status.setNumConflicts(status.getNumConflicts() + nonResolvedConflicts);
                status.setNumResolvedConflicts(resolvedConflicts);
            } else if (operations.length > 0) {
                this.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.getClient(), (Throwable)new Exception(MessageFormat.format(Messages.getString("Workspace.OperationCompletedForRemoteWorkspaceButGetRequiredFormat"), this.getDisplayName()))));
            }
            if (status == null) {
                status = new GetStatus();
                status.setNumOperations(operations.length);
            }
            if (changePendedFlags.contains(ChangePendedFlags.WORKING_FOLDER_MAPPINGS_UPDATED)) {
                this.invalidateMappings();
            }
            this.getClient().reportFailures(this, failures);
            for (WebServiceObjectWrapper webServiceObjectWrapper : failures) {
                status.addFailure((Failure)webServiceObjectWrapper);
            }
            this.getClient().getEventEngine().fireOperationCompleted(new RollbackOperationCompletedEvent(EventSource.newFromHere(), this, itemSpecs, options, status));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED);
        }
        catch (Throwable throwable) {
            this.getClient().getEventEngine().fireOperationCompleted(new RollbackOperationCompletedEvent(EventSource.newFromHere(), this, itemSpecs, options, status));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED);
            throw throwable;
        }
        return status;
    }

    public GetOperation[][] previewGetItems(GetRequest[] requests, GetOptions options) {
        return this.previewGetItems(requests, options, null);
    }

    public GetOperation[][] previewGetItems(GetRequest[] requests, GetOptions options, String[] itemPropertyFilters) {
        Check.notNull(requests, "requests");
        Check.notNull(options, "options");
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        return this.client.getWebServiceLayer().get(this.getName(), this.getOwnerName(), requests, 0, options, null, itemPropertyFilters, false);
    }

    public String getName() {
        return this.getWebServiceObject().getName();
    }

    public String getOwnerName() {
        return this.getWebServiceObject().getOwner();
    }

    public String getOwnerDisplayName() {
        return this.getWebServiceObject().getOwnerdisp();
    }

    public String[] getOwnerAliases() {
        if (this.getWebServiceObject().getOwnerAliases() != null) {
            return this.getWebServiceObject().getOwnerAliases();
        }
        return new String[0];
    }

    public Calendar getLastAccessDate() {
        return this.getWebServiceObject().getLastAccessDate();
    }

    public String getQualifiedName() {
        return new WorkspaceSpec(this.getName(), this.getOwnerName()).toString();
    }

    public boolean isLocalPathMapped(String localPath) {
        Check.notNullOrEmpty(localPath, "localPath");
        PathTranslation translation = this.translateLocalPathToServerPath(localPath);
        return translation != null && !translation.isCloaked();
    }

    public boolean isServerPathMapped(String serverPath) {
        Check.notNullOrEmpty(serverPath, "serverPath");
        PathTranslation translation = this.translateServerPathToLocalPath(serverPath);
        return translation != null && !translation.isCloaked();
    }

    public String getMappedServerPath(String localPath) {
        Check.notNullOrEmpty(localPath, "localPath");
        Check.isTrue(!ServerPath.isServerPath(localPath), "ServerPath.isServerPath(localPath) == false");
        PathTranslation translation = this.translateLocalPathToServerPath(localPath);
        if (translation != null && !translation.isCloaked()) {
            return translation.getTranslatedPath();
        }
        return null;
    }

    public String getMappedLocalPath(String serverPath) {
        Check.notNullOrEmpty(serverPath, "serverPath");
        Check.isTrue(ServerPath.isServerPath(serverPath), "ServerPath.isServerPath(serverPath)");
        PathTranslation translation = this.translateServerPathToLocalPath(serverPath);
        if (translation != null && !translation.isCloaked()) {
            return translation.getTranslatedPath();
        }
        return null;
    }

    public WorkingFolder getExactMappingForLocalPath(String localPath) {
        WorkingFolder[] workingFolders;
        PathTranslation translation = null;
        for (WorkingFolder workingFolder : workingFolders = this.getFolders()) {
            String localItem = workingFolder.getLocalItem();
            if (localItem == null) {
                String workingFolderServerPath;
                String translatedServerPath;
                if (translation == null) {
                    translation = this.translateLocalPathToServerPath(localPath);
                }
                if (translation == null || !ServerPath.equals(translatedServerPath = translation.getTranslatedPath(), workingFolderServerPath = workingFolder.getServerItem())) continue;
                return workingFolder;
            }
            if (!LocalPath.equals(localItem, localPath)) continue;
            return workingFolder;
        }
        return null;
    }

    public WorkingFolder getExactMappingForServerPath(String serverPath) {
        WorkingFolder[] workingFolders;
        for (WorkingFolder workingFolder : workingFolders = this.getFolders()) {
            String serverItem = workingFolder.getServerItem();
            if (serverItem == null || !ServerPath.equals(serverItem, serverPath)) continue;
            return workingFolder;
        }
        return null;
    }

    public WorkingFolder getClosestMappingForServerPath(String serverPath) {
        WorkingFolder[] workingFolders;
        WorkingFolder closestParentFolder = null;
        for (WorkingFolder workingFolder : workingFolders = this.getFolders()) {
            String serverItem = workingFolder.getServerItem();
            if (!ServerPath.isChild(serverItem, serverPath) || closestParentFolder != null && serverItem.length() <= closestParentFolder.getServerItem().length()) continue;
            closestParentFolder = workingFolder;
        }
        return closestParentFolder;
    }

    public WorkingFolder getClosestMappingForLocalPath(String localPath) {
        WorkingFolder[] workingFolders;
        WorkingFolder closestParentFolder = null;
        for (WorkingFolder workingFolder : workingFolders = this.getFolders()) {
            String localItem = workingFolder.getLocalItem();
            if (!LocalPath.isChild(localItem, localPath) || closestParentFolder != null && localItem.length() <= closestParentFolder.getLocalItem().length()) continue;
            closestParentFolder = workingFolder;
        }
        return closestParentFolder;
    }

    public boolean serverPathExists(String serverPath) {
        return this.serverPathExists(serverPath, LatestVersionSpec.INSTANCE);
    }

    public boolean serverPathExists(String serverPath, VersionSpec versionSpec) {
        Check.notNullOrEmpty(serverPath, "serverPath");
        Check.notNull(versionSpec, "versionSpec");
        Item item = null;
        try {
            item = this.getClient().getItem(serverPath, versionSpec);
        }
        catch (Exception e) {
            return false;
        }
        return item != null;
    }

    public PathTranslation translateLocalPathToServerPath(String localPath) {
        Check.notNullOrEmpty(localPath, "localPath");
        return WorkingFolder.translateLocalItemToServerItem(localPath, this.getFolders());
    }

    public PathTranslation translateServerPathToLocalPath(String serverPath) {
        return WorkingFolder.translateServerItemToLocalItem(serverPath, this.getFolders(), true);
    }

    public WorkingFolder[] getFolders() {
        this.refreshMappingsIfNeeded();
        Object[] folders = this.getWebServiceObject().getFolders();
        if (folders == null || folders.length == 0) {
            return new WorkingFolder[0];
        }
        return WorkingFolder.clone((WorkingFolder[])WrapperUtils.wrap(WorkingFolder.class, folders));
    }

    public void setFolders(WorkingFolder[] folders) {
        this.getWebServiceObject().setFolders((_WorkingFolder[])WrapperUtils.unwrap(_WorkingFolder.class, folders));
    }

    public static int compareName(String name1, String name2) {
        if (name1 == name2) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(name1, name2);
    }

    public static int compareOwner(String owner1, String owner2) {
        if (owner1 == owner2) {
            return 0;
        }
        if (owner1 == null) {
            return -1;
        }
        if (owner2 == null) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(owner1, owner2);
    }

    public static int compareComputer(String computer1, String computer2) {
        if (computer1 == computer2) {
            return 0;
        }
        if (computer1 == null) {
            return -1;
        }
        if (computer2 == null) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(computer1, computer2);
    }

    public static int compareComment(String comment1, String comment2) {
        if (comment1 == comment2) {
            return 0;
        }
        if (comment1 == null) {
            return -1;
        }
        if (comment2 == null) {
            return 1;
        }
        return comment1.compareTo(comment2);
    }

    public static int compareServerURI(URI uri1, URI uri2) {
        if (uri1 == uri2) {
            return 0;
        }
        if (uri1 == null) {
            return -1;
        }
        if (uri2 == null) {
            return 1;
        }
        return ServerURIComparator.INSTANCE.compare(uri1, uri2);
    }

    public static int compareSecurityToken(String securityToken1, String securityToken2) {
        if (securityToken1 == securityToken2) {
            return 0;
        }
        if (securityToken1 == null) {
            return -1;
        }
        if (securityToken2 == null) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(securityToken1, securityToken2);
    }

    public String[] getMappedPaths() {
        return WorkingFolder.extractMappedPaths(this.getFolders());
    }

    public static boolean matchName(String name1, String name2) {
        return Workspace.compareName(name1, name2) == 0;
    }

    public static boolean matchOwner(String owner1, String owner2) {
        return Workspace.compareOwner(owner1, owner2) == 0;
    }

    public static boolean matchComputer(String computer1, String computer2) {
        return Workspace.compareComputer(computer1, computer2) == 0;
    }

    public static boolean matchServerGUID(GUID serverGUID1, GUID serverGUID2) {
        return serverGUID1.equals(serverGUID2);
    }

    public static boolean matchComment(String comment1, String comment2) {
        return Workspace.compareComment(comment1, comment2) == 0;
    }

    public static boolean matchServerURI(URI serverURI1, URI serverURI2) {
        return Workspace.compareServerURI(serverURI1, serverURI2) == 0;
    }

    public static boolean matchSecurityToken(String securityToken1, String securityToken2) {
        return Workspace.compareSecurityToken(securityToken1, securityToken2) == 0;
    }

    public boolean ownerNameMatches(String ownerName) {
        if (Workspace.matchOwner(this.getOwnerName(), ownerName)) {
            return true;
        }
        if (Workspace.matchOwner(this.getOwnerDisplayName(), ownerName)) {
            return true;
        }
        if (this.getOwnerAliases() != null) {
            for (String aliasName : this.getOwnerAliases()) {
                if (!Workspace.matchOwner(aliasName, ownerName)) continue;
                return true;
            }
        }
        return false;
    }

    public static int hashName(String name) {
        return LocaleInvariantStringHelpers.caseInsensitiveHashCode(name);
    }

    public static int hashOwner(String ownerName) {
        return LocaleInvariantStringHelpers.caseInsensitiveHashCode(ownerName);
    }

    public void reconcile(boolean reconcileMissingLocalItems, AtomicBoolean pendingChangesUpdatedByServer) {
        pendingChangesUpdatedByServer.set(false);
        if (WorkspaceLocation.LOCAL != this.getLocation()) {
            return;
        }
        AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
        LocalDataAccessLayer.reconcileLocalWorkspace(this, this.client.getWebServiceLayer(), false, reconcileMissingLocalItems, failures, pendingChangesUpdatedByServer);
        this.client.reportFailures(this, failures.get());
    }

    public int pendAdd(String[] paths, boolean recursive, FileEncoding fileEncoding, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions) {
        Check.notNull(paths, "paths");
        return this.pendAdd(paths, recursive, lockLevel, getOptions, pendOptions, null, fileEncoding);
    }

    public int pendAdd(String[] paths, boolean recursive, final LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions, final Map<String, FileEncoding> encodingHints, final FileEncoding defaultEncoding) {
        String[] exclusionsApplied;
        boolean showItemExistsFailures;
        Check.notNullOrEmpty(paths, "paths");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        Check.notNull(pendOptions, "pendOptions");
        boolean bl = showItemExistsFailures = !recursive;
        if (!recursive) {
            for (String path : paths) {
                showItemExistsFailures &= !ItemPath.isWildcard(path);
            }
        }
        if (!showItemExistsFailures) {
            pendOptions = pendOptions.combine(PendChangesOptions.SUPPRESS_ITEM_NOT_FOUND_FAILURES);
        }
        FileSystemWalker walker = new FileSystemWalker(this, paths, recursive, true, pendOptions.contains(PendChangesOptions.TREAT_MISSING_ITEMS_AS_FILES), pendOptions.contains(PendChangesOptions.APPLY_LOCAL_ITEM_EXCLUSIONS));
        final ArrayList requests = new ArrayList();
        final ArrayList propertyRequests = new ArrayList();
        final ArrayList itemSpecs = new ArrayList();
        final PendChangesOptions finalPendChangesOptions = pendOptions;
        walker.walk(new FileSystemWalker.FileSystemVisitor(){

            @Override
            public void visit(String path) {
                int codePage;
                ItemType itemType;
                ItemType missingItemsItemType = finalPendChangesOptions.contains(PendChangesOptions.TREAT_MISSING_ITEMS_AS_FILES) ? ItemType.FILE : ItemType.ANY;
                FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(path);
                if (!attrs.exists()) {
                    if (missingItemsItemType == ItemType.ANY) {
                        throw new VersionControlException(MessageFormat.format(Messages.getString("Workspace.FileOrFolderNotFoundFormat"), path));
                    }
                    itemType = missingItemsItemType;
                    codePage = -1;
                } else if (attrs.isSymbolicLink()) {
                    itemType = ItemType.FILE;
                    codePage = -1;
                } else if (!attrs.isDirectory()) {
                    FileEncoding encoding;
                    itemType = ItemType.FILE;
                    FileEncoding fileEncoding = encoding = encodingHints != null ? (FileEncoding)encodingHints.get(path) : defaultEncoding;
                    if (encoding == null) {
                        encoding = FileEncoding.AUTOMATICALLY_DETECT;
                    }
                    codePage = FileEncodingDetector.detectEncoding(path, encoding).getCodePage();
                } else {
                    itemType = ItemType.FOLDER;
                    codePage = -1;
                }
                try {
                    ItemSpec spec = new ItemSpec(path, RecursionType.NONE);
                    itemSpecs.add(spec);
                    ChangeRequest cr = new ChangeRequest(spec, null, RequestType.ADD, itemType, codePage, lockLevel, 0, null, true);
                    if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
                        if (PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_DISABLE_SYMBOLIC_LINK_PROP") == null && attrs.isSymbolicLink()) {
                            if (Workspace.this.isLocalWorkspace()) {
                                cr.setProperties(new PropertyValue[]{PropertyConstants.IS_SYMLINK});
                            } else {
                                ChangeRequest r = new ChangeRequest(spec, null, RequestType.PROPERTY, itemType, codePage, lockLevel, 0, null, true);
                                r.setProperties(new PropertyValue[]{PropertyConstants.IS_SYMLINK});
                                propertyRequests.add(r);
                            }
                        } else if (!attrs.isDirectory() && attrs.isExecutable() && PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_DISABLE_DETECT_EXECUTABLE_PROP") == null) {
                            if (Workspace.this.isLocalWorkspace()) {
                                cr.setProperties(new PropertyValue[]{PropertyConstants.EXECUTABLE_ENABLED_VALUE});
                            } else {
                                ChangeRequest r = new ChangeRequest(spec, null, RequestType.PROPERTY, itemType, codePage, lockLevel, 0, null, false);
                                r.setProperties(new PropertyValue[]{PropertyConstants.EXECUTABLE_ENABLED_VALUE});
                                propertyRequests.add(r);
                            }
                        }
                    }
                    requests.add(cr);
                }
                catch (ChangeRequestValidationException e) {
                    log.info((Object)"Cannot create change request:", (Throwable)e);
                    Workspace.this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), Workspace.this, (Throwable)e));
                }
            }
        });
        if (requests.size() == 0) {
            return 0;
        }
        int numPended = this.pendChanges(requests.toArray(new ChangeRequest[requests.size()]), getOptions, pendOptions, null);
        if (numPended > 0 && propertyRequests.size() > 0) {
            if (this.getClient().getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                PendingSet set = this.getPendingChanges(itemSpecs.toArray(new ItemSpec[itemSpecs.size()]), false);
                if (set != null && set.getPendingChanges() != null && set.getPendingChanges().length > 0) {
                    PendingChange[] pendingChanges;
                    HashSet<String> newAdds = new HashSet<String>();
                    for (PendingChange pc : pendingChanges = set.getPendingChanges()) {
                        if (!pc.isAdd()) continue;
                        newAdds.add(pc.getLocalItem());
                    }
                    ArrayList<ChangeRequest> propRequests = new ArrayList<ChangeRequest>();
                    for (ChangeRequest r : propertyRequests) {
                        if (!newAdds.contains(r.getItemSpec().getItem())) continue;
                        propRequests.add(r);
                    }
                    if (propRequests.size() > 0) {
                        this.pendChanges(propRequests.toArray(new ChangeRequest[propRequests.size()]), GetOptions.NONE, pendOptions, null);
                    }
                }
            } else {
                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new VersionControlException(Messages.getString("Workspace.PropertyNotSupportedText"))));
            }
        }
        if ((exclusionsApplied = walker.getExclusionsApplied()).length > 0) {
            String exclusionsList = StringUtil.join(exclusionsApplied, ";");
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new Exception(MessageFormat.format(Messages.getString("Workspace.ItemsIgnoredBecauseOfExclusionsFormat"), exclusionsList))));
        }
        return numPended;
    }

    public int pendBranch(String sourcePath, String targetPath, VersionSpec version, LockLevel lockLevel, RecursionType recursion, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendBranch(sourcePath, targetPath, version, lockLevel, recursion, getOptions, pendOptions, null);
    }

    public int pendBranch(String sourcePath, String targetPath, VersionSpec version, LockLevel lockLevel, RecursionType recursion, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(sourcePath, "sourcePath");
        Check.notNullOrEmpty(targetPath, "targetPath");
        Check.notNull(version, "version");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        Check.notNull(pendOptions, "pendOptions");
        ChangeRequest[] changes = new ChangeRequest[1];
        try {
            changes[0] = new ChangeRequest(new ItemSpec(sourcePath, recursion), version, RequestType.BRANCH, ItemType.ANY, -2, lockLevel, 0, targetPath, true);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(changes, getOptions, pendOptions, itemPropertyFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pendChanges(ChangeRequest[] requests, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(requests, "requests");
        Check.notNull(getOptions, "getOptions");
        Check.notNull(pendOptions, "pendOptions");
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        this.client.getEventEngine().fireOperationStarted(new PendOperationStartedEvent(EventSource.newFromHere(), this, requests));
        if (this.getClient().getServiceLevel().getValue() < WebServiceLevel.TFS_2012.getValue() && this.hasPropertyChange(requests)) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new VersionControlException(Messages.getString("Workspace.PropertyNotSupportedText"))));
        }
        int ret = 0;
        try {
            SupportedFeatures features = SupportedFeatures.ALL;
            if (pendOptions.contains(PendChangesOptions.FORCE_CHECK_OUT_LOCAL_VERSION)) {
                features = features.remove(SupportedFeatures.GET_LATEST_ON_CHECKOUT);
            }
            AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
            AtomicBoolean onlineOperation = new AtomicBoolean();
            AtomicReference<ChangePendedFlags> changePendedFlags = new AtomicReference<ChangePendedFlags>();
            GetOperation[] operations = this.client.getWebServiceLayer().pendChanges(this.getName(), this.getOwnerName(), requests, pendOptions, features, failures, itemPropertyFilters, null, true, onlineOperation, changePendedFlags);
            if (operations.length > 0) {
                if (WorkspaceLocation.SERVER == this.getLocation() && this.getClient().getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                    for (ChangeRequest request : requests) {
                        PropertyValue[] operationProperties;
                        GetOperation operation;
                        PropertyValue[] requestProperties = request.getProperties();
                        if (requestProperties == null || (operation = this.findMatchingOperation(operations, request)) == null || (operationProperties = operation.getPropertyValues()) == null) continue;
                        operation.setPropertyValues(PropertyUtils.mergePendingValues(operationProperties, requestProperties));
                    }
                }
                GetEngine getEngine = new GetEngine(this.client);
                getEngine.processGetOperations(this, ProcessType.PEND, requests[0].getRequestType(), new GetOperation[][]{operations}, getOptions, false, onlineOperation.get(), changePendedFlags.get());
                ret = operations.length;
            }
            if (changePendedFlags.get().contains(ChangePendedFlags.WORKING_FOLDER_MAPPINGS_UPDATED)) {
                this.invalidateMappings();
            }
            if (failures.get() != null && failures.get().length > 0 && pendOptions.contains(PendChangesOptions.SUPPRESS_ITEM_NOT_FOUND_FAILURES)) {
                ArrayList<Failure> otherFailures = new ArrayList<Failure>();
                for (Failure f : failures.get()) {
                    if (f.getCode() != null && f.getCode().equals("ItemExistsException")) continue;
                    otherFailures.add(f);
                }
                failures.set(otherFailures.toArray(new Failure[otherFailures.size()]));
            }
            this.client.reportFailures(this, failures.get());
        }
        finally {
            this.client.getEventEngine().fireOperationCompleted(new PendOperationCompletedEvent(EventSource.newFromHere(), this, requests));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED);
        }
        return ret;
    }

    private GetOperation findMatchingOperation(GetOperation[] operations, ChangeRequest request) {
        for (GetOperation operation : operations) {
            if (!LocalPath.equals(request.getItemSpec().getItem(), operation.getSourceLocalItem())) continue;
            return operation;
        }
        return null;
    }

    private boolean hasPropertyChange(ChangeRequest[] requests) {
        for (ChangeRequest request : requests) {
            if (request.getRequestType().equals(RequestType.PROPERTY)) {
                return true;
            }
            if (request.getProperties() == null || request.getProperties().length <= 0) continue;
            return true;
        }
        return false;
    }

    public int pendDelete(String[] paths, RecursionType recursion, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendDelete(paths, recursion, lockLevel, getOptions, pendOptions, null);
    }

    public int pendDelete(String[] paths, RecursionType recursion, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(paths, "paths");
        Check.notNull(recursion, "recursion");
        Check.notNull(lockLevel, "lockLevel");
        LockLevel[] lockLevels = new LockLevel[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            lockLevels[i] = lockLevel;
        }
        return this.pendDelete(paths, recursion, lockLevels, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendDelete(String[] paths, RecursionType recursion, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendDelete(paths, recursion, lockLevels, getOptions, pendOptions, null);
    }

    public int pendDelete(String[] paths, RecursionType recursion, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(paths, "paths");
        Check.notNull(recursion, "recursion");
        Check.notNullOrEmpty(lockLevels, "lockLevels");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromStrings(paths, RequestType.DELETE, lockLevels, recursion, null);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendDelete(ItemSpec[] specs, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendDelete(specs, lockLevel, getOptions, pendOptions, null);
    }

    public int pendDelete(ItemSpec[] specs, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(specs, "specs");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        LockLevel[] lockLevels = new LockLevel[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            lockLevels[i] = lockLevel;
        }
        return this.pendDelete(specs, lockLevels, getOptions, pendOptions, null);
    }

    public int pendDelete(ItemSpec[] specs, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendDelete(specs, lockLevels, getOptions, pendOptions, null);
    }

    public int pendDelete(ItemSpec[] specs, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(specs, "specs");
        Check.notNullOrEmpty(lockLevels, "lockLevels");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromSpecs(specs, RequestType.DELETE, lockLevels, null);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendUndelete(ItemSpec[] items, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendUndelete(items, lockLevel, getOptions, pendOptions, null);
    }

    public int pendUndelete(ItemSpec[] items, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(items, "items");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        LockLevel[] lockLevels = new LockLevel[items.length];
        for (int i = 0; i < items.length; ++i) {
            lockLevels[i] = lockLevel;
        }
        return this.pendUndelete(items, lockLevels, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendUndelete(ItemSpec[] items, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendUndelete(items, lockLevels, getOptions, pendOptions, null);
    }

    public int pendUndelete(ItemSpec[] items, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(items, "paths");
        Check.notNull(lockLevels, "lockLevels");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromSpecs(items, RequestType.UNDELETE, lockLevels, null);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendUndelete(ItemSpec item, String newName, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendUndelete(item, newName, lockLevel, getOptions, pendOptions, null);
    }

    public int pendUndelete(ItemSpec item, String newName, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(item, "item");
        Check.notNullOrEmpty(newName, "newName");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromSpecs(new ItemSpec[]{item}, RequestType.UNDELETE, new LockLevel[]{lockLevel}, null);
            Check.isTrue(requests.length == 1, "requests.length == 1");
            if (!ServerPath.isServerPath(newName)) {
                newName = LocalPath.canonicalize(newName);
            }
            requests[0].setTargetItem(newName);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendRename(String oldPath, String newPath, LockLevel lockLevel, GetOptions getOptions, boolean detectTargetItemType, PendChangesOptions pendOptions) {
        return this.pendRename(oldPath, newPath, lockLevel, getOptions, detectTargetItemType, pendOptions, null);
    }

    public int pendRename(String oldPath, String newPath, LockLevel lockLevel, GetOptions getOptions, boolean detectTargetItemType, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(oldPath, "oldPath");
        Check.notNullOrEmpty(newPath, "newPath");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = new ChangeRequest[]{new ChangeRequest(new ItemSpec(oldPath, RecursionType.NONE), null, RequestType.RENAME, ItemType.ANY, -2, lockLevel, 0, newPath, detectTargetItemType)};
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendRename(String[] oldPaths, String[] newPaths, LockLevel lockLevel, GetOptions getOptions, boolean detectTargetItemType, PendChangesOptions pendOptions) {
        return this.pendRename(oldPaths, newPaths, lockLevel, getOptions, detectTargetItemType, pendOptions, null);
    }

    public int pendRename(String[] oldPaths, String[] newPaths, LockLevel lockLevel, GetOptions getOptions, boolean detectTargetItemType, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(oldPaths, "oldPaths");
        Check.notNullOrEmpty(newPaths, "newPaths");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        Check.isTrue(oldPaths.length == newPaths.length, "oldPaths.length == newPaths.length");
        ChangeRequest[] requests = new ChangeRequest[oldPaths.length];
        try {
            for (int i = 0; i < oldPaths.length; ++i) {
                Check.notNull(oldPaths[i], "oldPaths[i]");
                Check.notNull(newPaths[i], "newPaths[i]");
                requests[i] = new ChangeRequest(new ItemSpec(oldPaths[i], RecursionType.NONE), LatestVersionSpec.INSTANCE, RequestType.RENAME, ItemType.ANY, -2, lockLevel, 0, newPaths[i], detectTargetItemType);
            }
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendEdit(ItemSpec[] specs, LockLevel lockLevel, FileEncoding fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendEdit(specs, lockLevel, fileEncoding, getOptions, pendOptions, null);
    }

    public int pendEdit(ItemSpec[] specs, LockLevel lockLevel, FileEncoding fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(specs, "specs");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        LockLevel[] lockLevels = new LockLevel[specs.length];
        FileEncoding[] fileEncodings = new FileEncoding[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            lockLevels[i] = lockLevel;
            fileEncodings[i] = fileEncoding;
        }
        return this.pendEdit(specs, lockLevels, fileEncodings, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendEdit(ItemSpec[] specs, LockLevel[] lockLevels, FileEncoding[] fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendEdit(specs, lockLevels, fileEncoding, getOptions, pendOptions, null);
    }

    public int pendEdit(ItemSpec[] specs, LockLevel[] lockLevels, FileEncoding[] fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(specs, "specs");
        Check.notNull(lockLevels, "lockLevels");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromSpecs(specs, RequestType.EDIT, lockLevels, fileEncoding);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendEdit(String[] paths, RecursionType recursion, LockLevel lockLevel, FileEncoding fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendEdit(paths, recursion, lockLevel, fileEncoding, getOptions, pendOptions, null);
    }

    public int pendEdit(String[] paths, RecursionType recursion, LockLevel lockLevel, FileEncoding fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(paths, "paths");
        Check.notNull(recursion, "recursion");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        LockLevel[] lockLevels = new LockLevel[paths.length];
        FileEncoding[] fileEncodings = new FileEncoding[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            lockLevels[i] = lockLevel;
            fileEncodings[i] = fileEncoding;
        }
        return this.pendEdit(paths, recursion, lockLevels, fileEncodings, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendEdit(String[] paths, RecursionType recursion, LockLevel[] lockLevels, FileEncoding[] fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.pendEdit(paths, recursion, lockLevels, fileEncoding, getOptions, pendOptions, null);
    }

    public int pendEdit(String[] paths, RecursionType recursion, LockLevel[] lockLevels, FileEncoding[] fileEncoding, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNull(paths, "paths");
        Check.notNull(recursion, "recursion");
        Check.notNull(lockLevels, "lockLevels");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromStrings(paths, RequestType.EDIT, lockLevels, recursion, fileEncoding);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int pendPropertyChange(String path, PropertyValue property) {
        return this.pendPropertyChange(path, property, RecursionType.NONE, LockLevel.UNCHANGED);
    }

    public int pendPropertyChange(String path, PropertyValue property, RecursionType recursion, LockLevel lockLevel) {
        Check.notNullOrEmpty(path, "path");
        Check.notNull(property, "property");
        return this.pendPropertyChange(path, new PropertyValue[]{property}, recursion, lockLevel);
    }

    public int pendPropertyChange(String path, PropertyValue[] properties, RecursionType recursion, LockLevel lockLevel) {
        Check.notNullOrEmpty(path, "path");
        Check.notNull(properties, "properties");
        return this.pendPropertyChange(new String[]{path}, properties, recursion, lockLevel, PendChangesOptions.NONE, null);
    }

    public int pendPropertyChange(String[] paths, PropertyValue property, RecursionType recursion, LockLevel lockLevel) {
        Check.notNullOrEmpty(paths, "paths");
        Check.notNull(property, "property");
        return this.pendPropertyChange(paths, new PropertyValue[]{property}, recursion, lockLevel, PendChangesOptions.NONE, null);
    }

    public int pendPropertyChange(String[] paths, PropertyValue[] properties, RecursionType recursion, LockLevel lockLevel, PendChangesOptions options, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(paths, "paths");
        Check.notNullOrEmpty(properties, "properties");
        if (this.getClient().getServiceLevel().getValue() < WebServiceLevel.TFS_2012.getValue()) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new VersionControlException(Messages.getString("Workspace.PropertyNotSupportedText"))));
            return 0;
        }
        ArrayList<ChangeRequest> changeRequests = new ArrayList<ChangeRequest>(paths.length);
        for (String path : paths) {
            ChangeRequest cr = new ChangeRequest(new ItemSpec(path, recursion), null, RequestType.PROPERTY, ItemType.ANY, -2, lockLevel, 0, null, false);
            cr.setProperties(properties);
            changeRequests.add(cr);
        }
        return this.pendChanges(changeRequests.toArray(new ChangeRequest[changeRequests.size()]), GetOptions.NONE, options, itemPropertyFilters);
    }

    public int pendPropertyChange(ItemProperties[] specs, RecursionType recursion, LockLevel lockLevel, PendChangesOptions options, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(specs, "specs");
        if (this.getClient().getServiceLevel().getValue() < WebServiceLevel.TFS_2012.getValue()) {
            return 0;
        }
        ArrayList<ChangeRequest> changeRequests = new ArrayList<ChangeRequest>(specs.length);
        for (ItemProperties spec : specs) {
            ChangeRequest cr = new ChangeRequest(new ItemSpec(spec.getPath(), recursion), null, RequestType.PROPERTY, ItemType.ANY, -2, lockLevel, 0, null, false);
            cr.setProperties(spec.getProperties());
            changeRequests.add(cr);
        }
        return this.pendChanges(changeRequests.toArray(new ChangeRequest[changeRequests.size()]), GetOptions.NONE, options, itemPropertyFilters);
    }

    public int setLock(String[] paths, LockLevel lockLevel, RecursionType recursion, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.setLock(paths, lockLevel, recursion, getOptions, pendOptions, null);
    }

    public int setLock(String[] paths, LockLevel[] lockLevels, RecursionType recursion, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.setLock(paths, lockLevels, recursion, getOptions, pendOptions, null);
    }

    public int setLock(String[] paths, LockLevel lockLevel, RecursionType recursion, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(paths, "paths");
        Check.notNull(recursion, "recursion");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        LockLevel[] lockLevels = new LockLevel[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            lockLevels[i] = lockLevel;
        }
        return this.setLock(paths, lockLevels, recursion, getOptions, pendOptions, itemPropertyFilters);
    }

    public int setLock(String[] paths, LockLevel[] lockLevels, RecursionType recursion, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(paths, "paths");
        Check.notNull(recursion, "recursion");
        Check.notNullOrEmpty(lockLevels, "lockLevels");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromStrings(paths, RequestType.LOCK, lockLevels, recursion, null);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public int setLock(ItemSpec[] itemSpecs, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.setLock(itemSpecs, lockLevel, getOptions, pendOptions, null);
    }

    public int setLock(ItemSpec[] itemSpecs, LockLevel lockLevel, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(getOptions, "getOptions");
        LockLevel[] lockLevels = new LockLevel[itemSpecs.length];
        for (int i = 0; i < lockLevels.length; ++i) {
            lockLevels[i] = lockLevel;
        }
        return this.setLock(itemSpecs, lockLevels, getOptions, pendOptions, itemPropertyFilters);
    }

    public int setLock(ItemSpec[] itemSpecs, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions) {
        return this.setLock(itemSpecs, lockLevels, getOptions, pendOptions, null);
    }

    public int setLock(ItemSpec[] itemSpecs, LockLevel[] lockLevels, GetOptions getOptions, PendChangesOptions pendOptions, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        Check.notNullOrEmpty(lockLevels, "lockLevels");
        Check.notNull(getOptions, "getOptions");
        ChangeRequest[] requests = null;
        try {
            requests = ChangeRequest.fromSpecs(itemSpecs, RequestType.LOCK, lockLevels, null);
        }
        catch (ChangeRequestValidationException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            return 0;
        }
        return this.pendChanges(requests, getOptions, pendOptions, itemPropertyFilters);
    }

    public String addIgnoreFileExclusionAuto(String localItem) throws FileNotFoundException, IOException {
        Check.notNullOrEmpty(localItem, "localItem");
        return this.addIgnoreFileExclusionAuto(localItem, null);
    }

    public String addIgnoreFileExclusionAuto(String localItem, String exclusion) throws FileNotFoundException, IOException {
        String itemParent;
        String ignoreFilePath;
        Check.notNullOrEmpty(localItem, "localItem");
        WorkingFolder wf = this.getClosestMappingForLocalPath(localItem);
        if (wf == null) {
            throw new ItemNotMappedException(MessageFormat.format(Messages.getString("Workspace.ItemNotMappedExceptionFormat"), localItem));
        }
        String currentItem = LocalPath.getParent(localItem);
        while (!(!LocalPath.isChild(wf.getLocalItem(), currentItem) || new File(ignoreFilePath = LocalPath.combine(currentItem, LocalItemExclusionEvaluator.IGNORE_FILE_NAME)).exists() && this.isLocalPathMapped(ignoreFilePath) || ServerPath.isRootFolder(this.getMappedServerPath(itemParent = LocalPath.getParent(currentItem))) || !LocalPath.isChild(wf.getLocalItem(), itemParent))) {
            currentItem = itemParent;
        }
        if (exclusion == null) {
            exclusion = LocalPath.makeRelative(localItem, currentItem);
            exclusion = '\\' + exclusion.replace(File.separatorChar, '\\');
        }
        return this.addIgnoreFileExclusion(exclusion, currentItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addIgnoreFileExclusion(String exclusion, String ignoreFileDirectory) throws FileNotFoundException, IOException {
        boolean exists;
        File ignoreFile;
        block25: {
            FileOutputStream outputStream;
            block23: {
                block24: {
                    FileOutputStream outputStream2;
                    block21: {
                        Check.notNullOrEmpty(exclusion, "exclusion");
                        Check.notNullOrEmpty(ignoreFileDirectory, "ignoreFileDirectory");
                        File ignoreFileDirectoryFile = new File(ignoreFileDirectory);
                        if (!ignoreFileDirectoryFile.exists() || !ignoreFileDirectoryFile.isDirectory()) {
                            throw new FileNotFoundException(MessageFormat.format(Messages.getString("Workspace.PathDoesNotExistOrIsNotDirectoryFormat"), ignoreFileDirectoryFile));
                        }
                        ignoreFile = new File(ignoreFileDirectoryFile, LocalItemExclusionEvaluator.IGNORE_FILE_NAME);
                        if (!this.isLocalPathMapped(ignoreFile.getAbsolutePath())) {
                            throw new ItemNotMappedException(MessageFormat.format(Messages.getString("Workspace.ItemNotMappedExceptionFormat"), ignoreFile));
                        }
                        exists = ignoreFile.exists();
                        if (exists) break block24;
                        outputStream2 = null;
                        OutputStreamWriter streamWriter = null;
                        try {
                            outputStream2 = new FileOutputStream(ignoreFile, false);
                            streamWriter = new OutputStreamWriter((OutputStream)outputStream2, "UTF-8");
                            streamWriter.write(this.getTFIgnoreHeader());
                            streamWriter.write(NewlineUtils.PLATFORM_NEWLINE);
                            streamWriter.write(NewlineUtils.PLATFORM_NEWLINE);
                            streamWriter.write(exclusion);
                            streamWriter.write(NewlineUtils.PLATFORM_NEWLINE);
                            if (streamWriter == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (streamWriter != null) {
                                IOUtils.closeSafely(streamWriter);
                            }
                            if (outputStream2 != null) {
                                IOUtils.closeSafely(outputStream2);
                            }
                            throw throwable;
                        }
                        IOUtils.closeSafely(streamWriter);
                    }
                    if (outputStream2 != null) {
                        IOUtils.closeSafely(outputStream2);
                    }
                    break block25;
                }
                FileEncoding tfsEncoding = FileEncodingDetector.detectEncoding(ignoreFile.getAbsolutePath(), FileEncoding.AUTOMATICALLY_DETECT);
                Charset charset = CodePageMapping.getCharset(tfsEncoding.getCodePage(), false);
                if (charset == null) {
                    charset = CodePageMapping.getCharset(FileEncoding.getDefaultTextEncoding().getCodePage());
                }
                boolean writeNewLine = false;
                FileInputStream inputStream = new FileInputStream(ignoreFile);
                try {
                    char lastCharacter;
                    String existingContent = IOUtils.toString(inputStream, charset.name());
                    if (existingContent.length() > 0 && (lastCharacter = existingContent.charAt(existingContent.length() - 1)) != '\n') {
                        writeNewLine = true;
                    }
                }
                finally {
                    if (inputStream != null) {
                        IOUtils.closeSafely(inputStream);
                    }
                }
                outputStream = null;
                OutputStreamWriter streamWriter = null;
                try {
                    outputStream = new FileOutputStream(ignoreFile, true);
                    streamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
                    if (writeNewLine) {
                        streamWriter.write(NewlineUtils.PLATFORM_NEWLINE);
                    }
                    streamWriter.write(exclusion);
                    streamWriter.write(NewlineUtils.PLATFORM_NEWLINE);
                    if (streamWriter == null) break block23;
                }
                catch (Throwable throwable) {
                    if (streamWriter != null) {
                        IOUtils.closeSafely(streamWriter);
                    }
                    if (outputStream != null) {
                        IOUtils.closeSafely(outputStream);
                    }
                    throw throwable;
                }
                IOUtils.closeSafely(streamWriter);
            }
            if (outputStream != null) {
                IOUtils.closeSafely(outputStream);
            }
        }
        if (WorkspaceLocation.LOCAL == this.getLocation()) {
            this.getWorkspaceWatcher().markPathChanged(ignoreFile.getAbsolutePath());
        }
        if (!exists) {
            this.pendAdd(new String[]{ignoreFile.getAbsolutePath()}, false, FileEncoding.UTF_8, LockLevel.UNCHANGED, GetOptions.NONE, PendChangesOptions.NONE);
        }
        return ignoreFile.getAbsolutePath();
    }

    public Conflict[] queryConflicts(String[] pathFilters, boolean recursive) {
        ItemSpec[] specs = null;
        if (pathFilters != null && pathFilters.length > 0) {
            specs = new ItemSpec[pathFilters.length];
            for (int i = 0; i < pathFilters.length; ++i) {
                specs[i] = new ItemSpec(pathFilters[i], recursive ? RecursionType.FULL : RecursionType.NONE);
            }
        }
        return this.queryConflicts(specs);
    }

    public Conflict[] queryConflicts(ItemSpec[] itemSpecs) {
        Object[] ret = this.client.getWebServiceLayer().queryConflicts(this.getName(), this.getOwnerName(), itemSpecs);
        Arrays.sort(ret);
        return ret;
    }

    public void resolveConflict(Conflict conflict) {
        this.resolveConflict(conflict, new AtomicReference<Conflict[]>());
    }

    public void resolveConflict(Conflict conflict, AtomicReference<Conflict[]> resolvedConflicts) {
        this.resolveConflict(conflict, resolvedConflicts, null);
    }

    public void resolveConflict(Conflict conflict, AtomicReference<Conflict[]> resolvedConflicts, String[] itemPropertyFilters) {
        this.resolveConflict(conflict, resolvedConflicts, itemPropertyFilters, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveConflict(Conflict conflict, AtomicReference<Conflict[]> resolvedConflicts, String[] itemPropertyFilters, ExternalToolset externalToolset, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) {
        Check.notNull(conflict, "conflict");
        this.client.getEventEngine().fireOperationStarted(new ResolveConflictStartedEvent(EventSource.newFromHere(), this, conflict));
        try {
            this.resolveConflicts(new Conflict[]{conflict}, itemPropertyFilters, ResolveErrorOptions.THROW_ON_ERROR, resolvedConflicts, externalToolset, finishedHandler, capturedStandardOutput, capturedStandardError);
        }
        finally {
            this.client.getEventEngine().fireOperationCompleted(new ResolveConflictCompletedEvent(EventSource.newFromHere(), this, conflict));
        }
    }

    public void resolveConflicts(Conflict[] conflicts, String[] itemPropertyFilters, AtomicReference<Conflict[]> resolvedConflicts) {
        this.resolveConflicts(conflicts, itemPropertyFilters, ResolveErrorOptions.RAISE_WARNINGS_FOR_ERROR, resolvedConflicts);
    }

    public void resolveConflicts(Conflict[] conflicts, String[] itemPropertyFilters, ResolveErrorOptions errorOptions, AtomicReference<Conflict[]> resolvedConflicts) {
        this.resolveConflicts(conflicts, itemPropertyFilters, errorOptions, resolvedConflicts, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveConflicts(Conflict[] conflicts, String[] itemPropertyFilters, ResolveErrorOptions errorOptions, AtomicReference<Conflict[]> resolvedConflicts, ExternalToolset externalToolset, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) {
        Check.notNull(conflicts, "conflicts");
        Check.notNull(errorOptions, "errorOptions");
        Check.notNull(resolvedConflicts, "resolvedConflicts");
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        Resolution resolution = Resolution.NONE;
        for (Conflict conflict : conflicts) {
            Check.notNull(conflict, "conflict");
            if (Resolution.NONE.equals(resolution)) {
                resolution = conflict.getResolution();
                continue;
            }
            if (resolution.equals(conflict.getResolution())) continue;
            throw new VersionControlException(Messages.getString("Workspace.ResolveConflictsRequiresOneResolutionException"));
        }
        this.client.getEventEngine().fireOperationStarted(new ResolveConflictsStartedEvent(EventSource.newFromHere(), this, conflicts));
        try {
            this.resolveConflictsInternal(conflicts, itemPropertyFilters, errorOptions, resolvedConflicts, externalToolset, finishedHandler, capturedStandardOutput, capturedStandardError);
        }
        finally {
            this.client.getEventEngine().fireOperationCompleted(new ResolveConflictsCompletedEvent(EventSource.newFromHere(), this, conflicts));
        }
    }

    private void resolveConflictsInternal(Conflict[] conflicts, String[] itemPropertyFilters, ResolveErrorOptions errorOptions, AtomicReference<Conflict[]> resolvedConflicts, ExternalToolset externalToolset, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) {
        ArrayList<Conflict> conflictsToResolve = new ArrayList<Conflict>();
        for (Conflict conflict : conflicts) {
            block17: {
                Check.notNull(conflict, "conflict");
                if (conflict.isResolved()) continue;
                if (Resolution.ACCEPT_MERGE.equals(conflict.getResolution()) && (conflict.getMergedFileName() == null || conflict.getMergedFileName().length() == 0) && conflict.getConflictOptions().contains(ConflictOptions.DISALLOW_AUTO_MERGE)) {
                    AutoMergeDisallowedException exception = new AutoMergeDisallowedException(MessageFormat.format(Messages.getString("Workspace.AutoMergeDisallowedFormat"), conflict.getYourServerItem() != null ? conflict.getYourServerItem() : conflict.getTheirServerItem()));
                    if (ResolveErrorOptions.THROW_ON_ERROR.equals(errorOptions)) {
                        throw exception;
                    }
                    if (!ResolveErrorOptions.RAISE_WARNINGS_FOR_ERROR.equals(errorOptions)) continue;
                    this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)exception));
                    continue;
                }
                if (Resolution.ACCEPT_MERGE.equals(conflict.getResolution()) && conflict.canMergeContent()) {
                    if (!conflict.theirFileExists()) {
                        log.trace((Object)"Skipping content merge, file does not exist.");
                    } else if (conflict.getMergedFileName() == null || conflict.getMergedFileName().length() == 0) {
                        try {
                            boolean isProblem;
                            MergeEngine me = new MergeEngine(this, this.client, externalToolset);
                            boolean bl = isProblem = !me.mergeContent(conflict, false, finishedHandler, capturedStandardOutput, capturedStandardError);
                            if (isProblem || conflict.getContentMergeSummary() != null && !conflict.getResolutionOptions().isAcceptMergeWithConflicts() && conflict.getContentMergeSummary().getTotalConflictingLines() != 0) {
                                if (conflict.getMergedFileName() != null && conflict.getMergedFileName().length() > 0) {
                                    new File(conflict.getMergedFileName()).delete();
                                }
                                conflict.setMergedFileName(null);
                                log.debug((Object)"Failed content merge.");
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            if (conflict.getMergedFileName() != null) {
                                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new VersionControlException(MessageFormat.format(Messages.getString("Workspace.MergeSavedFormat"), conflict.getMergedFileName()))));
                                continue;
                            }
                            if (ResolveErrorOptions.RAISE_WARNINGS_FOR_ERROR.equals(errorOptions)) {
                                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)ex));
                                continue;
                            }
                            if (!ResolveErrorOptions.THROW_ON_ERROR.equals(errorOptions)) continue;
                            throw new VersionControlException(ex);
                        }
                    }
                }
                if (Resolution.ACCEPT_MERGE.equals(conflict.getResolution()) && conflict.isPropertyConflict() && conflict.getResolutionOptions().getAcceptMergeProperties() == null) {
                    try {
                        PropertiesMergeSummary propertiesMergeSummary = conflict.mergeProperties(this);
                        if (propertiesMergeSummary.getTotalConflicts() != 0) continue;
                        conflict.getResolutionOptions().setAcceptMergeProperties(propertiesMergeSummary.getMergedProperties());
                    }
                    catch (Exception ex) {
                        if (ResolveErrorOptions.RAISE_WARNINGS_FOR_ERROR.equals(errorOptions)) {
                            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)ex));
                        }
                        if (!ResolveErrorOptions.THROW_ON_ERROR.equals(errorOptions)) break block17;
                        throw new VersionControlException(ex);
                    }
                }
            }
            conflictsToResolve.add(conflict);
        }
        this.client.resolveConflicts(this, conflictsToResolve.toArray(new Conflict[conflictsToResolve.size()]), itemPropertyFilters, errorOptions, resolvedConflicts);
    }

    public PendingSet getPendingChanges() {
        return this.getPendingChanges(new String[]{"$/"}, RecursionType.FULL, false);
    }

    public PendingSet getPendingChanges(String[] serverPaths, RecursionType recursionType, boolean includeDownloadInfo) {
        return this.getPendingChanges(serverPaths, recursionType, includeDownloadInfo, null);
    }

    public PendingSet getPendingChanges(String[] serverPaths, RecursionType recursionType, boolean includeDownloadInfo, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(serverPaths, "serverPaths");
        Check.notNull(recursionType, "recursionType");
        PendingSet[] ret = this.queryPendingSets(serverPaths, recursionType, this.getName(), this.getOwnerName(), includeDownloadInfo, itemPropertyFilters);
        if (ret.length == 0) {
            return null;
        }
        return ret[0];
    }

    public PendingSet getPendingChanges(ItemSpec[] specs, boolean includeDownloadInfo) {
        return this.getPendingChanges(specs, includeDownloadInfo, null);
    }

    public PendingSet getPendingChanges(ItemSpec[] specs, boolean includeDownloadInfo, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(specs, "specs");
        PendingSet[] ret = this.queryPendingSets(specs, this.getName(), this.getOwnerName(), includeDownloadInfo, itemPropertyFilters);
        if (ret.length == 0) {
            return null;
        }
        return ret[0];
    }

    public PendingChange[] getPendingChangesWithCandidates(ItemSpec[] itemSpecs, boolean includeDownloadInfo, AtomicReference<PendingChange[]> candidateChanges) {
        return this.getPendingChangesWithCandidates(itemSpecs, includeDownloadInfo, candidateChanges, null);
    }

    public PendingChange[] getPendingChangesWithCandidates(ItemSpec[] itemSpecs, boolean includeDownloadInfo, AtomicReference<PendingChange[]> candidateChanges, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        Check.notNull(candidateChanges, "candidateChanges");
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
        PendingSet[] pendingSets = this.getClient().getWebServiceLayer().queryPendingSets(this.getName(), this.getOwnerName(), this.getName(), this.getOwnerName(), itemSpecs, includeDownloadInfo, failures, true, itemPropertyFilters);
        Check.isTrue(pendingSets.length <= 1, "How did we get more than 1 pending set for a workspace?");
        this.getClient().reportFailures(this, failures.get());
        if (pendingSets.length == 0) {
            candidateChanges.set(new PendingChange[0]);
            return new PendingChange[0];
        }
        candidateChanges.set(pendingSets[0].getCandidatePendingChanges());
        if (candidateChanges.get() == null) {
            candidateChanges.set(new PendingChange[0]);
        }
        return pendingSets[0].getPendingChanges();
    }

    public PendingSet[] queryPendingSets(String[] serverOrLocalPaths, RecursionType recursionType, String queryWorkspaceName, String queryWorkspaceOwner, boolean includeDownloadInfo) {
        return this.queryPendingSets(serverOrLocalPaths, recursionType, queryWorkspaceName, queryWorkspaceOwner, includeDownloadInfo, null);
    }

    public PendingSet[] queryPendingSets(String[] serverOrLocalPaths, RecursionType recursionType, String queryWorkspaceName, String queryWorkspaceOwner, boolean includeDownloadInfo, String[] itemPropertyFilters) {
        return this.client.queryPendingSets(serverOrLocalPaths, recursionType, includeDownloadInfo, queryWorkspaceName, queryWorkspaceOwner, itemPropertyFilters);
    }

    public PendingSet[] queryPendingSets(ItemSpec[] itemSpecs, String queryWorkspaceName, String queryWorkspaceOwner, boolean includeDownloadInfo) {
        return this.queryPendingSets(itemSpecs, queryWorkspaceName, queryWorkspaceOwner, includeDownloadInfo, null);
    }

    public PendingSet[] queryPendingSets(ItemSpec[] itemSpecs, String queryWorkspaceName, String queryWorkspaceOwner, boolean includeDownloadInfo, String[] itemPropertyFilters) {
        return this.client.queryPendingSets(itemSpecs, includeDownloadInfo, queryWorkspaceName, queryWorkspaceOwner, false, itemPropertyFilters);
    }

    public PendingSet[] queryShelvedChanges(String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs) {
        return this.queryShelvedChanges(shelvesetName, shelvesetOwner, itemSpecs, false);
    }

    public PendingSet[] queryShelvedChanges(String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs, boolean includeDownloadInfo) {
        return this.queryShelvedChanges(shelvesetName, shelvesetOwner, itemSpecs, includeDownloadInfo, null);
    }

    public PendingSet[] queryShelvedChanges(String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs, boolean includeDownloadInfo, String[] itemPropertyFilters) {
        return this.client.queryShelvedChanges(shelvesetName, shelvesetOwner, itemSpecs, includeDownloadInfo, itemPropertyFilters);
    }

    public void update(String newName, String newComment, WorkingFolder[] newMappings) {
        this.update(newName, newComment, newMappings, false);
    }

    public void update(String newName, String newComment, WorkingFolder[] newMappings, boolean removeUnparentedCloaks) {
        this.update(newName, null, newComment, newMappings, removeUnparentedCloaks);
    }

    public void update(String newName, String newOwner, String newComment, WorkingFolder[] newMappings, boolean removeUnparentedCloaks) {
        this.update(newName, newOwner, newComment, null, newMappings, null, removeUnparentedCloaks);
    }

    public void update(String newName, String newOwner, String newComment, String newComputer, WorkingFolder[] newMappings, WorkspacePermissionProfile newPermissionProfile, boolean removeUnparentedCloaks) {
        this.update(newName, newOwner, newComment, newComputer, newMappings, newPermissionProfile, removeUnparentedCloaks, null);
    }

    public void update(String newName, String newOwner, String newComment, String newComputer, WorkingFolder[] newMappings, WorkspacePermissionProfile newPermissionProfile, boolean removeUnparentedCloaks, WorkspaceOptions newOptions) {
        this.update(newName, newOwner, newComment, newComputer, newMappings, newPermissionProfile, removeUnparentedCloaks, newOptions, null);
    }

    public void update(String newName, String newOwner, String newComment, String newComputer, WorkingFolder[] newMappings, WorkspacePermissionProfile newPermissionProfile, boolean removeUnparentedCloaks, WorkspaceOptions newOptions, WorkspaceLocation newLocation) {
        this.client.updateWorkspace(this, newName, newOwner, newComment, newMappings, newComputer, newPermissionProfile, removeUnparentedCloaks, newOptions, newLocation);
    }

    public void updateComputerName() {
        this.update(null, null, null, LocalHost.getShortName(), null, null, false);
    }

    public void updateFromWorkspace(Workspace updateSource) {
        boolean cachedPropertiesModified;
        Check.notNull(updateSource, "updateSource");
        Workspace currentWorkspace = new Workspace(this);
        boolean invalidateLocalWorkspaceScanner = false;
        boolean bl = cachedPropertiesModified = !Workspace.matchName(currentWorkspace.getName(), updateSource.getName()) || !Workspace.matchOwner(currentWorkspace.getOwnerName(), updateSource.getOwnerName()) || !Workspace.matchOwner(currentWorkspace.getOwnerDisplayName(), updateSource.getOwnerDisplayName()) || !Workspace.matchComment(currentWorkspace.getComment(), updateSource.getComment()) || !Workspace.matchComputer(currentWorkspace.getComputer(), updateSource.getComputer()) || !Workspace.matchSecurityToken(currentWorkspace.getSecurityToken(), updateSource.getSecurityToken()) || currentWorkspace.getLocation() != updateSource.getLocation() || !currentWorkspace.getOptions().equals(updateSource.getOptions());
        if (updateSource.getLocation() == WorkspaceLocation.LOCAL && !WorkingFolder.areSetsEqual(currentWorkspace.getFolders(), updateSource.getFolders())) {
            invalidateLocalWorkspaceScanner = true;
        }
        WorkspaceInfo wi = Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).getCache().getWorkspace(this.getClient().getServerGUID(), currentWorkspace.getName(), currentWorkspace.getOwnerName());
        if (!cachedPropertiesModified) {
            if (currentWorkspace.getLocation() == WorkspaceLocation.LOCAL) {
                cachedPropertiesModified = invalidateLocalWorkspaceScanner || !WorkingFolder.areSetsEqual(currentWorkspace.getFolders(), updateSource.getFolders());
            } else if (null != wi) {
                boolean bl2 = cachedPropertiesModified = !WorkspaceInfo.areMappedPathSetsEqual(wi.getMappedPaths(), WorkingFolder.extractMappedPaths(updateSource.getFolders()));
            }
        }
        if (cachedPropertiesModified) {
            this.getClient().removeCachedWorkspace(currentWorkspace.getName(), currentWorkspace.getOwnerName());
        }
        _Workspace clone = Workspace.cloneWebServiceObject(updateSource.getWebServiceObject());
        this.webServiceObject = clone;
        this.setPermissionsProfile(null);
        this.uncachedPropertiesStale = false;
        this.workingFoldersStale = false;
        if (cachedPropertiesModified && Workspace.matchComputer(LocalHost.getShortName(), clone.getComputer())) {
            this.getClient().removeCachedWorkspace(clone.getName(), clone.getOwner());
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).insertWorkspaceIntoCache(this);
            if (null != wi) {
                this.setLastSavedCheckin(wi.getLastSavedCheckin());
            }
        }
        if (invalidateLocalWorkspaceScanner) {
            this.getWorkspaceWatcher().workingFoldersChanged(currentWorkspace.getFolders());
        }
        Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).saveConfigIfDirty();
    }

    private void updateLastSavedCheckin(String comment, CheckinNote note, WorkItemCheckinInfo[] associatedWorkItems, PolicyOverrideInfo policyOverrideInfo) {
        SavedCheckin savedCheckin = this.getLastSavedCheckin();
        if (savedCheckin == null) {
            savedCheckin = new SavedCheckin();
        }
        savedCheckin.setComment(comment);
        savedCheckin.setCheckinNotes(note);
        savedCheckin.setPersistentWorkItemsCheckedInfo(WorkItemCheckedInfo.fromCheckinInfo(associatedWorkItems));
        savedCheckin.setPolicyOverrideComment(policyOverrideInfo != null && policyOverrideInfo.getComment() != null ? policyOverrideInfo.getComment() : null);
        this.setLastSavedCheckin(savedCheckin);
    }

    public void updateLastSavedCheckin(Shelveset shelveset) {
        Check.notNull(shelveset, "shelveset");
        SavedCheckin newSavedCheckin = new SavedCheckin(shelveset);
        SavedCheckin lastSavedCheckin = this.getLastSavedCheckin();
        if (lastSavedCheckin != null) {
            newSavedCheckin.setExcludedServerPaths(lastSavedCheckin.getExcludedServerPaths());
            newSavedCheckin.mergeWorkItems(lastSavedCheckin.getWorkItemsCheckedInfo());
        }
        this.setLastSavedCheckin(newSavedCheckin);
    }

    public void updateLastSavedCheckin(Shelveset shelveset, PendingChange[] unshelvedChanges) {
        Check.notNull(shelveset, "shelveset");
        if (this.getLastSavedCheckin() == null) {
            this.setLastSavedCheckin(new SavedCheckin(shelveset));
        }
        this.getLastSavedCheckin().mergeShelvesetMetadata(shelveset, unshelvedChanges);
    }

    private static _Workspace cloneWebServiceObject(_Workspace workspace) {
        Check.notNull(workspace, "workspace");
        _WorkingFolder[] folders = null;
        if (workspace.getFolders() != null) {
            folders = new _WorkingFolder[workspace.getFolders().length];
            for (int i = 0; i < folders.length; ++i) {
                folders[i] = new _WorkingFolder(workspace.getFolders()[i].getItem(), workspace.getFolders()[i].getType(), workspace.getFolders()[i].getDepth(), workspace.getFolders()[i].getLocal());
            }
        }
        String[] ownerAliases = null;
        if (workspace.getOwnerAliases() != null) {
            ownerAliases = new String[workspace.getOwnerAliases().length];
            for (int i = 0; i < ownerAliases.length; ++i) {
                ownerAliases[i] = workspace.getOwnerAliases()[i];
            }
        }
        return new _Workspace(workspace.getComputer(), workspace.isIslocal(), workspace.getName(), workspace.getOwner(), workspace.getOwnerdisp(), workspace.getOwner(), workspace.getPermissions(), workspace.getSecuritytoken(), workspace.getOwnertype(), workspace.getOwnerid(), workspace.getComment(), folders, ownerAliases, workspace.getLastAccessDate() != null ? (Calendar)workspace.getLastAccessDate().clone() : null, workspace.getOptions());
    }

    public void refreshIfNeeded() {
        if (WorkspaceLocation.LOCAL == this.getLocation()) {
            if (this.uncachedPropertiesStale) {
                this.refresh();
            } else if (this.workingFoldersStale) {
                Object[] folders = LocalDataAccessLayer.queryWorkingFolders(this);
                this.getWebServiceObject().setFolders((_WorkingFolder[])WrapperUtils.unwrap(_WorkingFolder.class, folders));
                this.workingFoldersStale = false;
            }
        } else if (this.uncachedPropertiesStale || this.workingFoldersStale) {
            this.refresh();
        }
    }

    public void refreshMappingsIfNeeded() {
        if (this.getWebServiceObject().getFolders() == null || this.workingFoldersStale) {
            Object[] folders = this.getLocation() == WorkspaceLocation.LOCAL ? LocalDataAccessLayer.queryWorkingFolders(this) : this.client.queryWorkspace(this.getName(), this.getOwnerName()).getFolders();
            this.getWebServiceObject().setFolders((_WorkingFolder[])WrapperUtils.unwrap(_WorkingFolder.class, folders));
            this.workingFoldersStale = false;
        }
    }

    public void refresh() {
        Workspace ws = this.getClient().getRepositoryWorkspace(this.getName(), this.getOwnerName());
        if (ws != this) {
            log.debug((Object)"Runtime workspace cache returned a different object after this workspace refresh.");
            log.debug((Object)("    this.name  = " + this.getName()));
            log.debug((Object)("    this.owner = " + this.getOwnerName()));
            log.debug((Object)("      ws.name  = " + ws.getName()));
            log.debug((Object)("      ws.owner = " + ws.getOwnerName()));
            log.debug((Object)("    user.name  = " + this.getClient().getConnection().getAuthenticatedIdentity().getDisplayName()));
            log.debug((Object)("                 " + this.getClient().getConnection().getAuthenticatedIdentity().getUniqueName()));
        }
    }

    public int undo(ItemSpec[] items) {
        return this.undo(items, GetOptions.NONE);
    }

    public int undo(ItemSpec[] items, GetOptions getOptions) {
        return this.undo(items, getOptions, null);
    }

    public int undo(ItemSpec[] items, GetOptions getOptions, String[] itemPropertyFilters) {
        return this.undo(items, getOptions, false, itemPropertyFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int undo(ItemSpec[] items, GetOptions getOptions, boolean deleteAdds, String[] itemPropertyFilters) {
        Check.notNull(items, "items");
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        this.client.getEventEngine().fireOperationStarted(new UndoOperationStartedEvent(EventSource.newFromHere(), this, items));
        int ret = 0;
        try {
            if (items.length == 0) {
                int n = 0;
                return n;
            }
            AtomicReference<Failure[]> failuresHolder = new AtomicReference<Failure[]>();
            AtomicBoolean onlineOperationHolder = new AtomicBoolean();
            AtomicReference<ChangePendedFlags> changePendedFlagsHolder = new AtomicReference<ChangePendedFlags>();
            GetOperation[] operations = this.client.getWebServiceLayer().undoPendingChanges(this.getName(), this.getOwnerName(), items, failuresHolder, null, itemPropertyFilters, onlineOperationHolder, false, changePendedFlagsHolder);
            if (operations != null && operations.length > 0) {
                if (this.isLocal()) {
                    GetEngine getEngine = new GetEngine(this.client);
                    getEngine.processGetOperations(this, ProcessType.UNDO, RequestType.NONE, new GetOperation[][]{operations}, getOptions, deleteAdds, onlineOperationHolder.get(), changePendedFlagsHolder.get());
                    ret = operations.length;
                } else {
                    String messageFormat = Messages.getString("Workspace.OperationCompletedForRemoteWorkspaceButGetRequiredFormat");
                    String message = MessageFormat.format(messageFormat, this.getDisplayName());
                    this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new Exception(message)));
                }
            }
            if (changePendedFlagsHolder.get().contains(ChangePendedFlags.WORKING_FOLDER_MAPPINGS_UPDATED)) {
                this.invalidateMappings();
            }
            this.client.reportFailures(this, failuresHolder.get());
        }
        finally {
            this.client.getEventEngine().fireOperationCompleted(new UndoOperationCompletedEvent(EventSource.newFromHere(), this, items));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED);
        }
        return ret;
    }

    public SavedCheckin getLastSavedCheckin() {
        Workstation workstation = Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider());
        WorkspaceInfo workspaceInfo = workstation.getLocalWorkspaceInfo(this.getClient().getServerGUID(), this.getName(), this.getOwnerName());
        if (workspaceInfo != null) {
            return workspaceInfo.getLastSavedCheckin();
        }
        return null;
    }

    public void setLastSavedCheckin(SavedCheckin newSavedCheckin) {
        Workstation workstation = Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider());
        WorkspaceInfo workspaceInfo = workstation.getLocalWorkspaceInfo(this.getClient().getServerGUID(), this.getName(), this.getOwnerName());
        if (workspaceInfo != null) {
            workspaceInfo.setLastSavedCheckin(newSavedCheckin, workstation);
        }
    }

    public boolean isLocal() {
        return this.matchComputer(LocalHost.getShortName());
    }

    public boolean isLocalWorkspace() {
        return this.getLocation() == WorkspaceLocation.LOCAL;
    }

    public WorkspaceLocation getLocation() {
        if (this.getWebServiceObject().isIslocal()) {
            return WorkspaceLocation.LOCAL;
        }
        return WorkspaceLocation.SERVER;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public WorkspaceLock lock() {
        if (this.getLocation() == WorkspaceLocation.SERVER) {
            return null;
        }
        return new WorkspaceLock(this);
    }

    public void removeLocalConflict(Conflict conflict) {
        Check.notNull(conflict, "conflict");
        this.removeLocalConflicts(new Conflict[]{conflict}, ResolveErrorOptions.THROW_ON_ERROR);
    }

    public void removeLocalConflicts(Conflict[] conflicts) {
        this.removeLocalConflicts(conflicts, ResolveErrorOptions.RAISE_WARNINGS_FOR_ERROR);
    }

    private void removeLocalConflicts(Conflict[] conflicts, ResolveErrorOptions errorOptions) {
        Check.notNullOrEmpty(conflicts, "conflicts");
        this.client.resolveLocalConflicts(this, conflicts, errorOptions);
    }

    public FileType[] queryFileTypes() {
        return this.getClient().getWebServiceLayer().queryFileTypes();
    }

    public void setFileTypes(FileType[] fileTypes) {
        Check.notNull(fileTypes, "fileTypes");
        this.getClient().getWebServiceLayer().setFileTypes(fileTypes);
    }

    public void shelve(Shelveset set, PendingChange[] changesToShelve, boolean replace, boolean move) throws ShelveException {
        Check.notNull(set, "set");
        Check.notNullOrEmpty(changesToShelve, "changesToShelve");
        TaskMonitor monitor = TaskMonitorService.getTaskMonitor();
        monitor.begin(Messages.getString("Workspace.Shelve"), changesToShelve.length + 2);
        set.setOwnerName(IdentityHelper.getUniqueNameIfCurrentUser(this.client.getConnection().getAuthorizedIdentity(), set.getOwnerName()));
        Arrays.sort(changesToShelve, new PendingChangeComparator(PendingChangeComparatorType.SERVER_ITEM));
        monitor.worked(1);
        try {
            CheckinEngine ci = new CheckinEngine(this.client, this);
            try {
                ci.uploadChanges(changesToShelve, true, false);
            }
            catch (CheckinException e) {
                throw new ShelveException(e);
            }
            String[] sortedServerItems = PendingChange.toServerItems(changesToShelve);
            if (monitor.isCanceled()) {
                throw new CoreCancelException();
            }
            Failure[] failures = this.client.getWebServiceLayer().shelve(this.getName(), this.getOwnerName(), sortedServerItems, set, replace);
            if (failures != null && failures.length > 0) {
                this.client.reportFailures(this, failures);
                throw new ShelveException(Messages.getString("Workspace.NoChangesShelved"));
            }
            if (move) {
                PendingChange change;
                int i;
                this.setLastSavedCheckin(this.buildEmptyLastSavedCheckin());
                this.undo(ItemSpec.fromStrings(sortedServerItems, RecursionType.NONE));
                for (i = 0; i < changesToShelve.length; ++i) {
                    change = changesToShelve[i];
                    Check.notNull(change, "change");
                    if (change.getItemType() != ItemType.FILE || !change.getChangeType().contains(ChangeType.ADD) || change.getLocalItem() == null) continue;
                    try {
                        if (new File(change.getLocalItem()).delete()) continue;
                        throw new IOException(MessageFormat.format(Messages.getString("Workspace.CannotDeleteFileFormat"), change.getLocalItem()));
                    }
                    catch (Exception e) {
                        this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
                    }
                }
                for (i = 0; i < changesToShelve.length; ++i) {
                    change = changesToShelve[i];
                    Check.notNull(change, "change");
                    if (change.getItemType() != ItemType.FOLDER || !change.getChangeType().contains(ChangeType.ADD) || change.getLocalItem() == null) continue;
                    File dir = new File(change.getLocalItem());
                    if (!dir.exists()) {
                        this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new IOException(MessageFormat.format(Messages.getString("Workspace.DirectoryDoesNotExistFormat"), change.getLocalItem()))));
                        continue;
                    }
                    try {
                        if (new File(change.getLocalItem()).delete()) continue;
                        throw new IOException(MessageFormat.format(Messages.getString("Workspace.CannotDeleteDirectoryFormat"), change.getLocalItem()));
                    }
                    catch (Exception e) {
                        this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
                    }
                }
            }
            this.client.getEventEngine().fireShelve(new ShelveEvent(EventSource.newFromHere(), this, set, changesToShelve, move));
        }
        catch (CoreCancelException e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new CoreCancelException(Messages.getString("Workspace.ShelveCancelled"))));
        }
    }

    public SavedCheckin buildEmptyLastSavedCheckin() {
        String[] excludedServerPaths;
        SavedCheckin lastSavedCheckin = this.getLastSavedCheckin();
        if (lastSavedCheckin != null && (excludedServerPaths = lastSavedCheckin.getExcludedServerPaths()) != null && excludedServerPaths.length > 0) {
            return new SavedCheckin(Arrays.asList(excludedServerPaths), "", null, null, "");
        }
        return null;
    }

    public UnshelveResult unshelve(String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs) throws UnshelveException {
        return this.unshelve(shelvesetName, shelvesetOwner, itemSpecs, null, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnshelveResult unshelve(String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs, String[] itemPropertyFilters, String[] shelvesetPropertyFilters, boolean merge, boolean noAutoResolve) throws UnshelveException {
        PendingChange[] unshelvedChanges;
        Check.notNullOrEmpty(shelvesetName, "shelvesetName");
        Check.notNullOrEmpty(shelvesetOwner, "shelvesetOwner");
        log.debug((Object)"Unshelve started.");
        AtomicReference<Failure[]> failuresHolder = new AtomicReference<Failure[]>();
        AtomicReference<GetOperation[]> getOperationsHolder = new AtomicReference<GetOperation[]>();
        AtomicReference<Conflict[]> conflictsHolder = new AtomicReference<Conflict[]>();
        AtomicReference<ChangePendedFlags> changePendedFlagsHolder = new AtomicReference<ChangePendedFlags>();
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        Shelveset shelveset = this.client.getWebServiceLayer().unshelve(shelvesetName, shelvesetOwner, this.getName(), this.getOwnerName(), itemSpecs, null, itemPropertyFilters, shelvesetPropertyFilters, merge, failuresHolder, getOperationsHolder, conflictsHolder, changePendedFlagsHolder);
        log.debug((Object)"Preparing get operations.");
        if (failuresHolder.get().length > 0) {
            this.client.reportFailures(this, failuresHolder.get());
            if (getOperationsHolder.get().length == 0) {
                throw new UnshelveException(Messages.getString("Workspace.NoChangesUnshelved"));
            }
        }
        if (shelveset == null) {
            return null;
        }
        GetOperation[] getOperations = getOperationsHolder.get();
        Conflict[] conflicts = conflictsHolder.get();
        PendingChange[] pendingChangeArray = unshelvedChanges = getOperations != null ? new PendingChange[getOperations.length] : new PendingChange[]{};
        if (getOperations != null && getOperations.length > 0) {
            for (int i = 0; i < getOperations.length; ++i) {
                getOperations[i].setProcessType(ProcessType.UNSHELVE);
                unshelvedChanges[i] = new PendingChange(this, getOperations[i], ProcessType.UNSHELVE);
            }
        }
        this.client.getEventEngine().fireOperationStarted(new UnshelveShelvesetStartedEvent(EventSource.newFromHere(), this, shelveset, unshelvedChanges));
        GetStatus getStatus = new GetStatus();
        try {
            if (getOperations != null && getOperations.length > 0) {
                GetEngine getEngine = new GetEngine(this.client);
                getStatus = getEngine.processGetOperations(this, ProcessType.UNSHELVE, getOperations, GetOptions.NONE, changePendedFlagsHolder.get());
            }
            int resolvedConflicts = 0;
            if (conflicts != null && !noAutoResolve) {
                Conflict[] remainingConflicts = this.client.autoResolveValidConflicts(this, conflicts, AutoResolveOptions.ALL_SILENT);
                resolvedConflicts = conflicts.length - remainingConflicts.length;
                conflicts = remainingConflicts;
            }
            int nonResolvedConflicts = 0;
            if (conflicts != null) {
                for (Conflict conflict : conflicts) {
                    if (conflict.getResolution() != Resolution.NONE) continue;
                    ++nonResolvedConflicts;
                    this.client.getEventEngine().fireConflict(new ConflictEvent(EventSource.newFromHere(), conflict.getYourServerItemSource(), this, ConflictDescriptionFactory.getConflictDescription(ConflictCategory.getConflictCategory(conflict), conflict).getDescription(), true));
                }
            }
            getStatus.setNumConflicts(getStatus.getNumConflicts() + nonResolvedConflicts);
            getStatus.setNumResolvedConflicts(resolvedConflicts);
        }
        finally {
            this.client.getEventEngine().fireOperationCompleted(new UnshelveShelvesetCompletedEvent(EventSource.newFromHere(), this, shelveset, unshelvedChanges));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED);
        }
        if (changePendedFlagsHolder.get().contains(ChangePendedFlags.WORKING_FOLDER_MAPPINGS_UPDATED)) {
            this.invalidateMappings();
        }
        return new UnshelveResult(shelveset, getStatus, unshelvedChanges, conflicts);
    }

    public boolean matchName(String workspaceName) {
        Check.notNull(workspaceName, "workspaceName");
        return Workspace.matchName(workspaceName, this.getName());
    }

    public boolean matchOwner(String owner) {
        Check.notNull(owner, "owner");
        return Workspace.matchOwner(owner, this.getOwnerName());
    }

    public boolean matchComputer(String computer) {
        Check.notNull(computer, "computer");
        return Workspace.matchComputer(computer, this.getComputer());
    }

    public BranchHistory getBranchHistory(ItemSpec itemSpec, VersionSpec versionSpec) {
        Check.notNull(itemSpec, "itemSpec");
        Check.notNull(versionSpec, "versionSpec");
        return this.getBranchHistory(new ItemSpec[]{itemSpec}, versionSpec)[0];
    }

    public BranchHistory[] getBranchHistory(ItemSpec[] itemSpecs, VersionSpec versionSpec) {
        Check.notNull(itemSpecs, "itemSpecs");
        Check.notNull(versionSpec, "versionSpec");
        _BranchRelative[][] arrayOfArray = this.client.getWebServiceLayer().queryBranches(this.getName(), this.getOwnerName(), itemSpecs, versionSpec);
        BranchHistory[] historyItems = new BranchHistory[arrayOfArray.length];
        for (int i = 0; i < arrayOfArray.length; ++i) {
            _BranchRelative[] relatives = arrayOfArray[i];
            historyItems[i] = relatives == null ? null : this.buildBranchHistoryTree(relatives);
        }
        return historyItems;
    }

    protected BranchHistory buildBranchHistoryTree(_BranchRelative[] relatives) {
        HashMap missingParents = new HashMap(relatives.length);
        HashMap<Integer, BranchHistoryTreeItem> items = new HashMap<Integer, BranchHistoryTreeItem>(relatives.length);
        for (int i = 0; i < relatives.length; ++i) {
            ArrayList<BranchHistoryTreeItem> rootCandidates;
            int id = relatives[i].getReltoid();
            int parentId = relatives[i].getRelfromid();
            BranchHistoryTreeItem item = BranchHistoryTreeItem.createFromRelativeToItem(relatives[i]);
            if (item == null) continue;
            if (relatives[i].getBranchFromItem() != null) {
                item.setFromItem(new Item(relatives[i].getBranchFromItem()));
            }
            items.put(id, item);
            if (missingParents.containsKey(id)) {
                rootCandidates = (ArrayList<BranchHistoryTreeItem>)missingParents.get(id);
                for (BranchHistoryTreeItem child : rootCandidates) {
                    child.setParent(item);
                    item.addChild(child);
                }
                missingParents.remove(id);
            }
            if (items.containsKey(parentId)) {
                BranchHistoryTreeItem parent = (BranchHistoryTreeItem)items.get(parentId);
                item.setParent(parent);
                parent.addChild(item);
                continue;
            }
            if (missingParents.containsKey(parentId)) {
                ((List)missingParents.get(parentId)).add(item);
                continue;
            }
            rootCandidates = new ArrayList<BranchHistoryTreeItem>();
            rootCandidates.add(item);
            missingParents.put(parentId, rootCandidates);
        }
        BranchHistory history = new BranchHistory();
        for (List roots : missingParents.values()) {
            for (BranchHistoryTreeItem root : roots) {
                this.setBranchHistoryItemLevel(0, root);
                history.addChild(root);
            }
        }
        return history;
    }

    private void setBranchHistoryItemLevel(int level, BranchHistoryTreeItem item) {
        item.setLevel(level);
        for (BranchHistoryTreeItem child : item.getChildrenAsList()) {
            this.setBranchHistoryItemLevel(level + 1, child);
        }
    }

    public MergeCandidate[] getMergeCandidates(String sourcePath, String targetPath, RecursionType recursion, MergeFlags mergeFlags) {
        return this.client.getMergeCandidates(sourcePath, targetPath, recursion, mergeFlags);
    }

    public GetStatus merge(String sourcePath, String targetPath, VersionSpec sourceVersionFrom, VersionSpec sourceVersionTo, LockLevel lockLevel, RecursionType recursion, MergeFlags mergeFlags) {
        return this.merge(sourcePath, targetPath, sourceVersionFrom, sourceVersionTo, lockLevel, recursion, mergeFlags, null);
    }

    public GetStatus merge(String sourcePath, String targetPath, VersionSpec sourceVersionFrom, VersionSpec sourceVersionTo, LockLevel lockLevel, RecursionType recursion, MergeFlags mergeFlags, String[] itemPropertyFilters) {
        return this.merge(new ItemSpec(sourcePath, recursion), targetPath, sourceVersionFrom, sourceVersionTo, lockLevel, mergeFlags, itemPropertyFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public GetStatus merge(ItemSpec sourceSpec, String targetPath, VersionSpec sourceVersionFrom, VersionSpec sourceVersionTo, LockLevel lockLevel, MergeFlags mergeFlags, String[] itemPropertyFilters) {
        Check.notNull(sourceSpec, "sourceSpec");
        Check.notNullOrEmpty(sourceSpec.getItem(), "sourceSpec.item");
        Check.notNull(sourceSpec.getRecursionType(), "sourceSpec.recursion");
        Check.notNullOrEmpty(targetPath, "targetPath");
        Check.notNull(lockLevel, "lockLevel");
        Check.notNull(mergeFlags, "mergeFlags");
        itemPropertyFilters = this.client.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        ItemSpec targetSpec = new ItemSpec(targetPath, RecursionType.NONE);
        int nonResolvedConflicts = 0;
        int resolvedConflicts = 0;
        this.client.getEventEngine().fireOperationStarted(new MergeOperationStartedEvent(EventSource.newFromHere(), this));
        AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
        AtomicReference<Conflict[]> conflicts = new AtomicReference<Conflict[]>();
        AtomicReference<ChangePendedFlags> changePendedFlags = new AtomicReference<ChangePendedFlags>();
        try {
            void var21_39;
            Conflict conflict;
            GetOperation[] getOps = this.client.getWebServiceLayer().merge(this.getName(), this.getOwnerName(), sourceSpec, targetSpec, sourceVersionFrom, sourceVersionTo, lockLevel, mergeFlags, failures, conflicts, null, itemPropertyFilters, changePendedFlags);
            boolean discard = mergeFlags.contains(MergeFlags.ALWAYS_ACCEPT_MINE);
            TreeMap<String, Conflict> pathConflictDict = new TreeMap<String, Conflict>(ServerPath.TOP_DOWN_COMPARATOR);
            HashMap<Integer, Conflict> itemIdConflictDict = new HashMap<Integer, Conflict>();
            for (Conflict conflict2 : conflicts.get()) {
                if (!conflict2.isResolved()) continue;
                if (conflict2.getBaseChangeType().contains(ChangeType.BRANCH) && conflict2.getYourItemID() == 0) {
                    pathConflictDict.put(conflict2.getYourServerItem(), conflict2);
                    continue;
                }
                itemIdConflictDict.put(conflict2.getYourItemID(), conflict2);
            }
            for (WebServiceObjectWrapper webServiceObjectWrapper : getOps) {
                if (((GetOperation)webServiceObjectWrapper).getChangeType().contains(ChangeType.BRANCH) && ((GetOperation)webServiceObjectWrapper).getItemID() == 0) {
                    conflict = (Conflict)pathConflictDict.get(((GetOperation)webServiceObjectWrapper).getTargetServerItem());
                    if (conflict == null) continue;
                    ((GetOperation)webServiceObjectWrapper).setMergeDetails(conflict);
                    continue;
                }
                conflict = (Conflict)itemIdConflictDict.get(((GetOperation)webServiceObjectWrapper).getItemID());
                if (conflict == null) continue;
                ((GetOperation)webServiceObjectWrapper).setMergeDetails(conflict);
            }
            GetStatus getStatus = null;
            if (this.isLocal()) {
                void var21_35;
                if (!(discard || mergeFlags.contains(MergeFlags.NO_AUTO_RESOLVE) || mergeFlags.contains(MergeFlags.NO_MERGE))) {
                    if (this.getClient().getWebServiceLayer().getServiceLevel().getValue() < WebServiceLevel.TFS_2012_1.getValue()) {
                        conflicts.set(this.queryConflicts(new String[]{targetSpec.getItem()}, sourceSpec.getRecursionType() != RecursionType.NONE));
                    }
                    Conflict[] conflictArray = this.getClient().autoResolveValidConflicts(this, conflicts.get(), AutoResolveOptions.ALL_SILENT);
                    resolvedConflicts = conflicts.get().length - conflictArray.length;
                    conflicts.set(conflictArray);
                }
                Conflict[] getStatus2 = conflicts.get();
                int len$ = getStatus2.length;
                boolean bl = false;
                while (var21_35 < len$) {
                    conflict = getStatus2[var21_35];
                    if (conflict.getResolution() == Resolution.NONE) {
                        log.trace((Object)("Firing event on conflict: " + conflict));
                        this.client.getEventEngine().fireMerging(new MergingEvent(EventSource.newFromHere(), new Conflict(conflict), this, false, null, OperationStatus.CONFLICT, ChangeType.NONE, true, new PropertyValue[0]));
                        ++nonResolvedConflicts;
                    }
                    ++var21_35;
                }
                if (discard) {
                    void var21_37;
                    Conflict[] conflictArray = conflicts.get();
                    len$ = conflictArray.length;
                    boolean bl2 = false;
                    while (var21_37 < len$) {
                        conflict = conflictArray[var21_37];
                        this.client.getEventEngine().fireConflictResolved(new ConflictResolvedEvent(EventSource.newFromHere(), this, conflict, changePendedFlags.get()));
                        ++var21_37;
                    }
                    getStatus = new GetStatus();
                    getStatus.setNumOperations(conflicts.get().length);
                    GetStatus getStatus3 = getStatus;
                    return getStatus3;
                }
                GetOptions getOptions = mergeFlags.contains(MergeFlags.NO_MERGE) ? GetOptions.PREVIEW : GetOptions.NONE;
                GetEngine getEngine = new GetEngine(this.client);
                getStatus = getEngine.processGetOperations(this, ProcessType.MERGE, getOps, getOptions, changePendedFlags.get());
                getStatus.setNumConflicts(getStatus.getNumConflicts() + nonResolvedConflicts);
                getStatus.setNumResolvedConflicts(resolvedConflicts);
            } else if (getOps.length > 0) {
                this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)new VersionControlException(MessageFormat.format(Messages.getString("Workspace.NoLocalChangesRemoteWorkspaceFormat"), this.getDisplayName()))));
            }
            if (getStatus == null) {
                getStatus = new GetStatus();
                getStatus.setNumOperations(getOps.length);
            }
            if (changePendedFlags.get().contains(ChangePendedFlags.WORKING_FOLDER_MAPPINGS_UPDATED)) {
                this.invalidateMappings();
            }
            this.client.reportFailures(this, failures.get());
            Failure[] failureArray = failures.get();
            int len$ = failureArray.length;
            boolean bl = false;
            while (var21_39 < len$) {
                Failure failure = failureArray[var21_39];
                getStatus.addFailure(failure);
                ++var21_39;
            }
            GetStatus getStatus4 = getStatus;
            return getStatus4;
        }
        finally {
            this.client.getEventEngine().fireOperationCompleted(new MergeOperationCompletedEvent(EventSource.newFromHere(), this));
            Workstation.getCurrent(this.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this, Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReconcilePendingChangesStatus findReconcilablePendingChangesForChangeset(Changeset changeset, PendingChange[] pendingChanges) throws CanceledException {
        Check.notNull(changeset, "changeset");
        Check.notNull(pendingChanges, "pendingChanges");
        if (pendingChanges.length == 0) {
            return new ReconcilePendingChangesStatus(false);
        }
        TaskMonitor monitor = TaskMonitorService.getTaskMonitor();
        monitor.begin(MessageFormat.format(Messages.getString("Workspace.FindingReconcilableChangesForChangesetFormat"), Integer.toString(changeset.getChangesetID())), pendingChanges.length + 10);
        try {
            boolean schemaChangeRenameSupported = this.client.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue();
            TreeMap<String, Change> historicServerItemToChangeMap = new TreeMap<String, Change>(ServerPath.TOP_DOWN_COMPARATOR);
            for (Change reconcilePendingChangesStatus : changeset.getChanges()) {
                historicServerItemToChangeMap.put(reconcilePendingChangesStatus.getItem().getServerItem(), reconcilePendingChangesStatus);
            }
            boolean atLeastOneMatched = false;
            ArrayList<PendingChange> reconcilablePendingChanges = new ArrayList<PendingChange>();
            ArrayList<PendingChange> deferredChanges = new ArrayList<PendingChange>();
            for (PendingChange pendingChange : pendingChanges) {
                if (monitor.isCanceled()) {
                    throw new CanceledException();
                }
                monitor.worked(1);
                boolean safeChange = false;
                boolean deferForRenameSourceCheck = false;
                Change historicChange = (Change)historicServerItemToChangeMap.get(pendingChange.getServerItem());
                if (historicChange == null) continue;
                atLeastOneMatched = true;
                if (pendingChange.getChangeType().contains(ChangeType.RENAME) && !historicChange.getChangeType().contains(ChangeType.RENAME)) continue;
                if (historicChange.getChangeType().contains(ChangeType.RENAME)) {
                    if (!schemaChangeRenameSupported) {
                        if (pendingChange.getItemID() != historicChange.getItem().getItemID()) {
                            continue;
                        }
                    } else {
                        deferForRenameSourceCheck = true;
                    }
                }
                if (!(pendingChange.getChangeType().contains(ChangeType.EDIT) || pendingChange.getChangeType().contains(ChangeType.ENCODING) || pendingChange.getChangeType().contains(ChangeType.BRANCH))) {
                    safeChange = pendingChange.getChangeType().remove(ChangeType.LOCK).equals(historicChange.getChangeType().remove(ChangeType.LOCK));
                } else if (pendingChange.getEncoding() == historicChange.getItem().getEncoding().getCodePage()) {
                    if (pendingChange.getChangeType().remove(ChangeType.EDIT).remove(ChangeType.LOCK).remove(ChangeType.RENAME).equals(historicChange.getChangeType().remove(ChangeType.EDIT).remove(ChangeType.LOCK).remove(ChangeType.RENAME))) {
                        if (pendingChange.getChangeType().contains(ChangeType.EDIT) || pendingChange.getChangeType().contains(ChangeType.BRANCH) && pendingChange.getItemType() == ItemType.FILE) {
                            safeChange = false;
                            if (pendingChange.getLocalItem() != null && pendingChange.getLocalItem().length() > 0 && new File(pendingChange.getLocalItem()).exists()) {
                                byte[] localItemHash;
                                try {
                                    localItemHash = CheckinEngine.computeMD5Hash(pendingChange.getLocalItem(), monitor);
                                }
                                catch (CoreCancelException e) {
                                    throw new CanceledException();
                                }
                                safeChange = Arrays.equals(localItemHash, historicChange.getItem().getContentHashValue());
                            }
                        } else {
                            safeChange = !historicChange.getChangeType().contains(ChangeType.EDIT);
                        }
                    }
                } else {
                    safeChange = false;
                }
                if (!safeChange) continue;
                if (deferForRenameSourceCheck) {
                    deferredChanges.add(pendingChange);
                    continue;
                }
                reconcilablePendingChanges.add(pendingChange);
            }
            if (!atLeastOneMatched) {
                ReconcilePendingChangesStatus reconcilePendingChangesStatus = new ReconcilePendingChangesStatus(false);
                return reconcilePendingChangesStatus;
            }
            if (deferredChanges.size() > 0) {
                ChangesetVersionSpec changesetVersionSpec = new ChangesetVersionSpec(changeset.getChangesetID());
                ChangesetVersionSpec previousChangeSetVersionSpec = new ChangesetVersionSpec(changeset.getChangesetID() - 1);
                for (PendingChange deferredChange : deferredChanges) {
                    Changeset sourceOfRenameChangeset;
                    if (deferredChange.getSourceServerItem() == null || deferredChange.getSourceServerItem().length() == 0 || deferredChange.getServerItem() == null || deferredChange.getServerItem().length() == 0 || !deferredChange.getChangeType().contains(ChangeType.RENAME) && deferredChange.getSourceServerItem().equals(deferredChange.getServerItem())) continue;
                    Changeset[] historicChangesets = this.queryHistory(deferredChange.getServerItem(), changesetVersionSpec, 0, RecursionType.NONE, null, null, previousChangeSetVersionSpec, 1, true, false, false, false);
                    if (monitor.isCanceled()) {
                        throw new CanceledException();
                    }
                    if (historicChangesets == null || historicChangesets.length <= 0 || (sourceOfRenameChangeset = historicChangesets[0]) == null || sourceOfRenameChangeset.getChanges().length <= 0 || sourceOfRenameChangeset.getChanges()[0] == null) continue;
                    String sourceServerItem = sourceOfRenameChangeset.getChanges()[0].getItem().getServerItem();
                    if (!ServerPath.equals(deferredChange.getSourceServerItem(), sourceServerItem)) continue;
                    reconcilablePendingChanges.add(deferredChange);
                }
            }
            monitor.worked(10);
            ReconcilePendingChangesStatus reconcilePendingChangesStatus = new ReconcilePendingChangesStatus(true, reconcilablePendingChanges.toArray(new PendingChange[reconcilablePendingChanges.size()]));
            return reconcilePendingChangesStatus;
        }
        finally {
            monitor.done();
        }
    }

    public String getDisplayName() {
        return new WorkspaceSpec(this.getName(), this.getOwnerDisplayName()).toString();
    }

    public String getUniqueName() {
        return new WorkspaceSpec(this.getName(), this.getOwnerName()).toString();
    }

    public WorkspacePermissions getPermissions() {
        return WorkspacePermissions.fromIntFlags(this.getWebServiceObject().getPermissions());
    }

    public WorkspacePermissionProfile getPermissionsProfile() {
        this.throwIfDeleted();
        this.refreshIfNeeded();
        if (this.permissionsProfile == null) {
            this.refreshPermissionsProfile();
        }
        return this.permissionsProfile;
    }

    public void setPermissionsProfile(WorkspacePermissionProfile newPermissionProfile) {
        this.throwIfDeleted();
        this.permissionsProfile = newPermissionProfile;
    }

    @Override
    public String toString() {
        String spec = new WorkspaceSpec(this.getName(), this.getOwnerDisplayName()).toString();
        String comment = this.getComment() != null ? this.getComment() : "";
        return MessageFormat.format("{0} [{1}] ({2})", spec, this.getComputer(), comment);
    }

    @Override
    public int compareTo(Workspace other) {
        int ret = this.getServerURI().compareTo(other.getServerURI());
        if (ret != 0) {
            return ret;
        }
        ret = this.getName().compareToIgnoreCase(other.getName());
        if (ret != 0) {
            return ret;
        }
        return this.getOwnerName().compareToIgnoreCase(other.getOwnerName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workspace)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Workspace other = (Workspace)obj;
        return (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName())) && (this.getOwnerName() == null ? other.getOwnerName() == null : this.getOwnerName().equals(other.getOwnerName())) && (this.getComputer() == null ? other.getComputer() == null : this.getComputer().equals(other.getComputer())) && (this.getServerURI() == null ? other.getServerURI() == null : this.getServerURI().equals(other.getServerURI()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.getName() == null ? 0 : this.getName().hashCode());
        result = result * 37 + (this.getOwnerName() == null ? 0 : this.getOwnerName().hashCode());
        result = result * 37 + (this.getComputer() == null ? 0 : this.getComputer().hashCode());
        result = result * 37 + (this.getServerURI() == null ? 0 : this.getServerURI().hashCode());
        return result;
    }

    public static WorkingFolder[] checkForInternalMappingConflicts(String workspaceName, WorkingFolder[] folders, boolean removeUnparentedCloaks) {
        if (null == folders) {
            return null;
        }
        ArrayList<WorkingFolder> mappings = new ArrayList<WorkingFolder>(Arrays.asList(folders));
        for (int i = 0; i < mappings.size(); ++i) {
            WorkingFolder wf = (WorkingFolder)mappings.get(i);
            Check.notNull(wf, "wf");
            Mapping parent = null;
            for (int j = 0; j < mappings.size(); ++j) {
                WorkingFolder wf2 = (WorkingFolder)mappings.get(j);
                if (wf == wf2) continue;
                if (!wf.isCloaked() && !wf2.isCloaked() && LocalPath.equals(wf.getLocalItem(), wf2.getLocalItem())) {
                    throw new MappingConflictException(MessageFormat.format(Messages.getString("Workspace.MultipleWorkingFoldersForPathFormat"), workspaceName, wf.getLocalItem()));
                }
                if (ServerPath.equals(wf.getServerItem(), wf2.getServerItem())) {
                    throw new MappingConflictException(MessageFormat.format(Messages.getString("Workspace.MultipleWorkingFoldersForPathFormat"), workspaceName, wf.getServerItem()));
                }
                if (!wf.isCloaked() || !ServerPath.isChild(wf2.getServerItem(), wf.getServerItem()) || parent != null && wf2.getServerItem().length() <= parent.getServerItem().length()) continue;
                parent = wf2;
            }
            if (!removeUnparentedCloaks || !wf.isCloaked() || parent != null && !parent.isCloaked()) continue;
            mappings.remove(i);
            --i;
        }
        return mappings.toArray(new WorkingFolder[mappings.size()]);
    }

    public boolean hasAdministerPermission() {
        return this.hasWorkspacePermission(WorkspacePermissions.ADMINISTER);
    }

    public boolean hasWorkspacePermission(WorkspacePermissions permissionToCheck) {
        if (IdentityHelper.identityHasName(this.client.getConnection().getAuthorizedIdentity(), this.getOwnerName())) {
            return true;
        }
        if (this.client.getServiceLevel().getValue() < WebServiceLevel.TFS_2010.getValue()) {
            if ((permissionToCheck = permissionToCheck.remove(WorkspacePermissions.READ)).contains(WorkspacePermissions.ADMINISTER)) {
                String[] effectiveGlobalPermissions;
                for (String permission : effectiveGlobalPermissions = this.client.getWebServiceLayer().queryEffectiveGlobalPermissions(this.client.getConnection().getAuthorizedIdentity().getUniqueName())) {
                    if (!permission.equalsIgnoreCase("AdminWorkspaces")) continue;
                    permissionToCheck = permissionToCheck.remove(WorkspacePermissions.ADMINISTER);
                    break;
                }
            }
            return permissionToCheck.isEmpty();
        }
        return this.getPermissions().contains(permissionToCheck);
    }

    private String getTFIgnoreHeader() throws IOException {
        return NewlineUtils.normalizeToPlatform(IOUtils.toString(this.getClass().getClassLoader().getResourceAsStream(TFIGNORE_HEADER_RESOURCE), "UTF-8"));
    }

    private void throwIfDeleted() {
        if (this.isDeleted()) {
            throw new WorkspaceDeletedException(this);
        }
    }

    private void refreshPermissionsProfile() {
        this.throwIfDeleted();
        if (this.getSecurityToken() != null && this.client.getWorkspaceSecurity() != null) {
            AccessControlListDetails allPermissions = this.client.getWorkspaceSecurity().queryAccessControlList(this.getSecurityToken(), null, false);
            ArrayList<AccessControlEntryDetails> aceList = new ArrayList<AccessControlEntryDetails>();
            if (allPermissions != null) {
                Collections.addAll(aceList, allPermissions.getAccessControlEntries());
            }
            if (aceList.isEmpty()) {
                this.permissionsProfile = WorkspacePermissionProfile.getPrivateProfile();
                return;
            }
            this.removeWorkspaceOwnerAce(aceList);
            for (WorkspacePermissionProfile profile : WorkspacePermissionProfile.getBuiltInProfiles()) {
                if (!this.aceListsMatch(Arrays.asList(profile.getAccessControlEntries()), aceList)) continue;
                this.permissionsProfile = profile;
                return;
            }
            this.permissionsProfile = new WorkspacePermissionProfile("Custom", aceList.toArray(new AccessControlEntry[0]));
        } else {
            this.permissionsProfile = WorkspacePermissionProfile.getPrivateProfile();
        }
    }

    private void removeWorkspaceOwnerAce(List<AccessControlEntryDetails> workspaceAceList) {
        IdentityDescriptor ownerDescriptor = this.getOwnerDescriptor();
        if (ownerDescriptor != null) {
            for (AccessControlEntryDetails ace : workspaceAceList) {
                if (IdentityDescriptorComparer.INSTANCE.compare(ace.getSerializableDescriptor(), ownerDescriptor) != 0) continue;
                workspaceAceList.remove(ace);
                return;
            }
        }
    }

    private boolean aceListsMatch(List<AccessControlEntry> profileAceList, List<AccessControlEntryDetails> workspaceAceList) {
        if (profileAceList.size() != workspaceAceList.size()) {
            return false;
        }
        for (AccessControlEntry profileAce : profileAceList) {
            boolean aceFound = false;
            for (AccessControlEntryDetails workspaceAce : workspaceAceList) {
                if (!this.acesMatch((AccessControlEntryDetails)profileAce, workspaceAce)) continue;
                aceFound = true;
                break;
            }
            if (aceFound) continue;
            return false;
        }
        return true;
    }

    private boolean acesMatch(AccessControlEntryDetails profileAce, AccessControlEntryDetails workspaceAce) {
        if (IdentityDescriptorComparer.INSTANCE.compare(profileAce.getSerializableDescriptor(), workspaceAce.getSerializableDescriptor()) != 0) {
            return false;
        }
        if (profileAce.getAllow() != workspaceAce.getAllow()) {
            return false;
        }
        return profileAce.getDeny() == workspaceAce.getDeny();
    }

    public static String computeNewWorkspaceName(String baseName, Workspace[] existingWorkspaces) {
        if (existingWorkspaces == null || existingWorkspaces.length == 0) {
            return baseName;
        }
        String candidateName = baseName;
        boolean keepGoing = true;
        int ix = 0;
        while (keepGoing) {
            boolean matched = false;
            for (int i = 0; !matched && i < existingWorkspaces.length && !(matched = existingWorkspaces[i].getName().equalsIgnoreCase(candidateName)); ++i) {
            }
            if (!matched) {
                keepGoing = false;
                continue;
            }
            String messageFormat = Messages.getString("Workspace.DefaultNewWorkspaceNameFormat");
            candidateName = MessageFormat.format(messageFormat, baseName, Integer.toString(++ix));
        }
        return candidateName;
    }
}

