/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.webservices.GroupProperty;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.clients.webservices.IdentityManagementException;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.IdentitySearchFactor;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.SIDIdentityHelper;
import com.microsoft.tfs.core.clients.webservices.SecurityIdentifier;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.clients.webservices.internal.TeamFoundationSupportedFeatures;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import ms.ws._IdentityDescriptor;
import ms.ws._IdentityManagementWebServiceSoap;
import ms.ws._TeamFoundationIdentity;

public class IdentityManagementService
implements IIdentityManagementService {
    private final _IdentityManagementWebServiceSoap proxy;
    private final SecurityIdentifier domainSid;
    private final String domainSidWithWellKnownPrefix;
    private final String domainScope;
    private final boolean serverIsV3;

    public static String getIdentityDomainScope(GUID hostID) {
        ArtifactID id = new ArtifactID("Framework", "IdentityDomain", hostID.toString());
        return id.encodeURI();
    }

    public IdentityManagementService(TFSConnection connection) {
        RegistrationClient registrationClient;
        RegistrationEntry frameworkEntry;
        this.serverIsV3 = connection instanceof TFSConfigurationServer ? true : (frameworkEntry = (registrationClient = connection.getRegistrationClient()).getRegistrationEntry("Framework")) != null;
        if (!this.serverIsV3) {
            throw new IdentityManagementException(MessageFormat.format(Messages.getString("IdentityManagementService.IdentityManagementServiceUnavailableFormat"), connection.getBaseURI()));
        }
        this.proxy = (_IdentityManagementWebServiceSoap)connection.getWebService(_IdentityManagementWebServiceSoap.class);
        this.domainSid = SIDIdentityHelper.getDomainSID(connection.getInstanceID());
        this.domainSidWithWellKnownPrefix = this.domainSid.getValue() + "-0-";
        this.domainScope = IdentityManagementService.getIdentityDomainScope(connection.getInstanceID());
    }

    @Override
    public TeamFoundationIdentity[] readIdentities(IdentityDescriptor[] descriptors, MembershipQuery queryMembership, ReadIdentityOptions readOptions) {
        Check.notNull(descriptors, "descriptors");
        for (IdentityDescriptor descriptor : descriptors) {
            IdentityHelper.checkDescriptor(descriptor, "descriptors element");
        }
        TeamFoundationIdentity[] identities = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, this.proxy.readIdentitiesByDescriptor((_IdentityDescriptor[])WrapperUtils.unwrap(_TeamFoundationIdentity.class, descriptors), queryMembership.getValue(), readOptions.toIntFlags(), TeamFoundationSupportedFeatures.ALL.getValue(), null, IdentityPropertyScope.NONE.getValue()));
        return identities;
    }

    @Override
    public TeamFoundationIdentity readIdentity(IdentityDescriptor descriptor, MembershipQuery queryMembership, ReadIdentityOptions readOptions) {
        return this.readIdentities(new IdentityDescriptor[]{descriptor}, queryMembership, readOptions)[0];
    }

    @Override
    public TeamFoundationIdentity[] readIdentities(GUID[] teamFoundationIds, MembershipQuery queryMembership) {
        Check.notNull(teamFoundationIds, "teamFoundationIds");
        for (int i = 0; i < teamFoundationIds.length; ++i) {
            Check.notNull(teamFoundationIds[i], "teamFoundationIds[i]");
        }
        String[] ids = new String[teamFoundationIds.length];
        for (int i = 0; i < teamFoundationIds.length; ++i) {
            ids[i] = teamFoundationIds[i].getGUIDString();
        }
        TeamFoundationIdentity[] identities = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, this.proxy.readIdentitiesById(ids, queryMembership.getValue(), TeamFoundationSupportedFeatures.ALL.getValue(), ReadIdentityOptions.NONE.toIntFlags(), null, IdentityPropertyScope.NONE.getValue()));
        return identities;
    }

    @Override
    public TeamFoundationIdentity[][] readIdentities(IdentitySearchFactor searchFactor, String[] factorValues, MembershipQuery queryMembership, ReadIdentityOptions readOptions) {
        Check.notNull(factorValues, "searchFactorValues");
        for (String factorValue : factorValues) {
            Check.notNullOrEmpty(factorValue, "factorValue");
        }
        _TeamFoundationIdentity[][] wso = this.proxy.readIdentities(searchFactor.getValue(), factorValues, queryMembership.getValue(), readOptions.toIntFlags(), TeamFoundationSupportedFeatures.ALL.getValue(), null, IdentityPropertyScope.NONE.getValue());
        TeamFoundationIdentity[][] results = new TeamFoundationIdentity[wso.length][];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, wso[i]);
        }
        return results;
    }

    @Override
    public TeamFoundationIdentity readIdentity(IdentitySearchFactor searchFactor, String factorValue, MembershipQuery queryMembership, ReadIdentityOptions readOptions) {
        TeamFoundationIdentity[] results = this.readIdentities(searchFactor, new String[]{factorValue}, queryMembership, readOptions)[0];
        int resultCount = results.length;
        if (resultCount > 1) {
            int activeMatches = 0;
            TeamFoundationIdentity match = null;
            for (TeamFoundationIdentity result : results) {
                if (!result.isActive()) continue;
                match = result;
                ++activeMatches;
            }
            if (activeMatches != 1) {
                throw new IdentityManagementException(MessageFormat.format(Messages.getString("IdentityManagementService.MultipleIdentitiesFoundFormat"), factorValue));
            }
            return match;
        }
        if (resultCount == 1) {
            return results[0];
        }
        return null;
    }

    @Override
    public IdentityDescriptor createApplicationGroup(String projectUri, String groupName, String groupDescription) {
        return new IdentityDescriptor(this.proxy.createApplicationGroup(projectUri, groupName, groupDescription));
    }

    @Override
    public TeamFoundationIdentity[] listApplicationGroups(String projectUri, ReadIdentityOptions readOptions) {
        TeamFoundationIdentity[] groups = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, this.proxy.listApplicationGroups(projectUri, readOptions.toIntFlags(), TeamFoundationSupportedFeatures.ALL.getValue(), null, IdentityPropertyScope.NONE.getValue()));
        return groups;
    }

    @Override
    public String getScopeName(String scopeId) {
        Check.notNullOrEmpty(scopeId, "scopeId");
        return this.proxy.getScopeName(scopeId);
    }

    @Override
    public void updateApplicationGroup(IdentityDescriptor groupDescriptor, GroupProperty property, String newValue) {
        IdentityHelper.checkDescriptor(groupDescriptor, "groupDescriptor");
        this.proxy.updateApplicationGroup(groupDescriptor.getWebServiceObject(), property.getValue(), newValue);
    }

    @Override
    public void deleteApplicationGroup(IdentityDescriptor groupDescriptor) {
        IdentityHelper.checkDescriptor(groupDescriptor, "groupDescriptor");
        this.proxy.deleteApplicationGroup(groupDescriptor.getWebServiceObject());
    }

    @Override
    public void addMemberToApplicationGroup(IdentityDescriptor groupDescriptor, IdentityDescriptor descriptor) {
        IdentityHelper.checkDescriptor(groupDescriptor, "groupDescriptor");
        IdentityHelper.checkDescriptor(descriptor, "descriptor");
        this.proxy.addMemberToApplicationGroup(groupDescriptor.getWebServiceObject(), descriptor.getWebServiceObject());
    }

    @Override
    public void removeMemberFromApplicationGroup(IdentityDescriptor groupDescriptor, IdentityDescriptor descriptor) {
        IdentityHelper.checkDescriptor(groupDescriptor, "groupDescriptor");
        IdentityHelper.checkDescriptor(descriptor, "descriptor");
        this.proxy.removeMemberFromApplicationGroup(groupDescriptor.getWebServiceObject(), descriptor.getWebServiceObject());
    }

    @Override
    public boolean isMember(IdentityDescriptor groupDescriptor, IdentityDescriptor descriptor) {
        IdentityHelper.checkDescriptor(groupDescriptor, "groupDescriptor");
        IdentityHelper.checkDescriptor(descriptor, "descriptor");
        return this.proxy.isMember(groupDescriptor.getWebServiceObject(), descriptor.getWebServiceObject());
    }

    @Override
    public boolean refreshIdentity(IdentityDescriptor descriptor) {
        IdentityHelper.checkDescriptor(descriptor, "descriptor");
        return this.proxy.refreshIdentity(descriptor.getWebServiceObject());
    }

    @Override
    public boolean isOwner(IdentityDescriptor descriptor) {
        IdentityHelper.checkDescriptor(descriptor, "descriptor");
        return "Microsoft.TeamFoundation.Identity".equalsIgnoreCase(descriptor.getIdentityType()) && (descriptor.getIdentifier().toLowerCase().startsWith(this.domainSid.getValue()) || descriptor.getIdentifier().toLowerCase().startsWith(SIDIdentityHelper.WELL_KNOWN_SID_PREFIX));
    }

    @Override
    public boolean isOwnedWellKnownGroup(IdentityDescriptor descriptor) {
        IdentityHelper.checkDescriptor(descriptor, "descriptor");
        return "Microsoft.TeamFoundation.Identity".equalsIgnoreCase(descriptor.getIdentityType()) && (descriptor.getIdentifier().toLowerCase().startsWith(this.domainSidWithWellKnownPrefix) || descriptor.getIdentifier().toLowerCase().startsWith(SIDIdentityHelper.WELL_KNOWN_SID_PREFIX));
    }

    @Override
    public String getIdentityDomainScope() {
        return this.domainScope;
    }
}

