/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.links;

import com.microsoft.tfs.core.clients.workitem.internal.links.ComponentExtIDHandler;
import com.microsoft.tfs.core.clients.workitem.internal.links.WITComponentCollection;
import com.microsoft.tfs.core.clients.workitem.internal.update.ElementHandler;
import java.text.MessageFormat;
import org.w3c.dom.Element;

public abstract class WITComponent {
    private boolean newlyCreated;
    private boolean pendingDeletion;
    private boolean pendingModification;
    private int extId = -1;
    private WITComponentCollection associatedCollection;

    protected WITComponent(boolean newlyCreated) {
        this.newlyCreated = newlyCreated;
    }

    public final boolean isNewlyCreated() {
        return this.newlyCreated;
    }

    public final void setExtID(int extId) {
        this.extId = extId;
    }

    public final int getExtID() {
        return this.extId;
    }

    public final boolean shouldIncludeInOldCount() {
        return !this.newlyCreated;
    }

    public final boolean shouldIncludeInNewCount() {
        return !this.pendingDeletion;
    }

    public final void associate(WITComponentCollection collection) {
        if (this.associatedCollection != null) {
            if (this.associatedCollection == collection) {
                return;
            }
            throw new IllegalStateException("this component is already associated with another collection");
        }
        this.associatedCollection = collection;
        this.associatedCollection.getComponentSet().add(this);
    }

    public final void delete() {
        if (this.associatedCollection == null) {
            return;
        }
        if (this.newlyCreated) {
            this.disassociate();
        } else {
            this.pendingDeletion = true;
        }
    }

    public final void update() {
        this.onUpdate();
        if (this.newlyCreated) {
            this.newlyCreated = false;
        } else if (this.pendingDeletion) {
            this.disassociate();
            this.pendingDeletion = false;
        } else if (this.pendingModification) {
            this.pendingModification = false;
        }
    }

    public void reset() {
        if (this.newlyCreated) {
            this.disassociate();
        }
        if (this.pendingDeletion) {
            this.pendingDeletion = false;
        }
        if (this.pendingModification) {
            this.pendingModification = false;
        }
    }

    public final boolean isDirty() {
        return this.newlyCreated && this.associatedCollection != null || this.pendingModification || this.pendingDeletion;
    }

    public final boolean isPendingDelete() {
        return this.pendingDeletion;
    }

    public final ElementHandler createXMLForUpdatePackage(Element parentElement) {
        if (this.newlyCreated) {
            this.createXMLForAdd(parentElement);
            if (this.getInsertTagName() != null) {
                return new ComponentExtIDHandler(this, this.getInsertTagName());
            }
        } else if (this.pendingDeletion) {
            this.createXMLForRemove(parentElement);
        }
        return null;
    }

    public final boolean shouldIncludeAsPartOfPublicCollection() {
        return this.associatedCollection != null && !this.pendingDeletion;
    }

    protected abstract boolean isEquivalentTo(WITComponent var1);

    protected abstract void createXMLForAdd(Element var1);

    protected abstract String getInsertTagName();

    protected abstract void createXMLForRemove(Element var1);

    protected void onUpdate() {
    }

    protected final void validateTextMaxLength(String input, String argumentName, int maxLength) {
        if (input != null && input.length() > maxLength) {
            throw new IllegalArgumentException(MessageFormat.format("invalid length ({0}) of argument \"{1}\" - max length is {2}", input.length(), argumentName, maxLength));
        }
    }

    protected final WITComponentCollection getAssociatedCollection() {
        return this.associatedCollection;
    }

    protected final boolean isPendingModification() {
        return this.pendingModification;
    }

    protected final void setPendingModification(boolean pendingModification) {
        this.pendingModification = pendingModification;
    }

    private void disassociate() {
        this.associatedCollection.getComponentSet().remove(this);
        this.associatedCollection = null;
    }
}

