/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.internal.AccessDeniedWorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.PageCallback;
import com.microsoft.tfs.core.clients.workitem.internal.query.PagedCollection;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.PageResultsLargeTextRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.PageResultsRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParser;
import com.microsoft.tfs.core.clients.workitem.query.DisplayFieldList;
import com.microsoft.tfs.core.clients.workitem.query.Query;
import com.microsoft.tfs.core.clients.workitem.query.SortFieldList;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.core.ws.runtime.types.AnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.StaxAnyContentType;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap_PageWorkitemsByIdRevsResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap_PageWorkitemsByIdsResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap_PageWorkitemsByIdRevsResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap_PageWorkitemsByIdsResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap_PageWorkitemsByIdRevsResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap_PageWorkitemsByIdsResponse;
import ms.tfs.workitemtracking.clientservices._03._IdRevisionPair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WorkItemCollectionImpl
implements WorkItemCollection,
PageCallback {
    private static final Log log = LogFactory.getLog(WorkItemCollectionImpl.class);
    private final int[] ids;
    private final int[] revs;
    private Calendar asOfDate;
    private final Query query;
    private final WITContext witContext;
    private final PagedCollection pagedCollection;
    private String[] shortTextColumnNames;
    private int[] longTextColumnIds;
    private FieldDefinitionImpl[] longTextColumns;

    public WorkItemCollectionImpl(int[] ids, Calendar asOfDate, Query query, WITContext witContext) {
        Check.notNull(ids, "ids");
        this.ids = ids;
        this.asOfDate = asOfDate;
        this.query = query;
        this.witContext = witContext;
        this.revs = null;
        this.pagedCollection = new PagedCollection(ids != null ? ids.length : 0, 50, this);
    }

    public WorkItemCollectionImpl(int[] ids, int[] revs, Query query, WITContext witContext) {
        this.ids = ids;
        this.revs = revs;
        this.witContext = witContext;
        this.query = query;
        this.pagedCollection = new PagedCollection(ids.length, 50, this);
    }

    @Override
    public int size() {
        return this.pagedCollection.getSize();
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public DisplayFieldList getDisplayFieldList() {
        return this.query.getDisplayFieldList();
    }

    @Override
    public SortFieldList getSortFieldList() {
        return this.query.getSortFieldList();
    }

    @Override
    public WorkItem getWorkItem(int index) {
        return (WorkItem)this.pagedCollection.getItem(index);
    }

    @Override
    public int getPageSize() {
        return this.pagedCollection.getPageSize();
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize > 200) {
            throw new IllegalArgumentException(MessageFormat.format("cannot set page size greater than the maximum of {0}", 200));
        }
        if (pageSize < 50) {
            throw new IllegalArgumentException(MessageFormat.format("cannot set page size less than the minimum of {0}", 50));
        }
        this.pagedCollection.setPageSize(pageSize);
    }

    @Override
    public int[] getIDs() {
        return (int[])this.ids.clone();
    }

    @Override
    public Object[] pageInItems(int startingIx, int length) {
        if (this.shortTextColumnNames == null) {
            this.computeColumns();
        }
        if (!this.query.isBatchReadMode() || this.revs == null) {
            return this.pageWorkitemsByIDs(startingIx, length);
        }
        return this.pageWorkitemsByIDRevs(startingIx, length);
    }

    private void computeColumns() {
        int i;
        ArrayList<String> shortTextColumnNameList = new ArrayList<String>();
        ArrayList<FieldDefinitionImpl> longTextFieldDefinitionList = new ArrayList<FieldDefinitionImpl>();
        for (String pageWorkItemFieldName : PageResultsRowSetHandler.getPageWorkItemsFieldNames(this.witContext)) {
            shortTextColumnNameList.add(pageWorkItemFieldName);
        }
        DisplayFieldList displayFieldList = this.query.getDisplayFieldList();
        for (i = 0; i < displayFieldList.getSize(); ++i) {
            FieldDefinitionImpl displayField = (FieldDefinitionImpl)displayFieldList.getField(i);
            if (shortTextColumnNameList.contains((displayField = this.translateCalculatedField(displayField)).getReferenceName())) continue;
            if (displayField.isLargeText()) {
                longTextFieldDefinitionList.add(displayField);
                continue;
            }
            shortTextColumnNameList.add(displayField.getReferenceName());
        }
        this.shortTextColumnNames = shortTextColumnNameList.toArray(new String[0]);
        this.longTextColumns = longTextFieldDefinitionList.toArray(new FieldDefinitionImpl[0]);
        this.longTextColumnIds = new int[longTextFieldDefinitionList.size()];
        for (i = 0; i < longTextFieldDefinitionList.size(); ++i) {
            FieldDefinition longTextFieldDefinition = (FieldDefinition)longTextFieldDefinitionList.get(i);
            this.longTextColumnIds[i] = longTextFieldDefinition.getID();
        }
    }

    private FieldDefinitionImpl translateCalculatedField(FieldDefinitionImpl field) {
        switch (field.getID()) {
            case -1: {
                return this.witContext.getFieldDefinitions().getFieldDefinitionInternal(-6);
            }
            case -105: {
                return this.witContext.getFieldDefinitions().getFieldDefinitionInternal(-104);
            }
            case -42: 
            case -12: 
            case -7: {
                return this.witContext.getFieldDefinitions().getFieldDefinitionInternal(-2);
            }
        }
        return field;
    }

    private WorkItem[] handlePageResponse(Element[] pageResponse, int[] ids, int pageStart) {
        Element itemsTable = pageResponse[0];
        RowSetParser parser = new RowSetParser();
        PageResultsRowSetHandler handler = new PageResultsRowSetHandler(this.witContext);
        parser.parse(itemsTable, (RowSetParseHandler)handler);
        if (pageResponse.length > 1) {
            Element longTextTable = pageResponse[1];
            PageResultsLargeTextRowSetHandler textHandler = new PageResultsLargeTextRowSetHandler(handler);
            parser.parse(longTextTable, (RowSetParseHandler)textHandler);
        }
        WorkItem[] results = new WorkItem[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            WorkItemImpl workItem = handler.getByID(ids[i]);
            if (workItem == null) {
                workItem = new AccessDeniedWorkItemImpl(this.witContext, ids[i]);
            }
            workItem.getFieldsInternal().ensureFieldsExist(this.longTextColumns);
            results[i] = workItem;
        }
        return results;
    }

    private WorkItem[] pageWorkitemsByIDs(int pageStart, int pageLength) {
        AnyContentType items;
        AnyContentType metadata;
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("pageWorkitemsByIds({0},{1})", Integer.toString(pageStart), Integer.toString(pageLength)));
        }
        int[] idsToPage = new int[pageLength];
        System.arraycopy(this.ids, pageStart, idsToPage, 0, pageLength);
        if (this.witContext.isVersion2()) {
            _ClientService2Soap_PageWorkitemsByIdsResponse response = this.witContext.getProxy().pageWorkitemsByIds(idsToPage, this.shortTextColumnNames, this.longTextColumnIds, this.asOfDate, false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = response.getMetadata();
            items = response.getItems();
        } else if (this.witContext.isVersion3()) {
            _ClientService3Soap_PageWorkitemsByIdsResponse response = this.witContext.getProxy3().pageWorkitemsByIds(idsToPage, this.shortTextColumnNames, this.longTextColumnIds, this.asOfDate, false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = response.getMetadata();
            items = response.getItems();
        } else {
            _ClientService5Soap_PageWorkitemsByIdsResponse response = this.witContext.getProxy5().pageWorkitemsByIds(idsToPage, this.shortTextColumnNames, this.longTextColumnIds, this.asOfDate, false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = response.getMetadata();
            items = response.getItems();
        }
        this.witContext.getMetadataUpdateHandler().updateMetadata(metadata, null);
        metadata.dispose();
        return this.handlePageResponse(((DOMAnyContentType)items).getElements(), idsToPage, pageStart);
    }

    private WorkItem[] pageWorkitemsByIDRevs(int pageStart, int pageLength) {
        AnyContentType items;
        int[] pagedIds = new int[pageLength];
        _IdRevisionPair[] pairs = new _IdRevisionPair[pageLength];
        for (int i = 0; i < pageLength; ++i) {
            int index = pageStart + i;
            pairs[i] = new _IdRevisionPair(this.ids[index], this.revs[index]);
            pagedIds[i] = this.ids[index];
        }
        if (this.witContext.isVersion2()) {
            _ClientService2Soap_PageWorkitemsByIdRevsResponse response = this.witContext.getProxy().pageWorkitemsByIdRevs(pairs, this.shortTextColumnNames, this.longTextColumnIds, this.asOfDate, false, new DOMAnyContentType());
            items = response.getItems();
        } else if (this.witContext.isVersion3()) {
            _ClientService3Soap_PageWorkitemsByIdRevsResponse response = this.witContext.getProxy3().pageWorkitemsByIdRevs(pairs, this.shortTextColumnNames, this.longTextColumnIds, this.asOfDate, false, new DOMAnyContentType());
            items = response.getItems();
        } else {
            _ClientService5Soap_PageWorkitemsByIdRevsResponse response = this.witContext.getProxy5().pageWorkitemsByIdRevs(pairs, this.shortTextColumnNames, this.longTextColumnIds, this.asOfDate, false, new DOMAnyContentType());
            items = response.getItems();
        }
        return this.handlePageResponse(((DOMAnyContentType)items).getElements(), pagedIds, pageStart);
    }
}

