/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.revision;

import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.LookupFailedException;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterException;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIValueSource;
import com.microsoft.tfs.core.clients.workitem.revision.RevisionField;

public class RevisionFieldImpl
implements RevisionField {
    private Object originalValue;
    private Object newValue;
    private final FieldDefinitionImpl fieldDefinition;
    private final RevisionImpl revision;

    public static RevisionFieldImpl createCopy(RevisionFieldImpl source, RevisionImpl revision) {
        RevisionFieldImpl newField = new RevisionFieldImpl(source.originalValue, source.originalValue, source.fieldDefinition, revision);
        return newField;
    }

    public RevisionFieldImpl(Object originalValue, Object newValue, FieldDefinitionImpl fieldDefinition, RevisionImpl revision) {
        this.originalValue = originalValue;
        this.newValue = newValue;
        this.fieldDefinition = fieldDefinition;
        this.revision = revision;
    }

    @Override
    public Object getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public Object getValue() {
        return this.newValue;
    }

    @Override
    public String getName() {
        return this.fieldDefinition.getName();
    }

    @Override
    public String getReferenceName() {
        return this.fieldDefinition.getReferenceName();
    }

    @Override
    public int getID() {
        return this.fieldDefinition.getID();
    }

    @Override
    public boolean shouldIgnoreForDeltaTable() {
        int id = this.fieldDefinition.getID();
        if (id == -5 || id == -4 || id == -1 || id == 9 || id == 54 || id == -6 || id == 3 || id == 8 || id == 7) {
            return true;
        }
        return (id == -32 || id == -57 || id == 75 || id == -31) && this.originalValue == null && this.newValue != null && (Integer)this.newValue == 0;
    }

    public void setOldValueFromString(String input) {
        int id;
        String oldValueAsString = this.fieldDefinition.getTypeConverter().toString(this.originalValue);
        if (oldValueAsString != null && oldValueAsString.equals(input)) {
            if (this.fieldDefinition.getID() != -3) {
                this.originalValue = null;
            }
        } else {
            try {
                this.originalValue = this.fieldDefinition.getTypeConverter().translate(input, WIValueSource.SERVER);
            }
            catch (WITypeConverterException e) {
                throw new RuntimeException(e);
            }
        }
        if ((id = this.fieldDefinition.getID()) == -6) {
            RevisionFieldImpl authorizedAsField = this.revision.getFieldInternal(-1);
            if (this.originalValue == null) {
                authorizedAsField.originalValue = null;
            } else {
                try {
                    authorizedAsField.originalValue = this.revision.getContext().getMetadata().getConstantsTable().getConstantByID((Integer)this.originalValue);
                }
                catch (LookupFailedException ex) {
                    authorizedAsField.originalValue = null;
                }
            }
        } else if (id == -104) {
            NodeImpl iterationNode = this.revision.getContext().getRootNode().findNodeDownwards((Integer)this.originalValue);
            RevisionFieldImpl iterationPathField = this.revision.getFieldInternal(-105);
            iterationPathField.originalValue = iterationNode != null ? iterationNode.getPath() : null;
        } else if (id == -2) {
            NodeImpl areaNode = this.revision.getContext().getRootNode().findNodeDownwards((Integer)this.originalValue);
            RevisionFieldImpl areaPathField = this.revision.getFieldInternal(-7);
            areaPathField.originalValue = areaNode != null ? areaNode.getPath() : null;
            RevisionFieldImpl nodeNameField = this.revision.getFieldInternal(-12);
            nodeNameField.originalValue = areaNode != null ? areaNode.getName() : null;
        }
    }

    public void setOriginalValue(Object value) {
        this.originalValue = value;
    }

    public void setNewValue(Object value) {
        this.newValue = value;
    }

    public FieldDefinitionImpl getFieldDefinition() {
        return this.fieldDefinition;
    }
}

