/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;

public class NodeBoolValue
extends NodeItem {
    private final boolean bool;

    public NodeBoolValue(boolean b) {
        super(NodeType.BOOL_VALUE, Boolean.toString(b));
        this.bool = b;
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOL;
    }

    public boolean getBoolValue() {
        return this.bool;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        Boolean flag = Tools.TranslateBoolToken(this.getValue());
        Tools.ensureSyntax(flag != null, SyntaxError.EXPECTING_BOOLEAN, this);
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public void appendTo(StringBuffer b) {
        String valueString = this.bool ? "True" : "False";
        b.append(valueString);
    }
}

