/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.client;

import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.commonstructure.CommonStructureClient;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogService;
import com.microsoft.tfs.core.clients.framework.catalog.ICatalogService;
import com.microsoft.tfs.core.clients.framework.location.ILocationService;
import com.microsoft.tfs.core.clients.framework.location.LocationService;
import com.microsoft.tfs.core.clients.groupsecurity.GroupSecurityClient;
import com.microsoft.tfs.core.clients.linking.LinkingClient;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.reporting.ReportingClient;
import com.microsoft.tfs.core.clients.serverstatus.ServerStatusClient;
import com.microsoft.tfs.core.clients.sharepoint.WSSClient;
import com.microsoft.tfs.core.clients.team.TeamService;
import com.microsoft.tfs.core.clients.teamsettings.TeamSettingsConfigurationService;
import com.microsoft.tfs.core.clients.teamstore.TeamProjectCollectionTeamStore;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.clients.webservices.IdentityManagementService;
import com.microsoft.tfs.core.clients.webservices.IdentityManagementService2;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitemconfiguration.WorkItemConfigurationSettingsClient;
import com.microsoft.tfs.core.config.client.ClientFactory;
import com.microsoft.tfs.core.config.client.UnknownClientException;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import ms.sql.reporting.reportingservices._ReportingService2005Soap;
import ms.tfs.services.classification._03._Classification4Soap;
import ms.tfs.services.classification._03._ClassificationSoap;
import ms.tfs.services.groupsecurity._03._GroupSecurityServiceSoap;
import ms.tfs.services.serverstatus._03._ServerStatusSoap;
import ms.tfs.services.teamconfiguration._01._TeamConfigurationServiceSoap;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap;
import ms.tfs.workitemtracking.configurationsettingsservice._03._ConfigurationSettingsServiceSoap;
import ms.wss._ListsSoap;

public class DefaultClientFactory
implements ClientFactory {
    private final Object initLock = new Object();
    private boolean initialized = false;
    private final Map<Class, ClientInstantiator> instantiatorMap = new HashMap<Class, ClientInstantiator>();

    @Override
    public Object newClient(Class clientType, TFSConnection connection) {
        Check.notNull(clientType, "clientType");
        Check.notNull(connection, "connection");
        ClientInstantiator instantiator = this.getClientInstantiator(clientType);
        if (instantiator == null) {
            throw new UnknownClientException(clientType);
        }
        return instantiator.newClient(connection);
    }

    @Override
    public WSSClient newWSSClient(TFSTeamProjectCollection connection, ProjectInfo projectInfo) {
        Check.notNull(projectInfo, "projectInfo");
        Check.notNull(connection, "connection");
        _ListsSoap webService = connection.getWSSWebService(projectInfo);
        Check.notNull(webService, "webService");
        return new WSSClient(connection, webService, projectInfo.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInstantiator getClientInstantiator(Class clientType) {
        Object object = this.initLock;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
            return this.instantiatorMap.get(clientType);
        }
    }

    private void initialize() {
        this.instantiatorMap.put(CommonStructureClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, CommonStructureClient.class);
                _ClassificationSoap webService = (_ClassificationSoap)connection.getWebService(_ClassificationSoap.class);
                _Classification4Soap webService4 = (_Classification4Soap)connection.getWebService(_Classification4Soap.class);
                return new CommonStructureClient((TFSTeamProjectCollection)connection, webService, webService4);
            }
        });
        this.instantiatorMap.put(GroupSecurityClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, GroupSecurityClient.class);
                _GroupSecurityServiceSoap webService = (_GroupSecurityServiceSoap)connection.getWebService(_GroupSecurityServiceSoap.class);
                return new GroupSecurityClient((TFSTeamProjectCollection)connection, webService);
            }
        });
        this.instantiatorMap.put(LinkingClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, LinkingClient.class);
                return new LinkingClient((TFSTeamProjectCollection)connection);
            }
        });
        this.instantiatorMap.put(RegistrationClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, RegistrationClient.class);
                return new RegistrationClient((TFSTeamProjectCollection)connection);
            }
        });
        this.instantiatorMap.put(ReportingClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, ReportingClient.class);
                _ReportingService2005Soap webService = (_ReportingService2005Soap)connection.getWebService(_ReportingService2005Soap.class);
                return new ReportingClient((TFSTeamProjectCollection)connection, webService);
            }
        });
        this.instantiatorMap.put(ServerStatusClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, ServerStatusClient.class);
                _ServerStatusSoap webService = (_ServerStatusSoap)connection.getWebService(_ServerStatusSoap.class);
                return new ServerStatusClient(webService);
            }
        });
        this.instantiatorMap.put(VersionControlClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, VersionControlClient.class);
                _RepositorySoap repository = (_RepositorySoap)connection.getWebService(_RepositorySoap.class);
                _RepositoryExtensionsSoap repositoryExtensions = (_RepositoryExtensionsSoap)connection.getWebService(_RepositoryExtensionsSoap.class);
                _Repository4Soap repository4 = (_Repository4Soap)connection.getWebService(_Repository4Soap.class);
                _Repository5Soap repository5 = (_Repository5Soap)connection.getWebService(_Repository5Soap.class);
                return new VersionControlClient((TFSTeamProjectCollection)connection, repository, repositoryExtensions, repository4, repository5);
            }
        });
        this.instantiatorMap.put(WorkItemConfigurationSettingsClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, WorkItemConfigurationSettingsClient.class);
                _ConfigurationSettingsServiceSoap webService = (_ConfigurationSettingsServiceSoap)connection.getWebService(_ConfigurationSettingsServiceSoap.class);
                return new WorkItemConfigurationSettingsClient(webService);
            }
        });
        this.instantiatorMap.put(WorkItemClient.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, WorkItemClient.class);
                _ClientService2Soap webService2 = (_ClientService2Soap)connection.getWebService(_ClientService2Soap.class);
                _ClientService3Soap webService3 = (_ClientService3Soap)connection.getWebService(_ClientService3Soap.class);
                _ClientService5Soap webService5 = (_ClientService5Soap)connection.getWebService(_ClientService5Soap.class);
                return new WorkItemClient((TFSTeamProjectCollection)connection, webService2, webService3, webService5);
            }
        });
        this.instantiatorMap.put(IBuildServer.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, IBuildServer.class);
                return new BuildServer((TFSTeamProjectCollection)connection);
            }
        });
        this.instantiatorMap.put(ILocationService.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                return new LocationService(connection);
            }
        });
        this.instantiatorMap.put(ICatalogService.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotConfigurationServer(connection, ICatalogService.class);
                return new CatalogService((TFSConfigurationServer)connection);
            }
        });
        this.instantiatorMap.put(IIdentityManagementService.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                return new IdentityManagementService(connection);
            }
        });
        this.instantiatorMap.put(IIdentityManagementService2.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                return new IdentityManagementService2(connection);
            }
        });
        this.instantiatorMap.put(TeamService.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                return new TeamService(connection);
            }
        });
        this.instantiatorMap.put(TeamSettingsConfigurationService.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, TeamSettingsConfigurationService.class);
                _TeamConfigurationServiceSoap webService = (_TeamConfigurationServiceSoap)connection.getWebService(_TeamConfigurationServiceSoap.class);
                return new TeamSettingsConfigurationService(webService);
            }
        });
        this.instantiatorMap.put(TeamProjectCollectionTeamStore.class, new ClientInstantiator(){

            @Override
            public Object newClient(TFSConnection connection) {
                DefaultClientFactory.throwIfNotProjectCollection(connection, TeamProjectCollectionTeamStore.class);
                return new TeamProjectCollectionTeamStore((TFSTeamProjectCollection)connection);
            }
        });
    }

    private static void throwIfNotProjectCollection(TFSConnection connection, Class clientClass) {
        if (!(connection instanceof TFSTeamProjectCollection)) {
            throw new IllegalArgumentException(MessageFormat.format("Client class {0} can only be created with a {1}, {2} is not supported", clientClass.getName(), TFSTeamProjectCollection.class.getName(), connection.getClass().getName()));
        }
    }

    private static void throwIfNotConfigurationServer(TFSConnection connection, Class clientClass) {
        if (!(connection instanceof TFSConfigurationServer)) {
            throw new IllegalArgumentException(MessageFormat.format("Client class {0} can only be created with a {1}, {2} is not supported", clientClass.getName(), TFSConfigurationServer.class.getName(), connection.getClass().getName()));
        }
    }

    private static interface ClientInstantiator {
        public Object newClient(TFSConnection var1);
    }
}

