/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.webservice;

import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.internal.ServiceInterfaceIdentifiers;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.reporting.ReportUtils;
import com.microsoft.tfs.core.clients.sharepoint.WSSUtils;
import com.microsoft.tfs.core.clients.workitem.internal.WITRequestIDHeaderProvider;
import com.microsoft.tfs.core.config.webservice.UnknownWebServiceException;
import com.microsoft.tfs.core.config.webservice.WebServiceFactory;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.core.ws.runtime.client.TransportRequestHandler;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import ms.sql.reporting.reportingservices._ReportingService2005Soap;
import ms.sql.reporting.reportingservices._ReportingService2005SoapService;
import ms.tfs.build.buildcontroller._03._BuildControllerWebServiceSoap;
import ms.tfs.build.buildcontroller._03._BuildControllerWebServiceSoap12Service;
import ms.tfs.build.buildinfo._03._BuildStoreWebServiceSoap;
import ms.tfs.build.buildinfo._03._BuildStoreWebServiceSoap12Service;
import ms.tfs.build.buildservice._03._AdministrationWebServiceSoap;
import ms.tfs.build.buildservice._03._AdministrationWebServiceSoap12Service;
import ms.tfs.build.buildservice._03._BuildQueueWebServiceSoap;
import ms.tfs.build.buildservice._03._BuildQueueWebServiceSoap12Service;
import ms.tfs.build.buildservice._03._BuildServiceSoap12Service;
import ms.tfs.build.buildservice._03._BuildWebServiceSoap;
import ms.tfs.build.buildservice._03._BuildWebServiceSoap12Service;
import ms.tfs.build.buildservice._04._AdministrationServiceSoap;
import ms.tfs.build.buildservice._04._AdministrationServiceSoap12Service;
import ms.tfs.build.buildservice._04._BuildQueueServiceSoap;
import ms.tfs.build.buildservice._04._BuildQueueServiceSoap12Service;
import ms.tfs.build.buildservice._04._BuildServiceSoap;
import ms.tfs.services.classification._03._Classification4Soap;
import ms.tfs.services.classification._03._Classification4Soap12Service;
import ms.tfs.services.classification._03._ClassificationSoap;
import ms.tfs.services.classification._03._ClassificationSoap12Service;
import ms.tfs.services.groupsecurity._03._GroupSecurityServiceSoap;
import ms.tfs.services.groupsecurity._03._GroupSecurityServiceSoap12Service;
import ms.tfs.services.linking._03._IntegrationServiceSoap;
import ms.tfs.services.linking._03._IntegrationServiceSoapService;
import ms.tfs.services.registration._03._RegistrationSoap;
import ms.tfs.services.registration._03._RegistrationSoap12Service;
import ms.tfs.services.serverstatus._03._ServerStatusSoap;
import ms.tfs.services.serverstatus._03._ServerStatusSoap12Service;
import ms.tfs.services.teamconfiguration._01._TeamConfigurationServiceSoap;
import ms.tfs.services.teamconfiguration._01._TeamConfigurationServiceSoap12Service;
import ms.tfs.versioncontrol.admin._03._AdminSoap;
import ms.tfs.versioncontrol.admin._03._AdminSoap12Service;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap12Service;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap12Service;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap12Service;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap12Service;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap12Service;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap12Service;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap12Service;
import ms.tfs.workitemtracking.configurationsettingsservice._03._ConfigurationSettingsServiceSoap;
import ms.tfs.workitemtracking.configurationsettingsservice._03._ConfigurationSettingsServiceSoap12Service;
import ms.ws._CatalogWebServiceSoap;
import ms.ws._CatalogWebServiceSoap12Service;
import ms.ws._IdentityManagementWebService2Soap;
import ms.ws._IdentityManagementWebService2Soap12Service;
import ms.ws._IdentityManagementWebServiceSoap;
import ms.ws._IdentityManagementWebServiceSoap12Service;
import ms.ws._LocationWebServiceSoap;
import ms.ws._LocationWebServiceSoap12Service;
import ms.ws._SecurityWebServiceSoap;
import ms.ws._SecurityWebServiceSoap12Service;
import ms.wss._ListsSoap;
import ms.wss._ListsSoapService;

public class DefaultWebServiceFactory
implements WebServiceFactory {
    private final Locale acceptLangaugeLocale;
    private final TransportRequestHandler transportRequestHandler;
    private final Object initLock = new Object();
    private boolean initialized = false;
    private final Map<Class<?>, WebServiceMetadata> serviceInterfaceClassToMetadata = new HashMap();

    public DefaultWebServiceFactory(Locale acceptLanguageLocale, TransportRequestHandler transportRequestHandler) {
        this.acceptLangaugeLocale = acceptLanguageLocale;
        this.transportRequestHandler = transportRequestHandler;
    }

    @Override
    public _RegistrationSoap newRegistrationWebService(URI connectionBaseURI, HttpClient httpClient) throws URISyntaxException {
        Check.notNull(connectionBaseURI, "connectionBaseURI");
        Check.notNull(httpClient, "httpClient");
        WebServiceMetadata metadata = this.getWebServiceMetadata(_RegistrationSoap.class);
        Check.notNull(metadata, "metadata");
        URI webServiceURI = this.resolveEndpointURI(connectionBaseURI, metadata.getDefaultEndpointPath());
        webServiceURI = this.getSafeURI(webServiceURI);
        _RegistrationSoap service = (_RegistrationSoap)metadata.getInstantiator().newWebServiceImplementation(httpClient, webServiceURI, metadata.getPortQName());
        ((SOAPService)((Object)service)).setAcceptLanguage(this.acceptLangaugeLocale);
        ((SOAPService)((Object)service)).addTransportRequestHandler(this.transportRequestHandler);
        return service;
    }

    @Override
    public _LocationWebServiceSoap newLocationWebService(URI fullLocationServiceURI, HttpClient httpClient) throws URISyntaxException {
        Check.notNull(fullLocationServiceURI, "fullLocationServiceURI");
        Check.notNull(httpClient, "httpClient");
        WebServiceMetadata metadata = this.getWebServiceMetadata(_LocationWebServiceSoap.class);
        Check.notNull(metadata, "metadata");
        URI webServiceURI = this.getSafeURI(fullLocationServiceURI);
        _LocationWebServiceSoap service = (_LocationWebServiceSoap)metadata.getInstantiator().newWebServiceImplementation(httpClient, webServiceURI, metadata.getPortQName());
        ((SOAPService)((Object)service)).setAcceptLanguage(this.acceptLangaugeLocale);
        ((SOAPService)((Object)service)).addTransportRequestHandler(this.transportRequestHandler);
        return service;
    }

    @Override
    public Object newWebService(TFSConnection connection, Class<?> webServiceInterfaceType, URI connectionBaseURI, HttpClient httpClient, ServerDataProvider serverDataProvider, RegistrationClient registrationClient) throws URISyntaxException, UnknownWebServiceException {
        Check.notNull(webServiceInterfaceType, "webServiceInterfaceType");
        Check.notNull(connectionBaseURI, "connectionBaseURI");
        Check.notNull(httpClient, "httpClient");
        Check.notNull(serverDataProvider, "serverDataProvider");
        WebServiceMetadata metadata = this.getWebServiceMetadata(webServiceInterfaceType);
        if (metadata == null) {
            throw new UnknownWebServiceException(webServiceInterfaceType);
        }
        String endpointPath = null;
        if (webServiceInterfaceType == _ReportingService2005Soap.class) {
            Check.isTrue(connection instanceof TFSTeamProjectCollection, "connection instanceof TFSTeamProjectCollection");
            Check.notNull(registrationClient, "registrationClient");
            endpointPath = ReportUtils.getReportServiceURL((TFSTeamProjectCollection)connection);
        }
        if (endpointPath == null && metadata.getServiceInterfaceName() != null) {
            endpointPath = this.getServerDataProviderEndpointPath(serverDataProvider, metadata.getServiceInterfaceName(), metadata.getServiceInterfaceIdentifier());
        }
        if (endpointPath == null) {
            return null;
        }
        URI webServiceURI = this.resolveEndpointURI(connectionBaseURI, endpointPath);
        if (!this.isConnection2010OrLater(connection)) {
            webServiceURI = this.rewriteInternalHostToConnectionHost(webServiceURI, connectionBaseURI, registrationClient);
        }
        webServiceURI = this.getSafeURI(webServiceURI);
        Object service = metadata.getInstantiator().newWebServiceImplementation(httpClient, webServiceURI, metadata.getPortQName());
        ((SOAPService)service).setAcceptLanguage(this.acceptLangaugeLocale);
        ((SOAPService)service).addTransportRequestHandler(this.transportRequestHandler);
        return service;
    }

    @Override
    public _IntegrationServiceSoap newLinkingWebService(TFSConnection connection, String linkingEndpoint, URI connectionBaseURI, HttpClient httpClient, RegistrationClient registrationClient) throws URISyntaxException {
        Check.notNull(connection, "connection");
        Check.notNullOrEmpty(linkingEndpoint, "linkingEndpoint");
        Check.notNull(connectionBaseURI, "connectionBaseURI");
        Check.notNull(httpClient, "httpClient");
        Check.notNull(registrationClient, "registrationClient");
        WebServiceMetadata metadata = this.getWebServiceMetadata(_IntegrationServiceSoap.class);
        Check.notNull(metadata, "metadata");
        URI webServiceURI = this.resolveEndpointURI(connectionBaseURI, linkingEndpoint);
        if (!this.isConnection2010OrLater(connection)) {
            webServiceURI = this.rewriteInternalHostToConnectionHost(webServiceURI, connectionBaseURI, registrationClient);
        }
        webServiceURI = this.getSafeURI(webServiceURI);
        _IntegrationServiceSoap service = (_IntegrationServiceSoap)metadata.getInstantiator().newWebServiceImplementation(httpClient, webServiceURI, metadata.getPortQName());
        ((SOAPService)((Object)service)).setAcceptLanguage(this.acceptLangaugeLocale);
        ((SOAPService)((Object)service)).addTransportRequestHandler(this.transportRequestHandler);
        return service;
    }

    @Override
    public _ListsSoap newWSSWebService(TFSConnection connection, ProjectInfo projectInfo, URI connectionBaseURI, HttpClient httpClient, RegistrationClient registrationClient) throws URISyntaxException {
        Check.notNull(connection, "connection");
        Check.isTrue(connection instanceof TFSTeamProjectCollection, "connection is TeamProjectCollection");
        Check.notNull(connectionBaseURI, "connectionBaseURI");
        Check.notNull(projectInfo, "projectInfo");
        Check.notNull(httpClient, "httpClient");
        Check.notNull(registrationClient, "registrationClient");
        WebServiceMetadata metadata = this.getWebServiceMetadata(_ListsSoap.class);
        Check.notNull(metadata, "metadata");
        String endpointPath = WSSUtils.getWSSURL((TFSTeamProjectCollection)connection, projectInfo);
        URI webServiceURI = new URI(endpointPath);
        webServiceURI = URIUtils.ensurePathHasTrailingSlash(webServiceURI);
        webServiceURI = URIUtils.resolve(webServiceURI, "_vti_bin/Lists.asmx");
        if (!this.isConnection2010OrLater(connection)) {
            webServiceURI = this.rewriteInternalHostToConnectionHost(webServiceURI, connectionBaseURI, registrationClient);
        }
        webServiceURI = this.getSafeURI(webServiceURI);
        _ListsSoap service = (_ListsSoap)metadata.getInstantiator().newWebServiceImplementation(httpClient, webServiceURI, metadata.getPortQName());
        ((SOAPService)((Object)service)).setAcceptLanguage(this.acceptLangaugeLocale);
        ((SOAPService)((Object)service)).addTransportRequestHandler(this.transportRequestHandler);
        return service;
    }

    @Override
    public URI getWebServiceURI(Object webService) throws IllegalArgumentException, ClassCastException, URISyntaxException {
        SOAPService stub = (SOAPService)webService;
        return stub.getEndpoint();
    }

    private URI resolveEndpointURI(URI connectionBaseURI, String endpointPath) {
        if (endpointPath.startsWith("/")) {
            endpointPath = endpointPath.substring(1);
        }
        return connectionBaseURI.resolve(endpointPath);
    }

    private URI getSafeURI(URI input) throws URISyntaxException {
        return new URI(input.toASCIIString());
    }

    private boolean isConnection2010OrLater(TFSConnection connection) {
        Check.notNull(connection, "connection");
        if (connection instanceof TFSConfigurationServer) {
            return true;
        }
        return connection instanceof TFSTeamProjectCollection && ((TFSTeamProjectCollection)connection).getConfigurationServer() != null;
    }

    private URI rewriteInternalHostToConnectionHost(URI serviceEndpointURI, URI connectionBaseURI, RegistrationClient registrationClient) throws URISyntaxException {
        Check.notNull(serviceEndpointURI, "input");
        if (registrationClient == null) {
            return serviceEndpointURI;
        }
        String serviceEndpointHost = URIUtils.safeGetHost(serviceEndpointURI);
        String connectionBaseHost = URIUtils.safeGetHost(connectionBaseURI);
        if (serviceEndpointHost == null || serviceEndpointHost.equalsIgnoreCase(connectionBaseHost)) {
            return serviceEndpointURI;
        }
        String atMachineName = registrationClient.getExtendedAttributeValue("vstfs", "ATMachineName");
        if (atMachineName == null || !serviceEndpointHost.equalsIgnoreCase(atMachineName)) {
            return serviceEndpointURI;
        }
        return new URI(serviceEndpointURI.getScheme(), serviceEndpointURI.getUserInfo(), connectionBaseURI.getHost(), serviceEndpointURI.getPort(), serviceEndpointURI.getPath(), serviceEndpointURI.getQuery(), serviceEndpointURI.getFragment());
    }

    private String getServerDataProviderEndpointPath(ServerDataProvider serverDataProvider, String serviceInterfaceName, GUID serviceInterfaceIdentifier) {
        Check.notNull(serverDataProvider, "serverDataProvider");
        Check.notNull(serviceInterfaceName, "serviceInterfaceName");
        return serverDataProvider.locationForCurrentConnection(serviceInterfaceName, serviceInterfaceIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebServiceMetadata getWebServiceMetadata(Class<?> webServiceInterfaceType) {
        Object object = this.initLock;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
            return this.serviceInterfaceClassToMetadata.get(webServiceInterfaceType);
        }
    }

    private void initialize() {
        this.serviceInterfaceClassToMetadata.put(_RegistrationSoap.class, new WebServiceMetadata("RegistrationService", ServiceInterfaceIdentifiers.REGISTRATION, "/Services/v1.0/Registration.asmx", _RegistrationSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _RegistrationSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_LocationWebServiceSoap.class, new WebServiceMetadata("LocationService", ServiceInterfaceIdentifiers.LOCATION, null, _LocationWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _LocationWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ClassificationSoap.class, new WebServiceMetadata("CommonStructure", ServiceInterfaceIdentifiers.COMMON_STRUCTURE, _ClassificationSoap12Service.getEndpointPath(), _ClassificationSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _ClassificationSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_Classification4Soap.class, new WebServiceMetadata("CommonStructure4", ServiceInterfaceIdentifiers.COMMON_STRUCTURE_4, _Classification4Soap12Service.getEndpointPath(), _Classification4Soap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _Classification4Soap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ReportingService2005Soap.class, new WebServiceMetadata(null, null, _ReportingService2005SoapService.getEndpointPath(), _ReportingService2005SoapService.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                _ReportingService2005SoapService service = new _ReportingService2005SoapService(httpClient, endpoint, port);
                service.setPromptForCredentials(false);
                return service;
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ServerStatusSoap.class, new WebServiceMetadata("ServerStatus", ServiceInterfaceIdentifiers.SERVER_STATUS, _ServerStatusSoap12Service.getEndpointPath(), _ServerStatusSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _ServerStatusSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_RepositorySoap.class, new WebServiceMetadata("ISCCProvider", ServiceInterfaceIdentifiers.VERSION_CONTROL, _RepositorySoap12Service.getEndpointPath(), _RepositorySoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _RepositorySoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_RepositoryExtensionsSoap.class, new WebServiceMetadata("ISCCProvider3", ServiceInterfaceIdentifiers.VERSION_CONTROL_3, _RepositoryExtensionsSoap12Service.getEndpointPath(), _RepositoryExtensionsSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _RepositoryExtensionsSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_Repository4Soap.class, new WebServiceMetadata("ISCCProvider4", ServiceInterfaceIdentifiers.VERSION_CONTROL_4, _Repository4Soap12Service.getEndpointPath(), _Repository4Soap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _Repository4Soap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_Repository5Soap.class, new WebServiceMetadata("ISCCProvider5", ServiceInterfaceIdentifiers.VERSION_CONTROL_5, _Repository5Soap12Service.getEndpointPath(), _Repository5Soap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _Repository5Soap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_AdminSoap.class, new WebServiceMetadata("ISCCAdmin", ServiceInterfaceIdentifiers.VERSION_CONTROL_ADMIN, _AdminSoap12Service.getEndpointPath(), _AdminSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _AdminSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_SecurityWebServiceSoap.class, new WebServiceMetadata("SecurityService", ServiceInterfaceIdentifiers.SECURITY, _SecurityWebServiceSoap12Service.getEndpointPath(), _SecurityWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _SecurityWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ConfigurationSettingsServiceSoap.class, new WebServiceMetadata("ConfigurationSettingsUrl", ServiceInterfaceIdentifiers.WORK_ITEM_CONFIG, _ConfigurationSettingsServiceSoap12Service.getEndpointPath(), _ConfigurationSettingsServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _ConfigurationSettingsServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ClientService2Soap.class, new WebServiceMetadata("WorkitemService", ServiceInterfaceIdentifiers.WORK_ITEM, _ClientService2Soap12Service.getEndpointPath(), _ClientService2Soap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                _ClientService2Soap12Service service = new _ClientService2Soap12Service(httpClient, endpoint, port);
                service.setSOAPHeaderProvider(new WITRequestIDHeaderProvider());
                return service;
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ClientService3Soap.class, new WebServiceMetadata("WorkitemService3", ServiceInterfaceIdentifiers.WORK_ITEM_3, _ClientService3Soap12Service.getEndpointPath(), _ClientService3Soap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                _ClientService3Soap12Service service = new _ClientService3Soap12Service(httpClient, endpoint, port);
                service.setSOAPHeaderProvider(new WITRequestIDHeaderProvider());
                return service;
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ClientService5Soap.class, new WebServiceMetadata("WorkitemService5", ServiceInterfaceIdentifiers.WORK_ITEM_5, _ClientService5Soap12Service.getEndpointPath(), _ClientService5Soap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                _ClientService5Soap12Service service = new _ClientService5Soap12Service(httpClient, endpoint, port);
                service.setSOAPHeaderProvider(new WITRequestIDHeaderProvider());
                return service;
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_IntegrationServiceSoap.class, new WebServiceMetadata("LinkingProviderService", null, null, new QName(_IntegrationServiceSoapService.getPortQName().getNamespaceURI(), ""), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _IntegrationServiceSoapService(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_GroupSecurityServiceSoap.class, new WebServiceMetadata("GroupSecurity", ServiceInterfaceIdentifiers.GROUP_SECURITY, _GroupSecurityServiceSoap12Service.getEndpointPath(), _GroupSecurityServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _GroupSecurityServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_ListsSoap.class, new WebServiceMetadata(null, null, _ListsSoapService.getEndpointPath(), _ListsSoapService.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                _ListsSoapService service = new _ListsSoapService(httpClient, endpoint, port);
                service.setPromptForCredentials(false);
                return service;
            }
        }));
        this.serviceInterfaceClassToMetadata.put(ms.tfs.build.buildservice._03._BuildServiceSoap.class, new WebServiceMetadata("BuildService", ServiceInterfaceIdentifiers.BUILD, _BuildServiceSoap12Service.getEndpointPath(), _BuildServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _BuildServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_BuildWebServiceSoap.class, new WebServiceMetadata("BuildService3", ServiceInterfaceIdentifiers.BUILD_3, _BuildWebServiceSoap12Service.getEndpointPath(), _BuildWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _BuildWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_BuildServiceSoap.class, new WebServiceMetadata("BuildService4", ServiceInterfaceIdentifiers.BUILD_4, ms.tfs.build.buildservice._04._BuildServiceSoap12Service.getEndpointPath(), ms.tfs.build.buildservice._04._BuildServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new ms.tfs.build.buildservice._04._BuildServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_BuildQueueWebServiceSoap.class, new WebServiceMetadata("BuildQueueService", ServiceInterfaceIdentifiers.BUILD_QUEUE_SERVICE, _BuildQueueWebServiceSoap12Service.getEndpointPath(), _BuildQueueWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _BuildQueueWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_BuildQueueServiceSoap.class, new WebServiceMetadata("BuildQueueService4", ServiceInterfaceIdentifiers.BUILD_QUEUE_SERVICE_4, _BuildQueueServiceSoap12Service.getEndpointPath(), _BuildQueueServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _BuildQueueServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_AdministrationWebServiceSoap.class, new WebServiceMetadata("AdministrationService", ServiceInterfaceIdentifiers.BUILD_ADMINISTRATION_SERVICE, _AdministrationWebServiceSoap12Service.getEndpointPath(), _AdministrationWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _AdministrationWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_AdministrationServiceSoap.class, new WebServiceMetadata("AdministrationService4", ServiceInterfaceIdentifiers.BUILD_ADMINISTRATION_SERVICE_4, _AdministrationServiceSoap12Service.getEndpointPath(), _AdministrationServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _AdministrationServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_BuildControllerWebServiceSoap.class, new WebServiceMetadata("BuildControllerService", ServiceInterfaceIdentifiers.BUILD_CONTROLLER, _BuildControllerWebServiceSoap12Service.getEndpointPath(), _BuildControllerWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _BuildControllerWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_BuildStoreWebServiceSoap.class, new WebServiceMetadata("BuildStoreService", ServiceInterfaceIdentifiers.BUILD_STORE, _BuildStoreWebServiceSoap12Service.getEndpointPath(), _BuildStoreWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _BuildStoreWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_CatalogWebServiceSoap.class, new WebServiceMetadata("CatalogService", ServiceInterfaceIdentifiers.CATALOG, _CatalogWebServiceSoap12Service.getEndpointPath(), _CatalogWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _CatalogWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_IdentityManagementWebServiceSoap.class, new WebServiceMetadata("IdentityManagementService", ServiceInterfaceIdentifiers.COLLECTION_IDENTITY_MANAGEMENT, _IdentityManagementWebServiceSoap12Service.getEndpointPath(), _IdentityManagementWebServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _IdentityManagementWebServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_IdentityManagementWebService2Soap.class, new WebServiceMetadata("IdentityManagementService2", ServiceInterfaceIdentifiers.COLLECTION_IDENTITY_MANAGEMENT_2, _IdentityManagementWebService2Soap12Service.getEndpointPath(), _IdentityManagementWebService2Soap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _IdentityManagementWebService2Soap12Service(httpClient, endpoint, port);
            }
        }));
        this.serviceInterfaceClassToMetadata.put(_TeamConfigurationServiceSoap.class, new WebServiceMetadata("TeamConfigurationService", ServiceInterfaceIdentifiers.TEAM_CONFIGURATION, _TeamConfigurationServiceSoap12Service.getEndpointPath(), _TeamConfigurationServiceSoap12Service.getPortQName(), new WebServiceInstantiator(){

            @Override
            public Object newWebServiceImplementation(HttpClient httpClient, URI endpoint, QName port) {
                return new _TeamConfigurationServiceSoap12Service(httpClient, endpoint, port);
            }
        }));
    }

    private static class WebServiceMetadata {
        private final String serviceInterfaceName;
        private final GUID serviceInterfaceIdentifier;
        private final String defaultEndpointPath;
        private final QName port;
        private final WebServiceInstantiator instantiator;

        public WebServiceMetadata(String serviceInterfaceName, GUID serviceInterfaceIdentifier, String defaultEndpointPath, QName port, WebServiceInstantiator instantiator) {
            this.serviceInterfaceName = serviceInterfaceName;
            this.serviceInterfaceIdentifier = serviceInterfaceIdentifier;
            this.defaultEndpointPath = defaultEndpointPath;
            this.port = port;
            this.instantiator = instantiator;
        }

        public String getServiceInterfaceName() {
            return this.serviceInterfaceName;
        }

        public GUID getServiceInterfaceIdentifier() {
            return this.serviceInterfaceIdentifier;
        }

        public String getDefaultEndpointPath() {
            return this.defaultEndpointPath;
        }

        public QName getPortQName() {
            return this.port;
        }

        public WebServiceInstantiator getInstantiator() {
            return this.instantiator;
        }
    }

    private static interface WebServiceInstantiator {
        public Object newWebServiceImplementation(HttpClient var1, URI var2, QName var3);
    }
}

