/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.credentials;

import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.credentials.CredentialsManager;
import com.microsoft.tfs.core.credentials.internal.GnomeKeyringCredentialsManager;
import com.microsoft.tfs.core.credentials.internal.KeychainCredentialsManager;
import com.microsoft.tfs.core.credentials.internal.PersistenceStoreCredentialsManager;
import com.microsoft.tfs.core.credentials.internal.WinCredentialsManager;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;

public class CredentialsManagerFactory {
    public static CredentialsManager getCredentialsManager(PersistenceStoreProvider persistenceProvider) {
        return CredentialsManagerFactory.getCredentialsManager(persistenceProvider, false);
    }

    public static CredentialsManager getCredentialsManager(PersistenceStoreProvider persistenceProvider, boolean usePersistanceCredentialsManager) {
        Check.notNull(persistenceProvider, "persistenceProvider");
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return new WinCredentialsManager();
        }
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X) && !usePersistanceCredentialsManager) {
            return new KeychainCredentialsManager();
        }
        if (Platform.isCurrentPlatform(Platform.LINUX) && !usePersistanceCredentialsManager && GnomeKeyringCredentialsManager.isGnomeKeyringSupported()) {
            return new GnomeKeyringCredentialsManager();
        }
        return new PersistenceStoreCredentialsManager(persistenceProvider.getConfigurationPersistenceStore());
    }
}

