/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.exceptions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.util.TFSUser;
import com.microsoft.tfs.core.util.UserNameUtil;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyUnauthorizedException;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class HTTPProxyUnauthorizedException
extends TECoreException {
    public HTTPProxyUnauthorizedException(ProxyUnauthorizedException e) {
        super(HTTPProxyUnauthorizedException.buildMessage(e), e);
    }

    private static String buildMessage(ProxyUnauthorizedException e) {
        Check.notNull(e, "e");
        String displayHostString = e.getProxyHost() + ":" + e.getProxyPort();
        Credentials credentials = e.getCredentials();
        if (credentials instanceof DefaultNTCredentials) {
            String username = UserNameUtil.getCurrentUserName();
            String domain = UserNameUtil.getCurrentUserDomain();
            if (username != null) {
                return MessageFormat.format(Messages.getString("HttpProxyUnauthorizedException.AccessDeniedAuthenticatingAsFormat"), displayHostString, new TFSUser(username, domain).toString());
            }
            return MessageFormat.format(Messages.getString("HttpProxyUnauthorizedException.AccessDeniedAuthenticatingAsCurrentUserFormat"), displayHostString);
        }
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCrendentials = (UsernamePasswordCredentials)credentials;
            return MessageFormat.format(Messages.getString("HttpProxyUnauthorizedException.AccessDeniedAuthenticatingAsFormat"), displayHostString, upCrendentials.getUsername());
        }
        if (credentials != null) {
            return MessageFormat.format(Messages.getString("HttpProxyUnauthorizedException.AccessDeniedAuthenticatingUsingCredentialsFormat"), displayHostString, credentials);
        }
        return MessageFormat.format(Messages.getString("HttpProxyUnauthorizedException.AccessDeniedAuthenticatingNoCredentialsFormat"), displayHostString);
    }
}

