/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.exceptions.mappers;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.exceptions.HTTPProxyUnauthorizedException;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.exceptions.TFSAccessException;
import com.microsoft.tfs.core.exceptions.TFSFederatedAuthException;
import com.microsoft.tfs.core.exceptions.TFSUnauthorizedException;
import com.microsoft.tfs.core.ws.runtime.exceptions.FederatedAuthException;
import com.microsoft.tfs.core.ws.runtime.exceptions.FederatedAuthFailedException;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyUnauthorizedException;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportException;
import com.microsoft.tfs.core.ws.runtime.exceptions.UnauthorizedException;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public abstract class TECoreExceptionMapper {
    protected static RuntimeException map(RuntimeException e) {
        if (e instanceof UnauthorizedException) {
            return new TFSUnauthorizedException((UnauthorizedException)e);
        }
        if (e instanceof ProxyUnauthorizedException) {
            return new HTTPProxyUnauthorizedException((ProxyUnauthorizedException)e);
        }
        if (e instanceof FederatedAuthException) {
            return new TFSFederatedAuthException((FederatedAuthException)e);
        }
        if (e instanceof TransportException && e.getCause() instanceof UnknownHostException) {
            return new TECoreException(MessageFormat.format(Messages.getString("TECoreExceptionMapper.UnknownHostFormat"), e.getCause().getLocalizedMessage()), e.getCause());
        }
        if (e instanceof FederatedAuthFailedException) {
            return new TFSAccessException((FederatedAuthFailedException)e);
        }
        if (e instanceof TECoreException) {
            return e;
        }
        if (e instanceof ProxyException) {
            return new TECoreException(e.getMessage(), e);
        }
        return e;
    }
}

