/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.exceptions.mappers;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.exceptions.ItemAlreadyUpdatedOnServerException;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnauthorizedAccessException;
import com.microsoft.tfs.core.clients.workitem.exceptions.ValidationException;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemLinkValidationException;
import com.microsoft.tfs.core.exceptions.mappers.TECoreExceptionMapper;
import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WorkItemExceptionMapper
extends TECoreExceptionMapper {
    public static RuntimeException map(RuntimeException e) {
        RuntimeException betterException;
        if (e instanceof SOAPFault && (betterException = WorkItemExceptionMapper.mapSoapFault((SOAPFault)e)) != e) {
            return betterException;
        }
        return TECoreExceptionMapper.map(e);
    }

    private static RuntimeException mapSoapFault(SOAPFault soapFault) {
        Node detailNode = soapFault.getDetail();
        if (detailNode != null) {
            Element detailElement = (Element)detailNode;
            NodeList children = detailElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String sId;
                Element childElement;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !"details".equals((childElement = (Element)child).getNodeName()) || (sId = childElement.getAttribute("id")) == null || sId.length() <= 0) continue;
                try {
                    int id = Integer.parseInt(sId);
                    return WorkItemExceptionMapper.mapSoapFaultDetailsID(id, soapFault);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        return soapFault;
    }

    private static RuntimeException mapSoapFaultDetailsID(int id, SOAPFault soapFault) {
        switch (id) {
            case 600031: {
                return new UnauthorizedAccessException(Messages.getString("WorkItemExceptionMapper.ItemDoesNotExistOrNoPermission"), soapFault, id);
            }
            case 600035: {
                return new UnauthorizedAccessException(Messages.getString("WorkItemExceptionMapper.NotRecognizedAdministratorInTeamProject"), soapFault, id);
            }
            case 600036: {
                return new ValidationException(Messages.getString("WorkItemExceptionMapper.QueryNameAlreadyExists"), (Throwable)soapFault, id, ValidationException.Type.NOT_UNIQUE_STORED_QUERY);
            }
            case 600072: {
                return new WorkItemException(Messages.getString("WorkItemExceptionMapper.NoPermissionToUpdateWorkItem"));
            }
            case 600122: {
                return new ItemAlreadyUpdatedOnServerException(soapFault);
            }
            case 600269: {
                return new WorkItemLinkValidationException(Messages.getString("WorkItemExceptionMapper.CannotAddLinkBecauseTypeDisabled"), (Throwable)soapFault, id, WorkItemLinkValidationException.Type.ADD_LINK_DISABLED_TYPE);
            }
            case 600270: {
                return new WorkItemLinkValidationException(Messages.getString("WorkItemExceptionMapper.LinkWouldResultInCircularRelationship"), (Throwable)soapFault, id, WorkItemLinkValidationException.Type.ADD_LINK_CIRCULARITY);
            }
            case 600271: {
                return new WorkItemLinkValidationException(Messages.getString("WorkItemExceptionMapper.CanOnlyHaveOneLinkOfThisType"), (Throwable)soapFault, id, WorkItemLinkValidationException.Type.ADD_LINK_EXTRA_PARENT);
            }
            case 600272: {
                return new WorkItemLinkValidationException(Messages.getString("WorkItemExceptionMapper.LinkWouldResultInCircularRelationship"), (Throwable)soapFault, id, WorkItemLinkValidationException.Type.ADD_LINK_CHILD_IS_ANCESTOR);
            }
            case 600273: {
                return new WorkItemLinkValidationException(Messages.getString("WorkItemExceptionMapper.LinkToWorkItemAlreadyExists"), (Throwable)soapFault, id, WorkItemLinkValidationException.Type.ADD_LINK_ALREADY_EXISTS);
            }
            case 600278: {
                return new WorkItemLinkValidationException(Messages.getString("WorkItemExceptionMapper.LinkBetweenWorkItemsWouldExceedMaximum"), (Throwable)soapFault, id, WorkItemLinkValidationException.Type.ADD_LINK_MAX_DEPTH_EXCEEDED);
            }
        }
        return soapFault;
    }
}

