/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.db;

import com.microsoft.tfs.core.internal.db.Configuration;
import com.microsoft.tfs.core.internal.db.DBConnection;
import com.microsoft.tfs.core.persistence.FilesystemPersistenceStore;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.core.persistence.VersionedVendorFilesystemPersistenceStore;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.locking.AdvisoryFileLock;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionConfiguration {
    private static final Log log = LogFactory.getLog(ConnectionConfiguration.class);
    private static final String DB_PROPS_FILE_NAME = "db.properties";
    private static final String DRIVER_CONFIG_KEY = "jdbc.driver.classname";
    private static final String URL_CONFIG_KEY = "jdbc.connection.url";
    private static final String USERNAME_CONFIG_KEY = "jdbc.username";
    private static final String PASSWORD_CONFIG_KEY = "jdbc.password";
    private static final String CLASSPATH_CONFIG_KEY = "jdbc.classpath";
    private static final String DRIVER_DEFAULT = "org.hsqldb.jdbcDriver";
    private static final String URL_DEFAULT = "jdbc:hsqldb:LOCAL_SETTINGS_DISKFILE";
    private static final String USERNAME_DEFAULT = "sa";
    private static final String PASSWORD_DEFAULT = "";
    private static final String URL_FALLBACK = "jdbc:hsqldb:mem:DB";
    private final String driverClass;
    private String url;
    private final String username;
    private final String password;
    private File databaseDiskDirectory;
    private AdvisoryFileLock lock;
    private final String pathIdentifer;
    private final Configuration configuration;
    private Driver driver;
    private final boolean verbose;

    public ConnectionConfiguration(PersistenceStore baseStore, String pathId) {
        this(baseStore, pathId, false);
    }

    public ConnectionConfiguration(PersistenceStore cacheStore, String pathId, boolean verboseInput) {
        Check.notNull(cacheStore, "cacheStore");
        this.pathIdentifer = "4.0A-" + pathId;
        this.verbose = verboseInput;
        this.configuration = new Configuration(ConnectionConfiguration.class, "/db.properties");
        this.driverClass = this.configuration.getConfiguration(DRIVER_CONFIG_KEY, DRIVER_DEFAULT);
        this.url = this.configuration.getConfiguration(URL_CONFIG_KEY, URL_DEFAULT);
        this.username = this.configuration.getConfiguration(USERNAME_CONFIG_KEY, USERNAME_DEFAULT);
        this.password = this.configuration.getConfiguration(PASSWORD_CONFIG_KEY, PASSWORD_DEFAULT);
        String extraClasspath = this.configuration.getConfiguration(CLASSPATH_CONFIG_KEY, null);
        if (this.url.equals(URL_DEFAULT)) {
            if (cacheStore instanceof VersionedVendorFilesystemPersistenceStore) {
                this.databaseDiskDirectory = this.getDirectoryForDiskDatabase((VersionedVendorFilesystemPersistenceStore)cacheStore, this.pathIdentifer);
            } else {
                log.warn((Object)MessageFormat.format("The {0} used to create {1} is not a {2}, which is required to retarget HSQLDB storage (it can only use files).  The fallback URL of {3} will be used.", PersistenceStore.class.getName(), ConnectionConfiguration.class.getName(), VersionedVendorFilesystemPersistenceStore.class.getName(), URL_FALLBACK));
            }
            if (this.databaseDiskDirectory == null) {
                this.url = URL_FALLBACK;
            } else {
                File db = new File(this.databaseDiskDirectory, "teamexplorer");
                this.url = "jdbc:hsqldb:file:" + db.getAbsolutePath();
            }
        }
        ClassLoader jdbcLoader = this.getClass().getClassLoader();
        if (extraClasspath != null) {
            File extraJar = new File(extraClasspath);
            try {
                jdbcLoader = new URLClassLoader(new URL[]{extraJar.toURL()}, jdbcLoader);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            this.driver = (Driver)jdbcLoader.loadClass(this.driverClass).newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(MessageFormat.format("unable to load specified jdbc driver class [{0}]", this.driverClass), t);
        }
        if (this.verbose) {
            System.out.println(MessageFormat.format("DB connection URL:     [{0}]", this.url));
            System.out.println(MessageFormat.format("DB driver class:       [{0}] (version {1}.{2})", this.driver.getClass().getName(), Integer.toString(this.driver.getMajorVersion()), Integer.toString(this.driver.getMinorVersion())));
            System.out.println(MessageFormat.format("DB driver loaded from: [{0}]", this.getDriverClassURL().toExternalForm()));
        }
    }

    public URL getDriverClassURL() {
        String resourceName = this.driverClass.replaceAll("\\.", "/") + ".class";
        return this.driver.getClass().getClassLoader().getResource(resourceName);
    }

    public int getDriverMajorVersion() {
        return this.driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.driver.getMinorVersion();
    }

    public String getPathIdentifier() {
        return this.pathIdentifer;
    }

    public File getDatabaseDiskDirectory() {
        return this.databaseDiskDirectory;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DBConnection createNewConnection() {
        try {
            Properties info = new Properties();
            info.setProperty("user", this.username);
            info.setProperty("password", this.password);
            Connection connection = this.driver.connect(this.url, info);
            if (connection == null) {
                throw new RuntimeException(MessageFormat.format("the driver [{0}] did not accept [{1}]", this.driver.getClass().getName(), this.url));
            }
            return new DBConnection(connection, this.driverClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private File getDirectoryForDiskDatabase(VersionedVendorFilesystemPersistenceStore cacheStore, String pathIdentifier) {
        PersistenceStore scopedDatabaseStore = cacheStore.getChildStore("TEE-WorkItemTracking").getChildStore(pathIdentifier);
        for (int i = 0; i < 1000; ++i) {
            String name = "data" + (i != 0 ? String.valueOf(i) : PASSWORD_DEFAULT);
            PersistenceStore candidateStore = scopedDatabaseStore.getChildStore(name);
            this.lock = this.tryLock(candidateStore);
            if (this.lock == null) continue;
            return ((FilesystemPersistenceStore)candidateStore).getStoreFile();
        }
        return null;
    }

    private AdvisoryFileLock tryLock(PersistenceStore store) {
        try {
            store.initialize();
            AdvisoryFileLock lock = store.getStoreLock(false);
            if (lock == null) {
                log.info((Object)MessageFormat.format("unable to lock [{0}]", store.toString()));
            } else {
                log.info((Object)MessageFormat.format("locked [{0}]", store.toString()));
            }
            return lock;
        }
        catch (IOException e) {
            log.warn((Object)MessageFormat.format("error getting lock on [{0}]", store.toString()), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            log.warn((Object)MessageFormat.format("error getting lock on [{0}]", store.toString()), (Throwable)e);
            return null;
        }
    }

    public void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException e) {
                log.warn((Object)"error releasing db directory lock", (Throwable)e);
            }
        }
    }
}

