/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.filelock;

import com.microsoft.tfs.jni.filelock.ITFSFileLock;
import com.microsoft.tfs.jni.filelock.NIOFileLock;
import com.microsoft.tfs.jni.filelock.WindowsMutexFileLock;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;

public class TFSFileLock
implements ITFSFileLock {
    private final ITFSFileLock fileLock;

    public TFSFileLock(String filename) {
        this(filename, false);
    }

    public TFSFileLock(String filename, boolean acquire) {
        Check.notNull(filename, "filename");
        this.fileLock = Platform.isCurrentPlatform(Platform.WINDOWS) ? new WindowsMutexFileLock(filename) : new NIOFileLock(filename);
        Check.notNull(this.fileLock, "fileLock");
        if (acquire) {
            this.acquire();
        }
    }

    @Override
    public String getFilename() {
        return this.fileLock.getFilename();
    }

    @Override
    public void acquire() {
        this.fileLock.acquire();
    }

    @Override
    public boolean acquire(int timeout) {
        return this.fileLock.acquire(timeout);
    }

    @Override
    public void release() {
        this.fileLock.release();
    }

    @Override
    public void close() {
        this.fileLock.close();
    }
}

