/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.helpers;

import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.appleforked.ResourceForkInputStream;
import com.microsoft.tfs.jni.appleforked.ResourceForkOutputStream;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileCopyHelper {
    private static final Log log = LogFactory.getLog(FileCopyHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyText(String source, Charset sourceCharset, String destination, Charset destinationCharset) throws FileNotFoundException, IOException, MalformedInputException, UnmappableCharacterException {
        Writer out;
        block15: {
            Check.notNull(source, "source");
            Check.notNull(destination, "destination");
            if (sourceCharset == null) {
                sourceCharset = Charset.defaultCharset();
            }
            if (destinationCharset == null) {
                destinationCharset = Charset.defaultCharset();
            }
            Reader in = null;
            out = null;
            try {
                CharsetDecoder decoder = sourceCharset.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), decoder));
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destination), destinationCharset));
                FileCopyHelper.copy(in, out);
                if (in == null) break block15;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)MessageFormat.format("Could not close {0} for reading: {1}", source, e.getMessage()));
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)MessageFormat.format("Could not close {0} for writing: {1}", destination, e.getMessage()));
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                log.warn((Object)MessageFormat.format("Could not close {0} for reading: {1}", source, e.getMessage()));
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.warn((Object)MessageFormat.format("Could not close {0} for writing: {1}", destination, e.getMessage()));
            }
        }
        FileCopyHelper.copyAttributes(source, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String source, String destination) throws FileNotFoundException, IOException {
        block15: {
            OutputStream out;
            FileSystemAttributes attr;
            FileSystemUtils util;
            block13: {
                block14: {
                    Check.notNull(source, "source");
                    Check.notNull(destination, "destination");
                    File sourceFile = new File(source);
                    util = FileSystemUtils.getInstance();
                    attr = util.getAttributes(sourceFile);
                    if (!attr.isSymbolicLink()) break block14;
                    String targetPath = util.getSymbolicLink(source);
                    util.createSymbolicLink(targetPath, destination);
                    break block15;
                }
                InputStream in = null;
                out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(source));
                    out = new BufferedOutputStream(new FileOutputStream(destination));
                    FileCopyHelper.copy(in, out);
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            log.warn((Object)MessageFormat.format("Could not close {0} for reading: {1}", source, e.getMessage()));
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            log.warn((Object)MessageFormat.format("Could not close {0} for writing: {1}", destination, e.getMessage()));
                        }
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn((Object)MessageFormat.format("Could not close {0} for reading: {1}", source, e.getMessage()));
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.warn((Object)MessageFormat.format("Could not close {0} for writing: {1}", destination, e.getMessage()));
                }
            }
            util.setAttributes(destination, attr);
            FileCopyHelper.copyAttributes(source, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAttributes(String source, String destination) throws FileNotFoundException, IOException {
        Check.notNull(source, "source");
        Check.notNull(destination, "destination");
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            String[] xattrs = FileSystemUtils.getInstance().listMacExtendedAttributes(source);
            if (xattrs == null) {
                log.warn((Object)MessageFormat.format("Could not query extended attributes for {0}", source));
            } else {
                for (int i = 0; i < xattrs.length; ++i) {
                    String xattrName = xattrs[i];
                    if (xattrName == null || xattrName.equals("")) {
                        log.warn((Object)MessageFormat.format("Got empty extended attribute for {0}, ignored", source));
                        continue;
                    }
                    if (xattrName.equals("com.apple.ResourceFork")) {
                        OutputStream out;
                        block18: {
                            InputStream in = null;
                            out = null;
                            try {
                                in = new BufferedInputStream(new ResourceForkInputStream(source));
                                out = new BufferedOutputStream(new ResourceForkOutputStream(destination));
                                FileCopyHelper.copy(in, out);
                                if (in == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e) {
                                        log.warn((Object)MessageFormat.format("Could not close resource fork {0} for reading: {1}", source, e.getMessage()));
                                    }
                                }
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException e) {
                                        log.warn((Object)MessageFormat.format("Could not close resource fork {0} for reading: {1}", destination, e.getMessage()));
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                log.warn((Object)MessageFormat.format("Could not close resource fork {0} for reading: {1}", source, e.getMessage()));
                            }
                        }
                        if (out == null) continue;
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            log.warn((Object)MessageFormat.format("Could not close resource fork {0} for reading: {1}", destination, e.getMessage()));
                        }
                        continue;
                    }
                    byte[] xattrValue = FileSystemUtils.getInstance().getMacExtendedAttribute(source, xattrName);
                    if (FileSystemUtils.getInstance().setMacExtendedAttribute(destination, xattrName, xattrValue)) continue;
                    throw new IOException(MessageFormat.format("Could not write extended attribute {0} for {1}", xattrName, destination));
                }
            }
        }
    }

    private static void copy(InputStream source, OutputStream destination) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = source.read(buffer)) != -1) {
            destination.write(buffer, 0, len);
        }
    }

    private static void copy(Reader source, Writer destination) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while ((len = source.read(buffer)) != -1) {
            destination.write(buffer, 0, len);
        }
    }
}

