/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.datetime;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.datetime.LenientDateTimeFormat;
import com.microsoft.tfs.util.datetime.LenientDateTimeFormatComparator;
import com.microsoft.tfs.util.datetime.LenientDateTimePattern;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LenientDateTimeParserExpander {
    private static final Log log = LogFactory.getLog(LenientDateTimeParserExpander.class);
    private static final String[] dateSeparators = new String[]{"/", "-", "."};
    private static final String[] timeSeparators = new String[]{":", "."};
    private static final String[] monthPatterns = new String[]{"MM", "MMM"};
    private static final String[] zonePatterns = new String[]{"z", "Z"};
    private final boolean constructLenient;
    private final Set lenientDateTimeParserFormats = new HashSet();
    private final Locale locale;
    private int counter = 0;

    protected LenientDateTimeParserExpander(boolean constructLenient, Locale locale) {
        this.constructLenient = constructLenient;
        this.locale = locale;
    }

    public void add(DateFormat format, boolean specifiesDate, boolean specifiesTime) {
        this.lenientDateTimeParserFormats.add(new LenientDateTimeFormat(format, this.counter++, specifiesDate, specifiesTime));
    }

    public void addExpanded(String pattern, boolean specifiesDate, boolean specifiesTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, this.locale);
        sdf.setLenient(this.constructLenient);
        this.lenientDateTimeParserFormats.add(new LenientDateTimeFormat(sdf, this.counter++, specifiesDate, specifiesTime));
    }

    public void addExpanded(LenientDateTimePattern[] patterns) {
        Check.notNull(patterns, "patterns");
        for (int i = 0; i < patterns.length; ++i) {
            LenientDateTimePattern pattern = patterns[i];
            for (int j = 0; j < dateSeparators.length; ++j) {
                for (int k = 0; k < timeSeparators.length; ++k) {
                    for (int l = 0; l < monthPatterns.length; ++l) {
                        for (int m = 0; m < zonePatterns.length; ++m) {
                            SimpleDateFormat sdf = new SimpleDateFormat(pattern.getPattern().replaceAll("/", dateSeparators[j]).replaceAll(":", timeSeparators[k]).replaceAll("MM", monthPatterns[l]).replaceAll("z", zonePatterns[m]), this.locale);
                            sdf.setLenient(this.constructLenient);
                            this.lenientDateTimeParserFormats.add(new LenientDateTimeFormat(sdf, this.counter++, pattern.specifiesDate(), pattern.specifiesTime()));
                        }
                    }
                }
            }
        }
    }

    public LenientDateTimeFormat[] getSortedResults() {
        LenientDateTimeFormat[] flat = this.lenientDateTimeParserFormats.toArray(new LenientDateTimeFormat[this.lenientDateTimeParserFormats.size()]);
        Arrays.sort(flat, new LenientDateTimeFormatComparator());
        if (log.isTraceEnabled()) {
            for (int i = 0; i < flat.length; ++i) {
                DateFormat format = flat[i].getDateFormat();
                if (format instanceof SimpleDateFormat) {
                    String pattern = ((SimpleDateFormat)format).toPattern();
                    String messageFormat = "expanded format {0}: {1}";
                    String message = MessageFormat.format("expanded format {0}: {1}", i, pattern);
                    log.trace((Object)message);
                    continue;
                }
                String messageFormat = "expanded format {0}: {1}";
                String message = MessageFormat.format("expanded format {0}: {1}", i, format.toString());
                log.trace((Object)message);
            }
        }
        return flat;
    }
}

