/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.valid;

import com.microsoft.tfs.util.valid.IValidity;
import com.microsoft.tfs.util.valid.Severity;
import com.microsoft.tfs.util.valid.Validator;
import com.microsoft.tfs.util.valid.ValidatorHelper;
import com.microsoft.tfs.util.valid.ValidityChangedEvent;
import com.microsoft.tfs.util.valid.ValidityChangedListener;

public class ValidatorWrapper
extends ValidatorHelper {
    private final Validator wrappedValidator;
    private final String errorMessage;
    private final ValidityChangedListener validityChangedListener;

    public ValidatorWrapper(Validator wrappedValidator) {
        this(wrappedValidator, null);
    }

    public ValidatorWrapper(Validator wrappedValidator, String errorMessage) {
        super(wrappedValidator.getSubject());
        this.wrappedValidator = wrappedValidator;
        this.errorMessage = errorMessage;
        this.validityChangedListener = new ValidityChangedListener(){

            @Override
            public void validityChanged(ValidityChangedEvent event) {
                ValidatorWrapper.this.computeValidity(event.getValidity());
            }
        };
        wrappedValidator.addValidityChangedListener(this.validityChangedListener);
        this.computeValidity(wrappedValidator.getValidity());
    }

    @Override
    public void dispose() {
        this.wrappedValidator.removeValidityChangedListener(this.validityChangedListener);
    }

    private void computeValidity(IValidity wrappedValidity) {
        Severity severity = wrappedValidity.getSeverity();
        if (severity == Severity.ERROR) {
            this.setInvalid(this.errorMessage);
        } else {
            this.setValid();
        }
    }
}

