/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.xml;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.xml.TransformerCache;
import com.microsoft.tfs.util.xml.XMLException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class DOMSerializeUtils {
    private static final TransformerCache cache = new TransformerCache();
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final int NONE = 0;
    public static final int XML_DECLARATION = 1;
    public static final int INDENT = 2;
    public static final int BYTE_ORDER_MARK = 4;
    public static final int DOCTYPE = 8;
    public static final int NO_CLOSE = 16;

    public static String toString(Node node) {
        return DOMSerializeUtils.toString(null, node, 0);
    }

    public static String toString(Node node, int flags) {
        return DOMSerializeUtils.toString(null, node, flags);
    }

    public static String toString(Transformer transformer, Node node) {
        return DOMSerializeUtils.toString(transformer, node, 0);
    }

    public static String toString(Transformer transformer, Node node, int flags) {
        StringWriter stringWriter = new StringWriter();
        DOMSerializeUtils.serializeToWriter(transformer, node, stringWriter, flags | 0x10);
        return stringWriter.toString();
    }

    public static void serializeToWriter(Node node, Writer writer) {
        DOMSerializeUtils.serializeToWriter(null, node, writer, 0);
    }

    public static void serializeToWriter(Node node, Writer writer, int flags) {
        DOMSerializeUtils.serializeToWriter(null, node, writer, flags);
    }

    public static void serializeToWriter(Transformer transformer, Node node, Writer writer) {
        DOMSerializeUtils.serializeToWriter(transformer, node, writer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeToWriter(Transformer transformer, Node node, Writer writer, int flags) {
        Check.notNull(writer, "writer");
        try {
            StreamResult result = new StreamResult(writer);
            DOMSerializeUtils.serialize(transformer, node, result, null, flags);
        }
        finally {
            if ((0x10 & flags) == 0) {
                IOUtils.closeSafely(writer);
            }
        }
    }

    public static void serializeToFile(Node node, File file, String encoding) {
        DOMSerializeUtils.serializeToFile(null, node, file, encoding, 0);
    }

    public static void serializeToFile(Node node, File file, String encoding, int flags) {
        DOMSerializeUtils.serializeToFile(null, node, file, encoding, flags);
    }

    public static void serializeToFile(Transformer transformer, Node node, File file, String encoding) {
        DOMSerializeUtils.serializeToFile(transformer, node, file, encoding, 0);
    }

    public static void serializeToFile(Transformer transformer, Node node, File file, String encoding, int flags) {
        OutputStream outputStream;
        Check.notNull(file, "file");
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new XMLException(e);
        }
        outputStream = new BufferedOutputStream(outputStream);
        DOMSerializeUtils.serializeToStream(transformer, node, outputStream, encoding, flags);
    }

    public static void serializeToStream(Node node, OutputStream outputStream, String encoding) {
        DOMSerializeUtils.serializeToStream(null, node, outputStream, encoding, 0);
    }

    public static void serializeToStream(Node node, OutputStream outputStream, String encoding, int flags) {
        DOMSerializeUtils.serializeToStream(null, node, outputStream, encoding, flags);
    }

    public static void serializeToStream(Transformer transformer, Node node, OutputStream outputStream, String encoding) {
        DOMSerializeUtils.serializeToStream(transformer, node, outputStream, encoding, 0);
    }

    public static void serializeToStream(Transformer transformer, Node node, OutputStream outputStream, String encoding, int flags) {
        Check.notNull(outputStream, "outputStream");
        try {
            if ((4 & flags) != 0) {
                DOMSerializeUtils.writeByteOrderMark(outputStream, encoding);
            }
            StreamResult result = new StreamResult(outputStream);
            DOMSerializeUtils.serialize(transformer, node, result, encoding, flags);
        }
        catch (IOException e) {
            throw new XMLException(e);
        }
        finally {
            if ((0x10 & flags) == 0) {
                IOUtils.closeSafely(outputStream);
            }
        }
    }

    public static void serialize(Node node, Result result, String encoding) {
        DOMSerializeUtils.serialize(null, node, result, encoding, 0);
    }

    public static void serialize(Node node, Result result, String encoding, int flags) {
        DOMSerializeUtils.serialize(null, node, result, encoding, flags);
    }

    public static void serialize(Transformer transformer, Node node, Result result, String encoding) {
        DOMSerializeUtils.serialize(transformer, node, result, encoding, 0);
    }

    public static void serialize(Transformer transformer, Node node, Result result, String encoding, int flags) {
        boolean useCache;
        boolean bl = useCache = transformer == null;
        if (useCache) {
            transformer = cache.takeTransformer();
        }
        try {
            Document document;
            DocumentType doctype;
            transformer.setOutputProperty("omit-xml-declaration", (flags & 1) == 0 ? "yes" : "no");
            if ((flags & 2) != 0) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            } else {
                transformer.setOutputProperty("indent", "no");
            }
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            if ((flags & 8) != 0 && node.getNodeType() == 9 && (doctype = (document = (Document)node).getDoctype()) != null) {
                if (doctype.getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                }
                if (doctype.getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                }
            }
            DOMSource input = new DOMSource(node);
            transformer.transform(input, result);
        }
        catch (TransformerException e) {
            throw new XMLException(e);
        }
        finally {
            if (useCache) {
                cache.releaseTransformer(transformer);
            }
        }
    }

    private static void writeByteOrderMark(OutputStream stream, String encoding) throws IOException {
        if (encoding == null) {
            return;
        }
        if (ENCODING_UTF8.equalsIgnoreCase(encoding)) {
            stream.write(new byte[]{-17, -69, -65});
        }
        if ("UTF-16BE".equalsIgnoreCase(encoding)) {
            stream.write(new byte[]{-2, -1});
        }
        if ("UTF-16LE".equalsIgnoreCase(encoding)) {
            stream.write(new byte[]{-1, -2});
        }
    }
}

