/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.admin.instance_comparison.comparison.GlobalComparisonResult;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationIndex;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationMetadata;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationOptions;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonResultBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonSnapshotLoader;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.option.IInstanceComparisonAcceptableDeviationsOption;
import com.teamscale.index.admin.instance_comparison.option.InstanceComparisonFindingOption;
import com.teamscale.index.admin.instance_comparison.option.InstanceComparisonLogErrorOption;
import com.teamscale.index.admin.instance_comparison.option.InstanceComparisonMaintenanceLogOption;
import com.teamscale.index.admin.instance_comparison.option.InstanceComparisonMetricOption;
import com.teamscale.index.admin.instance_comparison.option.InstanceComparisonTestGapOption;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotDto;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.MaintenanceLogErrorsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FindingsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.LogErrorsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.MetricsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TestGapAnalysisComparisonContribution;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class InstanceComparisonComputationTrigger
extends MaintenanceTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private InstanceComparisonComputationIndex computationIndex;
    private String combinedKey;
    private InstanceComparisonSnapshotLoader snapshotLoader;

    public void execute() throws Exception {
        this.combinedKey = this.jobDescriptor.getParameter();
        CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)this.combinedKey), (String)"Could not find instance comparison id (must be supplied as job parameter)");
        this.computationIndex = (InstanceComparisonComputationIndex)this.indexLayer.openGlobalIndex(InstanceComparisonComputationIndex.class);
        InstanceComparisonComputationMetadata comparisonMetadata = this.computationIndex.getComparisonMetadata(this.combinedKey).orElseThrow(() -> new IllegalStateException("No instance comparison metadata found for id %s".formatted(this.combinedKey)));
        this.snapshotLoader = new InstanceComparisonSnapshotLoader(this.indexLayer, (ICancelable)this);
        try {
            this.performComputation(comparisonMetadata);
            comparisonMetadata.setCompleted();
        }
        catch (Throwable e) {
            comparisonMetadata.setFailed(e);
            throw e;
        }
        finally {
            this.computationIndex.updateComparisonMetadata(this.combinedKey, comparisonMetadata);
        }
    }

    private void performComputation(InstanceComparisonComputationMetadata comparison) throws ConQATException, ExecutionCanceledException, ExecutionException {
        InstanceComparisonComputationOptions options = comparison.getOptions();
        InstanceComparisonSnapshotDto remoteSnapshot = this.snapshotLoader.getRemoteSnapshot(comparison, options);
        comparison.setRemoteInstanceName(remoteSnapshot.instanceName());
        comparison.setRemoteInstanceTeamscaleVersion(remoteSnapshot.teamscaleVersion());
        this.computationIndex.updateComparisonMetadata(this.combinedKey, comparison);
        InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions localSnapshot = this.snapshotLoader.readLocalSnapshot(options.getLocalSnapshotId(), Instant.ofEpochMilli(comparison.getCreatedOn()), comparison.getId());
        comparison.addProcessedProjects(InstanceComparisonComputationTrigger.getProcessedProjects(localSnapshot.projectComparisonInputs(), remoteSnapshot.projectComparisonInputs()));
        this.processInputs(comparison, localSnapshot.getAllComparisonInputs(), remoteSnapshot.getAllComparisonInputs());
    }

    private static Set<String> getProcessedProjects(List<ProjectComparisonContributionBase> localComparisonInputs, List<ProjectComparisonContributionBase> remoteComparisonInputs) {
        return Stream.of(localComparisonInputs, remoteComparisonInputs).flatMap(Collection::stream).map(ProjectComparisonContributionBase::getProject).collect(Collectors.toSet());
    }

    private void processInputs(InstanceComparisonComputationMetadata comparison, List<? extends InstanceComparisonContributionBase> localComparisonInputs, List<? extends InstanceComparisonContributionBase> remoteComparisonInputs) throws StorageException, ExecutionException {
        Map<String, InstanceComparisonContributionBase> localComparisonInputMap = InstanceComparisonComputationTrigger.buildComparisonInputMap(localComparisonInputs);
        Map<String, InstanceComparisonContributionBase> remoteComparisonInputMap = InstanceComparisonComputationTrigger.buildComparisonInputMap(remoteComparisonInputs);
        Set<String> localKeys = localComparisonInputMap.keySet();
        Set<String> remoteKeys = remoteComparisonInputMap.keySet();
        Function<InstanceComparisonContributionBase, InstanceComparisonContributionBase.ComparisonContext> contextCreator = this.prepareContextCreator(localComparisonInputs, remoteComparisonInputs);
        ArrayList inputKeysFromBothInstances = CollectionUtils.sort((Collection)CollectionUtils.intersectionSet(localKeys, (Collection[])new Collection[]{remoteKeys}));
        this.executeInParallelBatches(inputKeysFromBothInstances, inputKeyBatch -> {
            for (String key : inputKeyBatch) {
                this.verifyNotCanceled();
                InstanceComparisonContributionBase localComparisonInput = (InstanceComparisonContributionBase)localComparisonInputMap.get(key);
                InstanceComparisonResultBase result = localComparisonInput.computeComparisonResult((InstanceComparisonContributionBase)remoteComparisonInputMap.get(key), (InstanceComparisonContributionBase.ComparisonContext)contextCreator.apply(localComparisonInput));
                this.computationIndex.addResult(comparison, result);
            }
        });
        HashSet inputKeysOnlyLocal = CollectionUtils.differenceSet(localKeys, (Collection[])new Collection[]{remoteKeys});
        HashSet inputKeysOnlyRemote = CollectionUtils.differenceSet(remoteKeys, (Collection[])new Collection[]{localKeys});
        this.handleUnprocessedInputs(comparison, CollectionUtils.map((Collection)CollectionUtils.sort((Collection)inputKeysOnlyLocal), localComparisonInputMap::get), CollectionUtils.map((Collection)CollectionUtils.sort((Collection)inputKeysOnlyRemote), remoteComparisonInputMap::get));
    }

    private Function<InstanceComparisonContributionBase, InstanceComparisonContributionBase.ComparisonContext> prepareContextCreator(List<? extends InstanceComparisonContributionBase> localComparisonInputs, List<? extends InstanceComparisonContributionBase> remoteComparisonInputs) throws StorageException {
        Map<String, List<InstanceComparisonContributionBase>> localComparisonsByProject = localComparisonInputs.stream().collect(Collectors.groupingBy(InstanceComparisonContributionBase::getProject));
        Map<String, List<InstanceComparisonContributionBase>> remoteComparisonsByProject = remoteComparisonInputs.stream().collect(Collectors.groupingBy(InstanceComparisonContributionBase::getProject));
        Map<Class<? extends InstanceComparisonContributionBase>, InstanceComparisonContributionBase.AcceptedComparisonDeviations> acceptedComparisonDeviations = this.getAcceptedComparisonDeviations(localComparisonInputs);
        GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        return comparisonContribution -> new InstanceComparisonContributionBase.ComparisonContext((Collection)localComparisonsByProject.get(comparisonContribution.getProject()), (Collection)remoteComparisonsByProject.get(comparisonContribution.getProject()), (InstanceComparisonContributionBase.AcceptedComparisonDeviations)acceptedComparisonDeviations.get(comparisonContribution.getClass()), globalStorageSystem);
    }

    private static Map<String, InstanceComparisonContributionBase> buildComparisonInputMap(List<? extends InstanceComparisonContributionBase> comparisonInputs) {
        return comparisonInputs.stream().collect(Collectors.toMap(InstanceComparisonContributionBase::makeContributionKey, Function.identity()));
    }

    private Map<Class<? extends InstanceComparisonContributionBase>, InstanceComparisonContributionBase.AcceptedComparisonDeviations> getAcceptedComparisonDeviations(List<? extends InstanceComparisonContributionBase> comparisonInputs) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        ServerOptionRegistry registry = ServerOptionRegistry.getInstance();
        HashMap<Class<? extends InstanceComparisonContributionBase>, InstanceComparisonContributionBase.AcceptedComparisonDeviations> result = new HashMap<Class<? extends InstanceComparisonContributionBase>, InstanceComparisonContributionBase.AcceptedComparisonDeviations>();
        for (InstanceComparisonContributionBase instanceComparisonContributionBase : comparisonInputs) {
            CollectionUtils.computeIfAbsentWithException(result, instanceComparisonContributionBase.getClass(), ignored -> InstanceComparisonComputationTrigger.getAcceptedComparisonDeviations(comparisonInput, registry, optionIndex));
        }
        return result;
    }

    private static InstanceComparisonContributionBase.AcceptedComparisonDeviations getAcceptedComparisonDeviations(InstanceComparisonContributionBase comparisonInput, ServerOptionRegistry registry, ServerOptionIndex optionIndex) throws StorageException {
        IInstanceComparisonAcceptableDeviationsOption option;
        InstanceComparisonContributionBase instanceComparisonContributionBase = comparisonInput;
        Objects.requireNonNull(instanceComparisonContributionBase);
        InstanceComparisonContributionBase instanceComparisonContributionBase2 = instanceComparisonContributionBase;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetricsComparisonContribution.class, FindingsComparisonContribution.class, TestGapAnalysisComparisonContribution.class, LogErrorsComparisonContribution.class, MaintenanceLogErrorsComparisonContribution.class}, (Object)instanceComparisonContributionBase2, n)) {
            case 0: {
                MetricsComparisonContribution ignored = (MetricsComparisonContribution)instanceComparisonContributionBase2;
                IInstanceComparisonAcceptableDeviationsOption iInstanceComparisonAcceptableDeviationsOption = (InstanceComparisonMetricOption)registry.getServerOption("instance-comparison-metrics", InstanceComparisonMetricOption.class, optionIndex);
                break;
            }
            case 1: {
                FindingsComparisonContribution ignored = (FindingsComparisonContribution)instanceComparisonContributionBase2;
                IInstanceComparisonAcceptableDeviationsOption iInstanceComparisonAcceptableDeviationsOption = (InstanceComparisonFindingOption)registry.getServerOption("instance-comparison-findings", InstanceComparisonFindingOption.class, optionIndex);
                break;
            }
            case 2: {
                TestGapAnalysisComparisonContribution ignored = (TestGapAnalysisComparisonContribution)instanceComparisonContributionBase2;
                IInstanceComparisonAcceptableDeviationsOption iInstanceComparisonAcceptableDeviationsOption = (InstanceComparisonTestGapOption)registry.getServerOption("instance-comparison-test-gaps", InstanceComparisonTestGapOption.class, optionIndex);
                break;
            }
            case 3: {
                LogErrorsComparisonContribution ignored = (LogErrorsComparisonContribution)instanceComparisonContributionBase2;
                IInstanceComparisonAcceptableDeviationsOption iInstanceComparisonAcceptableDeviationsOption = (InstanceComparisonLogErrorOption)registry.getServerOption("instance-comparison-log-error", InstanceComparisonLogErrorOption.class, optionIndex);
                break;
            }
            case 4: {
                MaintenanceLogErrorsComparisonContribution ignored = (MaintenanceLogErrorsComparisonContribution)instanceComparisonContributionBase2;
                IInstanceComparisonAcceptableDeviationsOption iInstanceComparisonAcceptableDeviationsOption = (InstanceComparisonMaintenanceLogOption)registry.getServerOption("instance-comparison-maintenance-log", InstanceComparisonMaintenanceLogOption.class, optionIndex);
                break;
            }
            default: {
                IInstanceComparisonAcceptableDeviationsOption iInstanceComparisonAcceptableDeviationsOption = option = null;
            }
        }
        if (option == null) {
            return InstanceComparisonContributionBase.AcceptedComparisonDeviations.EMPTY;
        }
        return option.getAcceptedComparisonDeviations();
    }

    private void handleUnprocessedInputs(InstanceComparisonComputationMetadata comparison, Collection<? extends InstanceComparisonContributionBase> localUnprocessedInputs, Collection<? extends InstanceComparisonContributionBase> remoteUnprocessedInputs) throws StorageException {
        if (localUnprocessedInputs.isEmpty() && remoteUnprocessedInputs.isEmpty()) {
            return;
        }
        Map<String, List<InstanceComparisonContributionBase>> unprocessedLocalInputsByProject = localUnprocessedInputs.stream().collect(Collectors.groupingBy(InstanceComparisonContributionBase::getProject));
        Map<String, List<InstanceComparisonContributionBase>> unprocessedRemoteInputsByProject = remoteUnprocessedInputs.stream().collect(Collectors.groupingBy(InstanceComparisonContributionBase::getProject));
        ArrayList localOnlyProjectNames = new ArrayList();
        ArrayList remoteOnlyProjectNames = new ArrayList();
        for (String project : CollectionUtils.unionSet(unprocessedLocalInputsByProject.keySet(), (Collection[])new Collection[]{unprocessedRemoteInputsByProject.keySet()})) {
            if (!comparison.getContributorsByProject().containsKey((Object)project)) {
                if (unprocessedLocalInputsByProject.containsKey(project)) {
                    localOnlyProjectNames.add(PredefinedImprovedInstanceComparisonDiffEntry.fromObject("Project Name", project, "<not found>", false));
                    continue;
                }
                remoteOnlyProjectNames.add(PredefinedImprovedInstanceComparisonDiffEntry.fromObject("Project Name", "<not found>", project, false));
                continue;
            }
            LOGGER.warn("Found snapshot contributors only present in one instance for project \"{}\".\nLocal Only: {}\nRemote Only: {}", (Object)project, InstanceComparisonComputationTrigger.extractContributorNames(unprocessedLocalInputsByProject.getOrDefault(project, Collections.emptyList())), InstanceComparisonComputationTrigger.extractContributorNames(unprocessedRemoteInputsByProject.getOrDefault(project, Collections.emptyList())));
        }
        this.computationIndex.addResult(comparison, new GlobalComparisonResult("Projects only in one instance", localOnlyProjectNames, remoteOnlyProjectNames, Collections.emptyList()));
    }

    private static List<String> extractContributorNames(Collection<? extends InstanceComparisonContributionBase> unprocessedInputs) {
        return unprocessedInputs.stream().map(InstanceComparisonContributionBase::getContributor).distinct().toList();
    }
}

