/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.google.common.math.DoubleMath;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.KeyValueInstanceComparisonValueBase;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class NumberInstanceComparisonValue
extends KeyValueInstanceComparisonValueBase<Number> {
    public static final Predicate<Pair<@Nullable Number, @Nullable Number>> LOWER_LOCAL_IMPROVEMENT = localAndRemote -> {
        double remoteCount;
        double localCount = Optional.ofNullable((Number)localAndRemote.getFirst()).map(Number::doubleValue).orElse(0.0);
        return localCount < (remoteCount = Optional.ofNullable((Number)localAndRemote.getSecond()).map(Number::doubleValue).orElse(0.0).doubleValue());
    };
    private final Function<Number, String> formatter;

    public NumberInstanceComparisonValue(@NonNull String key, @NonNull Number value) {
        this(key, value, null, NumberInstanceComparisonValue.noImprovement());
    }

    public NumberInstanceComparisonValue(@NonNull String key, @NonNull Number value, @Nullable IDetailedInstanceComparisonContribution detail) {
        this(key, value, detail, NumberInstanceComparisonValue.noImprovement());
    }

    public NumberInstanceComparisonValue(@NonNull String key, @NonNull Number value, @Nullable IDetailedInstanceComparisonContribution detail, Predicate<Pair<@Nullable Number, @Nullable Number>> onlyImprovementDecider) {
        this(key, value, detail, onlyImprovementDecider, (String)null);
    }

    public NumberInstanceComparisonValue(@NonNull String key, @NonNull Number value, @Nullable IDetailedInstanceComparisonContribution detail, Predicate<Pair<@Nullable Number, @Nullable Number>> onlyImprovementDecider, String acceptedDeviationKeyOverride) {
        this(key, value, detail, onlyImprovementDecider, acceptedDeviationKeyOverride, String::valueOf);
    }

    public NumberInstanceComparisonValue(@NonNull String key, @NonNull Number value, @Nullable IDetailedInstanceComparisonContribution detail, Predicate<Pair<@Nullable Number, @Nullable Number>> onlyImprovementDecider, String acceptedDeviationKeyOverride, Function<Number, String> formatter) {
        super(key, value, detail, onlyImprovementDecider, acceptedDeviationKeyOverride);
        this.formatter = formatter;
    }

    @Override
    protected Optional<? extends InstanceComparisonDiffEntryBase<?>> computeDifference(InstanceComparisonContributionBase.ComparisonContext context, KeyValueInstanceComparisonValueBase<Number> local, KeyValueInstanceComparisonValueBase<Number> remote) {
        Number localValue = local != null ? (Number)((Number)local.value) : (Number)null;
        Number remoteValue = remote != null ? (Number)((Number)remote.value) : (Number)null;
        Pair localAndRemoteValue = Pair.createPair((Object)localValue, (Object)remoteValue);
        if (localValue == null || remoteValue == null) {
            return Optional.of(new PredefinedImprovedInstanceComparisonDiffEntry(this.key, Optional.ofNullable(localValue).map(String::valueOf).orElse("<not found>"), Optional.ofNullable(remoteValue).map(String::valueOf).orElse("<not found>"), IInstanceComparisonValue.computeExamples(this.key, local, remote), this.onlyImprovementDecider.test(localAndRemoteValue), false));
        }
        if (DoubleMath.fuzzyEquals((double)localValue.doubleValue(), (double)remoteValue.doubleValue(), (double)1.0E-6)) {
            return Optional.empty();
        }
        return Optional.of(PredefinedImprovedInstanceComparisonDiffEntry.fromObject(this.key, this.formatter.apply(localValue), this.formatter.apply(remoteValue), IInstanceComparisonValue.computeExamples(this.key, local, remote), this.onlyImprovementDecider.test(localAndRemoteValue), IInstanceComparisonValue.isWithinAcceptedDeviation(localValue.doubleValue(), remoteValue.doubleValue(), context.getAcceptedComparisonDeviation(this.getAcceptedDeviationKey()))));
    }
}

