/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.analysis.xclones;

import com.teamscale.index.audit.analysis.xclones.ExternalXCloneClass;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneStatus;
import java.io.Serializable;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="ext-x-clones", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED}, valueClasses={ExternalXCloneStatus.class})
public class ExternalXCloneIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "ext-x-clones";
    private static final String STATUS_KEY = "status";
    private static final byte[] CLONE_KEY_PREFIX = new byte[]{99};

    public ExternalXCloneIndex(IStore store) {
        super(store);
    }

    public ExternalXCloneStatus getStatus() throws StorageException {
        byte[] value = this.store.getWithString(STATUS_KEY);
        if (value == null) {
            return new ExternalXCloneStatus("No detection scheduled");
        }
        return (ExternalXCloneStatus)StorageUtils.deserialize((byte[])value);
    }

    public void updateStatus(ExternalXCloneStatus status) throws StorageException {
        this.store.putWithString(STATUS_KEY, StorageUtils.serialize((Serializable)status));
    }

    public void addCloneClass(ExternalXCloneClass cloneClass) throws StorageException {
        this.store.put(ExternalXCloneIndex.makeCloneKey(cloneClass.getId()), StorageUtils.serialize((Serializable)cloneClass));
    }

    public List<ExternalXCloneClass> getAllCloneClasses() throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(CLONE_KEY_PREFIX, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    private static byte[] makeCloneKey(int id) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{CLONE_KEY_PREFIX, ByteArrayUtils.intToByteArray((int)id)});
    }

    public void clearClones() throws StorageException {
        this.store.removeByPrefix(CLONE_KEY_PREFIX);
    }
}

