/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.analysis.xclones;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.audit.analysis.xclones.ExternalXClone;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneClass;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneIndex;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneStatus;
import com.teamscale.index.audit.analysis.xclones.ExternalXClonesParameter;
import com.teamscale.index.code_clones.CloneChunkByHashIndex;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.CloneChunkIndexInverter;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.detection.CloneDetector;
import com.teamscale.index.code_clones.report.ICloneClassReporter;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStorageSystem;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.transaction.TransactionalStorageSystem;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.filesystem.AntPatternDirectoryScanner;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class ExternalXCloneTrigger
extends PrivilegedTriggerBase {
    private static final int FILE_SIZE_LIMIT = (int)ByteUnit.MEBIBYTES.toBytes(1L);
    private static final int FILE_SIZE_REPORTING_LIMIT = 10;
    private static final int CLONE_MAX_EXTERNAL_FILES = 2;
    private static final int MAX_CLONE_CLASSES = 1000;
    private static final long STATUS_UPDATE_PERIOD_MILLIS = Duration.ofSeconds(5L).toMillis();
    private static final String EXTERNAL_FILE = "__external__file__";
    private static final CloneChunkByPathIndex EMPTY_BY_PATH_INDEX = new CloneChunkByPathIndex((IStore)new StoreWithAbbreviationSupport((IStore)new InMemoryStore(), (IStorageAbbreviator)new StorageAbbreviator((IStorageSystem)new InMemoryStorageSystem())));
    private ExternalXCloneIndex externalXCloneIndex;
    private ExternalXCloneStatus status;
    private byte[] previousSerializedStatus = new byte[0];
    private static final Logger LOGGER = LogManager.getLogger();
    private long startTime;
    private int numberOfClones = 0;
    private final List<String> sizeExcludedFiles = new ArrayList<String>();

    public void execute() throws StorageException {
        this.startTime = System.currentTimeMillis();
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.jobDescriptor.getInternalProjectId());
        this.externalXCloneIndex = (ExternalXCloneIndex)projectStorageSystem.openProjectIndex(ExternalXCloneIndex.class, null);
        this.status = this.externalXCloneIndex.getStatus();
        String token = UUID.randomUUID().toString();
        if (StringUtils.isEmpty((CharSequence)this.status.getTriggerToken())) {
            this.status.setTriggerToken(token);
        } else if (!token.equals(this.status.getTriggerToken()) && !this.status.isCompleted()) {
            LOGGER.error("Attempted to schedule second run in parallel!");
            return;
        }
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ExternalXCloneTrigger.this.updateStatus();
            }
        }, STATUS_UPDATE_PERIOD_MILLIS, STATUS_UPDATE_PERIOD_MILLIS);
        try {
            this.detectClones();
        }
        catch (IOException | AssertionError | ConQATException e) {
            this.status.setMessage("Failed with exception: " + ((Throwable)e).getMessage());
            LOGGER.error(((Throwable)e).getMessage(), (Throwable)e);
        }
        timer.cancel();
        this.updateStatus();
    }

    private void updateStatus() {
        try {
            byte[] serialized = StorageUtils.serialize((Serializable)this.status);
            if (Arrays.equals(serialized, this.previousSerializedStatus)) {
                return;
            }
            this.previousSerializedStatus = serialized;
            this.externalXCloneIndex.updateStatus(this.status);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to update status: " + e.getMessage(), (Throwable)e);
        }
    }

    private void detectClones() throws ConQATException, IOException {
        this.status.setMessage("Deleting old results");
        this.externalXCloneIndex.clearClones();
        ExternalXClonesParameter parameters = (ExternalXClonesParameter)this.jobDescriptor.getParameterObject(ExternalXClonesParameter.class);
        List<File> files = this.collectFiles(parameters);
        this.detectClones(files, parameters);
        this.status.setMessage("Detection completed");
        this.status.setDetails("Processed " + files.size() + " files", "Detected " + this.numberOfClones + " clone classes", "Overall time: " + DurationUtils.formatDurationHumanReadable((Duration)Duration.ofMillis(System.currentTimeMillis() - this.startTime)));
        if (this.numberOfClones > 1000) {
            this.status.addDetails("Note that we found more clones than the detection limit of 1000; only the first clone classes are shown.");
        }
        if (!this.sizeExcludedFiles.isEmpty()) {
            this.status.addDetails("Note that " + this.sizeExcludedFiles.size() + " files where excluded because they were too large (> " + FILE_SIZE_LIMIT + " characters), including " + String.valueOf(this.sizeExcludedFiles.subList(0, Math.min(this.sizeExcludedFiles.size(), 10))));
        }
        this.status.setCompleted();
    }

    private List<File> collectFiles(ExternalXClonesParameter parameters) throws IOException {
        this.status.setMessage("Collecting files ...");
        String[] relativePaths = AntPatternDirectoryScanner.scan((String)parameters.externalPath, (boolean)true, (String[])parameters.include.split("[,\\s]+"), (String[])parameters.exclude.split("[,\\s]+"));
        return Arrays.stream(relativePaths).map(path -> new File(parameters.externalPath, (String)path)).collect(Collectors.toList());
    }

    private void detectClones(List<File> files, ExternalXClonesParameter parameters) throws ConQATException {
        this.status.setMessage("Running detection ...");
        IStorageSystem rawProjectStorageSystem = this.indexLayer.getRawStorageSystemProvider().openStorageSystem(this.jobDescriptor.getInternalProjectId().toString());
        StorageCacheProvider.StorageSystemCacheProvider projectStorageSystemCacheProvider = this.indexLayer.getStorageCacheProvider().getCacheProvider(this.jobDescriptor.getInternalProjectId().toString());
        TransactionalStorageSystem neverCommittedTransactionalStorageSystem = new TransactionalStorageSystem(rawProjectStorageSystem, projectStorageSystemCacheProvider, InMemoryStore::new);
        StorageCacheProvider.StorageSystemCacheProvider standaloneCacheProvider = StorageCacheRegistry.createStandaloneCacheProvider();
        TransactionalStorageSystem transactionalStorageSystem = new TransactionalStorageSystem((IStorageSystem)neverCommittedTransactionalStorageSystem, standaloneCacheProvider, InMemoryStore::new);
        ProjectStorageSystem projectStorageSystem = new ProjectStorageSystem((IStorageSystem)transactionalStorageSystem, standaloneCacheProvider);
        StorageAbbreviator stringAbbreviator = new StorageAbbreviator(rawProjectStorageSystem);
        HistoryAccessOption historyAccess = HistoryAccessOption.readHeadWriteTimestamp((String)this.getDefaultBranchName(), (long)System.currentTimeMillis());
        CloneChunkByPathIndex byPathIndex = new CloneChunkByPathIndex((IStore)new StoreWithAbbreviationSupport(projectStorageSystem.openStoreChecked("clone-chunks-by-path", CloneChunkByPathIndex.class, (IStorageSystem)projectStorageSystem, false, historyAccess), (IStorageAbbreviator)stringAbbreviator));
        CloneChunkByHashIndex byHashIndex = new CloneChunkByHashIndex((IStore)new StoreWithAbbreviationSupport(projectStorageSystem.openStoreChecked("clone-chunks-by-hash", CloneChunkByHashIndex.class, (IStorageSystem)projectStorageSystem, false, historyAccess), (IStorageAbbreviator)stringAbbreviator));
        transactionalStorageSystem.commit();
        int chunkLength = byPathIndex.getChunkLength();
        for (int i = 0; i < files.size(); ++i) {
            if (i % 100 == 0) {
                this.reportProgress(i, files.size());
            }
            transactionalStorageSystem.rollback();
            try {
                this.detectClones(files.get(i), chunkLength, byPathIndex, byHashIndex, parameters.minLength, ExternalXCloneTrigger.getFileIncludedPredicate(parameters.uniformPath, projectStorageSystem, historyAccess));
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error during detection against " + files.get(i).getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Predicate<String> getFileIncludedPredicate(String uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws ConQATException {
        if (ArchitectureMetricsUtils.isArchitectureArtifactPath(uniformPath)) {
            Set<String> sourceFiles = ArchitectureMetricsUtils.getArchitectureFreeSourcePaths(uniformPath, projectStorageSystem, historyAccessOption);
            return sourceFiles::contains;
        }
        return fileName -> fileName.startsWith(uniformPath);
    }

    private void detectClones(File file, int chunkLength, CloneChunkByPathIndex byPathIndex, CloneChunkByHashIndex byHashIndex, int minCloneLength, Predicate<String> isFileIncluded) throws IOException, ConQATException {
        String content = FileSystemUtils.readFileUTF8((File)file);
        if (content.length() > FILE_SIZE_LIMIT) {
            this.sizeExcludedFiles.add(file.getAbsolutePath());
            return;
        }
        TokenElementInfo element = TokenElementInfo.createWithLocalPreprocessing(EXTERNAL_FILE, ELanguage.fromFile((File)file), content);
        byPathIndex.insertFiles(Collections.singletonList(element), chunkLength);
        ExternalXCloneTrigger.invertCloneChunkIndex(byPathIndex, byHashIndex);
        new CloneDetector(byPathIndex, byHashIndex).reportClones(Collections.singletonList(EXTERNAL_FILE), new IndexWritingCloneClassReporter(file.getAbsolutePath(), minCloneLength, isFileIncluded), minCloneLength, false);
    }

    private static void invertCloneChunkIndex(CloneChunkByPathIndex byPathIndex, CloneChunkByHashIndex byHashIndex) throws ConQATException {
        KeyDelta contentDelta = new KeyDelta(Collections.singletonList(new StorageKey(EXTERNAL_FILE)), Collections.emptyList());
        CloneChunkIndexInverter.invertCloneChunkIndex(contentDelta, byHashIndex, byPathIndex, EMPTY_BY_PATH_INDEX);
    }

    private void reportProgress(int count, int fileCount) {
        long seconds = (long)((double)(System.currentTimeMillis() - this.startTime) / 1000.0);
        this.status.setDetails("Processing file " + count + " of " + fileCount, "Detected " + this.numberOfClones + " clones so far", "Running for " + DurationUtils.formatDurationHumanReadable((Duration)Duration.ofSeconds(seconds)));
        if (count > 0) {
            long remaining = (long)((double)seconds / (double)count * (double)(fileCount - count));
            this.status.addDetails("Estimated remaining time: " + DurationUtils.formatDurationHumanReadable((Duration)Duration.ofSeconds(remaining)));
        }
    }

    private class IndexWritingCloneClassReporter
    implements ICloneClassReporter {
        private final String externalFilePath;
        private final int minCloneLength;
        private final Predicate<String> isFileIncluded;

        private IndexWritingCloneClassReporter(String externalFilePath, int minCloneLength, Predicate<String> isFileIncluded) {
            this.externalFilePath = externalFilePath;
            this.minCloneLength = minCloneLength;
            this.isFileIncluded = isFileIncluded;
        }

        @Override
        public boolean shouldReport(int normalizedLength, int numberOfClones) {
            return normalizedLength >= this.minCloneLength;
        }

        @Override
        public void report(CloneClass cloneClass) throws StorageException {
            ArrayList<Clone> clonesInExternalFile = new ArrayList<Clone>();
            ArrayList<Clone> clonesInInternalFile = new ArrayList<Clone>();
            for (Clone clone2 : cloneClass.getClones()) {
                if (clone2.getUniformPath().equals(ExternalXCloneTrigger.EXTERNAL_FILE)) {
                    if (clonesInExternalFile.size() >= 2) continue;
                    clonesInExternalFile.add(clone2);
                    continue;
                }
                if (!this.isFileIncluded.test(clone2.getUniformPath())) continue;
                clonesInInternalFile.add(clone2);
            }
            if (clonesInExternalFile.isEmpty() || clonesInInternalFile.isEmpty()) {
                return;
            }
            int id = ExternalXCloneTrigger.this.numberOfClones++;
            if (ExternalXCloneTrigger.this.numberOfClones > 1000) {
                return;
            }
            List internalClones = CollectionUtils.map(clonesInInternalFile, clone -> new ExternalXClone(clone.getUniformPath(), clone.getLocation().getRawStartLine(), clone.getLocation().getRawEndLine()));
            List externalClones = CollectionUtils.map(clonesInExternalFile, clone -> new ExternalXClone(this.externalFilePath, clone.getLocation().getRawStartLine(), clone.getLocation().getRawEndLine()));
            ExternalXCloneClass externalCloneClass = new ExternalXCloneClass(id, cloneClass.getNormalizedLength(), internalClones, externalClones);
            ExternalXCloneTrigger.this.externalXCloneIndex.addCloneClass(externalCloneClass);
        }
    }
}

