/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.snapshot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.index.backup.AutoBackupOptionBase;
import com.teamscale.index.backup.snapshot.AutoStorageSnapshotTrigger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="schedule.snapshot-backup", name="Automatic Storage System Snapshots", type=EOptionType.SERVER, category=EOptionCategory.BACKUP)
@IndexValueClass(containedInBackup=true)
public class AutoStorageSnapshotOption
extends AutoBackupOptionBase {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "schedule.snapshot-backup";
    public static final String OPTION_NAME = "Automatic Storage System Snapshots";
    @JsonProperty(value="storageLocation")
    @OptionFieldDescription(name="Backup File Path", description="Full path or URL to store the backup ZIP into. '%t' is replaced by the current date/time stamp. '%h' is replaced by the name of the host machine. '%p' is replaced by the configured HTTPS or HTTP port. '%i' is replaced by the instance name defined in the server configuration (teamscale.properties). '%u' is replaced by the configured URL prefix.")
    public String storageLocation = this.getStorageLocationDefaultValue();
    @JsonProperty(value="updateSchedule")
    @OptionFieldDescription(name="Snapshot schedule")
    @ScheduleOption(triggerClass=AutoStorageSnapshotTrigger.class)
    public String updateSchedule = "";
    @JsonProperty(value="backupsToKeep")
    @OptionFieldDescription(name="Number of backups to keep. If this is 0, no automatic backup deletion takes place.")
    public int backupsToKeep = 0;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (this.backupsToKeep < 0) {
            return "Number of backups to keep can't be negative.";
        }
        if (this.backupsToKeep == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)this.updateSchedule)) {
            return "Backup schedule must be set if backup folder cleanup is active.";
        }
        String backupPathError = AutoStorageSnapshotOption.validateStorageLocationIsZipPath(this.storageLocation);
        if (backupPathError != null) {
            return backupPathError;
        }
        return this.validateStorageLocationContainsPlaceholders(this.storageLocation, storageInfo.getGlobalStorageSystem(), instanceConfiguration);
    }

    @Override
    protected String determineDefaultFilenamePrefix() {
        return "teamscale-storage-snapshot";
    }

    @Override
    protected String getStorageLocation() {
        return this.storageLocation;
    }
}

