/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class ChecksDescriptionsLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PROJECTS_AND_CHECKS_FILE = "projects-and-checks.json";
    private static final String PROJECTS_KEY = "projects";
    private static final String CHECKS_KEY = "checks";
    private static final String CHECK_ANALYSIS_GROUP_KEY = "analysis-group";
    private static final String CHECK_ID_KEY = "id";

    public static void loadCheckDescriptions(Function<String, Optional<String>> readCheckDescription, IndexLayer indexLayer, File folderForCheckJsonSpecification) {
        File projectsAndChecksFile = TeamscaleInstallationUtils.locateConfigFile((String)PROJECTS_AND_CHECKS_FILE).orElse(null);
        if (projectsAndChecksFile == null && !(projectsAndChecksFile = new File(folderForCheckJsonSpecification, PROJECTS_AND_CHECKS_FILE)).exists()) {
            return;
        }
        LOGGER.info("Found projects and checks JSON file: " + projectsAndChecksFile.getAbsolutePath());
        try {
            String fileJsonContents = FileSystemUtils.readFileUTF8((File)projectsAndChecksFile);
            ArrayNode loadingSpecifications = (ArrayNode)CCSMAssert.checkedCast((Object)JsonUtils.deserializeFromJson((String)fileJsonContents), ArrayNode.class);
            Iterator loadingSpecificationsIt = loadingSpecifications.elements();
            while (loadingSpecificationsIt.hasNext()) {
                ChecksDescriptionsLoader.processLoadingSpecification(readCheckDescription, indexLayer, (JsonNode)loadingSpecificationsIt.next());
            }
        }
        catch (IOException | JsonSerializationException | StorageException e) {
            LOGGER.error("Could not process json override specs: " + String.valueOf(e));
        }
    }

    private static void processLoadingSpecification(Function<String, Optional<String>> readCheckDescription, IndexLayer indexLayer, JsonNode loadSpecificationNode) throws StorageException {
        Iterator projectsNodeIt = loadSpecificationNode.get(PROJECTS_KEY).elements();
        while (projectsNodeIt.hasNext()) {
            String projectId = ((JsonNode)projectsNodeIt.next()).asText();
            CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)new PublicProjectId(projectId));
            Iterator checksNodeIt = loadSpecificationNode.get(CHECKS_KEY).elements();
            ArrayList<String> checkTypeIds = new ArrayList<String>();
            ArrayList<String> newDescriptions = new ArrayList<String>();
            while (checksNodeIt.hasNext()) {
                JsonNode checkNode = (JsonNode)checksNodeIt.next();
                String analysisGroup = checkNode.get(CHECK_ANALYSIS_GROUP_KEY).asText();
                String checkName = FileSystemUtils.toValidFileName((String)checkNode.get(CHECK_ID_KEY).asText());
                String typeId = IndexFinding.makeFindingTypeId((String)analysisGroup, (String)checkName);
                checkTypeIds.add(typeId);
                readCheckDescription.apply(checkName).ifPresent(newDescriptions::add);
            }
            ChecksDescriptionsLoader.saveUpdatedDescriptionsIntoSchema(projectStorageSystem, checkTypeIds, newDescriptions);
        }
    }

    private static void saveUpdatedDescriptionsIntoSchema(CommitResolvingStorageSystem projectStorageSystem, List<String> checkTypeIds, List<String> newDescriptions) throws StorageException {
        FindingsSchemaIndex findingsSchemaIndex = (FindingsSchemaIndex)projectStorageSystem.openProjectIndex(FindingsSchemaIndex.class, null);
        for (CodeScopeName codeScope : ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem).getCodeScopeNames()) {
            ChecksDescriptionsLoader.saveUpdatedDescriptionsIntoSchema(checkTypeIds, newDescriptions, findingsSchemaIndex, codeScope);
        }
    }

    private static void saveUpdatedDescriptionsIntoSchema(List<String> checkTypeIds, List<String> newDescriptions, FindingsSchemaIndex findingsSchemaIndex, CodeScopeName codeScope) throws StorageException {
        Map oldFindingTypeDescriptions = findingsSchemaIndex.getFindingTypeDescriptions(checkTypeIds, codeScope);
        PairList newFindingTypeDescriptions = new PairList();
        for (Pair entry : CollectionUtils.zip(checkTypeIds, newDescriptions)) {
            String typeId = (String)entry.getFirst();
            String newDescription = (String)entry.getSecond();
            FindingTypeDescription oldFindingTypeDescription = (FindingTypeDescription)oldFindingTypeDescriptions.get(typeId);
            FindingTypeDescription newFindingTypeDescription = new FindingTypeDescription(oldFindingTypeDescription.getName(), newDescription, oldFindingTypeDescription.getTool());
            oldFindingTypeDescription.getPropertyDescriptions().forEach((arg_0, arg_1) -> ((FindingTypeDescription)newFindingTypeDescription).setPropertyDescription(arg_0, arg_1));
            newFindingTypeDescriptions.add((Object)typeId, (Object)newFindingTypeDescription);
        }
        findingsSchemaIndex.setFindingTypeDescriptions(codeScope, newFindingTypeDescriptions);
    }
}

