/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection.abap;

import com.teamscale.index.code_change.refactoring_detection.ELocalRefactoringDetectionResult;
import com.teamscale.index.code_change.refactoring_detection.MethodRefactoringDetectorStrategyBase;
import com.teamscale.index.code_change.refactoring_detection.ParallelTokenListIterator;
import com.teamscale.index.code_change.refactoring_detection.RenameDetector;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.conqat.engine.sourcecode.pattern.EnumPatternMatcher;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.algo.Diff;

public class AbapMethodRefactoringDetectorStrategy
extends MethodRefactoringDetectorStrategyBase {
    private static final String REGEX_ENCLOSING_QUOTE = "('([^']*)'|`([^`]*)`)";
    private static final TokenTypePattern SINGLE_PARAMETER_METHOD_CALL_PATTERN = new TokenTypePattern("(?:<ARROW>|<EQGT>)<IDENTIFIER><LPAREN>(<IDENTIFIER><EQ>).<RPAREN>");

    public AbapMethodRefactoringDetectorStrategy(RenameDetector renameDetector) {
        super(ELanguage.ABAP, renameDetector);
    }

    @Override
    protected EnumSet<ETokenType> getRenameableTokenTypes() {
        return EnumSet.of(ETokenType.IDENTIFIER, ETokenType.CHARACTER_LITERAL, ETokenType.STRING_LITERAL);
    }

    @Override
    protected boolean isMethodInvocation(ParallelTokenListIterator tokenListIterator) {
        return tokenListIterator.bothMatchTypeSequence(-1, ETokenType.EQGT, ETokenType.IDENTIFIER) || tokenListIterator.bothMatchTypeSequence(-2, ETokenType.EQGT, ETokenType.LPAREN, ETokenType.CHARACTER_LITERAL) || tokenListIterator.bothMatchTypeSequence(-2, ETokenType.EQGT, ETokenType.LPAREN, ETokenType.STRING_LITERAL) || tokenListIterator.bothMatchTypeSequence(-1, ETokenType.ARROW, ETokenType.IDENTIFIER) || tokenListIterator.bothMatchTypeSequence(-2, ETokenType.ARROW, ETokenType.LPAREN, ETokenType.CHARACTER_LITERAL) || tokenListIterator.bothMatchTypeSequence(-2, ETokenType.ARROW, ETokenType.LPAREN, ETokenType.STRING_LITERAL) || tokenListIterator.bothMatchTypeSequence(-1, ETokenType.SUBMIT, ETokenType.IDENTIFIER) || tokenListIterator.bothMatchTypeSequence(-1, ETokenType.MODULE, ETokenType.IDENTIFIER) || tokenListIterator.bothMatchTypeSequence(-3, ETokenType.ARROW, ETokenType.IDENTIFIER, ETokenType.TILDE, ETokenType.IDENTIFIER) || tokenListIterator.bothMatchTypeSequence(-1, ETokenType.PERFORM, ETokenType.IDENTIFIER) || tokenListIterator.bothMatchTypeSequence(-2, ETokenType.CALL, ETokenType.FUNCTION, ETokenType.STRING_LITERAL) || tokenListIterator.bothMatchTypeSequence(-2, ETokenType.CALL, ETokenType.FUNCTION, ETokenType.CHARACTER_LITERAL);
    }

    @Override
    protected ELocalRefactoringDetectionResult detectMethodRename(ParallelTokenListIterator tokenListIterator) {
        if (this.isMethodInvocation(tokenListIterator)) {
            String oldMethodName = tokenListIterator.getOldTokenText().toLowerCase().replaceAll(REGEX_ENCLOSING_QUOTE, "$2$3");
            String newMethodName = tokenListIterator.getNewTokenText().toLowerCase().replaceAll(REGEX_ENCLOSING_QUOTE, "$2$3");
            return this.detectMethodRename(oldMethodName, newMethodName);
        }
        return ELocalRefactoringDetectionResult.NO_DECISION;
    }

    @Override
    protected ELocalRefactoringDetectionResult detectVariableRename(ParallelTokenListIterator tokenListIterator) {
        if (tokenListIterator.bothMatchTypeSequence(-1, ETokenType.LT, ETokenType.IDENTIFIER, ETokenType.GT)) {
            TypedVariable oldVariable = tokenListIterator.getOldTypeInfo("<" + tokenListIterator.getOldTokenText() + ">");
            TypedVariable newVariable = tokenListIterator.getNewTypeInfo("<" + tokenListIterator.getNewTokenText() + ">");
            return this.detectVariableRename(tokenListIterator, oldVariable, newVariable);
        }
        return super.detectVariableRename(tokenListIterator);
    }

    @Override
    protected boolean childrenDeltaContainsRefactoringsOnly(Diff.Delta<ShallowEntity> delta) {
        return false;
    }

    @Override
    protected EnumSet<ETokenType> getIgnoredTokenTypes() {
        return EnumSet.of(ETokenType.CHANGING, ETokenType.IMPORTING, ETokenType.EXPORTING, ETokenType.RECEIVING);
    }

    @Override
    protected boolean areStatementsEqual(ShallowEntity oldEntity, List<IToken> oldTokens, ShallowEntity newEntity, List<IToken> newTokens) {
        List<IToken> normalizedOldTokens = AbapMethodRefactoringDetectorStrategy.normalizeSingleParameterMethodCalls(oldTokens);
        List<IToken> normalizedNewTokens = AbapMethodRefactoringDetectorStrategy.normalizeSingleParameterMethodCalls(newTokens);
        return super.areStatementsEqual(oldEntity, normalizedOldTokens, newEntity, normalizedNewTokens);
    }

    private static List<IToken> normalizeSingleParameterMethodCalls(List<IToken> oldTokens) {
        EnumPatternMatcher matcher = SINGLE_PARAMETER_METHOD_CALL_PATTERN.matcher(oldTokens);
        if (!matcher.find()) {
            return oldTokens;
        }
        ArrayList<IToken> result = new ArrayList<IToken>(oldTokens);
        result.subList(matcher.start(1), matcher.end(1)).clear();
        return result;
    }
}

