/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import com.teamscale.index.code_clones.core.TokenUnit;
import com.teamscale.index.code_clones.normalization.AbapNormalizer;
import com.teamscale.index.code_clones.normalization.CLikeNormalizer;
import com.teamscale.index.code_clones.normalization.CppNormalizer;
import com.teamscale.index.code_clones.normalization.CsNormalizer;
import com.teamscale.index.code_clones.normalization.GenericNormalizer;
import com.teamscale.index.code_clones.normalization.ITokenNormalizer;
import com.teamscale.index.code_clones.normalization.WorkItemNormalizer;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class StatementNormalizationConfiguration {
    private static final Set<ETokenType> JAVASCRIPT_VARIABLE = EnumSet.of(ETokenType.VAR, ETokenType.LET, ETokenType.CONST);
    private static final Map<ELanguage, Predicate<List<TokenUnit>>> STATEMENT_PREDICATES = StatementNormalizationConfiguration.createStatementPredicatesMap();
    private static final Map<ELanguage, ITokenNormalizer> TOKEN_NORMALIZERS = CollectionUtils.asMap(new EnumMap(ELanguage.class), (Pair[])new Pair[]{Pair.createPair((Object)ELanguage.ABAP, (Object)new AbapNormalizer()), Pair.createPair((Object)ELanguage.CS, (Object)new CsNormalizer()), Pair.createPair((Object)ELanguage.CPP, (Object)new CppNormalizer()), Pair.createPair((Object)ELanguage.CPP_MS_CLI, (Object)new CppNormalizer()), Pair.createPair((Object)ELanguage.C, (Object)new CppNormalizer()), Pair.createPair((Object)ELanguage.NL_REQUIREMENTS, (Object)new WorkItemNormalizer()), Pair.createPair((Object)ELanguage.NL_TESTS, (Object)new WorkItemNormalizer()), Pair.createPair((Object)ELanguage.NL_ISSUES, (Object)new WorkItemNormalizer())});
    private static final Map<ELanguage, Function<List<IToken>, Integer>> START_INDEX_FINDERS = CollectionUtils.asMap(new EnumMap(ELanguage.class), (Pair[])new Pair[]{Pair.createPair((Object)ELanguage.COBOL, StatementNormalizationConfiguration::findCobolStartIndex)});
    private static final Map<ELanguage, Set<String>> METHOD_NAMES_FOR_CONSERVATIVE_NORMALIZATION;
    private static final Predicate<List<TokenUnit>> DEFAULT_STATEMENT_PREDICATE;
    private static final ITokenNormalizer DEFAULT_NORMALIZER;
    private static final ITokenNormalizer DEFAULT_CLIKE_NORMALIZER;
    private static final Function<List<IToken>, Integer> DEFAULT_START_INDEX_FINDER;

    private static UnmodifiableMap<ELanguage, Predicate<List<TokenUnit>>> createStatementPredicatesMap() {
        EnumMap<ELanguage, Predicate<List<TokenUnit>>> map = new EnumMap<ELanguage, Predicate<List<TokenUnit>>>(ELanguage.class);
        map.put(ELanguage.ADA, StatementNormalizationConfiguration.skipByFirstTokenType(ETokenType.WITH, ETokenType.USE, ETokenType.END));
        map.put(ELanguage.CS, StatementNormalizationConfiguration::isCsStatementIncluded);
        Predicate<List<TokenUnit>> cppPredicate = StatementNormalizationConfiguration.skipByFirstTokenType(ETokenType.PREPROCESSOR_INCLUDE);
        map.put(ELanguage.CPP, cppPredicate);
        map.put(ELanguage.CPP_MS_CLI, cppPredicate);
        map.put(ELanguage.C, cppPredicate);
        map.put(ELanguage.OPEN_CL, cppPredicate);
        Predicate<List<TokenUnit>> javaPredicate = StatementNormalizationConfiguration.skipByFirstTokenType(ETokenType.IMPORT, ETokenType.PACKAGE);
        map.put(ELanguage.JAVA, javaPredicate);
        map.put(ELanguage.XTEND, javaPredicate);
        map.put(ELanguage.GROOVY, javaPredicate);
        map.put(ELanguage.JAVASCRIPT, StatementNormalizationConfiguration::isJavaScriptStatementIncluded);
        map.put(ELanguage.VB, StatementNormalizationConfiguration.skipByFirstTokenType(ETokenType.IMPORTS));
        map.put(ELanguage.PYTHON, StatementNormalizationConfiguration::isPythonStatementIncluded);
        return CollectionUtils.asUnmodifiable(map);
    }

    private static Predicate<List<TokenUnit>> skipByFirstTokenType(ETokenType ... skippedStartTypes) {
        EnumSet<ETokenType> skipped = EnumSet.noneOf(ETokenType.class);
        Collections.addAll(skipped, skippedStartTypes);
        return tokens -> !skipped.contains(((TokenUnit)tokens.get(0)).getType());
    }

    private static boolean isJavaScriptStatementIncluded(List<TokenUnit> units) {
        if (StatementNormalizationConfiguration.unitCheck(units, 0, ETokenType.IDENTIFIER, "goog") && StatementNormalizationConfiguration.unitCheck(units, 1, ETokenType.DOT, ".") && StatementNormalizationConfiguration.unitCheck(units, 1, ETokenType.IDENTIFIER, "require")) {
            return false;
        }
        return units.isEmpty() || !JAVASCRIPT_VARIABLE.contains(units.get(0).getType()) || !CollectionUtils.anyMatch(units, unit -> unit.getType() == ETokenType.IDENTIFIER && unit.getUnnormalizedContent().equals("require"));
    }

    private static boolean isCsStatementIncluded(List<TokenUnit> units) {
        return units.size() < 1 || units.get(0).getType() != ETokenType.USING || units.stream().anyMatch(unit -> unit.getType() == ETokenType.NEW);
    }

    private static boolean isPythonStatementIncluded(List<TokenUnit> units) {
        for (TokenUnit unit : units) {
            ETokenType type = unit.getType();
            if (type.getTokenClass() == ETokenType.ETokenClass.SYNTHETIC) continue;
            return type != ETokenType.IMPORT && type != ETokenType.FROM;
        }
        return false;
    }

    private static boolean unitCheck(List<TokenUnit> units, int index, ETokenType type, String text) {
        return index < units.size() && units.get(index).getType() == type && units.get(index).getUnnormalizedContent().equals(text);
    }

    private static int findCobolStartIndex(List<IToken> tokens) {
        int procedureDivisionStatementStart = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.PROCEDURE, ETokenType.DIVISION});
        if (procedureDivisionStatementStart == -1) {
            return tokens.size();
        }
        int procedureDivisionStatementEnd = TokenStreamUtils.firstTokenMatching(tokens, (int)procedureDivisionStatementStart, (ITokenMatcher)ETokenType.DOT);
        if (procedureDivisionStatementEnd == -1) {
            return tokens.size();
        }
        return procedureDivisionStatementEnd + 1;
    }

    public static ITokenNormalizer getTokenNormalization(ELanguage language) {
        ITokenNormalizer normalizer = TOKEN_NORMALIZERS.get(language);
        if (normalizer != null) {
            return normalizer;
        }
        if (LanguageProperties.of((ELanguage)language).isCLike()) {
            return DEFAULT_CLIKE_NORMALIZER;
        }
        return DEFAULT_NORMALIZER;
    }

    public static Predicate<List<TokenUnit>> getStatementPredicate(ELanguage language) {
        return STATEMENT_PREDICATES.getOrDefault(language, DEFAULT_STATEMENT_PREDICATE);
    }

    public static Function<List<IToken>, Integer> getStartIndexFinder(ELanguage language) {
        return START_INDEX_FINDERS.getOrDefault(language, DEFAULT_START_INDEX_FINDER);
    }

    public static Set<String> getMethodNamesForConservativeNormalization(ELanguage language) {
        return METHOD_NAMES_FOR_CONSERVATIVE_NORMALIZATION.getOrDefault(language, Collections.emptySet());
    }

    static {
        HashSet objectiveCMethods = CollectionUtils.asHashSet((Object[])new String[]{"copy", "copyWithZone", "mutableCopy", "mutableCopyWithZone", "isEqual"});
        METHOD_NAMES_FOR_CONSERVATIVE_NORMALIZATION = CollectionUtils.asMap(new EnumMap(ELanguage.class), (Pair[])new Pair[]{Pair.createPair((Object)ELanguage.JAVA, (Object)CollectionUtils.asHashSet((Object[])new String[]{"toString", "hashCode", "equals"})), Pair.createPair((Object)ELanguage.OBJECTIVE_C, (Object)objectiveCMethods), Pair.createPair((Object)ELanguage.OBJECTIVE_CPP, (Object)objectiveCMethods)});
        DEFAULT_STATEMENT_PREDICATE = x -> true;
        DEFAULT_NORMALIZER = new GenericNormalizer();
        DEFAULT_CLIKE_NORMALIZER = new CLikeNormalizer();
        DEFAULT_START_INDEX_FINDER = x -> 0;
    }
}

