/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.binary_size.common_substrings.CommonSubstringsAnalysisStep;
import com.teamscale.index.binary_size.common_substrings.StringLiteralSubstringCloneIndex;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class BinarySizeAnalysisConfiguration
extends AnalysisConfigurationBase {
    public static final EnumSet<ELanguage> SUPPORTED_LANGUAGES = CommonSubstringsAnalysisStep.SUPPORTED_LANGUAGES;
    @ConfigExposed(name="Minimum substring clone length", description="Configures the minimum length of reported clones (in number of characters). Clones that are shorter than the configured length are ignored.\n", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public int minimumSubstringCloneLength = 8;
    @ConfigExposed(name="Minimum potential savings per clone class", description="Configures the minimum number of (estimated) bytes that can be saved per reported clone group. Groups with less potential saving will not be reported.\n\nTo compute the saving, we assume that the common substring will be extracted to one shared constant. Therefore, it will be stored only once in the binary.\nAt the clone sites, the cost decreases by the length of the clone and increases for an additional null terminator and string-concatenation operators.\n", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public int minimumPotentialSavingsPerCloneClass = 10;
    @ConfigExposed(name="Architecture path for intra component analysis", description="The path of a teamscale architecture in the project. If given, the analysis will report substring clones only if all clones of the clone class are in the same architecture component.\nNote that the analysis expects that each file is mapped to at most one component. If a file is mapped to more than one component, the analysis ignores all but the alphabetically first component.\n", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public String architecturePathForIntraComponentAnalysis = "";
    private final FindingDescriptor substringCloneFinding = new FindingDescriptor("Substring clone", EAnalysisTool.TEAMSCALE, CommonSubstringsAnalysisStep.SUPPORTED_LANGUAGES, EFindingEnablement.OFF, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-string-literal-substring-clone.md").orElseThrow());
    private final Set<ConfigurationItemBase> substringCloneFindingConfigItems = new LinkedHashSet<FindingDescriptor>(List.of(this.substringCloneFinding));

    public BinarySizeAnalysisConfiguration() {
        this.autoExpose();
        this.substringCloneFindingConfigItems.add((ConfigurationItemBase)this.getOptionForField("minimumSubstringCloneLength"));
        this.substringCloneFindingConfigItems.add((ConfigurationItemBase)this.getOptionForField("minimumPotentialSavingsPerCloneClass"));
        this.substringCloneFindingConfigItems.add((ConfigurationItemBase)this.getOptionForField("architecturePathForIntraComponentAnalysis"));
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (CollectionUtils.intersectionSet(languages, (Collection[])new Collection[]{CommonSubstringsAnalysisStep.SUPPORTED_LANGUAGES}).isEmpty()) {
            return;
        }
        template.registerConfigurationItems("Binary Size", "Efficiency", this.substringCloneFindingConfigItems);
    }

    protected void configureProjectInternal(ProjectCreationProxy projectCreationProxy) throws ProjectConfigurationException {
        projectCreationProxy.addFindingsSchemaEntry("Efficiency", this.substringCloneFinding.getName(), this.substringCloneFinding);
        projectCreationProxy.createProjectIndex(StringLiteralSubstringCloneIndex.class);
        projectCreationProxy.createTrigger(this.configureTrigger());
    }

    private TriggerBuilder configureTrigger() {
        TriggerBuilder triggerBuilder = new TriggerBuilder(CommonSubstringsAnalysisStep.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setTriggerParameter("minimum-substring-clone-length", ITriggerParameter.of((int)this.minimumSubstringCloneLength));
        triggerBuilder.setTriggerParameter("minimum-potential-savings", ITriggerParameter.of((int)this.minimumPotentialSavingsPerCloneClass));
        triggerBuilder.setTriggerParameter("architecture-path-for-intra-component-analysis", ITriggerParameter.of((String)this.architecturePathForIntraComponentAnalysis));
        return triggerBuilder;
    }
}

