/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.testcoverage.BranchCoverageMetricSynchronizer;
import com.teamscale.index.testcoverage.CoverageMetricSynchronizerBase;
import com.teamscale.index.testcoverage.LineCoverageMetricSynchronizer;
import com.teamscale.index.testcoverage.McDcCoverageMetricSynchronizer;
import com.teamscale.index.testcoverage.MethodCoverageMetricSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class TestCoverageConfiguration
extends AnalysisConfigurationBase {
    private static final String METHOD_COVERAGE_METRIC_DESCRIPTION = "metric for the relative amount of functions/methods covered by at least one test. Partially covered methods are counted as fully covered.";
    private static final String EXPOSE_METHOD_COVERAGE = "Expose Absolute Method Coverage";
    private static final String EXPOSE_METHOD_COVERAGE_DESCRIPTION = "Makes the absolute numbers of coverable and of covered functions/methods visible to the end user.";
    private static final String LINE_COVERAGE_METRIC_DESCRIPTION = "metric for the relative amount of coverable lines covered by at least one test. Partially covered lines are counted as fully covered.";
    private static final String EXPOSE_LINE_COVERAGE = "Expose Absolute Line Coverage";
    private static final String EXPOSE_LINE_COVERAGE_DESCRIPTION = "Makes the absolute numbers of coverable and of covered lines visible to the end user.";
    private static final String MCDC_COVERAGE_METRIC_DESCRIPTION = "metric for the relative amount of MC/DC conditions that were met.";
    private static final String EXPOSE_MCDC_COVERAGE = "Expose Absolute MC/DC Coverage";
    private static final String EXPOSE_MCDC_COVERAGE_DESCRIPTION = "Makes the absolute numbers of coverable and of covered MC/DC conditions visible to the end user.";
    private static final String BRANCH_COVERAGE_METRIC_DESCRIPTION = "metric for the relative amount of coverable branches covered by at least one test.";
    private static final String EXPOSE_BRANCH_COVERAGE = "Expose Absolute Branch Coverage";
    private static final String EXPOSE_BRANCH_COVERAGE_DESCRIPTION = "Makes the absolute numbers of coverable and of covered branches visible to the end user.";
    private static final String ENABLES_PREFIX = "Enables a ";
    private static final String EXCLUDE_TEST_CODE = "Exclude Test Code";
    private static final String EXCLUDE_TEST_CODE_DESCRIPTION = "Exclude test code from test coverage calculation. What is considered test code can be defined with the expert parameter 'Test-code path exclude pattern' in the Advanced Settings section of the project's connector configuration(s).";
    private static final String LINE_COVERAGE_METRIC_ID = "test-coverage";
    private static final String METHOD_COVERAGE_METRIC_ID = "method-coverage";
    private static final String BRANCH_COVERAGE_METRIC_ID = "branch-coverage";
    private static final String MCDC_COVERAGE_METRIC_ID = "mcdc-coverage";
    private static final String GROUPING_SUFFIX = " Partition Grouping";
    private static final String GROUPING_DESCRIPTION = "Mapping of names of coverage metrics to regular expressions that match the upload partitions that should be grouped into this metric. Patterns match case-insensitive here. Patterns are not required to be disjunctive. Separate the name and pattern with -> and multiple name/pattern pairs with comma. Example: 'UI Test Coverage -> ui-test-.*'";
    private static final Set<EAnalysisTool> COVERAGE_TOOLS_WITH_BRANCH_COVERAGE = EnumSet.of(EAnalysisTool.CTC_TESTCOVERAGE, new EAnalysisTool[]{EAnalysisTool.BULLSEYE_TESTCOVERAGE, EAnalysisTool.JACOCO, EAnalysisTool.COBERTURA, EAnalysisTool.GCOV, EAnalysisTool.LCOV});
    @ConfigExposed(name="Line Coverage", description="Enables a metric for the relative amount of coverable lines covered by at least one test. Partially covered lines are counted as fully covered.")
    private CodeScopeAware<Boolean> enableLineCoverageMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Expose Absolute Line Coverage", description="Makes the absolute numbers of coverable and of covered lines visible to the end user.")
    private boolean exposeLineCoverageMetric = false;
    @ConfigExposed(name="Line Coverage Partition Grouping", description="Mapping of names of coverage metrics to regular expressions that match the upload partitions that should be grouped into this metric. Patterns match case-insensitive here. Patterns are not required to be disjunctive. Separate the name and pattern with -> and multiple name/pattern pairs with comma. Example: 'UI Test Coverage -> ui-test-.*'")
    private final PairList<String, String> lineCoverageGrouping = PairList.from((Object)"Line Coverage", (Object)".*");
    @ConfigExposed(name="Method Coverage", description="Enables a metric for the relative amount of functions/methods covered by at least one test. Partially covered methods are counted as fully covered.")
    private CodeScopeAware<Boolean> enableMethodCoverageMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Expose Absolute Method Coverage", description="Makes the absolute numbers of coverable and of covered functions/methods visible to the end user.")
    private boolean exposeMethodCoverageMetric = false;
    @ConfigExposed(name="Method Coverage Partition Grouping", description="Mapping of names of coverage metrics to regular expressions that match the upload partitions that should be grouped into this metric. Patterns match case-insensitive here. Patterns are not required to be disjunctive. Separate the name and pattern with -> and multiple name/pattern pairs with comma. Example: 'UI Test Coverage -> ui-test-.*'")
    private final PairList<String, String> methodCoverageGrouping = PairList.from((Object)"Method Coverage", (Object)".*");
    @ConfigExposed(name="Branch Coverage", description="Enables a metric for the relative amount of coverable branches covered by at least one test.")
    private CodeScopeAware<Boolean> enableBranchCoverageMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Expose Absolute Branch Coverage", description="Makes the absolute numbers of coverable and of covered branches visible to the end user.")
    private boolean exposeBranchCoverageMetric = false;
    @ConfigExposed(name="Branch Coverage Partition Grouping", description="Mapping of names of coverage metrics to regular expressions that match the upload partitions that should be grouped into this metric. Patterns match case-insensitive here. Patterns are not required to be disjunctive. Separate the name and pattern with -> and multiple name/pattern pairs with comma. Example: 'UI Test Coverage -> ui-test-.*'")
    private final PairList<String, String> branchCoverageGrouping = PairList.from((Object)"Branch Coverage", (Object)".*");
    @ConfigExposed(name="MC/DC Coverage", description="Enables a metric for the relative amount of MC/DC conditions that were met.")
    private CodeScopeAware<Boolean> enableMcdcCoverageMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Expose Absolute MC/DC Coverage", description="Makes the absolute numbers of coverable and of covered MC/DC conditions visible to the end user.")
    private boolean exposeMcDcCoverageMetric = false;
    @ConfigExposed(name="Exclude Test Code", description="Exclude test code from test coverage calculation. What is considered test code can be defined with the expert parameter 'Test-code path exclude pattern' in the Advanced Settings section of the project's connector configuration(s).")
    private boolean excludeTestCode = true;
    @ConfigExposed(name="MC/DC Coverage Partition Grouping", description="Mapping of names of coverage metrics to regular expressions that match the upload partitions that should be grouped into this metric. Patterns match case-insensitive here. Patterns are not required to be disjunctive. Separate the name and pattern with -> and multiple name/pattern pairs with comma. Example: 'UI Test Coverage -> ui-test-.*'")
    private final PairList<String, String> mcdcCoverageGrouping = PairList.from((Object)"MC/DC Coverage", (Object)".*");

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        boolean useMultipleCoverablePartitions = EFeatureToggle.USE_COVERABLE_LINES_FROM_COVERAGE_REPORTS.isEnabled();
        TestCoverageConfiguration.createCoverageSupportIfEnabled(this.enableLineCoverageMetric, this.exposeLineCoverageMetric, useMultipleCoverablePartitions, this.lineCoverageGrouping, "Line Coverage", LineCoverageMetricSynchronizer.class, "Lines", LINE_COVERAGE_METRIC_ID, "test-coverable-lines", "test-covered-lines", StringUtils.capitalize((String)LINE_COVERAGE_METRIC_DESCRIPTION), proxy, this.excludeTestCode, "enable-line-coverage");
        TestCoverageConfiguration.createCoverageSupportIfEnabled(this.enableMethodCoverageMetric, this.exposeMethodCoverageMetric, useMultipleCoverablePartitions, this.methodCoverageGrouping, "Method Coverage", MethodCoverageMetricSynchronizer.class, "Methods", METHOD_COVERAGE_METRIC_ID, "test-coverable-methods", "test-covered-methods", StringUtils.capitalize((String)METHOD_COVERAGE_METRIC_DESCRIPTION), proxy, this.excludeTestCode, "enable-method-coverage");
        TestCoverageConfiguration.createCoverageSupportIfEnabled(this.enableBranchCoverageMetric, this.exposeBranchCoverageMetric, useMultipleCoverablePartitions, this.branchCoverageGrouping, "Branch Coverage", BranchCoverageMetricSynchronizer.class, "Branches", BRANCH_COVERAGE_METRIC_ID, "test-coverable-branches", "test-covered-branches", StringUtils.capitalize((String)BRANCH_COVERAGE_METRIC_DESCRIPTION), proxy, this.excludeTestCode, "enable-branch-coverage");
        TestCoverageConfiguration.createCoverageSupportIfEnabled(this.enableMcdcCoverageMetric, this.exposeMcDcCoverageMetric, useMultipleCoverablePartitions, this.mcdcCoverageGrouping, "MC/DC Coverage", McDcCoverageMetricSynchronizer.class, "MC/DC criteria", MCDC_COVERAGE_METRIC_ID, "test-coverable-mcdc", "test-covered-mcdc", StringUtils.capitalize((String)MCDC_COVERAGE_METRIC_DESCRIPTION), proxy, this.excludeTestCode, "enable-mcdc-coverage");
    }

    private static void createCoverageSupportIfEnabled(CodeScopeAware<Boolean> enabled, boolean exposeMetric, boolean useMultipleCoverablePartitions, PairList<String, String> grouping, String defaultMetricName, Class<? extends CoverageMetricSynchronizerBase> triggerClass, String volumeName, String metricIdBase, String coverablePartitionBase, String coveredPartitionBase, String description, ProjectCreationProxy proxy, boolean excludeTestCode, String enablementParameterName) throws ProjectConfigurationException {
        if (!CodeScopeUtils.isOptionEnabled(enabled)) {
            return;
        }
        if (grouping.isEmpty()) {
            grouping = PairList.from((Object)defaultMetricName, (Object)".*");
        }
        ArrayList<String> patterns = new ArrayList<String>(grouping.size());
        ArrayList<String> coveredPartitions = new ArrayList<String>(grouping.size());
        ArrayList<String> coverablePartitions = new ArrayList<String>(grouping.size());
        for (int i = 0; i < grouping.size(); ++i) {
            @Nullable String input = (String)grouping.getFirst(i);
            String name = StringUtils.isEmptyOrElse((String)input, (String)defaultMetricName);
            String pattern = (String)grouping.getSecond(i);
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new ProjectConfigurationException("Could not compile pattern '" + pattern + "' for " + volumeName + " coverage metric " + name + ": " + e.getMessage(), (Throwable)e);
            }
            String metricId = TestCoverageConfiguration.appendSuffix(metricIdBase, i);
            String coveredPartition = TestCoverageConfiguration.appendSuffix(coveredPartitionBase, i);
            String coverablePartition = coverablePartitionBase;
            if (useMultipleCoverablePartitions) {
                coverablePartition = TestCoverageConfiguration.appendSuffix(coverablePartitionBase, i);
            }
            String exposedMetricNameSuffix = " (" + name + ")";
            boolean createCoverableMetric = i == 0 || useMultipleCoverablePartitions;
            TestCoverageConfiguration.addCoverageMetricSchema(proxy.getCodeMetricSchema(), new MetricDescriptor(name, name + ": " + description), coverablePartition, coveredPartition, metricId, volumeName, createCoverableMetric, exposeMetric, useMultipleCoverablePartitions, exposedMetricNameSuffix);
            patterns.add(pattern);
            coveredPartitions.add(coveredPartition);
            coverablePartitions.add(coverablePartition);
        }
        TriggerBuilder trigger = new TriggerBuilder(triggerClass, ETriggerConcurrency.PARALLEL);
        TestCoverageConfiguration.addBlockParametersToTrigger(trigger, patterns, coveredPartitions, coverablePartitions);
        trigger.setTriggerParameter(enablementParameterName, enabled);
        trigger.setTriggerParameter("exclude-test-code", excludeTestCode);
        proxy.createTrigger(trigger);
    }

    private static String appendSuffix(String name, int suffix) {
        if (suffix > 0) {
            return name + suffix;
        }
        return name;
    }

    private static void addBlockParametersToTrigger(TriggerBuilder trigger, List<String> patterns, List<String> coveredPartitions, List<String> coverablePartitions) {
        if (patterns.size() != coveredPartitions.size() || coveredPartitions.size() != coverablePartitions.size()) {
            throw new IllegalArgumentException("All values must have the same size");
        }
        trigger.setTriggerParameter("coverage-partition-group", ITriggerParameter.of(coveredPartitions));
        trigger.setTriggerParameter("coverable-partition", ITriggerParameter.of(coverablePartitions));
        trigger.setTriggerParameter("coverage-partition-pattern", ITriggerParameter.of(patterns));
    }

    private static void addCoverageMetricSchema(MetricSchemaProxy schema, MetricDescriptor coverageMetric, String coverableVolumePartition, String coveredVolumePartition, String coverageMetricName, String volumeName, boolean createCoverableMetric, boolean exposeMetric, boolean useMultipleCoverablePartitions, String exposedMetricNameSuffix) throws ProjectConfigurationException {
        if (createCoverableMetric) {
            String displayName = "Coverable " + volumeName;
            if (useMultipleCoverablePartitions) {
                displayName = displayName + exposedMetricNameSuffix;
            }
            schema.addMetric(coverableVolumePartition, schema.createMetricIndexSource(coverableVolumePartition), displayName, "The absolute number of coverable " + volumeName.toLowerCase(), EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, TestCoverageConfiguration.createMetricPropertiesForCoverableLines(exposeMetric));
        }
        schema.addMetric(coveredVolumePartition, schema.createMetricIndexSource(coveredVolumePartition), "Covered " + volumeName + exposedMetricNameSuffix, "The absolute number of covered " + volumeName.toLowerCase(), EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, TestCoverageConfiguration.createMetricPropertiesForCoveredLines(exposeMetric));
        schema.addMetric(coverageMetricName, schema.createRangedDivisionMetricSource(coveredVolumePartition, coverableVolumePartition, 1.0, 0.0, 1.0), coverageMetric.getName(), coverageMetric.getDescription(), EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC, EMetricProperty.LOW_IS_BAD});
    }

    private static EMetricProperty[] createMetricPropertiesForCoverableLines(boolean exposeMetric) {
        if (exposeMetric) {
            return new EMetricProperty[]{EMetricProperty.SIZE_METRIC, EMetricProperty.QUALITY_NEUTRAL};
        }
        return new EMetricProperty[]{EMetricProperty.HIDDEN};
    }

    private static EMetricProperty[] createMetricPropertiesForCoveredLines(boolean exposeMetric) {
        if (exposeMetric) {
            return new EMetricProperty[]{EMetricProperty.LOW_IS_BAD};
        }
        return new EMetricProperty[]{EMetricProperty.HIDDEN};
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (languages.isEmpty()) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        this.autoExpose(template.getCodeScope());
        this.registerConfigItemsForCoverageMetric(template, "enableLineCoverageMetric", "lineCoverageGrouping", "exposeLineCoverageMetric");
        this.registerConfigItemsForCoverageMetric(template, "enableMethodCoverageMetric", "methodCoverageGrouping", "exposeMethodCoverageMetric");
        if (!CollectionUtils.intersectionSet(tools, (Collection[])new Collection[]{COVERAGE_TOOLS_WITH_BRANCH_COVERAGE}).isEmpty()) {
            this.registerConfigItemsForCoverageMetric(template, "enableBranchCoverageMetric", "branchCoverageGrouping", "exposeBranchCoverageMetric");
        }
        if (tools.contains(EAnalysisTool.CTC_TESTCOVERAGE)) {
            this.registerConfigItemsForCoverageMetric(template, "enableMcdcCoverageMetric", "mcdcCoverageGrouping", "exposeMcDcCoverageMetric");
        }
        template.registerConfigurationItems("Test Coverage", "Testing", List.of(this.getOptionForField("excludeTestCode", template.getCodeScope())));
        template.getOrCreateQualityIndicatorTemplate("Testing").addGroup(Objects.requireNonNull(template.getAnalysisGroup("Test Coverage")));
    }

    private void registerConfigItemsForCoverageMetric(ConfigurationTemplate template, String enablementOptionName, String groupingOptionName, String exposingOptionName) {
        CodeScopeName codeScopeName = template.getCodeScope();
        template.registerConfigurationItemsCodeScopeAware("Test Coverage", "Testing", List.of(this.getOptionForField(enablementOptionName, codeScopeName)));
        template.registerConfigurationItems("Test Coverage", "Testing", List.of(this.getOptionForField(groupingOptionName, codeScopeName), this.getOptionForField(exposingOptionName, codeScopeName)));
    }
}

