/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.division_by_zero;

import com.teamscale.index.dataflow.ArithmeticExpressionTokenUtils;
import com.teamscale.index.dataflow.IntegerArithmeticExpressionEvaluator;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.division_by_zero.AdvancedIntVariableWriteHeuristic;
import com.teamscale.index.dataflow.division_by_zero.DivisionByZeroLattice;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AdvancedIntVariableWriteResolver {
    public static Optional<Integer> resolveWrite(VariableWrite assignment, ControlFlowNode node, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableName, List<VariableWrite> writes) throws ArithmeticException {
        List<IToken> tokens = node.getTokens();
        if (assignment.getType() != VariableWrite.EVariableWriteType.OTHER || tokens.isEmpty()) {
            return Optional.empty();
        }
        if (AdvancedIntVariableWriteResolver.containsDivByZero(tokens = ArithmeticExpressionTokenUtils.generateShiftOperators(tokens), statesByVariableName, statesByVariableName, node) || !ArithmeticExpressionTokenUtils.allParenthesesAreBalanced(tokens)) {
            return Optional.empty();
        }
        if (!AdvancedIntVariableWriteHeuristic.isArithmeticExpression(tokens)) {
            if (!AdvancedIntVariableWriteResolver.shouldInDecrementsBeConsidered(assignment, statesByVariableName, tokens)) {
                return Optional.empty();
            }
            return AdvancedIntVariableWriteResolver.processInDecrementsInMethodCall(assignment, tokens, statesByVariableName, writes);
        }
        if (TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.COMMA)) {
            tokens = AdvancedIntVariableWriteResolver.extractRelevantTokens(assignment, tokens);
        }
        AdvancedIntVariableWriteResolver.removeTypeInformation(assignment, node, tokens);
        HashMap<String, Integer> writesResolved = new HashMap<String, Integer>();
        Map<String, Integer> variableValues = AdvancedIntVariableWriteResolver.transformStatesMap(statesByVariableName);
        Optional<Integer> value = IntegerArithmeticExpressionEvaluator.evaluateIntegerArithmeticExpression(tokens, variableValues, writesResolved);
        AdvancedIntVariableWriteResolver.removeResolvedWrites(writes, writesResolved);
        AdvancedIntVariableWriteResolver.insertResults(variableValues, statesByVariableName, node.getId());
        return value;
    }

    public static void addExpressionsCausingDivByZero(ControlFlowNode node, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableNameIn, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableNameOut) {
        AdvancedIntVariableWriteResolver.containsDivByZero(node.getTokens(), statesByVariableNameIn, statesByVariableNameOut, node);
    }

    private static boolean containsDivByZero(List<IToken> tokens, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableNameIn, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableNameOut, ControlFlowNode node) {
        List<List<IToken>> divisors = ArithmeticExpressionTokenUtils.getAllRightSideOperands(tokens, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DIV, ETokenType.DIVEQ}));
        boolean containsDivByZero = AdvancedIntVariableWriteResolver.addZeroDivisors(divisors, statesByVariableNameIn, statesByVariableNameOut, DivisionByZeroLattice.getDivByZeroState(), node);
        List<List<IToken>> moduloDivisors = ArithmeticExpressionTokenUtils.getAllRightSideOperands(tokens, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MOD, ETokenType.MODEQ}));
        return containsDivByZero |= AdvancedIntVariableWriteResolver.addZeroDivisors(moduloDivisors, statesByVariableNameIn, statesByVariableNameOut, DivisionByZeroLattice.getModByZeroState(), node);
    }

    private static boolean addZeroDivisors(List<List<IToken>> operands, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableNameIn, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableNameOut, DivisionByZeroLattice.DivByZeroAnalysisState zeroState, ControlFlowNode node) {
        boolean containsZeroOperand = false;
        Map<String, Integer> variableValues = AdvancedIntVariableWriteResolver.transformStatesMap(statesByVariableNameIn);
        for (List<IToken> operandTokens : operands) {
            Optional<Integer> operandValue;
            if (operandTokens.isEmpty() || !AdvancedIntVariableWriteHeuristic.isPureIntegerExpression(operandTokens) || AdvancedIntVariableWriteHeuristic.containsMethodCalls(operandTokens) || !(operandValue = IntegerArithmeticExpressionEvaluator.evaluateIntegerArithmeticExpression(operandTokens, variableValues)).isPresent() || operandValue.get() != 0) continue;
            containsZeroOperand = true;
            String operandText = TokenStreamTextUtils.concatTokenTexts(operandTokens, (String)" ");
            statesByVariableNameOut.put(operandText, zeroState);
            node.getReadWriteInfo().getReads().add(operandText);
        }
        return containsZeroOperand;
    }

    private static Map<String, Integer> transformStatesMap(Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableName) {
        HashMap<String, Integer> transformedMap = new HashMap<String, Integer>();
        for (Map.Entry<String, DivisionByZeroLattice.DivByZeroAnalysisState> variable : statesByVariableName.entrySet()) {
            if (variable.getValue().getState() != DivisionByZeroLattice.EVariableState.INT_VALUE) continue;
            transformedMap.put(variable.getKey(), variable.getValue().getValue());
        }
        return transformedMap;
    }

    private static void insertResults(Map<String, Integer> variableValues, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableName, int nodeId) {
        for (Map.Entry<String, Integer> variable : variableValues.entrySet()) {
            statesByVariableName.put(variable.getKey(), DivisionByZeroLattice.getValueState(variable.getValue(), nodeId));
        }
    }

    private static void removeResolvedWrites(List<VariableWrite> writes, Map<String, Integer> writesResolved) {
        for (Map.Entry<String, Integer> entry : writesResolved.entrySet()) {
            AdvancedIntVariableWriteResolver.removeResolvedWrite(writes, entry.getKey(), entry.getValue());
        }
    }

    private static void removeResolvedWrite(List<VariableWrite> writes, String variable, int times) {
        List<VariableWrite> writesOfVariable = writes.stream().filter(w -> w.getChangedVariable().equals(variable)).toList();
        if (writesOfVariable.size() == times) {
            writes.removeAll(writesOfVariable);
        } else {
            for (int i = 0; i < times && i < writesOfVariable.size(); ++i) {
                writes.remove(writesOfVariable.get(i));
            }
        }
    }

    private static boolean shouldInDecrementsBeConsidered(VariableWrite assignment, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> states, List<IToken> tokens) {
        String variable = assignment.getChangedVariable();
        DivisionByZeroLattice.DivByZeroAnalysisState state = states.get(variable);
        return state != null && state.getState() == DivisionByZeroLattice.EVariableState.INT_VALUE && ArithmeticExpressionTokenUtils.allParenthesesAreBalanced(tokens);
    }

    private static Optional<Integer> processInDecrementsInMethodCall(VariableWrite assignment, List<IToken> tokens, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableName, List<VariableWrite> writes) {
        String variable = assignment.getChangedVariable();
        DivisionByZeroLattice.DivByZeroAnalysisState state = statesByVariableName.get(variable);
        if (state.getState() != DivisionByZeroLattice.EVariableState.INT_VALUE) {
            return Optional.empty();
        }
        List<Integer> preIncrements = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.PLUSPLUS, ETokenType.IDENTIFIER}).stream().filter(i -> ((IToken)tokens.get(i + 1)).getText().equals(variable)).toList();
        List<Integer> postIncrements = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.PLUSPLUS}).stream().filter(i -> ((IToken)tokens.get((int)i)).getText().equals(variable)).toList();
        List<Integer> preDecrements = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.MINUSMINUS, ETokenType.IDENTIFIER}).stream().filter(i -> ((IToken)tokens.get(i + 1)).getText().equals(variable)).toList();
        List<Integer> postDecrements = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.MINUSMINUS}).stream().filter(i -> ((IToken)tokens.get((int)i)).getText().equals(variable)).toList();
        int increments = preIncrements.size() + postIncrements.size();
        int decrements = preDecrements.size() + postDecrements.size();
        if (increments == 0 && decrements == 0) {
            return Optional.empty();
        }
        AdvancedIntVariableWriteResolver.removeResolvedWrite(writes, variable, increments + decrements);
        return Optional.of(state.getValue() + increments - decrements);
    }

    private static List<IToken> extractRelevantTokens(VariableWrite assignment, List<IToken> tokens) {
        ArrayList definitions = new ArrayList();
        int openParentheses = 0;
        ArrayList<IToken> currentSublist = new ArrayList<IToken>();
        block5: for (IToken token : tokens) {
            switch (token.getType()) {
                case LPAREN: {
                    ++openParentheses;
                    continue block5;
                }
                case RPAREN: {
                    --openParentheses;
                    continue block5;
                }
                case COMMA: {
                    if (openParentheses != 0) break;
                    definitions.add(currentSublist);
                    currentSublist = new ArrayList();
                    continue block5;
                }
            }
            currentSublist.add(token);
        }
        definitions.add(currentSublist);
        Optional<List> definitionTokens = definitions.stream().filter(definition -> TokenStreamTextUtils.contains((List)definition, (String)assignment.getChangedVariable())).findFirst();
        return definitionTokens.orElseGet(ArrayList::new);
    }

    private static void removeTypeInformation(VariableWrite assignment, ControlFlowNode node, List<IToken> tokens) {
        if (node.getReadWriteInfo().getDefinitions().contains(assignment)) {
            int identifierTypeDefinitionIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.SCOPE, ETokenType.IDENTIFIER});
            if (identifierTypeDefinitionIndex != -1) {
                tokens.remove(identifierTypeDefinitionIndex);
                tokens.remove(identifierTypeDefinitionIndex);
            }
            if ((identifierTypeDefinitionIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.IDENTIFIER, ETokenType.EQ})) != -1) {
                tokens.remove(identifierTypeDefinitionIndex);
            }
        }
    }
}

