/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.division_by_zero;

import com.teamscale.index.dataflow.ILattice;

public class DivisionByZeroLattice
implements ILattice<DivByZeroAnalysisState> {
    public static final DivisionByZeroLattice INSTANCE = new DivisionByZeroLattice();
    private static final DivByZeroAnalysisState UNKNOWN_STATE = new DivByZeroAnalysisState(EVariableState.UNKNOWN, -1, -1);
    private static final DivByZeroAnalysisState OTHER_STATE = new DivByZeroAnalysisState(EVariableState.OTHER, -1, -1);
    private static final DivByZeroAnalysisState DIV_BY_ZERO_STATE = new DivByZeroAnalysisState(EVariableState.DIV_BY_ZERO, -1, -1);
    private static final DivByZeroAnalysisState MOD_BY_ZERO_STATE = new DivByZeroAnalysisState(EVariableState.MOD_BY_ZERO, -1, -1);

    @Override
    public DivByZeroAnalysisState leastUpperBound(DivByZeroAnalysisState value1, DivByZeroAnalysisState value2) {
        if (value1 == UNKNOWN_STATE) {
            return value2;
        }
        if (value2 == UNKNOWN_STATE) {
            return value1;
        }
        if (value1 == OTHER_STATE) {
            return value2;
        }
        if (value2 == OTHER_STATE) {
            return value1;
        }
        if (value1 == DIV_BY_ZERO_STATE) {
            return value1;
        }
        if (value2 == DIV_BY_ZERO_STATE) {
            return value2;
        }
        if (value1 == MOD_BY_ZERO_STATE) {
            return value1;
        }
        if (value2 == MOD_BY_ZERO_STATE) {
            return value2;
        }
        if (value1.nodeId == value2.nodeId) {
            return DivisionByZeroLattice.leastUpperBoundForSameNode(value1, value2);
        }
        if (value1.nodeId < value2.nodeId) {
            return value2;
        }
        return value1;
    }

    private static DivByZeroAnalysisState leastUpperBoundForSameNode(DivByZeroAnalysisState value1, DivByZeroAnalysisState value2) {
        if (value1.creationTimeStamp < value2.creationTimeStamp) {
            return value1;
        }
        if (value1.creationTimeStamp > value2.creationTimeStamp) {
            return value2;
        }
        return new DivByZeroAnalysisState(value1.variableState, value1.variableValue, value1.nodeId, value1.creationTimeStamp - 1L);
    }

    @Override
    public DivByZeroAnalysisState getBottom() {
        return UNKNOWN_STATE;
    }

    @Override
    public Class<DivByZeroAnalysisState> getValueType() {
        return this.getBottom().getClass();
    }

    public static DivByZeroAnalysisState getUnknownState() {
        return INSTANCE.getBottom();
    }

    public static DivByZeroAnalysisState getOtherState() {
        return OTHER_STATE;
    }

    public static DivByZeroAnalysisState getValueState(int value, int nodeId) {
        return new DivByZeroAnalysisState(EVariableState.INT_VALUE, value, nodeId);
    }

    public static DivByZeroAnalysisState getDivByZeroState() {
        return DIV_BY_ZERO_STATE;
    }

    public static DivByZeroAnalysisState getModByZeroState() {
        return MOD_BY_ZERO_STATE;
    }

    public static class DivByZeroAnalysisState {
        private final int variableValue;
        private final EVariableState variableState;
        private final long creationTimeStamp;
        private final int nodeId;

        private DivByZeroAnalysisState(EVariableState variableState, int variableValue, int nodeId) {
            this.variableValue = variableValue;
            this.variableState = variableState;
            this.nodeId = nodeId;
            this.creationTimeStamp = System.currentTimeMillis();
        }

        private DivByZeroAnalysisState(EVariableState variableState, int variableValue, int nodeId, long creationTimeStamp) {
            this.variableValue = variableValue;
            this.variableState = variableState;
            this.nodeId = nodeId;
            this.creationTimeStamp = creationTimeStamp;
        }

        public EVariableState getState() {
            return this.variableState;
        }

        public int getValue() {
            return this.variableValue;
        }

        public String toString() {
            if (this.getState() == EVariableState.INT_VALUE) {
                return this.getState().toString() + "(" + this.getValue() + ")";
            }
            return this.getState().toString();
        }
    }

    public static enum EVariableState {
        UNKNOWN,
        OTHER,
        INT_VALUE,
        DIV_BY_ZERO,
        MOD_BY_ZERO;

    }
}

