/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters;

import com.teamscale.index.dataflow.DataflowConfigurationParameters;
import com.teamscale.index.dataflow.EDataflowAnalysis;
import com.teamscale.index.dataflow.filters.AssignmentInConditionFalsePositiveFilter;
import com.teamscale.index.dataflow.filters.AssignmentInLambdaDeadStoreFilter;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.filters.IdentifierBasedFalsePositiveFilter;
import com.teamscale.index.dataflow.filters.InitialVariableDeclarationDeadStoreFilter;
import com.teamscale.index.dataflow.filters.MallocAssignmentFilter;
import com.teamscale.index.dataflow.filters.MultipleSelfModificationDeadStoreFilter;
import com.teamscale.index.dataflow.filters.NullCheckBeforeDereferenceFilter;
import com.teamscale.index.dataflow.filters.NullSafeMethodsFalsePositiveFilter;
import com.teamscale.index.dataflow.filters.OverwrittenDefaultInitializationDeadStoreFilter;
import com.teamscale.index.dataflow.filters.PrefixSelfModificationDeadStoreFilter;
import com.teamscale.index.dataflow.filters.ProtectedMethodDeadStoreFilter;
import com.teamscale.index.dataflow.filters.ReadAfterAssignmentDeadStoreFilter;
import com.teamscale.index.dataflow.filters.TrivialValueDeadStoreFilter;
import com.teamscale.index.dataflow.filters.TrivialVariableDefinitionDeadStoreFilter;
import com.teamscale.index.dataflow.filters.VarReadInInfiniteLoopDeadStoreFilter;
import com.teamscale.index.dataflow.filters.abap.ReportWithFormsDeadStoreFilter;
import com.teamscale.index.dataflow.filters.c.DeadStoreOnByAddressWriteWithoutOtherWriteFilter;
import com.teamscale.index.dataflow.filters.c.DeadStoreOnOutputParameterFilter;
import com.teamscale.index.dataflow.filters.c.DeadStoreOnPointerOrReferenceFilter;
import com.teamscale.index.dataflow.filters.c.NullPointerFindingOnStatementWithLambda;
import com.teamscale.index.dataflow.filters.c.NullUseInSizeofFilter;
import com.teamscale.index.dataflow.filters.c.ParameterUnusedAttributeFilter;
import com.teamscale.index.dataflow.filters.c.PragmaUnusedParameterFilter;
import com.teamscale.index.dataflow.filters.cpp.ForwardMethodDeclarationFilter;
import com.teamscale.index.dataflow.filters.cpp.ParameterUnusedAnnotationFilter;
import com.teamscale.index.dataflow.filters.cpp.ParameterUsedInDisabledPreprocessorAlternativeFilter;
import com.teamscale.index.dataflow.filters.cpp.ScopeGuardUnusedVariableFilter;
import com.teamscale.index.dataflow.filters.cs.CsAsyncMethodFilter;
import com.teamscale.index.dataflow.filters.cs.CsCallbackParameterFilter;
import com.teamscale.index.dataflow.filters.cs.CsDelegateParameterFilter;
import com.teamscale.index.dataflow.filters.cs.CsDiscardVariableDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsEmptyDeclarationDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsEventHandlerDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsMainMethodDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsMethodArgumentLambdaDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsMoqFrameworkOutParameterDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsOutParameterFilter;
import com.teamscale.index.dataflow.filters.cs.CsOverwrittenMethodDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsSwitchTypePatternDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsTemplateMethodDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsValueAssignedToVariableDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.CsValueAssignedToVariableWithOutParameterDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.IsCastCheckDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.IsCheckNullPointerFilter;
import com.teamscale.index.dataflow.filters.cs.MethodReturnTupleDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.OutParameterInConditionFalsePositiveFilter;
import com.teamscale.index.dataflow.filters.cs.OutRefParameterDeadStoreFilter;
import com.teamscale.index.dataflow.filters.cs.StringConcatenationWithNullValue;
import com.teamscale.index.dataflow.filters.java.FinallyBlockNullPointerFilter;
import com.teamscale.index.dataflow.filters.java.InstanceofNullPointerFilter;
import com.teamscale.index.dataflow.filters.java.JavaDefaultMethodUnusedParameterFilter;
import com.teamscale.index.dataflow.filters.java.JavaMainMethodDeadStoreFilter;
import com.teamscale.index.dataflow.filters.java.JavaOverwrittenMethodDeadStoreFilter;
import com.teamscale.index.dataflow.filters.java.JavaSuppressWarningsUnusedFilter;
import com.teamscale.index.dataflow.filters.java.JavaTemplateMethodDeadStoreFilter;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class DataflowFalsePositiveFilterFactory {
    public static List<IFalsePositiveFilter> createFilters(EDataflowAnalysis analysisType, ELanguage language, DataflowConfigurationParameters config) {
        ArrayList<IFalsePositiveFilter> filters = new ArrayList<IFalsePositiveFilter>();
        switch (analysisType) {
            case DEAD_STORE: {
                DataflowFalsePositiveFilterFactory.addDeadStoreFilters(language, config, filters);
                break;
            }
            case NULL_POINTER: {
                DataflowFalsePositiveFilterFactory.addNullPointerFilters(language, config, filters);
                break;
            }
            case TAINT_GRAPH_GENERATOR: 
            case DIVISION_BY_ZERO: {
                break;
            }
            default: {
                CCSMAssert.fail((String)("No filters configured for analysis " + String.valueOf(((Object)((Object)analysisType)).getClass())));
            }
        }
        return filters;
    }

    private static void addNullPointerFilters(ELanguage language, DataflowConfigurationParameters config, List<IFalsePositiveFilter> filters) {
        switch (language) {
            case CS: {
                filters.add(new IsCheckNullPointerFilter());
                filters.add(new OutParameterInConditionFalsePositiveFilter());
                filters.add(new StringConcatenationWithNullValue());
                filters.add(new CsAsyncMethodFilter());
                break;
            }
            case JAVA: {
                filters.add(new InstanceofNullPointerFilter());
                break;
            }
            case C: 
            case CPP: 
            case CPP_MS_CLI: {
                filters.add(new NullUseInSizeofFilter());
                filters.add(new NullPointerFindingOnStatementWithLambda());
                if (!config.isIgnoreMallocAssignments()) break;
                filters.add(new MallocAssignmentFilter());
                break;
            }
        }
        if (!config.getIdentifierBasedFilters().isEmpty()) {
            filters.add(new IdentifierBasedFalsePositiveFilter((Set<String>)config.getIdentifierBasedFilters()));
        }
        if (!config.getNullSafeMethodsFilters().isEmpty()) {
            filters.add(new NullSafeMethodsFalsePositiveFilter((Set<String>)config.getNullSafeMethodsFilters()));
        }
        filters.add(new NullCheckBeforeDereferenceFilter());
        filters.add(new FinallyBlockNullPointerFilter());
        filters.add(new AssignmentInConditionFalsePositiveFilter());
    }

    private static void addDeadStoreFilters(ELanguage language, DataflowConfigurationParameters config, List<IFalsePositiveFilter> filters) {
        switch (language) {
            case ABAP: {
                filters.add(new ReportWithFormsDeadStoreFilter());
                break;
            }
            case CS: {
                filters.addAll(DataflowFalsePositiveFilterFactory.createCsFilters(config));
                break;
            }
            case JAVA: {
                filters.addAll(DataflowFalsePositiveFilterFactory.createJavaFilters(config));
                break;
            }
            case C: 
            case CPP: 
            case CPP_MS_CLI: {
                filters.add(new DeadStoreOnPointerOrReferenceFilter());
                filters.add(new DeadStoreOnOutputParameterFilter());
                filters.add(new DeadStoreOnByAddressWriteWithoutOtherWriteFilter());
                filters.add(new ParameterUsedInDisabledPreprocessorAlternativeFilter());
                filters.add(new ParameterUnusedAttributeFilter());
                filters.add(new ParameterUnusedAnnotationFilter());
                filters.add(new ScopeGuardUnusedVariableFilter());
                filters.add(new PragmaUnusedParameterFilter());
                filters.add(new ForwardMethodDeclarationFilter());
                break;
            }
        }
        if (EnumSet.of(ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.CS).contains(language)) {
            filters.addAll(DataflowFalsePositiveFilterFactory.createClikeFilters());
        }
        filters.add(new TrivialValueDeadStoreFilter(config.getTrivialValues()));
        filters.add(new OverwrittenDefaultInitializationDeadStoreFilter());
        filters.add(new TrivialVariableDefinitionDeadStoreFilter());
        filters.add(new VarReadInInfiniteLoopDeadStoreFilter());
        if (config.isIgnoreProtectedMethods()) {
            filters.add(new ProtectedMethodDeadStoreFilter());
        }
        if (config.isIgnoreAssignmentInDeclaration()) {
            filters.add(new InitialVariableDeclarationDeadStoreFilter());
        }
    }

    private static Collection<IFalsePositiveFilter> createClikeFilters() {
        ArrayList<IFalsePositiveFilter> filters = new ArrayList<IFalsePositiveFilter>();
        filters.add(new PrefixSelfModificationDeadStoreFilter());
        filters.add(new MultipleSelfModificationDeadStoreFilter());
        filters.add(new ReadAfterAssignmentDeadStoreFilter());
        filters.add(new AssignmentInLambdaDeadStoreFilter());
        return filters;
    }

    private static Collection<IFalsePositiveFilter> createJavaFilters(DataflowConfigurationParameters config) {
        ArrayList<IFalsePositiveFilter> filters = new ArrayList<IFalsePositiveFilter>();
        filters.add(new JavaMainMethodDeadStoreFilter());
        filters.add(new JavaOverwrittenMethodDeadStoreFilter());
        filters.add(new JavaSuppressWarningsUnusedFilter());
        filters.add(new JavaDefaultMethodUnusedParameterFilter());
        if (config.shouldReportUnusedStaticAndPrivateMethodParameters()) {
            filters.add(new JavaTemplateMethodDeadStoreFilter());
        }
        return filters;
    }

    private static Collection<IFalsePositiveFilter> createCsFilters(DataflowConfigurationParameters config) {
        ArrayList<IFalsePositiveFilter> filters = new ArrayList<IFalsePositiveFilter>();
        filters.add(new OutRefParameterDeadStoreFilter());
        filters.add(new IsCastCheckDeadStoreFilter());
        filters.add(new MethodReturnTupleDeadStoreFilter());
        filters.add(new CsMainMethodDeadStoreFilter());
        filters.add(new CsOverwrittenMethodDeadStoreFilter());
        filters.add(new CsEventHandlerDeadStoreFilter());
        filters.add(new CsCallbackParameterFilter());
        filters.add(new CsDelegateParameterFilter());
        filters.add(new CsValueAssignedToVariableDeadStoreFilter());
        filters.add(new CsValueAssignedToVariableWithOutParameterDeadStoreFilter());
        filters.add(new CsDiscardVariableDeadStoreFilter());
        filters.add(new CsSwitchTypePatternDeadStoreFilter());
        filters.add(new CsEmptyDeclarationDeadStoreFilter());
        filters.add(new CsMethodArgumentLambdaDeadStoreFilter());
        filters.add(new CsMoqFrameworkOutParameterDeadStoreFilter());
        filters.add(new CsOutParameterFilter());
        if (config.shouldReportUnusedStaticAndPrivateMethodParameters()) {
            filters.add(new CsTemplateMethodDeadStoreFilter());
        }
        return filters;
    }
}

