/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.dart;

import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="dart-package-paths", options={EStorageOption.BRANCHED})
public class DartPackagePathsIndex
implements IProjectIndex {
    public static final String PUBSPEC_YAML_FILENAME = "pubspec.yaml";
    private final ValueIndex<String> delegate;

    public DartPackagePathsIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void storePackageNamesForUniformPaths(PairList<String, String> packageNamesWithUniformPaths) throws StorageException {
        this.delegate.setValues(packageNamesWithUniformPaths);
    }

    public void removeStoredPackageNamesForPaths(List<String> uniformPaths) throws StorageException {
        List<String> keysToDelete = this.delegate.getAllEntries().stream().filter(entry -> uniformPaths.contains(entry.getSecond())).map(ImmutablePair::getFirst).toList();
        this.delegate.removeValues(keysToDelete);
    }

    public Optional<String> getUniformPathForPackageName(String packageName) throws StorageException {
        return Optional.ofNullable((String)this.delegate.getValue(packageName));
    }
}

