/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.IClientProvider;
import com.teamscale.index.external.input.external_storage.OutgoingExternalAnalysisSessionMetadata;
import com.teamscale.index.external.input.external_storage.OutgoingExternalStorageArchive;
import com.teamscale.index.external.input.external_storage.migration.MigratedArchivePathsIndex;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class SessionUploader
implements AutoCloseable {
    private final Logger logger;
    private final ExternalAnalysisImportSessionIndex sessionIndex;
    private final MigratedArchivePathsIndex migratedArchivePathsIndex;
    private final SupplierWithException<S3ArchiveIndex, StorageException> archiveIndexSupplier;
    private final ProjectConfiguration projectConfiguration;
    private final IClientProvider clientProvider;
    private final ConsumerWithException<EExternalStorageBackendProtocol, StorageException> scheduleChangeRetriever;
    private final Set<ExternalStorageBackend> externalStoragesWithChanges = new HashSet<ExternalStorageBackend>();
    private final Map<String, Exception> errorsBySessionId = new HashMap<String, Exception>();

    public SessionUploader(ExternalAnalysisImportSessionIndex sessionIndex, MigratedArchivePathsIndex migratedArchivePathsIndex, ProjectConfiguration projectConfiguration, SupplierWithException<S3ArchiveIndex, StorageException> archiveIndexSupplier, IClientProvider clientProvider, ConsumerWithException<EExternalStorageBackendProtocol, StorageException> scheduleChangeRetriever, Logger logger) {
        this.sessionIndex = sessionIndex;
        this.migratedArchivePathsIndex = migratedArchivePathsIndex;
        this.projectConfiguration = projectConfiguration;
        this.archiveIndexSupplier = archiveIndexSupplier;
        this.clientProvider = clientProvider;
        this.scheduleChangeRetriever = scheduleChangeRetriever;
        this.logger = logger;
    }

    public boolean processSession(ExternalAnalysisSessionInfo session) {
        Optional<ExternalStorageBackend> externalStorage = session.getTargetStorage();
        if (externalStorage.isEmpty()) {
            return true;
        }
        SessionProcessingResult sessionProcessingResult = this.tryProcessSession(session, externalStorage.get());
        sessionProcessingResult.consumeChangedExternalStorageOrError(this.externalStoragesWithChanges::add, error -> this.errorsBySessionId.put(session.getSessionId(), (Exception)error));
        return sessionProcessingResult.isSuccess();
    }

    private SessionProcessingResult tryProcessSession(ExternalAnalysisSessionInfo session, ExternalStorageBackend externalStorage) {
        try {
            boolean shouldRetrieveChanges;
            this.logger.info("Using write commit: {}", (Object)session.getCommit());
            String newUploadedPath = this.uploadSession(session, externalStorage);
            boolean bl = shouldRetrieveChanges = externalStorage.backendProtocol() != EExternalStorageBackendProtocol.S3 || this.storeChangedPathInIncrementalScanIndex(newUploadedPath);
            if (!shouldRetrieveChanges) {
                this.logger.warn("Upload from session '{}' will only be available after next reanalysis.", (Object)session.getSessionId());
                return SessionProcessingResult.ofSuccessWithoutChanges();
            }
            return SessionProcessingResult.ofSuccessWithChanges(externalStorage);
        }
        catch (Exception e) {
            return SessionProcessingResult.ofFailure(e);
        }
    }

    private boolean storeChangedPathInIncrementalScanIndex(String newPathToScan) throws StorageException {
        try {
            ((S3ArchiveIndex)((Object)this.archiveIndexSupplier.get())).runWithIncrementalScanLock(lockedIndex -> lockedIndex.addKeysForIncrementalScan(Collections.singleton(newPathToScan)));
        }
        catch (StorageException e) {
            if (e.getMessage().contains("No schema entry for store")) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private String uploadSession(ExternalAnalysisSessionInfo session, ExternalStorageBackend externalStorage) throws RepositoryException, StorageException, ProjectConfigurationException, IOException {
        SimpleArtifactStoreClientBase<?> client = this.clientProvider.createClient(externalStorage);
        OutgoingExternalStorageArchive archive = this.storeArchive(session, externalStorage, client);
        this.storeMetadata(session, externalStorage, client, archive);
        this.sessionIndex.deleteSession(session.getSessionId());
        return archive.getTargetPath();
    }

    private void storeMetadata(ExternalAnalysisSessionInfo session, ExternalStorageBackend externalStorage, SimpleArtifactStoreClientBase<?> client, OutgoingExternalStorageArchive archive) throws RepositoryException, IOException {
        OutgoingExternalAnalysisSessionMetadata metadata = OutgoingExternalAnalysisSessionMetadata.create(session, archive);
        this.logger.traceEntry("Storing metadata file with {} bytes at '{}'.", new Object[]{metadata.getContentSizeInBytes(), metadata.getTargetPath()});
        client.putFile(externalStorage.repositoryOrBucketName(), metadata);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = session::getSessionId;
        supplierArray[1] = metadata::getTargetPath;
        this.logger.info("Stored metadata for session {} successfully at '{}'.", supplierArray);
        this.logger.traceExit("Successfully stored metadata file at '{}'.", (Object)metadata.getTargetPath());
    }

    private OutgoingExternalStorageArchive storeArchive(ExternalAnalysisSessionInfo session, ExternalStorageBackend externalStorage, SimpleArtifactStoreClientBase<?> client) throws IOException, StorageException, RepositoryException {
        OutgoingExternalStorageArchive archive = new OutgoingExternalStorageArchive(session, this.projectConfiguration, this.getRawReports(this.sessionIndex, session));
        this.logger.traceEntry("Storing external analysis data archive with {} bytes at '{}'.", new Object[]{archive.getContentSizeInBytes(), archive.getTargetPath()});
        this.storeMigratedPath(session, archive);
        client.putFile(externalStorage.repositoryOrBucketName(), archive);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = session::getSessionId;
        supplierArray[1] = archive::getTargetPath;
        this.logger.info("Stored archive for session {} successfully at '{}'.", supplierArray);
        return (OutgoingExternalStorageArchive)this.logger.traceExit("Successfully stored external analysis data archive '{}'.", (Object)archive);
    }

    private void storeMigratedPath(ExternalAnalysisSessionInfo session, OutgoingExternalStorageArchive archive) throws StorageException {
        if (!session.isMigrated()) {
            return;
        }
        if (this.migratedArchivePathsIndex.wasMigrated(archive.getTargetPath())) {
            throw new StorageException("Skipping upload of archive '%s' as it was already migrated by a previous migration or another project.".formatted(archive.getTargetPath()));
        }
        try {
            this.migratedArchivePathsIndex.addMigratedPath(archive.getTargetPath());
        }
        catch (StorageException e) {
            this.logger.atError().withThrowable((Throwable)e).log("Failed to store migrated archive path '{}'. Session '{}' will not be migrated to avoid a rollback.", (Object)archive.getTargetPath(), (Object)session.getSessionId());
            throw e;
        }
    }

    private Collection<ExternalAnalysisImportInfoReport> getRawReports(ExternalAnalysisImportSessionIndex sessionIndex, ExternalAnalysisSessionInfo session) throws StorageException {
        return sessionIndex.getImportInfos(session).values().stream().flatMap(importInfos -> importInfos.getInfos().stream().filter(this::isRawReportPath)).map(report -> (ExternalAnalysisImportInfoReport)report).toList();
    }

    private boolean isRawReportPath(ExternalAnalysisImportInfo<?> info) {
        String uniformPath = info.getUniformPath();
        if (ExternalAnalysisImportInfoReport.isRawReportPath(uniformPath)) {
            return true;
        }
        this.logger.error("External uploads contained a pre-parsed report for the uniform path '{}'. This trigger can only handle raw reports, hence this upload will be ignored. This probably happened because a service implementation pre-parsed the report. Please report this to the Teamscale support if possible.", (Object)uniformPath);
        return false;
    }

    @Override
    public void close() throws RepositoryException, RescheduleRequestedException {
        this.scheduleChangeRetrievers(this.externalStoragesWithChanges);
        SessionUploader.throwAggregatedErrorsIfNotEmpty(this.errorsBySessionId);
    }

    private void scheduleChangeRetrievers(Set<ExternalStorageBackend> externalStoragesWithChanges) {
        for (ExternalStorageBackend externalStorage : externalStoragesWithChanges) {
            try {
                this.scheduleChangeRetriever.accept((Object)externalStorage.backendProtocol());
            }
            catch (StorageException e) {
                this.logger.atError().withThrowable((Throwable)e).log("Failed to schedule change retriever for external storage '{}'. Changes may only be available after re-analysis.", (Object)externalStorage.externalStorageBackendName());
            }
        }
    }

    private static void throwAggregatedErrorsIfNotEmpty(Map<String, Exception> errorsBySessionId) throws RepositoryException {
        if (errorsBySessionId.isEmpty()) {
            return;
        }
        RepositoryException aggregatedException = new RepositoryException("Failed to upload session(s) [%s].".formatted(String.join((CharSequence)", ", errorsBySessionId.keySet())));
        errorsBySessionId.values().forEach(aggregatedException::addSuppressed);
        throw aggregatedException;
    }

    private record SessionProcessingResult(@Nullable ExternalStorageBackend changedExternalStorage, @Nullable Exception exception) {
        private static SessionProcessingResult ofSuccessWithChanges(ExternalStorageBackend changedExternalStorage) {
            return new SessionProcessingResult(changedExternalStorage, null);
        }

        private static SessionProcessingResult ofSuccessWithoutChanges() {
            return new SessionProcessingResult(null, null);
        }

        private static SessionProcessingResult ofFailure(Exception exception) {
            return new SessionProcessingResult(null, exception);
        }

        public boolean isSuccess() {
            return this.exception == null;
        }

        public void consumeChangedExternalStorageOrError(Consumer<ExternalStorageBackend> changedExternalStorageConsumer, Consumer<Exception> errorConsumer) {
            if (this.exception != null) {
                errorConsumer.accept(this.exception);
                return;
            }
            if (this.changedExternalStorage != null) {
                changedExternalStorageConsumer.accept(this.changedExternalStorage);
            }
        }
    }
}

