/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.status;

import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultCompileCommand;
import com.teamscale.index.external.result.ExternalAnalysisResultDependencyInfo;
import com.teamscale.index.external.result.ExternalAnalysisResultExecutionUnit;
import com.teamscale.index.external.result.ExternalAnalysisResultFindings;
import com.teamscale.index.external.result.ExternalAnalysisResultIssues;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResultMetricSchemaChange;
import com.teamscale.index.external.result.ExternalAnalysisResultMetrics;
import com.teamscale.index.external.result.ExternalAnalysisResultMultiFileRangeCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResultProbeCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResultProcessStepInfo;
import com.teamscale.index.external.result.ExternalAnalysisResultSimulinkCodeGeneration;
import com.teamscale.index.external.result.ExternalAnalysisResultSpecItems;
import com.teamscale.index.external.result.ExternalAnalysisResultTestExecution;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum EExternalAnalysisResultType {
    FINDINGS("Findings"),
    METRICS("Metrics"),
    NON_CODE("Custom Artifacts Data"),
    TEST_COVERAGE("Test Coverage"),
    TEST_RESULTS("Test Results"),
    PROBE_COVERAGE("Probe Coverage"),
    DEPENDENCIES("Dependencies"),
    ISSUES("Issues"),
    SPECIFICATION_ITEMS("Specification Items"),
    COMPILATION_COMMANDS("Compilation Commands"),
    OTHER("Meta Data");

    private String readableName;
    public static final Set<EExternalAnalysisResultType> TEST_COVERAGE_UPLOAD_TYPES;
    private static final Map<Class<? extends ExternalAnalysisResult>, EExternalAnalysisResultType> RESULT_TO_TYPE_MAPPING;

    private EExternalAnalysisResultType(String readableName) {
        this.readableName = readableName;
    }

    public String getReadableName() {
        return this.readableName;
    }

    public static EExternalAnalysisResultType forResultClass(Class<? extends ExternalAnalysisResult> resultClass) {
        EExternalAnalysisResultType resultType = RESULT_TO_TYPE_MAPPING.get(resultClass);
        CCSMAssert.isNotNull((Object)((Object)resultType), () -> "No result type defined for " + resultClass.getName() + "!");
        return resultType;
    }

    static {
        TEST_COVERAGE_UPLOAD_TYPES = EnumSet.of(PROBE_COVERAGE, TEST_COVERAGE);
        RESULT_TO_TYPE_MAPPING = new HashMap<Class<? extends ExternalAnalysisResult>, EExternalAnalysisResultType>();
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultExecutionUnit.class, TEST_RESULTS);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultTestExecution.class, TEST_RESULTS);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultMultiFileRangeCoverage.class, TEST_COVERAGE);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultLineCoverage.class, TEST_COVERAGE);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultProbeCoverage.class, PROBE_COVERAGE);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultProcessStepInfo.class, NON_CODE);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultIssues.class, ISSUES);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultSpecItems.class, SPECIFICATION_ITEMS);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultSimulinkCodeGeneration.class, OTHER);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultFindings.class, FINDINGS);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultDependencyInfo.class, DEPENDENCIES);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultMetrics.class, METRICS);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultCompileCommand.class, COMPILATION_COMMANDS);
        RESULT_TO_TYPE_MAPPING.put(ExternalAnalysisResultMetricSchemaChange.class, OTHER);
    }
}

