/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.fileloaders;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.configuration.service.EProjectConfigurationVersion;
import com.teamscale.index.fileloaders.FileLoader;
import com.teamscale.index.fileloaders.IFileLoader;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.File;
import java.io.IOException;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@FileLoader(extension="tsproject")
public class ProjectFileLoader
implements IFileLoader {
    public static final String EXTENSION = "tsproject";

    @Override
    public String loadFile(File file, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration) throws IOException {
        String projectFile = FileSystemUtils.readFileUTF8((File)file);
        try {
            ProjectConfiguration projectConfiguration = (ProjectConfiguration)TeamscaleVersionContainer.fromJson((String)projectFile, null, ProjectConfiguration.class, (Enum)EProjectConfigurationVersion.CURRENT_VERSION, (String)"project configuration");
            new ProjectCreator(indexLayer, ConfigurationInitializationContext.EInitializationReason.BACKUP).createProject(projectConfiguration);
        }
        catch (ProjectConfigurationException | MigrationException | TriggerCompilationException | InternalServerErrorException | StorageException e) {
            throw new IOException("Failed to load project from file: " + String.valueOf(file), e);
        }
        return "Successfully loaded: " + String.valueOf(file);
    }
}

