/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server;

import com.google.common.hash.HashCode;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.findings.ClangTidyAndCppcheckRunnerBase;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.OutsourcedAnalysisUtils;
import com.teamscale.index.findings.clangtidy.ClangTidyOutputParser;
import com.teamscale.index.findings.clangtidy.ClangTidyRunner;
import com.teamscale.index.findings.clangtidy.ShallowCodeFileRepresentation;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisHashUtils;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisRequestParameters;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyResultsTransport;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.EClangTidyOutsourcedAnalysisStatus;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.IClangTidyOutsourcedAnalysisTeamscaleServerAPI;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisContext;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisContextIndex;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisFindingsCacheIndex;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisLocalContentReader;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisStatusIndex;
import com.teamscale.index.findings.cppcheck.LineOffsetConverterCache;
import com.teamscale.index.resource.BasicTokenElementIndex;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.SchemaNotFoundException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ClangTidyOutsourcedAnalysisRunner
extends MaintenanceTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.MAINTENANCE_PARALLEL;
    }

    public void execute() throws StorageException, IOException, ProjectConfigurationException, ServiceCallException {
        String sessionKey = this.jobDescriptor.getParameter();
        ClangTidyOutsourcedAnalysisStatusIndex statusIndex = (ClangTidyOutsourcedAnalysisStatusIndex)this.indexLayer.openGlobalIndex(ClangTidyOutsourcedAnalysisStatusIndex.class);
        ClangTidyOutsourcedAnalysisContext context = ((ClangTidyOutsourcedAnalysisContextIndex)this.indexLayer.openGlobalIndex(ClangTidyOutsourcedAnalysisContextIndex.class)).getContext(sessionKey).orElseThrow(() -> new IllegalStateException("No analysis context found for session '" + sessionKey + "'. This is likely a programming error."));
        try {
            statusIndex.setStatus(sessionKey, EClangTidyOutsourcedAnalysisStatus.RUNNING);
            Map<String, HashCode> inputHashes = ClangTidyOutsourcedAnalysisHashUtils.computeInputHashCodesForSubjectFiles(context.parameters());
            inputHashes = this.removeHashesThatWereAlreadyAnalyzedBefore(inputHashes);
            LOGGER.debug("Using cached findings for " + (context.parameters().analysisSubjectInfos().size() - inputHashes.size()) + " of " + context.parameters().analysisSubjectInfos().size() + " file(s).");
            ArrayList<String> subjectFilesWithChangedInputHash = new ArrayList<String>(inputHashes.keySet());
            if (subjectFilesWithChangedInputHash.isEmpty()) {
                statusIndex.setStatus(sessionKey, EClangTidyOutsourcedAnalysisStatus.DONE);
                return;
            }
            BasicTokenElementIndex basicTokenElementIndex = this.openBasicTokenElementIndex(context).orElse(null);
            Map<String, ShallowCodeFileRepresentation> fileContentMap = ClangTidyOutsourcedAnalysisRunner.loadFileContents(basicTokenElementIndex, subjectFilesWithChangedInputHash, context);
            ClangTidyOutsourcedAnalysisRunner.logErrorIfContentHashDoesNotMatch(context, fileContentMap);
            Map<String, ClangTidyResultsTransport> clangTidyResultsByPath = ClangTidyOutsourcedAnalysisRunner.executeAnalysis(ClangTidyOutsourcedAnalysisRunner.filterFileInfosByUniformPaths(subjectFilesWithChangedInputHash, context.parameters().analysisSubjectInfos()), context.parameters(), fileContentMap);
            this.writeResultsToCache(inputHashes, clangTidyResultsByPath);
            statusIndex.setStatus(sessionKey, EClangTidyOutsourcedAnalysisStatus.DONE);
        }
        catch (Throwable t) {
            statusIndex.setStatus(sessionKey, EClangTidyOutsourcedAnalysisStatus.ERROR);
            throw t;
        }
        finally {
            ExternalCredentials teamscaleServerCredentials = OutsourcedAnalysisUtils.findFirstCredentialsForTeamscaleServerAt(context.returnAddress(), ((ExternalCredentialsIndex)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class)).getAllExternalCredentials());
            ClangTidyOutsourcedAnalysisRunner.sendAnalysisCompletionConfirmation(context.returnAddress(), teamscaleServerCredentials, sessionKey, context.projectId(), context.commit());
        }
    }

    private static List<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> filterFileInfosByUniformPaths(List<String> subjectFilesUniformPaths, List<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> analysisSubjectInformations) {
        HashSet<String> subjectFilesUniformPathsSet = new HashSet<String>(subjectFilesUniformPaths);
        return CollectionUtils.filter(analysisSubjectInformations, info -> subjectFilesUniformPathsSet.contains(info.uniformPath()));
    }

    private Optional<BasicTokenElementIndex> openBasicTokenElementIndex(ClangTidyOutsourcedAnalysisContext context) throws StorageException {
        if (context.projectId() == null && context.commit() == null) {
            LOGGER.debug("External ClangTidy analysis request without project id and commit descriptor. Continuing without local file contents.");
            return Optional.empty();
        }
        if (context.projectId() == null || context.commit() == null) {
            throw new StorageException("Provided project id '" + String.valueOf(context.projectId()) + "' and commit descriptor '" + String.valueOf(context.commit()) + "'. Please provide both to enable reading content from server storage or none to disable reading content.");
        }
        LOGGER.debug("Continuing outsourced ClangTidy analysis with local file content from project id '{}'.", (Object)context.projectId());
        ProjectStorageSystem projectStorage = ClangTidyOutsourcedAnalysisRunner.tryOpenProjectStorage(this.indexLayer, context.projectId());
        BasicTokenElementIndex basicTokenElementIndex = (BasicTokenElementIndex)projectStorage.openProjectIndex(BasicTokenElementIndex.class, HistoryAccessOption.readTimestamp((String)context.commit().getBranchName(), (long)context.commit().getTimestamp()));
        return Optional.ofNullable(basicTokenElementIndex);
    }

    private static Map<String, ShallowCodeFileRepresentation> loadFileContents(BasicTokenElementIndex basicTokenElementIndex, List<String> filesWithChangedInputHash, ClangTidyOutsourcedAnalysisContext context) throws StorageException {
        HashSet<String> subjectPathsPathsRequiringAnalysis = new HashSet<String>(filesWithChangedInputHash);
        Map<String, String> hashesForRequiredUniformPaths = ClangTidyOutsourcedAnalysisRunner.collectHashesForRequiredUniformPaths(context, subjectPathsPathsRequiringAnalysis);
        HashMap<String, ShallowCodeFileRepresentation> contents = new HashMap<String, ShallowCodeFileRepresentation>();
        if (basicTokenElementIndex != null) {
            Map<String, BasicTokenElementInfo> localTokenElements = ClangTidyOutsourcedAnalysisLocalContentReader.loadLocalBasicTokenElements(context.commit(), hashesForRequiredUniformPaths, basicTokenElementIndex);
            for (Map.Entry entry : localTokenElements.entrySet()) {
                contents.put((String)entry.getKey(), ShallowCodeFileRepresentation.fromBasicTokenElementInfo((BasicTokenElementInfo)entry.getValue()));
            }
        }
        HashMap<String, String> hashesForMissingPaths = new HashMap<String, String>();
        for (String string : hashesForRequiredUniformPaths.keySet()) {
            if (contents.containsKey(string)) continue;
            hashesForMissingPaths.put(string, hashesForRequiredUniformPaths.get(string));
        }
        contents.putAll(ClangTidyOutsourcedAnalysisRunner.fetchMissingElementsFromTeamscaleServer(hashesForMissingPaths, context.returnAddress()));
        return contents;
    }

    private static @NonNull Map<String, String> collectHashesForRequiredUniformPaths(ClangTidyOutsourcedAnalysisContext context, Set<String> subjectPathsPathsRequiringAnalysis) {
        HashMap<String, String> hashesForRequiredUniformPaths = new HashMap<String, String>();
        for (ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation subjectInfo : context.parameters().analysisSubjectInfos()) {
            if (!subjectPathsPathsRequiringAnalysis.contains(subjectInfo.uniformPath())) continue;
            hashesForRequiredUniformPaths.put(subjectInfo.uniformPath(), context.parameters().fileContentHashes().get(subjectInfo.uniformPath()));
            List requiredPathsForSubject = CollectionUtils.map(subjectInfo.includedPaths(), CppIncludeHandler.IncludeFile::uniformPath);
            for (String requiredPathForSubject : requiredPathsForSubject) {
                hashesForRequiredUniformPaths.put(requiredPathForSubject, context.parameters().fileContentHashes().get(requiredPathForSubject));
            }
        }
        return hashesForRequiredUniformPaths;
    }

    private @NonNull Map<String, HashCode> removeHashesThatWereAlreadyAnalyzedBefore(Map<String, HashCode> inputHashes) throws StorageException {
        Set<String> alreadyComputedHashes = this.openClangTidyFindingsCacheIndex().getContainedKeys(CollectionUtils.map(inputHashes.values(), HashCode::toString));
        return inputHashes.entrySet().stream().filter(entry -> !alreadyComputedHashes.contains(((HashCode)entry.getValue()).toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static void logErrorIfContentHashDoesNotMatch(ClangTidyOutsourcedAnalysisContext context, Map<String, ShallowCodeFileRepresentation> filesOnExecutionServer) {
        for (Map.Entry<String, String> fileHashes : context.parameters().fileContentHashes().entrySet()) {
            String textContentOnExecutionServer;
            String hashOnTeamscaleServer;
            String uniformPath = fileHashes.getKey();
            if (filesOnExecutionServer.get(uniformPath) == null || (hashOnTeamscaleServer = fileHashes.getValue()).equals(ClangTidyOutsourcedAnalysisHashUtils.generateClangTidyFileContentHash(uniformPath, textContentOnExecutionServer = filesOnExecutionServer.get(uniformPath).textContent()))) continue;
            LOGGER.error("Content in file is different on execution server than on Teamscale server. Uniform Path " + uniformPath + " commit " + String.valueOf(context.commit()) + " project " + String.valueOf(context.projectId()) + " Teamscale Server " + context.returnAddress());
        }
    }

    private static @Nullable ProjectStorageSystem tryOpenProjectStorage(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        try {
            return indexLayer.openNonCommitResolvingProjectStorageSystem(projectId);
        }
        catch (SchemaNotFoundException e) {
            return null;
        }
    }

    private static void sendAnalysisCompletionConfirmation(String returnAddress, ExternalCredentials teamscaleServerCredentials, String sessionKey, @Nullable IProjectId projectId, UnresolvedCommitDescriptor commit) throws ServiceCallException {
        if (projectId == null) {
            LOGGER.debug("Skipped sending analysis completion confirmation because project id was null.");
            return;
        }
        IClangTidyOutsourcedAnalysisTeamscaleServerAPI teamscaleServerInterface = IClangTidyOutsourcedAnalysisTeamscaleServerAPI.generateTeamscaleServerInterface(returnAddress, teamscaleServerCredentials, LOGGER);
        Retrofit.executeServiceCall(teamscaleServerInterface.receiveAnalysisCompletedConfirmation(sessionKey, projectId, commit));
    }

    private static Map<String, ClangTidyResultsTransport> executeAnalysis(List<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> subjectFilesWithChangedInputHash, ClangTidyOutsourcedAnalysisRequestParameters parameters, Map<String, ShallowCodeFileRepresentation> fileContentMap) {
        HashMap<String, ClangTidyResultsTransport> hashMap;
        block9: {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = subjectFilesWithChangedInputHash::size;
            LOGGER.info("Analyzing {} file(s) with ClangTidy.", supplierArray);
            TemporaryDirectory tempDirectory = FileSystemUtils.getTemporaryDirectory((String)"TeamscaleClangTidy");
            try {
                File codeDirectory = tempDirectory.getPath().resolve("code").toFile();
                FileSystemUtils.ensureDirectoryExists((File)codeDirectory);
                ClangTidyAndCppcheckRunnerBase.writeFiles(fileContentMap.values(), codeDirectory);
                ArrayList<Callable<Void>> clangTidyJobs = new ArrayList<Callable<Void>>();
                HashMap<String, ClangTidyResultsTransport> results = new HashMap<String, ClangTidyResultsTransport>();
                LineOffsetConverterCache lineOffsetConverterCache = new LineOffsetConverterCache(fileContentMap);
                for (int i = 0; i < subjectFilesWithChangedInputHash.size(); ++i) {
                    ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation subjectInfo = subjectFilesWithChangedInputHash.get(i);
                    File checkDirectory = tempDirectory.getPath().resolve("check_" + i).toFile();
                    clangTidyJobs.add(ClangTidyOutsourcedAnalysisRunner.buildClangTidyJob(subjectInfo, parameters, fileContentMap, checkDirectory, codeDirectory, results, lineOffsetConverterCache));
                }
                ClangTidyAndCppcheckRunnerBase.executeJobsInParallel(clangTidyJobs, ClangTidyRunner.CLANG_TIDY_JOB_EXECUTOR, "clang-tidy");
                hashMap = results;
                if (tempDirectory == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tempDirectory != null) {
                        try {
                            tempDirectory.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error running ClangTidy: " + String.valueOf(e), (Throwable)e);
                    return Collections.emptyMap();
                }
            }
            tempDirectory.close();
        }
        return hashMap;
    }

    private static Callable<Void> buildClangTidyJob(ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation subjectInfo, ClangTidyOutsourcedAnalysisRequestParameters parameters, Map<String, ShallowCodeFileRepresentation> fileContentMap, File checkDirectory, File codeDirectory, Map<String, ClangTidyResultsTransport> results, LineOffsetConverterCache lineOffsetConverterCache) {
        Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles = subjectInfo.includedPaths();
        ShallowCodeFileRepresentation currentFile = fileContentMap.get(subjectInfo.uniformPath());
        String selectedChecks = parameters.selectedChecksPerLanguage().get(currentFile.language());
        List<String> globalCompilerArguments = parameters.globalCompilerArguments();
        List<String> compilerCommandAndArguments = ClangTidyRunner.concatenateCompilerArguments(subjectInfo.localCompilerArguments(), globalCompilerArguments);
        Map<String, String> clangTidyOptions = parameters.clangTidyOptions();
        return () -> {
            List<ClangTidyOutputParser.ClangTidyResultItem> resultItems = ClangTidyRunner.runClangTidyOnElement(checkDirectory, selectedChecks, false, codeDirectory, relevantIncludeFiles, compilerCommandAndArguments, subjectInfo.uniformPath(), clangTidyOptions);
            ArrayList<ParseLogMessage> parseLogMessages = new ArrayList<ParseLogMessage>();
            List<ClangTidyResultsTransport.ClangTidyFindingTransport> findingsTransport = ClangTidyRunner.convertClangTidyResultsToFindings(codeDirectory, resultItems, parseLogMessages, currentFile, lineOffsetConverterCache);
            ClangTidyResultsTransport resultsTransport = new ClangTidyResultsTransport(subjectInfo.uniformPath(), findingsTransport, parseLogMessages);
            Map map = results;
            synchronized (map) {
                results.put(subjectInfo.uniformPath(), resultsTransport);
            }
            return null;
        };
    }

    private ClangTidyOutsourcedAnalysisFindingsCacheIndex openClangTidyFindingsCacheIndex() throws StorageException {
        return (ClangTidyOutsourcedAnalysisFindingsCacheIndex)this.indexLayer.openGlobalIndex(ClangTidyOutsourcedAnalysisFindingsCacheIndex.class);
    }

    private static Map<String, ShallowCodeFileRepresentation> fetchMissingElementsFromTeamscaleServer(Map<String, String> hashesForMissingPaths, @Nullable String teamscaleServerAddress) {
        if (hashesForMissingPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        if (teamscaleServerAddress == null) {
            LOGGER.error("Calling server did not pass a return address. These missing files will be ignored: {}", (Object)hashesForMissingPaths.keySet().stream().map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
            return Collections.emptyMap();
        }
        Map<String, ShallowCodeFileRepresentation> fetchedContentsByPath = ClangTidyOutsourcedAnalysisRunner.fetchElementsByPath(teamscaleServerAddress, hashesForMissingPaths.keySet());
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = fetchedContentsByPath::size;
        supplierArray[1] = () -> teamscaleServerAddress;
        LOGGER.debug("Fetched {} element(s) from calling server '{}'.", supplierArray);
        int numberOfMissingElements = hashesForMissingPaths.size() - fetchedContentsByPath.size();
        if (numberOfMissingElements > 0) {
            LOGGER.error("Missing content for {} element(s). Analysis will ignore these files: {}", (Object)numberOfMissingElements, (Object)hashesForMissingPaths.keySet().stream().filter(Predicate.not(fetchedContentsByPath::containsKey)).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
        }
        return fetchedContentsByPath;
    }

    private static Map<String, ShallowCodeFileRepresentation> fetchElementsByPath(String serverAddress, Set<String> filesToFetchElementsFor) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = filesToFetchElementsFor::size;
        supplierArray[1] = () -> serverAddress;
        LOGGER.debug("Fetching {} element(s) from '{}'", supplierArray);
        LOGGER.error("Fetching from calling server is not yet supported.");
        return Collections.emptyMap();
    }

    private void writeResultsToCache(Map<String, HashCode> inputHashes, Map<String, ClangTidyResultsTransport> resultItemsByPath) throws StorageException {
        PairList resultsByInputHash = new PairList(resultItemsByPath.size());
        for (Map.Entry<String, HashCode> inputHashEntry : inputHashes.entrySet()) {
            String uniformPath = inputHashEntry.getKey();
            HashCode inputHash = inputHashEntry.getValue();
            resultsByInputHash.add((Object)inputHash.toString(), (Object)resultItemsByPath.get(uniformPath));
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((PairList)resultsByInputHash).size();
        LOGGER.debug("Writing results for {} files to cache.", supplierArray);
        this.openClangTidyFindingsCacheIndex().writeCache((PairList<String, ClangTidyResultsTransport>)resultsByInputHash);
    }
}

