/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="clang-tidy-execution-server-account-name", name="External-account name for the ClangTidy analysis execution server", type=EOptionType.SERVER, category=EOptionCategory.SERVER, orderingHint=0x7FFFFFFF, visibilityFeatureToggle=EFeatureToggle.ENABLE_OUTSOURCED_CLANG_TIDY_ANALYSIS)
@IndexValueClass(containedInBackup=true)
public class ClangTidyExecutionServerCredentialsNameOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "clang-tidy-execution-server-account-name";
    public static final String OPTION_NAME = "External-account name for the ClangTidy analysis execution server";
    @JsonProperty(value="credentialsName")
    @OptionFieldDescription(name="External-account name for the ClangTidy analysis execution server", description="The name of the credentials to use for the outsourced ClangTidy analysis service.\nMust be the name of an External Account configured in the Admin/External Accounts view.\nThe account must point to a server that implements the Clang-Tidy outsourced analysis interface (e.g., this server or another Teamscale server).\n")
    public String credentialsName = "Outsourced Analysis Execution Server";

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        ExternalCredentials externalCredentials = ((ExternalCredentialsIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(ExternalCredentialsIndex.class)).getExternalCredentials(this.credentialsName);
        if (externalCredentials == null) {
            return "No external account exists with name '" + this.credentialsName + "'";
        }
        return null;
    }

    public static String getCredentialsName(ServerOptionIndex optionIndex) throws StorageException {
        ClangTidyExecutionServerCredentialsNameOption option = (ClangTidyExecutionServerCredentialsNameOption)ServerOptionRegistry.getInstance().getOption("server", OPTION_ID, null, ClangTidyExecutionServerCredentialsNameOption.class, (OptionIndexBase)optionIndex);
        if (option == null) {
            return null;
        }
        String credentialsName = option.credentialsName.trim();
        if (StringUtils.isEmpty((String)credentialsName)) {
            return null;
        }
        return credentialsName;
    }
}

