/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.raex;

import com.teamscale.index.configuration.tools.message.SonarLintCsMessageManager;
import com.teamscale.index.findings.UpdaterUtils;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.dotnet.DotnetExecutorBase;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.options.CommandLineBase;

public class SonarLintCsUpdater
extends CommandLineBase<Exception> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Path SONARLINT_CS_CHECK_MAPPINGS_FILE = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/sonarlint-cs/check-mappings.tsv", new String[0]);
    private static final Path SONARLINT_CS_DESCRIPTIONS_DIRECTORY = Path.of("server/com.teamscale.index/check-descriptions/raex/sonarlint-cs", new String[0]);
    private static final Path ORG_CONQAT_ENGINE_DOTNET_RPOJECT = Path.of("server/org.conqat.engine.dotnet", new String[0]);
    private static final Path RAEX_CS_SOURCE_DIRECTORY = ORG_CONQAT_ENGINE_DOTNET_RPOJECT.resolve("src-cs/Cqse.Teamscale.Raex/src");
    private static final Path RAEX_CS_PROJECT = RAEX_CS_SOURCE_DIRECTORY.resolve("Cqse.Teamscale.Raex.csproj");
    private static final Path RAEX_EXECUTABLE = RAEX_CS_SOURCE_DIRECTORY.resolve("bin/Release/net6.0/raex.dll");
    private static final Path RAEX_OUTPUT_DIRECTORY = ORG_CONQAT_ENGINE_DOTNET_RPOJECT.resolve("src/main/resources/META-INF/natives/raex/check-mappings");
    private static final Pattern SONAR_LINT_CS_ANALYZER_VERSION_PATTERN = Pattern.compile("<SonarAnalyzerVersion>(?<version>[^<]+)</SonarAnalyzerVersion>");
    private static final String SONAR_LINT_CS_GIT_REPO_URL = "https://github.com/SonarSource/sonar-dotnet";

    public static void main(String[] args) throws Exception {
        SonarLintCsUpdater.execute(SonarLintCsUpdater::new, (String[])args);
    }

    public void run() throws Exception {
        SonarLintCsUpdater.extractCheckMappingsViaRaex();
        Set<String> checkIds = SonarLintCsUpdater.updateRules();
        SonarLintCsUpdater.updateLicenseAndDescriptions(checkIds);
        FileSystemUtils.deleteRecursively((Path)RAEX_OUTPUT_DIRECTORY);
    }

    private static void extractCheckMappingsViaRaex() throws IOException, ConQATException {
        new RaexExecutor().execute("check-mappings", "--output", RAEX_OUTPUT_DIRECTORY.toAbsolutePath().toString());
    }

    private static Set<String> updateRules() throws IOException {
        Map newCheckMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((File)RAEX_OUTPUT_DIRECTORY.resolve("SonarLint/check-mappings.tsv").toFile());
        SonarLintCsMessageManager checkMappingsManager = SonarLintCsMessageManager.getInstance();
        Map<String, CheckMapping> checkMappings = checkMappingsManager.getCheckMappings();
        CheckMappingAndCheckOptionTSVUtils.updateCheckMapping(checkMappings, (Map)newCheckMappings);
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((File)SONARLINT_CS_CHECK_MAPPINGS_FILE.toFile(), checkMappings.values().stream().toList());
        LOGGER.info("New mappings TSV file has been written to {}", (Object)SONARLINT_CS_CHECK_MAPPINGS_FILE);
        return newCheckMappings.keySet();
    }

    private static void updateLicenseAndDescriptions(Set<String> checkIds) throws IOException {
        Path clonedGitRepo = Files.createTempDirectory("teamscale-sonarlint-cs-update", new FileAttribute[0]);
        UpdaterUtils.cloneOrUpdateRepository(SONAR_LINT_CS_GIT_REPO_URL, clonedGitRepo, SonarLintCsUpdater.determineSonarLintCsVersion());
        SonarLintCsUpdater.updateLicense(clonedGitRepo);
        SonarLintCsUpdater.updateDescriptions(clonedGitRepo, checkIds);
        FileSystemUtils.deleteRecursively((Path)clonedGitRepo);
    }

    private static String determineSonarLintCsVersion() throws IOException {
        String csProjectContents = Files.readString(RAEX_CS_PROJECT);
        Matcher versionMatcher = SONAR_LINT_CS_ANALYZER_VERSION_PATTERN.matcher(csProjectContents);
        if (!versionMatcher.find()) {
            throw new IllegalStateException("File " + String.valueOf(RAEX_CS_PROJECT) + " does not contain a Sonar Analyzer version.");
        }
        return versionMatcher.group("version");
    }

    private static void updateLicense(Path clonedGitRepo) throws IOException {
        Files.copy(clonedGitRepo.resolve("LICENSE.txt"), SONARLINT_CS_DESCRIPTIONS_DIRECTORY.resolve("LICENSE"), StandardCopyOption.REPLACE_EXISTING);
        LOGGER.info("Successfully updated license");
    }

    private static void updateDescriptions(Path clonedGitRepo, Set<String> checkIds) throws IOException {
        Path checkDescriptionsDir = clonedGitRepo.resolve("analyzers/rspec/cs");
        for (String checkId : checkIds) {
            Path checkDescription = checkDescriptionsDir.resolve(checkId + ".html");
            if (!checkDescription.toFile().exists()) {
                throw new IllegalArgumentException("Check description for '" + checkId + "' does not exist in git repository.");
            }
            Files.copy(checkDescription, SONARLINT_CS_DESCRIPTIONS_DIRECTORY.resolve(checkId + ".md"), StandardCopyOption.REPLACE_EXISTING);
        }
        LOGGER.info("Successfully updated descriptions");
    }

    private static class RaexExecutor
    extends DotnetExecutorBase {
        private RaexExecutor() {
        }

        private void execute(String ... arguments) throws ConQATException, IOException {
            this.setExecutable(RAEX_EXECUTABLE.toAbsolutePath().toString(), false);
            this.execute(Arrays.asList(arguments));
        }
    }
}

