/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.issue_reference.CodeToReferenceMappingSynchronizerBase;
import com.teamscale.index.issue_reference.IssueReferenceIndex;
import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.issue_reference.SpecItemEntityExtractor;
import com.teamscale.index.requirements_tracing.index.SpecItemUnmanagedKeysHistoryIndex;
import com.teamscale.index.resource.issue_reference.EIssueReferenceType;
import com.teamscale.index.resource.issue_reference.IssueReference;
import com.teamscale.index.testimpact.CodeToTestPathsMapIndex;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.wia.TeamscaleIssueId;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class CodeToSpecItemReferenceMappingSynchronizer
extends CodeToReferenceMappingSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String SPEC_ITEM_ID_PATTERN_PARAMETER = "spec-item-id-pattern";
    @StepParameter(value="spec-item-id-pattern")
    private String specItemIdPatternParameter;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SpecItemCodeReferenceIndex specItemCodeReferenceIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private IssueReferenceIndex oldIssueReferenceIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CodeToTestPathsMapIndex codeToTestPathsMapIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestImplementationIndex testImplementationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SpecItemUnmanagedKeysHistoryIndex specItemUnmanagedKeysHistoryIndex;
    private final Map<TeamscaleIssueId, List<SpecItemCodeReference>> codeReferencesByIssueReferenceId = new HashMap<TeamscaleIssueId, List<SpecItemCodeReference>>();
    private static final int LINE_NUMBER_OFFSET = 1;
    private TwoDimHashMap<String, Integer, String> testsByFileAndStartOffset;

    public void execute() throws ConQATException {
        Pattern specItemIdPattern = Pattern.compile(this.specItemIdPatternParameter);
        this.testsByFileAndStartOffset = this.preloadTests(this.contentDelta.getAddedOrChangedKeysAsStrings());
        PairList<String, ArrayList<IssueReference>> uniformPathsWithIssueReferences = this.getUniformPathsIssueReferences(specItemIdPattern);
        this.storeIssueReferences(uniformPathsWithIssueReferences);
        this.removeValuesFromIssueReferenceIndex();
        this.storeCodeReferences();
    }

    @Override
    protected EIssueReferenceType getIssueReferenceType() {
        return EIssueReferenceType.SPEC_ITEM;
    }

    private TwoDimHashMap<String, Integer, String> preloadTests(List<String> uniformPaths) throws StorageException {
        TwoDimHashMap testsByFileAndStartOffset = new TwoDimHashMap();
        List<String> allPotentialTests = this.codeToTestPathsMapIndex.getFlatListOfContainedTestPaths(uniformPaths);
        List<TestImplementation> allTestImplementations = this.testImplementationIndex.getTestImplementations(allPotentialTests);
        CollectionUtils.forEach(allPotentialTests, allTestImplementations, (testUniformPath, testImplementation) -> {
            if (testImplementation == null) {
                LOGGER.error("No test details found for " + testUniformPath + "!");
                return;
            }
            testsByFileAndStartOffset.putValue((Object)testImplementation.getLocation().getUniformPath(), (Object)testImplementation.getLocation().getRawStartOffset(), testUniformPath);
        });
        return testsByFileAndStartOffset;
    }

    @Override
    protected void createIssueReferenceForIssueReferenceIdInComment(String issueReferenceId, String uniformPath, Map<String, List<OffsetBasedRegion>> regionsByReferenceId, Comment comment, List<ShallowEntity> entities, List<ShallowEntity> nonPreprocessedEntities) {
        this.createIssueReference(issueReferenceId, uniformPath, regionsByReferenceId, comment.getToken().getOffset());
        CommentEntities commentEntities = CodeToSpecItemReferenceMappingSynchronizer.mapCommentToEntity(entities, nonPreprocessedEntities, comment, uniformPath);
        if (commentEntities.commentEntity == null || commentEntities.nonPreprocessedCommentEntity == null) {
            return;
        }
        String testUniformPath = this.findTestUniformPath(uniformPath, commentEntities.commentEntity);
        this.addCodeReferenceIntoMap(issueReferenceId, uniformPath, regionsByReferenceId, comment.getToken().getOffset(), comment.getToken().getLineNumber() + 1, testUniformPath, commentEntities);
    }

    private String findTestUniformPath(String uniformPath, ShallowEntity commentEntity) {
        return ShallowEntityTraversalUtils.findEntityOrParentEntity((ShallowEntity)commentEntity, entity -> entity.getType() != EShallowEntityType.MODULE && this.testsByFileAndStartOffset.containsKey((Object)uniformPath, (Object)entity.getStartOffset())).map(shallowEntity -> (String)this.testsByFileAndStartOffset.getValue((Object)uniformPath, (Object)shallowEntity.getStartOffset())).orElse(null);
    }

    private static CommentEntities mapCommentToEntity(List<ShallowEntity> entities, List<ShallowEntity> nonPreprocessedEntities, Comment currentComment, String uniformPath) {
        ShallowEntity commentEntity = SpecItemEntityExtractor.getSpecItemEntity(currentComment.getToken(), entities, uniformPath);
        ShallowEntity nonPreprocessedCommentEntity = SpecItemEntityExtractor.getSpecItemEntity(currentComment.getToken(), nonPreprocessedEntities, uniformPath);
        return new CommentEntities(commentEntity, nonPreprocessedCommentEntity);
    }

    private void addCodeReferenceIntoMap(String issueReferenceId, String uniformPath, Map<String, List<OffsetBasedRegion>> regionsByReferenceId, int commentOffset, int commentLineNumber, String testUniformPath, CommentEntities commentEntities) {
        List codeReferences = this.codeReferencesByIssueReferenceId.computeIfAbsent(new TeamscaleIssueId(this.connectorId, issueReferenceId), key -> new ArrayList());
        codeReferences.add(new SpecItemCodeReference(uniformPath, SpecItemCodeReference.ReferencedShallowEntity.fromShallowEntity(commentEntities.commentEntity), SpecItemCodeReference.ReferencedShallowEntity.fromShallowEntity(commentEntities.nonPreprocessedCommentEntity), (Pair<Integer, OffsetBasedRegion>)Pair.createPair((Object)commentOffset, (Object)regionsByReferenceId.get(issueReferenceId).get(0)), commentLineNumber, testUniformPath));
    }

    private void storeCodeReferences() throws StorageException {
        List updatedUniformPaths = this.contentDelta.getAllKeysAsStrings();
        Set specItemIdsThatNeedUpdate = this.oldIssueReferenceIndex.getIssueReferences(updatedUniformPaths).stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(this::referenceIsFromThisSynchronizer).map(IssueReference::getId).collect(Collectors.toSet());
        specItemIdsThatNeedUpdate.addAll(this.codeReferencesByIssueReferenceId.keySet());
        Set<String> removedIds = this.specItemCodeReferenceIndex.updateSpecItemCodeReferences(new HashSet<String>(updatedUniformPaths), new ArrayList<TeamscaleIssueId>(specItemIdsThatNeedUpdate), this.codeReferencesByIssueReferenceId);
        Map<String, List<SpecItemCodeReference>> updatedEntries = this.specItemCodeReferenceIndex.getSpecItemCodeReferencesBySpecItemIds(specItemIdsThatNeedUpdate.stream().map(TeamscaleIssueId::getInternalId).collect(Collectors.toSet()));
        Long timestamp = this.getSchedulingCommit().getTimestamp();
        this.specItemUnmanagedKeysHistoryIndex.updateEntries(updatedEntries, timestamp, removedIds);
    }

    private static class CommentEntities {
        private final ShallowEntity commentEntity;
        private final ShallowEntity nonPreprocessedCommentEntity;

        public CommentEntities(ShallowEntity commentEntity, ShallowEntity nonPreprocessedCommentEntity) {
            this.commentEntity = commentEntity;
            this.nonPreprocessedCommentEntity = nonPreprocessedCommentEntity;
        }
    }
}

