/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestBuildPipelineInfo;
import com.teamscale.index.merge_request.MergeRequestProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class MergeRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="identifier")
    public final MergeRequestIdentifier identifier;
    @JsonProperty(value="status")
    public final EMergeRequestStatus status;
    @JsonProperty(value="title")
    public final String title;
    @JsonProperty(value="sourceBranch")
    public final String sourceBranch;
    @JsonProperty(value="sourceHead")
    public final String sourceHead;
    @JsonProperty(value="targetBranch")
    public final String targetBranch;
    @JsonProperty(value="url")
    public final String url;
    @JsonProperty(value="createdAt")
    public final @Nullable Long createdAt;
    @JsonProperty(value="updatedAt")
    public final @Nullable Long updatedAt;
    @JsonProperty(value="votingRelevantChangeTimestamps")
    public final List<Long> votingRelevantChangeTimestamps = new ArrayList<Long>();
    @JsonProperty(value="buildPipelineInfo")
    public final MergeRequestBuildPipelineInfo buildPipelineInfo;
    private static final EnumSet<EMergeRequestStatus> STATES_STORED_IN_MERGE_REQUEST_INDEX = EnumSet.of(EMergeRequestStatus.OPEN, EMergeRequestStatus.MERGED);

    @JsonCreator
    public MergeRequest(@JsonProperty(value="identifier") MergeRequestIdentifier identifier, @JsonProperty(value="status") EMergeRequestStatus status, @JsonProperty(value="title") String title, @JsonProperty(value="sourceBranch") String sourceBranch, @JsonProperty(value="sourceHead") String sourceHead, @JsonProperty(value="targetBranch") String targetBranch, @JsonProperty(value="url") String url, @JsonProperty(value="createdAt") @Nullable Long createdAt, @JsonProperty(value="updatedAt") @Nullable Long updatedAt, @JsonProperty(value="buildPipelineInfo") MergeRequestBuildPipelineInfo buildPipelineInfo) {
        this.identifier = identifier;
        this.status = status;
        this.title = title;
        this.sourceBranch = sourceBranch;
        this.sourceHead = sourceHead;
        this.targetBranch = targetBranch;
        this.url = url;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.buildPipelineInfo = buildPipelineInfo;
    }

    public MergeRequest(MergeRequestIdentifier identifier, EMergeRequestStatus status, String title, MergeRequestProvider.SourceBranchAndCommit sourceBranchAndCommit, String targetBranch, String url, @Nullable Long createdAt, @Nullable Long updatedAt, MergeRequestBuildPipelineInfo buildPipelineInfo) {
        this.identifier = identifier;
        this.status = status;
        this.title = title;
        this.sourceBranch = sourceBranchAndCommit.sourceBranchName();
        this.sourceHead = sourceBranchAndCommit.sourceCommitHash();
        this.targetBranch = targetBranch;
        this.url = url;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.buildPipelineInfo = buildPipelineInfo;
    }

    public MergeRequest(MergeRequestIdentifier identifier, EMergeRequestStatus status, String title, MergeRequestProvider.SourceBranchAndCommit sourceBranchAndCommit, String targetBranch, String url, @Nullable Long createdAt, @Nullable Long updatedAt) {
        this(identifier, status, title, sourceBranchAndCommit, targetBranch, url, createdAt, updatedAt, new MergeRequestBuildPipelineInfo(false, Collections.emptyList()));
    }

    @VisibleForTesting
    public MergeRequest(MergeRequestIdentifier identifier, EMergeRequestStatus status, String title, MergeRequestProvider.SourceBranchAndCommit sourceBranchAndCommit, String targetBranch, String url, @Nullable Long createdAt) {
        this(identifier, status, title, sourceBranchAndCommit, targetBranch, url, createdAt, createdAt, new MergeRequestBuildPipelineInfo(false, Collections.emptyList()));
    }

    @VisibleForTesting
    MergeRequest(MergeRequest other, EMergeRequestStatus status) {
        this.identifier = other.identifier;
        this.title = other.title;
        this.sourceBranch = other.sourceBranch;
        this.sourceHead = other.sourceHead;
        this.targetBranch = other.targetBranch;
        this.url = other.url;
        this.createdAt = other.createdAt;
        this.updatedAt = other.updatedAt;
        this.status = status;
        this.buildPipelineInfo = other.buildPipelineInfo;
    }

    @VisibleForTesting
    public MergeRequest(MergeRequest other, MergeRequestBuildPipelineInfo buildPipelineInfo) {
        this.identifier = other.identifier;
        this.title = other.title;
        this.sourceBranch = other.sourceBranch;
        this.sourceHead = other.sourceHead;
        this.targetBranch = other.targetBranch;
        this.url = other.url;
        this.createdAt = other.createdAt;
        this.updatedAt = other.updatedAt;
        this.status = other.status;
        this.buildPipelineInfo = buildPipelineInfo;
    }

    public long getId() {
        return this.identifier.id();
    }

    public String getTitle() {
        return this.title;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public String getRepositoryName() {
        return this.identifier.repositoryName();
    }

    public String getUrl() {
        return this.url;
    }

    public @Nullable Long getCreatedAt() {
        return this.createdAt;
    }

    public String toString() {
        return this.identifier.toString();
    }

    public boolean shouldBeRemovedFromIndex() {
        return !STATES_STORED_IN_MERGE_REQUEST_INDEX.contains((Object)this.status);
    }

    public boolean isOpen() {
        return EMergeRequestStatus.OPEN == this.status;
    }

    public boolean equals(Object mergeRequestObject) {
        if (this == mergeRequestObject) {
            return true;
        }
        if (mergeRequestObject == null || this.getClass() != mergeRequestObject.getClass()) {
            return false;
        }
        MergeRequest mergeRequest = (MergeRequest)mergeRequestObject;
        return this.identifier.equals((Object)mergeRequest.identifier) && this.sourceBranch.equals(mergeRequest.sourceBranch) && this.sourceHead.equals(mergeRequest.sourceHead) && this.targetBranch.equals(mergeRequest.targetBranch) && Objects.equals(this.createdAt, mergeRequest.createdAt) && Objects.equals(this.buildPipelineInfo, mergeRequest.buildPipelineInfo);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.sourceBranch, this.sourceHead, this.targetBranch, this.createdAt, this.buildPipelineInfo);
    }
}

