/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.commons.service.client.ServiceCallException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class MergeRequestAnnotationUtils {
    @VisibleForTesting
    public static boolean descriptionContainsCommentLimitWarning(String description, String template) {
        return MergeRequestAnnotationUtils.templateStringToPattern(template).matcher(description).find();
    }

    private static Pattern templateStringToPattern(String template) {
        List<String> split = Arrays.stream(template.split("%s")).map(Pattern::quote).toList();
        return Pattern.compile(String.join((CharSequence)".*?", split), 32);
    }

    private static String updateCommentLimitWarning(String oldDescription, String newCommentLimitWarning, String templateToReplace) {
        if (oldDescription.contains(newCommentLimitWarning)) {
            return oldDescription;
        }
        Pattern patternFromTemplate = MergeRequestAnnotationUtils.templateStringToPattern(templateToReplace);
        return patternFromTemplate.matcher(oldDescription).replaceFirst(newCommentLimitWarning);
    }

    public static void updateDescription(String oldDescription, String teamscaleBadges, String startMarker, String endMarker, boolean badgeAtTopPosition, ConsumerWithTwoExceptions<String, ServiceCallException, StorageException> updateDescription) throws ServiceCallException, StorageException {
        Pattern oldBadgesPattern = Pattern.compile(Pattern.quote(startMarker.trim()) + ".*" + Pattern.quote(endMarker.trim()), 32);
        MergeRequestAnnotationUtils.updateDescription(oldDescription, teamscaleBadges, startMarker, endMarker, oldBadgesPattern, badgeAtTopPosition, updateDescription);
    }

    public static void updateDescription(String oldDescription, String teamscaleBadges, String startMarker, String endMarker, Pattern oldBadgesPattern, boolean badgeAtTopPosition, ConsumerWithTwoExceptions<String, ServiceCallException, StorageException> updateDescription) throws ServiceCallException, StorageException {
        String newDescription;
        if (oldDescription == null) {
            oldDescription = "";
        }
        if (StringUtils.isEmpty((String)teamscaleBadges)) {
            newDescription = oldBadgesPattern.matcher(oldDescription).replaceAll("");
        } else {
            String teamscaleBadgesWithMarkers = startMarker + "\n\n" + teamscaleBadges + "\n\n" + endMarker;
            newDescription = MergeRequestAnnotationUtils.getMergeRequestDescriptionWithBadge(oldDescription, oldBadgesPattern, teamscaleBadgesWithMarkers, badgeAtTopPosition);
        }
        if (!newDescription.trim().equals(oldDescription.trim())) {
            updateDescription.accept((Object)newDescription);
        }
    }

    public static String compileDescriptionWithLimitCommentWarning(String commentLimitWarningExceededMessage, String oldDescription, String startMarker, String endMarker, String commentLimitWarningTemplate) {
        if (oldDescription == null) {
            oldDescription = "";
        }
        if (MergeRequestAnnotationUtils.descriptionContainsCommentLimitWarning(oldDescription, commentLimitWarningTemplate)) {
            return MergeRequestAnnotationUtils.updateCommentLimitWarning(oldDescription, commentLimitWarningExceededMessage, commentLimitWarningTemplate);
        }
        String textBetweenMarkers = StringUtils.between((String)oldDescription, (String)startMarker, (String)endMarker);
        if (textBetweenMarkers == null) {
            return String.format("%s\n%s\n%s\n%s", startMarker, commentLimitWarningExceededMessage, endMarker, oldDescription);
        }
        return StringUtils.getFirstPart((String)oldDescription, (String)startMarker) + startMarker + textBetweenMarkers + commentLimitWarningExceededMessage + "\n\n" + endMarker + StringUtils.getLastPart((String)oldDescription, (String)endMarker);
    }

    private static String getMergeRequestDescriptionWithBadge(String description, Pattern oldBadgesPattern, String teamscaleBadgesWithMarkers, boolean badgeAtTopPosition) {
        Matcher oldBadgesMatcher = oldBadgesPattern.matcher(description);
        if (oldBadgesMatcher.find()) {
            return oldBadgesMatcher.replaceAll(teamscaleBadgesWithMarkers);
        }
        description = description.trim();
        if (badgeAtTopPosition) {
            return teamscaleBadgesWithMarkers + "\n\n" + description;
        }
        return description + "\n\n" + teamscaleBadgesWithMarkers;
    }

    private MergeRequestAnnotationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

