/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdIdentifier;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfigurationEntry;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.index.merge_request.MetricAssessmentComputation;
import com.teamscale.index.merge_request.metrics.IMergeRequestMetricGroupEvaluationResult;
import com.teamscale.index.merge_request.metrics.IMergeRequestSingleMetricAssessmentEvaluationResult;
import com.teamscale.index.merge_request.metrics.MergeRequestEvaluatedMetricGroup;
import com.teamscale.index.merge_request.metrics.MergeRequestMetricGroupEvaluationError;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import com.teamscale.index.metrics.assessment.context.IMetricEvaluationContext;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.assessment.context.NonCodeMetricEvaluationContext;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.metrics.threshold.MetricThresholdSelectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.SupplierWithException;

public class MergeRequestMetricEvaluator {
    private final SupplierWithException<MetricThresholdConfigurationIndex, StorageException> metricThresholdConfigurationIndex;
    private final IMetricEvaluationContext evaluationContext;
    private final MetricDataRetrieverFactory metricDataRetrieverFactory;
    private final Map<String, MetricThresholdConfiguration> thresholdConfigurationCache = new HashMap<String, MetricThresholdConfiguration>();
    private final ProjectStorageSystem projectStorage;
    private final IParallelTaskExecutor parallelExecutor;

    public MergeRequestMetricEvaluator(GlobalStorageSystem globalStorage, ProjectStorageSystem projectStorage, String sourceBranch, CommitDescriptor baseCommit, IParallelTaskExecutor parallelExecutor) {
        this.metricThresholdConfigurationIndex = SupplierWithException.memoize(() -> (MetricThresholdConfigurationIndex)globalStorage.openGlobalIndex(MetricThresholdConfigurationIndex.class));
        this.metricDataRetrieverFactory = new MetricDataRetrieverFactory(projectStorage, globalStorage, null, new MetricSchemaRetrieverFactory(projectStorage));
        this.evaluationContext = new NonCodeMetricEvaluationContext("", this.metricDataRetrieverFactory, projectStorage);
        this.evaluationContext.setCurrentHistoryAccessOption(HistoryAccessOption.readCommit((CommitDescriptor)CommitDescriptor.latestOnBranch((String)sourceBranch)));
        this.evaluationContext.setBaselineHistoryAccessOption(HistoryAccessOption.readCommit((CommitDescriptor)baseCommit));
        this.projectStorage = projectStorage;
        this.parallelExecutor = parallelExecutor;
    }

    public IMergeRequestSingleMetricAssessmentEvaluationResult evaluateMetricThreshold(MetricBadgesConfigurationEntry metricDescription) {
        try {
            Optional<MetricThresholdConfiguration> thresholdConfiguration = this.getMetricThresholdConfiguration(metricDescription.thresholdConfigurationName());
            if (thresholdConfiguration.isEmpty()) {
                return IMergeRequestSingleMetricAssessmentEvaluationResult.fromError(metricDescription, new MetricThresholdConfigurationException("Failed to load threshold configuration '%s'.".formatted(metricDescription.thresholdConfigurationName())));
            }
            return this.evaluateMetricThreshold(thresholdConfiguration.get(), metricDescription);
        }
        catch (StorageException e) {
            return IMergeRequestSingleMetricAssessmentEvaluationResult.fromError(metricDescription, new MetricThresholdConfigurationException(e.getMessage(), (Throwable)e));
        }
    }

    private IMergeRequestSingleMetricAssessmentEvaluationResult evaluateMetricThreshold(MetricThresholdConfiguration thresholdConfiguration, MetricBadgesConfigurationEntry metricDescription) {
        try {
            return IMergeRequestSingleMetricAssessmentEvaluationResult.fromSuccess(this.getMetricAssessmentFromThresholdConfiguration(thresholdConfiguration, metricDescription.metricName(), MergeRequestMetricEvaluator.createThresholdConfigurationInterval(thresholdConfiguration), metricDescription.metricThresholdGroupName(), this.evaluationContext));
        }
        catch (StorageException e) {
            return IMergeRequestSingleMetricAssessmentEvaluationResult.fromError(metricDescription, new MetricThresholdConfigurationException(e.getMessage(), (Throwable)e));
        }
        catch (MetricThresholdConfigurationException e) {
            return IMergeRequestSingleMetricAssessmentEvaluationResult.fromError(metricDescription, e);
        }
    }

    public Set<IMergeRequestMetricGroupEvaluationResult> evaluateMetricGroups(List<MetricBadgesConfigurationEntry> metricDescriptions) {
        Map<Pair, List<MetricBadgesConfigurationEntry>> metricDescriptionsPerGroup = metricDescriptions.stream().collect(Collectors.groupingBy(metricDescription -> new Pair((Object)metricDescription.thresholdConfigurationName(), (Object)metricDescription.metricThresholdGroupName())));
        return metricDescriptionsPerGroup.entrySet().stream().map(metricGroup -> {
            String thresholdConfigurationName = (String)((Pair)metricGroup.getKey()).getFirst();
            String groupName = (String)((Pair)metricGroup.getKey()).getSecond();
            List<String> metricNames = ((List)metricGroup.getValue()).stream().map(MetricBadgesConfigurationEntry::metricName).toList();
            return this.evaluateMetricGroup(thresholdConfigurationName, groupName, metricNames);
        }).collect(Collectors.toSet());
    }

    public IMergeRequestMetricGroupEvaluationResult evaluateMetricGroup(String thresholdConfigurationName, String metricGroupName, List<String> metricNames) {
        try {
            Collection<IMergeRequestSingleMetricAssessmentEvaluationResult> metricAssessmentResults = this.evaluateMetrics(thresholdConfigurationName, metricGroupName, metricNames);
            return MergeRequestMetricEvaluator.aggregateEvaluatedMetrics(metricGroupName, metricAssessmentResults);
        }
        catch (StorageException e) {
            return new MergeRequestMetricGroupEvaluationError(metricGroupName, new MetricThresholdConfigurationException(e.getMessage(), (Throwable)e));
        }
        catch (MetricThresholdConfigurationException e) {
            return new MergeRequestMetricGroupEvaluationError(metricGroupName, e);
        }
    }

    private Collection<IMergeRequestSingleMetricAssessmentEvaluationResult> evaluateMetrics(String thresholdConfigurationName, String metricGroupName, List<String> metricNames) throws MetricThresholdConfigurationException, StorageException {
        Optional<MetricThresholdConfiguration> thresholdConfiguration = this.getMetricThresholdConfiguration(thresholdConfigurationName);
        if (thresholdConfiguration.isEmpty()) {
            throw new MetricThresholdConfigurationException("Failed to load threshold configuration '%s'.".formatted(thresholdConfigurationName));
        }
        Map resultByMetricName = Collections.synchronizedMap(new LinkedHashMap(metricNames.size()));
        metricNames.forEach(metricName -> resultByMetricName.put(metricName, null));
        try {
            this.parallelExecutor.processInParallelBatches(metricNames, metricNamesInBatch -> metricNamesInBatch.forEach(metricName -> resultByMetricName.put(metricName, this.evaluateMetricThreshold((MetricThresholdConfiguration)thresholdConfiguration.get(), new MetricBadgesConfigurationEntry(thresholdConfigurationName, metricGroupName, metricName)))), 5);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MetricThresholdConfigurationException("Error calculating one or all metrics: " + String.valueOf(metricNames), (Throwable)e);
        }
        return resultByMetricName.values();
    }

    private static IMergeRequestMetricGroupEvaluationResult aggregateEvaluatedMetrics(String metricGroupName, Collection<IMergeRequestSingleMetricAssessmentEvaluationResult> metricAssessmentResults) {
        Map<ETrend, List<IMergeRequestSingleMetricAssessmentEvaluationResult>> metricsPerTrend = metricAssessmentResults.stream().collect(Collectors.groupingBy(IMergeRequestSingleMetricAssessmentEvaluationResult::getMetricTrend));
        List<IMergeRequestSingleMetricAssessmentEvaluationResult> metricsWithNewThresholdViolations = metricAssessmentResults.stream().filter(IMergeRequestSingleMetricAssessmentEvaluationResult::isNewThresholdViolation).toList();
        return new MergeRequestEvaluatedMetricGroup(metricGroupName, metricAssessmentResults.stream().anyMatch(IMergeRequestSingleMetricAssessmentEvaluationResult::lowIsBad), metricsPerTrend.getOrDefault((Object)ETrend.NA, (List<IMergeRequestSingleMetricAssessmentEvaluationResult>)CollectionUtils.emptyList()), metricsPerTrend.getOrDefault((Object)ETrend.DOWN, (List<IMergeRequestSingleMetricAssessmentEvaluationResult>)CollectionUtils.emptyList()), metricsPerTrend.getOrDefault((Object)ETrend.STABLE, (List<IMergeRequestSingleMetricAssessmentEvaluationResult>)CollectionUtils.emptyList()), metricsPerTrend.getOrDefault((Object)ETrend.UP, (List<IMergeRequestSingleMetricAssessmentEvaluationResult>)CollectionUtils.emptyList()), metricsWithNewThresholdViolations);
    }

    private Optional<MetricThresholdConfiguration> getMetricThresholdConfiguration(String thresholdConfigurationName) throws StorageException {
        MetricThresholdConfiguration value;
        if (!this.thresholdConfigurationCache.containsKey(thresholdConfigurationName) && (value = ((MetricThresholdConfigurationIndex)this.metricThresholdConfigurationIndex.get()).getConfiguration(thresholdConfigurationName)) != null) {
            this.thresholdConfigurationCache.put(thresholdConfigurationName, value);
        }
        return Optional.ofNullable(this.thresholdConfigurationCache.get(thresholdConfigurationName));
    }

    private static MetricThresholdEvaluator createThresholdConfigurationInterval(MetricThresholdConfiguration thresholdConfiguration) {
        return new MetricThresholdEvaluator(thresholdConfiguration);
    }

    private MetricAssessment getMetricAssessmentFromThresholdConfiguration(MetricThresholdConfiguration thresholdConfiguration, String metricName, MetricThresholdEvaluator thresholdConfigurationInterval, String metricThresholdGroupName, IMetricEvaluationContext evaluationContext) throws MetricThresholdConfigurationException, StorageException {
        Optional<MetricThresholdIdentifier> thresholdIdentifier = MergeRequestMetricEvaluator.getMetricThresholdIdentifier(thresholdConfiguration, metricThresholdGroupName, metricName);
        if (thresholdIdentifier.isEmpty()) {
            throw new MetricThresholdConfigurationException("Failed to find threshold identifier for " + "metric threshold %s%s of threshold configuration %s".formatted(metricName, metricThresholdGroupName != null ? " in group" + metricThresholdGroupName : "", thresholdConfiguration.getName()));
        }
        MetricAssessmentComputation assessmentComputation = new MetricAssessmentComputation(thresholdConfigurationInterval, this.metricDataRetrieverFactory, this.projectStorage, this.parallelExecutor);
        return assessmentComputation.createMetricAssessmentResult(evaluationContext, thresholdIdentifier.get());
    }

    private static Optional<MetricThresholdIdentifier> getMetricThresholdIdentifier(MetricThresholdConfiguration thresholdConfiguration, String metricThresholdGroupName, String metricName) {
        return MetricThresholdSelectionUtils.findThresholdInConfigurationByDisplayName(thresholdConfiguration, metricThresholdGroupName, metricName);
    }
}

