/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass(containedInBackup=true)
public record TrendDelta(@JsonProperty(value="formattedText") String formattedText) implements Serializable
{
    private static final NumberFormat PLUS_MINUS_NUMBER_FORMAT = new DecimalFormat("+#;-#");
    private static final double RELATIVE_DELTA_ZERO_THRESHOLD = 5.0E-4;
    public static final TrendDelta EMPTY = new TrendDelta("");
    public static final TrendDelta NOT_AVAILABLE = new TrendDelta("-");
    private static final String DELTA_VALUES_DELIMITER = ", ";
    private static final String FORMATTED_ZERO_DELTA = "+0.0%";

    public static TrendDelta calculateAndFormatDelta(Assessment oldAssessment, Assessment newAssessment) {
        String formattedDeltaText = ETrafficLightColor.getTrafficLightColors().stream().filter(color -> TrendDelta.calculateRelativeFrequencyDelta(color, oldAssessment, newAssessment) != 0.0).map(color -> TrendDelta.calculateAndFormatDelta(color, oldAssessment, newAssessment)).collect(Collectors.joining(DELTA_VALUES_DELIMITER));
        return new TrendDelta(formattedDeltaText);
    }

    public boolean isAvailable() {
        return !StringUtils.isEmpty((String)this.formattedText) && !this.equals(NOT_AVAILABLE);
    }

    private static String calculateAndFormatDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        String absoluteDeltaText = TrendDelta.calculateAndFormatAbsoluteDelta(color, oldAssessment, newAssessment);
        String relativeDeltaText = TrendDelta.calculateAndFormatRelativeDelta(color, oldAssessment, newAssessment);
        return color.getAssessmentDisplayName() + ": " + absoluteDeltaText + " (" + relativeDeltaText + ")";
    }

    @VisibleForTesting
    static double calculateRelativeFrequencyDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        return newAssessment.getRelativeColorFrequency(color) - oldAssessment.getRelativeColorFrequency(color);
    }

    private static String calculateAndFormatAbsoluteDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        double absoluteDelta = newAssessment.getColorFrequency(color) - oldAssessment.getColorFrequency(color);
        return PLUS_MINUS_NUMBER_FORMAT.format(absoluteDelta);
    }

    private static String calculateAndFormatRelativeDelta(ETrafficLightColor color, Assessment oldAssessment, Assessment newAssessment) {
        double colorRelativeDelta = TrendDelta.calculateRelativeFrequencyDelta(color, oldAssessment, newAssessment);
        if (Math.abs(colorRelativeDelta) < 5.0E-4) {
            return FORMATTED_ZERO_DELTA;
        }
        Object colorRelativeDeltaFormatted = Assessment.PERCENT_FORMAT.format(colorRelativeDelta);
        if (colorRelativeDelta > 0.0) {
            colorRelativeDeltaFormatted = "+" + (String)colorRelativeDeltaFormatted;
        }
        return colorRelativeDeltaFormatted;
    }
}

